/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelVariant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/WatchFaceForAndroidXDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "visitMetaData", "metaData", "Issues", "android.sdktools.lint-checks"})
public final class WatchFaceForAndroidXDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    public static final String WATCH_FACE_META_DATA_NAME = "com.google.android.wearable.watchface.wearableConfigurationAction";
    @NotNull
    public static final String WATCH_FACE_EDITOR_ACTION = "androidx.wear.watchface.editor.action.WATCH_FACE_EDITOR";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"meta-data");
    }

    /*
     * WARNING - void declaration
     */
    private final void visitMetaData(XmlContext context2, Element metaData) {
        block4: {
            Object object;
            Element element;
            Issue issue;
            XmlContext xmlContext;
            LintFix fix;
            block6: {
                block5: {
                    void it;
                    LintModelLibrary lintModelLibrary;
                    LintModelAndroidArtifact lintModelAndroidArtifact;
                    if (!Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)WATCH_FACE_META_DATA_NAME) || Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "value"), (Object)WATCH_FACE_EDITOR_ACTION)) break block4;
                    LintModelVariant lintModelVariant = context2.getProject().getBuildVariant();
                    if (lintModelVariant == null || (lintModelAndroidArtifact = lintModelVariant.getMainArtifact()) == null || (lintModelLibrary = lintModelAndroidArtifact.findCompileDependency("androidx.wear.watchface:watchface")) == null) {
                        return;
                    }
                    fix = this.fix().set().attribute("value").value(WATCH_FACE_EDITOR_ACTION).android().build();
                    xmlContext = context2;
                    issue = ISSUE;
                    element = metaData;
                    object = metaData.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "value");
                    if (object == null) break block5;
                    Attr attr = object;
                    Element element2 = element;
                    Issue issue2 = issue;
                    XmlContext xmlContext2 = xmlContext;
                    boolean bl = false;
                    Location location2 = context2.getValueLocation((Attr)it);
                    xmlContext = xmlContext2;
                    issue = issue2;
                    element = element2;
                    Location location3 = location2;
                    object = location3;
                    if (location3 != null) break block6;
                }
                object = context2.getLocation(metaData);
            }
            LintFix lintFix = fix;
            String string = "Watch face configuration action must be set to WATCH_FACE_EDITOR for an AndroidX watch face";
            Object object2 = object;
            Element element3 = element;
            Issue issue3 = issue;
            xmlContext.report(new Incident(issue3, element3, (Location)object2, string, lintFix));
        }
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (Intrinsics.areEqual((Object)element.getTagName(), (Object)"meta-data")) {
            this.visitMetaData(context2, element);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(WatchFaceForAndroidXDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "WatchFaceForAndroidX", "AndroidX watch faces must use action `WATCH_FACE_EDITOR`", "\n                If the package depends on `androidx.wear:wear-watchface`, \\\n                and an AndroidX watch face declares the `wearableConfigurationAction` metadata, \\\n                its value should be `androidx.wear.watchface.editor.action.WATCH_FACE_EDITOR`.\n            ", implementation, "https://developer.android.com/training/wearables/watch-faces/configuration", category, 5, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/WatchFaceForAndroidXDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "WATCH_FACE_EDITOR_ACTION", "", "WATCH_FACE_META_DATA_NAME", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

