/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintJarVerifier;
import com.android.tools.lint.client.api.LintJarVerifierKt;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u001a\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002J \u0010$\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\nH\u0002J\u0006\u0010(\u001a\u00020\u0010J\u0014\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002J \u0010-\u001a\u00020.2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0006\u0010/\u001a\u00020\u0010J\b\u00100\u001a\u0004\u0018\u00010\u001dJ\u0010\u00101\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0010H\u0002J\u0006\u00102\u001a\u00020\u0007J\u0006\u00103\u001a\u00020\u0007J\u0010\u00104\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0010H\u0002J&\u00105\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010*2\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0012H\u0002J\u0010\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u0005H\u0002JK\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00102\b\u0010=\u001a\u0004\u0018\u00010\u00102\b\u0010>\u001a\u0004\u0018\u00010\u00102\u0010\u0010?\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010@H\u0016\u00a2\u0006\u0002\u0010AJE\u0010B\u001a\u00020C2\u0006\u0010<\u001a\u00020\n2\b\u0010#\u001a\u0004\u0018\u00010\u00102\b\u0010%\u001a\u0004\u0018\u00010\u00102\b\u0010=\u001a\u0004\u0018\u00010\u00102\u0010\u0010D\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u00010@H\u0016\u00a2\u0006\u0002\u0010ER\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/android/tools/lint/client/api/LintJarVerifier;", "Lorg/objectweb/asm/ClassVisitor;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "jarFile", "Ljava/io/File;", "skip", "", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Z)V", "<set-?>", "", "apiCount", "getApiCount", "()I", "bundledClasses", "", "", "classLoader", "Ljava/lang/ClassLoader;", "currentClass", "currentClassFile", "currentSuperClass", "inaccessible", "incompatibleReference", "incompatibleReferencer", "methodVisitor", "com/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1", "Lcom/android/tools/lint/client/api/LintJarVerifier$methodVisitor$1;", "verifyProblem", "", "checkClass", "", "internal", "checkField", "owner", "name", "checkMethod", "descriptor", "checkModifiers", "modifiers", "describeFirstIncompatibleReference", "getClass", "Ljava/lang/Class;", "getField", "Ljava/lang/reflect/Field;", "getMethod", "Ljava/lang/reflect/Executable;", "getReferenceClassFile", "getVerificationThrowable", "isCalledFromSubClass", "isCompatible", "isInaccessible", "isRelevantApi", "isSubClass", "target", "loader", "verify", "lintJar", "visit", "version", "access", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "android.sdktools.lint-api"})
public final class LintJarVerifier
extends ClassVisitor {
    @NotNull
    private final LintClient client;
    @NotNull
    private final File jarFile;
    private final boolean skip;
    @Nullable
    private Throwable verifyProblem;
    @Nullable
    private String incompatibleReference;
    @NotNull
    private final Set<String> bundledClasses;
    @Nullable
    private String incompatibleReferencer;
    private boolean inaccessible;
    @NotNull
    private final methodVisitor.1 methodVisitor;
    private int apiCount;
    @Nullable
    private String currentClassFile;
    @Nullable
    private String currentClass;
    @Nullable
    private String currentSuperClass;
    @Nullable
    private ClassLoader classLoader;

    public LintJarVerifier(@NotNull LintClient client, @NotNull File jarFile, boolean skip) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        super(589824);
        this.client = client;
        this.jarFile = jarFile;
        this.skip = skip;
        this.bundledClasses = new LinkedHashSet();
        this.methodVisitor = new MethodVisitor(this){
            final /* synthetic */ LintJarVerifier this$0;
            {
                this.this$0 = $receiver;
                super(589824);
            }

            public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name, @NotNull String descriptor, boolean isInterface) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                LintJarVerifier.access$checkMethod(this.this$0, owner, name, descriptor);
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name, @Nullable String descriptor) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                LintJarVerifier.access$checkField(this.this$0, owner, name);
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }
        };
        try {
            this.verify(this.jarFile);
        }
        catch (Throwable throwable) {
            this.verifyProblem = throwable;
        }
    }

    public /* synthetic */ LintJarVerifier(LintClient lintClient, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(lintClient, file, bl);
    }

    private final boolean isRelevantApi(String internal) {
        boolean relevant = StringsKt.startsWith$default((String)internal, (String)"com/android/", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/uast", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"org/jetbrains/kotlin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)internal, (String)"com/intellij", (boolean)false, (int)2, null);
        return relevant && !this.bundledClasses.contains(internal);
    }

    public final boolean isCompatible() {
        return this.incompatibleReference == null;
    }

    public final boolean isInaccessible() {
        return this.inaccessible;
    }

    @Nullable
    public final Throwable getVerificationThrowable() {
        return this.verifyProblem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void verify(File lintJar) {
        block15: {
            ClassLoader classLoader;
            Object object;
            if (this.skip) {
                return;
            }
            Map classes = new LinkedHashMap();
            Closeable closeable = new JarFile(lintJar);
            Throwable throwable = null;
            try {
                Iterator jar = (JarFile)closeable;
                boolean bl = false;
                object = ((JarFile)((Object)jar)).entries();
                Enumeration<JarEntry> entries = object;
                boolean bl2 = false;
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry;
                    Intrinsics.checkNotNull((Object)entries.nextElement(), (String)"null cannot be cast to non-null type java.util.jar.JarEntry");
                    JarEntry entry = jarEntry;
                    boolean bl3 = false;
                    boolean directory = entry.isDirectory();
                    String name = entry.getName();
                    if (directory) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    if (!StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null)) continue;
                    Closeable closeable2 = ((JarFile)((Object)jar)).getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        InputStream stream = (InputStream)closeable2;
                        boolean bl4 = false;
                        byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
                        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                        classes.put(name, bytes);
                        Unit throwable3 = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                jar = object;
            }
            catch (Throwable jar) {
                Throwable throwable4 = jar;
                throw jar;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, throwable);
            }
            Map $this$forEach$iv = classes;
            boolean entry = false;
            for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
                object = element$iv;
                boolean bl = false;
                String name = (String)object.getKey();
                this.bundledClasses.add(StringsKt.removeSuffix((String)name, (CharSequence)".class"));
            }
            for (Map.Entry classLoader2 : classes.entrySet()) {
                String name = (String)classLoader2.getKey();
                byte[] bytes = (byte[])classLoader2.getValue();
                this.currentClassFile = name;
                ClassReader reader = new ClassReader(bytes);
                reader.accept((ClassVisitor)this, 6);
                if (this.incompatibleReference == null) continue;
            }
            URLClassLoader uRLClassLoader = (classLoader = this.classLoader) instanceof URLClassLoader ? (URLClassLoader)classLoader : null;
            if (uRLClassLoader == null) break block15;
            uRLClassLoader.close();
        }
    }

    @NotNull
    public final String describeFirstIncompatibleReference() {
        String string = this.incompatibleReference;
        if (string == null) {
            return "Compatible";
        }
        String reference = string;
        int index2 = StringsKt.indexOf$default((CharSequence)reference, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (index2 == -1) {
            String string2 = Type.getObjectType((String)reference).getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getObjectType(reference).className");
            return StringsKt.replace$default((String)string2, (char)'$', (char)'.', (boolean)false, (int)4, null);
        }
        String string3 = reference.substring(0, index2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string4 = Type.getObjectType((String)string3).getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getObjectType(reference.\u2026ring(0, index)).className");
        String className = StringsKt.replace$default((String)string4, (char)'$', (char)'.', (boolean)false, (int)4, null);
        int paren = StringsKt.indexOf$default((CharSequence)reference, (char)'(', (int)0, (boolean)false, (int)6, null);
        if (paren == -1) {
            String string5 = reference.substring(index2 + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            return className + "#" + string5;
        }
        StringBuilder sb = new StringBuilder(className).append(": ");
        String string6 = reference.substring(paren);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
        String descriptor = string6;
        CharSequence name = reference.subSequence(index2 + 1, paren);
        Object[] arguments = Type.getArgumentTypes((String)descriptor);
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            String string7 = className.substring(StringsKt.lastIndexOf$default((CharSequence)className, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
            sb.append(string7);
        } else {
            String returnType = Type.getReturnType((String)descriptor).getClassName();
            sb.append(returnType).append(' ');
            sb.append(name);
        }
        sb.append('(');
        Intrinsics.checkNotNullExpressionValue((Object)arguments, (String)"arguments");
        sb.append(ArraysKt.joinToString$default((Object[])arguments, (CharSequence)",", null, null, (int)0, null, (Function1)describeFirstIncompatibleReference.1.INSTANCE, (int)30, null));
        sb.append(')');
        String string8 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"sb.toString()");
        return string8;
    }

    @NotNull
    public final String getReferenceClassFile() {
        String string = this.incompatibleReferencer;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final void checkClass(String internal) {
        if (this.isRelevantApi(internal)) {
            try {
                this.getClass(internal);
            }
            catch (Throwable e) {
                this.incompatibleReference = internal;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    public final int getApiCount() {
        return this.apiCount;
    }

    private final void checkMethod(String owner, String name, String descriptor) {
        if (this.isRelevantApi(owner)) {
            try {
                int n = this.apiCount;
                this.apiCount = n + 1;
                Executable method = this.getMethod(owner, name, descriptor);
                this.checkModifiers(owner, method.getModifiers());
            }
            catch (Throwable e) {
                this.incompatibleReference = owner + "#" + name + descriptor;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    private final void checkField(String owner, String name) {
        if (this.isRelevantApi(owner)) {
            try {
                int n = this.apiCount;
                this.apiCount = n + 1;
                Field field = this.getField(owner, name);
                this.checkModifiers(owner, field.getModifiers());
            }
            catch (Throwable e) {
                this.incompatibleReference = owner + "#" + name;
                this.incompatibleReferencer = this.currentClassFile;
            }
        }
    }

    private final void checkModifiers(String owner, int modifiers) {
        if ((modifiers & 1) != 0 || (modifiers & 4) != 0 && this.isCalledFromSubClass(owner)) {
            return;
        }
        this.inaccessible = true;
        throw new IllegalAccessException(owner);
    }

    private final boolean isCalledFromSubClass(String owner) {
        if (Intrinsics.areEqual((Object)this.currentSuperClass, (Object)owner)) {
            return true;
        }
        try {
            ClassLoader classLoader = this.classLoader;
            if (classLoader == null) {
                ClassLoader classLoader2;
                List list2 = CollectionsKt.listOf((Object)this.jarFile);
                ClassLoader classLoader3 = ((Object)((Object)this)).getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader3, (String)"this.javaClass.classLoader");
                ClassLoader it = classLoader2 = this.client.createUrlClassLoader(list2, classLoader3);
                boolean bl = false;
                this.classLoader = it;
                classLoader = classLoader2;
            }
            ClassLoader loader = classLoader;
            String string = this.currentClass;
            if (string == null) {
                return false;
            }
            String currentClass = string;
            Class<?> cls = Class.forName(StringsKt.replace$default((String)currentClass, (char)'/', (char)'.', (boolean)false, (int)4, null), false, loader);
            return this.isSubClass(cls, StringsKt.replace$default((String)owner, (char)'/', (char)'.', (boolean)false, (int)4, null), loader);
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    private final boolean isSubClass(Class<?> currentClass, String target2, ClassLoader loader) {
        if (currentClass == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)currentClass.getName(), (Object)target2)) {
            return true;
        }
        Class<?> superClass = currentClass.getSuperclass();
        if (this.isSubClass(superClass, target2, loader)) {
            return true;
        }
        Class<?>[] classArray = currentClass.getInterfaces();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"currentClass.interfaces");
        for (Class<?> itf : classArray) {
            if (!this.isSubClass(itf, target2, loader)) continue;
            return true;
        }
        return false;
    }

    private final Class<?> getClass(String internal) {
        int n = this.apiCount;
        this.apiCount = n + 1;
        String className = Type.getObjectType((String)internal).getClassName();
        Class<?> clazz = Class.forName(className, false, ((Object)((Object)this)).getClass().getClassLoader());
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(className, false, javaClass.classLoader)");
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private final Executable getMethod(String owner, String name, String descriptor) {
        Executable executable;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Class<?> clz = this.getClass(owner);
        Type[] typeArray = Type.getArgumentTypes((String)descriptor);
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getArgumentTypes(descriptor)");
        Object $this$map$iv = typeArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void type2;
            Type type3 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
            collection.add(LintJarVerifierKt.access$toTypeClass((Type)type2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Class[] argumentTypes = thisCollection$iv.toArray(new Class[0]);
        if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
            Constructor<?> constructor;
            try {
                constructor = clz.getDeclaredConstructor(Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            catch (Throwable e) {
                constructor = clz.getConstructor(Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            Constructor<?> constructor2 = constructor;
            Intrinsics.checkNotNullExpressionValue(constructor2, (String)"{\n      try {\n        cl\u2026umentTypes)\n      }\n    }");
            executable = constructor2;
        } else {
            Method method;
            try {
                method = clz.getDeclaredMethod(name, Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            catch (Throwable e) {
                method = clz.getMethod(name, Arrays.copyOf(argumentTypes, argumentTypes.length));
            }
            Method method2 = method;
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"{\n      try {\n        cl\u2026umentTypes)\n      }\n    }");
            executable = method2;
        }
        return executable;
    }

    private final Field getField(String owner, String name) {
        Field field;
        Class<?> clz = this.getClass(owner);
        try {
            Field field2 = clz.getDeclaredField(name);
            Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"{\n      clz.getDeclaredField(name)\n    }");
            field = field2;
        }
        catch (Throwable e) {
            Field field3 = clz.getField(name);
            Intrinsics.checkNotNullExpressionValue((Object)field3, (String)"{\n      clz.getField(name)\n    }");
            field = field3;
        }
        return field;
    }

    public void visit(int version2, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        String[] it;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.currentClass = name;
        this.currentSuperClass = superName;
        if (superName != null) {
            it = superName;
            boolean bl = false;
            this.checkClass((String)it);
        }
        if (interfaces != null) {
            it = interfaces;
            boolean bl = false;
            String[] $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String internal = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                this.checkClass(internal);
            }
        }
        super.visit(version2, access, name, signature, (String)superName, interfaces);
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @Nullable String name, @Nullable String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        return this.methodVisitor;
    }

    public static final /* synthetic */ void access$checkMethod(LintJarVerifier $this, String owner, String name, String descriptor) {
        $this.checkMethod(owner, name, descriptor);
    }

    public static final /* synthetic */ void access$checkField(LintJarVerifier $this, String owner, String name) {
        $this.checkField(owner, name);
    }
}

