/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.manifest.parser;

import com.android.tools.manifest.parser.BinaryXmlParser;
import com.android.tools.manifest.parser.XmlNode;
import com.android.tools.manifest.parser.components.ManifestActivityInfo;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ManifestInfo {
    private final List<ManifestActivityInfo> activities = new ArrayList<ManifestActivityInfo>();
    private final List<ManifestServiceInfo> services = new ArrayList<ManifestServiceInfo>();
    private final List<String> sdkLibraries = new ArrayList<String>();
    private final List<String> instrumentationTargetPackages = new ArrayList<String>();
    private String applicationId = "";
    private String split = null;
    private int versionCode = 0;
    private boolean debuggable = false;

    private ManifestInfo() {
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public List<ManifestActivityInfo> activities() {
        return this.activities;
    }

    public List<ManifestServiceInfo> services() {
        return this.services;
    }

    public List<String> getSdkLibraries() {
        return this.sdkLibraries;
    }

    public List<String> getInstrumentationTargetPackages() {
        return this.instrumentationTargetPackages;
    }

    public String getSplitName() {
        return this.split;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public boolean getDebuggable() {
        return this.debuggable;
    }

    private void parseNode(XmlNode node) {
        for (String attribute : node.attributes().keySet()) {
            String value = node.attributes().get(attribute);
            if ("package".equals(attribute)) {
                this.applicationId = value;
                continue;
            }
            if ("split".equals(attribute)) {
                this.split = value;
                continue;
            }
            if (!"versionCode".equals(attribute) || value.isEmpty()) continue;
            this.versionCode = Integer.parseInt(value);
        }
        for (XmlNode child : node.children()) {
            if ("application".equals(child.name())) {
                this.parseApplication(child);
                continue;
            }
            if (!"instrumentation".equals(child.name())) continue;
            this.parseInstrumentation(child);
        }
    }

    private void parseInstrumentation(XmlNode node) {
        for (String attribute : node.attributes().keySet()) {
            if (!"targetPackage".equals(attribute)) continue;
            this.instrumentationTargetPackages.add(node.attributes().get(attribute));
        }
    }

    private void parseApplication(XmlNode node) {
        this.debuggable = Boolean.parseBoolean(node.attributes().getOrDefault("debuggable", "false"));
        for (XmlNode child : node.children()) {
            if ("activity".equals(child.name()) || "activity-alias".equals(child.name())) {
                this.activities.add(new ManifestActivityInfo(child, this.applicationId));
                continue;
            }
            if ("service".equals(child.name())) {
                this.services.add(new ManifestServiceInfo(child, this.applicationId));
                continue;
            }
            if (!"sdk-library".equals(child.name())) continue;
            this.sdkLibraries.add(child.attributes().get("name"));
        }
    }

    public static ManifestInfo parseBinaryFromStream(InputStream inputStream) throws IOException {
        XmlNode node = BinaryXmlParser.parse(inputStream);
        ManifestInfo manifest = new ManifestInfo();
        manifest.parseNode(node);
        return manifest;
    }
}

