/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.captures.DataBuffer;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.InstanceList;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tJ\b\u0010(\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0013\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/android/tools/perflib/heap/ArrayInstance;", "Lcom/android/tools/perflib/heap/Instance;", "id", "", "stack", "Lcom/android/tools/perflib/heap/StackTrace;", "arrayType", "Lcom/android/tools/perflib/heap/Type;", "length", "", "valuesOffset", "(JLcom/android/tools/perflib/heap/StackTrace;Lcom/android/tools/perflib/heap/Type;IJ)V", "getArrayType", "()Lcom/android/tools/perflib/heap/Type;", "classObj", "Lcom/android/tools/perflib/heap/ClassObj;", "getClassObj", "()Lcom/android/tools/perflib/heap/ClassObj;", "getLength", "()I", "size", "getSize", "setSize", "(I)V", "values", "", "", "getValues", "()[Ljava/lang/Object;", "accept", "", "visitor", "Lcom/android/tools/perflib/heap/Visitor;", "asCharArray", "", "offset", "asRawByteArray", "", "start", "elementCount", "resolveReferences", "toString", "", "android.sdktools.perflib"})
public class ArrayInstance
extends Instance {
    @NotNull
    private final Type arrayType;
    private final int length;
    private final long valuesOffset;

    public ArrayInstance(long id, @Nullable StackTrace stack, @NotNull Type arrayType, int length, long valuesOffset) {
        Intrinsics.checkNotNullParameter((Object)((Object)arrayType), (String)"arrayType");
        super(id, stack);
        this.arrayType = arrayType;
        this.length = length;
        this.valuesOffset = valuesOffset;
    }

    @NotNull
    public final Type getArrayType() {
        return this.arrayType;
    }

    public final int getLength() {
        return this.length;
    }

    @NotNull
    public Object[] getValues() {
        this.getBuffer().setPosition(this.valuesOffset);
        int n = 0;
        int n2 = this.length;
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = this.readValue(this.arrayType);
        }
        return objectArray;
    }

    @NotNull
    public final byte[] asRawByteArray(int start2, int elementCount) {
        boolean bl;
        this.getBuffer().setPosition(this.valuesOffset);
        boolean bl2 = bl = this.arrayType != Type.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = start2 + elementCount <= this.length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        byte[] bytes = new byte[elementCount * this.arrayType.getSize()];
        this.getBuffer().readSubSequence(bytes, start2 * this.arrayType.getSize(), elementCount * this.arrayType.getSize());
        return bytes;
    }

    @NotNull
    public final char[] asCharArray(int offset, int length) {
        boolean bl;
        boolean bl2 = bl = this.arrayType == Type.CHAR;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        CharBuffer charBuffer = ByteBuffer.wrap(this.asRawByteArray(offset, length)).order(DataBuffer.HPROF_BYTE_ORDER).asCharBuffer();
        char[] result = new char[length];
        charBuffer.get(result);
        return result;
    }

    @Override
    public int getSize() {
        Heap heap = this.getHeap();
        Intrinsics.checkNotNull((Object)heap);
        return this.length * heap.mSnapshot.getTypeSize(this.arrayType);
    }

    @Override
    public void setSize(int size) {
        super.setSize(size);
    }

    @Override
    public void resolveReferences() {
        if (this.arrayType == Type.OBJECT) {
            for (Object value : this.getValues()) {
                if (!(value instanceof Instance)) continue;
                ((Instance)value).addReverseReference(null, this);
                this.set_hardFwdRefs-OLAdukE$android_sdktools_perflib(InstanceList.plus-GO6bYc0(this.get_hardFwdRefs-s3XpT2Q$android_sdktools_perflib(), (Instance)value));
            }
        }
    }

    @Override
    public void accept(@NotNull Visitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitArrayInstance(this);
        for (Instance instance : this.getHardForwardReferences()) {
            visitor2.visitLater(this, instance);
        }
    }

    @Override
    @Nullable
    public ClassObj getClassObj() {
        ClassObj classObj;
        if (WhenMappings.$EnumSwitchMapping$0[this.arrayType.ordinal()] == 1) {
            classObj = super.getClassObj();
        } else {
            Heap heap = this.getHeap();
            Intrinsics.checkNotNull((Object)heap);
            classObj = heap.mSnapshot.findClass(this.arrayType.getClassNameOfPrimitiveArray(false));
            if (classObj == null) {
                Heap heap2 = this.getHeap();
                Intrinsics.checkNotNull((Object)heap2);
                classObj = heap2.mSnapshot.findClass(this.arrayType.getClassNameOfPrimitiveArray(true));
            }
        }
        return classObj;
    }

    @NotNull
    public String toString() {
        ClassObj classObj = this.getClassObj();
        Intrinsics.checkNotNull((Object)classObj);
        String className = classObj.getClassName();
        if (StringsKt.endsWith$default((String)className, (String)"[]", (boolean)false, (int)2, null)) {
            String string = className.substring(0, className.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            className = string;
        }
        Locale locale = Locale.US;
        String string = "%s[%d]@%d (0x%x)";
        Object[] objectArray = new Object[]{className, this.length, this.getUniqueId(), this.getUniqueId()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

