/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.InstanceList;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u001c\u001a\u00020\tJ\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/perflib/heap/ClassInstance;", "Lcom/android/tools/perflib/heap/Instance;", "id", "", "stack", "Lcom/android/tools/perflib/heap/StackTrace;", "valuesOffset", "(JLcom/android/tools/perflib/heap/StackTrace;J)V", "asString", "", "getAsString", "()Ljava/lang/String;", "isSoftReference", "", "()Z", "isStringInstance", "values", "", "Lcom/android/tools/perflib/heap/ClassInstance$FieldValue;", "getValues", "()Ljava/util/List;", "accept", "", "visitor", "Lcom/android/tools/perflib/heap/Visitor;", "maxDecodeStringLength", "", "getFields", "name", "resolveReferences", "toString", "FieldValue", "android.sdktools.perflib"})
public class ClassInstance
extends Instance {
    private final long valuesOffset;

    public ClassInstance(long id, @Nullable StackTrace stack, long valuesOffset) {
        super(id, stack);
        this.valuesOffset = valuesOffset;
    }

    @NotNull
    public List<FieldValue> getValues() {
        List list2;
        List result = list2 = (List)new ArrayList();
        boolean bl = false;
        this.getBuffer().setPosition(this.valuesOffset);
        ClassInstance._get_values_$lambda$1$collect(result, this, this.getClassObj());
        return list2;
    }

    @Override
    public boolean isSoftReference() {
        ClassObj classObj = this.getClassObj();
        Intrinsics.checkNotNull((Object)classObj);
        return classObj.isSoftReference();
    }

    public final boolean isStringInstance() {
        ClassObj classObj = this.getClassObj();
        return Intrinsics.areEqual((Object)"java.lang.String", (Object)(classObj != null ? classObj.getClassName() : null));
    }

    @Nullable
    public final String getAsString() {
        return this.getAsString(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FieldValue> getFields(@NotNull String name) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = this.getValues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FieldValue it = (FieldValue)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getField().getName(), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void resolveReferences() {
        for (FieldValue fieldValue : this.getValues()) {
            if (!(fieldValue.getValue() instanceof Instance)) continue;
            ((Instance)fieldValue.getValue()).addReverseReference(fieldValue.getField(), this);
            if (this.isSoftReference() && Intrinsics.areEqual((Object)fieldValue.getField().getName(), (Object)"referent")) continue;
            this.set_hardFwdRefs-OLAdukE$android_sdktools_perflib(InstanceList.plus-GO6bYc0(this.get_hardFwdRefs-s3XpT2Q$android_sdktools_perflib(), (Instance)fieldValue.getValue()));
        }
    }

    @Override
    public void accept(@NotNull Visitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitClassInstance(this);
        for (Instance instance : this.getHardForwardReferences()) {
            visitor2.visitLater(this, instance);
        }
    }

    @NotNull
    public String toString() {
        Locale locale = Locale.US;
        String string = "%s@%d (0x%x)";
        Object[] objectArray = new Object[3];
        ClassObj classObj = this.getClassObj();
        Intrinsics.checkNotNull((Object)classObj);
        objectArray[0] = classObj.getClassName();
        objectArray[1] = this.getUniqueId();
        objectArray[2] = this.getUniqueId();
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        return string2;
    }

    @Nullable
    public final String getAsString(int maxDecodeStringLength) {
        Object object;
        Ref.IntRef count = new Ref.IntRef();
        count.element = -1;
        Ref.IntRef offset = new Ref.IntRef();
        ArrayInstance charBufferArray = null;
        ArrayInstance byteBufferArray = null;
        for (FieldValue entry : this.getValues()) {
            if (charBufferArray == null && Intrinsics.areEqual((Object)"value", (Object)entry.getField().getName())) {
                if (!(entry.getValue() instanceof ArrayInstance)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[((ArrayInstance)entry.getValue()).getArrayType().ordinal()]) {
                    case 1: {
                        charBufferArray = (ArrayInstance)entry.getValue();
                        break;
                    }
                    case 2: {
                        byteBufferArray = (ArrayInstance)entry.getValue();
                    }
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)"count", (Object)entry.getField().getName()) && entry.getValue() instanceof Integer) {
                count.element = ((Number)entry.getValue()).intValue();
                continue;
            }
            if (!Intrinsics.areEqual((Object)"offset", (Object)entry.getField().getName()) || !(entry.getValue() instanceof Integer)) continue;
            offset.element = ((Number)entry.getValue()).intValue();
        }
        if (byteBufferArray != null) {
            Object object2;
            try {
                object2 = new String((byte[])ClassInstance.getAsString$mkRaw(offset, count, maxDecodeStringLength, (Function2)new Function2<Integer, Integer, byte[]>(byteBufferArray){

                    @NotNull
                    public final byte[] invoke(int p0, int p1) {
                        return ((ArrayInstance)this.receiver).asRawByteArray(p0, p1);
                    }
                }), Charsets.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                object2 = null;
            }
            object = object2;
        } else {
            object = charBufferArray != null ? new String((char[])ClassInstance.getAsString$mkRaw(offset, count, maxDecodeStringLength, (Function2)new Function2<Integer, Integer, char[]>(charBufferArray){

                @NotNull
                public final char[] invoke(int p0, int p1) {
                    return ((ArrayInstance)this.receiver).asCharArray(p0, p1);
                }
            })) : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void _get_values_$lambda$1$collect(List<FieldValue> $result, ClassInstance this$0, ClassObj cl) {
        while (cl != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Field[] fieldArray = cl.getFields();
            List<FieldValue> list2 = $result;
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Type type2 = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)type2), (String)"it.type");
                collection.add(new FieldValue((Field)it, this$0.readValue(type2)));
            }
            list2.addAll((List)destination$iv$iv);
            cl = cl.getSuperClassObj();
        }
    }

    private static final <T> T getAsString$mkRaw(Ref.IntRef offset, Ref.IntRef count, int $maxDecodeStringLength, Function2<? super Integer, ? super Integer, ? extends T> mk) {
        return (T)mk.invoke((Object)Math.max(offset.element, 0), (Object)Math.max(Math.min(count.element, $maxDecodeStringLength), 0));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/perflib/heap/ClassInstance$FieldValue;", "", "field", "Lcom/android/tools/perflib/heap/Field;", "value", "(Lcom/android/tools/perflib/heap/Field;Ljava/lang/Object;)V", "getField", "()Lcom/android/tools/perflib/heap/Field;", "getValue", "()Ljava/lang/Object;", "android.sdktools.perflib"})
    public static final class FieldValue {
        @NotNull
        private final Field field;
        @Nullable
        private final Object value;

        public FieldValue(@NotNull Field field, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            this.field = field;
            this.value = value;
        }

        @NotNull
        public final Field getField() {
            return this.field;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.CHAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

