/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.NonRecursiveVisitor;
import java.util.Comparator;
import java.util.PriorityQueue;
import kotlin.sequences.SequencesKt;

public class ShortestDistanceVisitor
extends NonRecursiveVisitor {
    private PriorityQueue<Instance> mPriorityQueue = new PriorityQueue<Instance>(1024, new Comparator<Instance>(){

        @Override
        public int compare(Instance o1, Instance o2) {
            return o1.getDistanceToGcRoot() - o2.getDistanceToGcRoot();
        }
    });
    private int mVisitDistance = 0;

    @Override
    public void visitLater(Instance parent, Instance child) {
        if (this.mVisitDistance < child.getDistanceToGcRoot() && (parent == null || child.getSoftReverseReferences() == null || !SequencesKt.contains(child.getSoftReverseReferences(), (Object)parent) || child.isSoftReference())) {
            child.setDistanceToGcRoot(this.mVisitDistance);
            this.mPriorityQueue.add(child);
        }
    }

    @Override
    public void doVisit(Iterable<? extends Instance> startNodes) {
        for (Instance instance : startNodes) {
            instance.accept(this);
        }
        while (!this.mPriorityQueue.isEmpty()) {
            Instance node = this.mPriorityQueue.poll();
            this.mVisitDistance = node.getDistanceToGcRoot() + 1;
            node.accept(this);
        }
    }
}

