/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.usb;

import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.parser.OutputParser;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/usb/UsbDeviceCollectorImpl;", "Lcom/android/tools/usb/UsbDeviceCollector;", "()V", "execute", "Ljava/util/concurrent/CompletableFuture;", "Ljava/io/InputStream;", "command", "", "getPlatform", "Lcom/android/tools/usb/Platform;", "isSupported", "", "platform", "listUsbDevices", "", "Lcom/android/tools/usb/UsbDevice;", "usb-devices"})
public final class UsbDeviceCollectorImpl
implements UsbDeviceCollector {
    @Override
    @NotNull
    public CompletableFuture<List<UsbDevice>> listUsbDevices() {
        Platform currentOS = Platform.Factory.currentOS();
        if (!currentOS.getSupported()) {
            CompletableFuture<List<UsbDevice>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Collections.emptyList())");
            return completableFuture;
        }
        String string = currentOS.getCommand();
        Intrinsics.checkNotNull((Object)string);
        CompletionStage completionStage = this.execute(string).thenApply(new Function(currentOS){
            final /* synthetic */ Platform $currentOS;
            {
                this.$currentOS = $currentOS;
            }

            public final List<UsbDevice> apply(InputStream it) {
                OutputParser outputParser = this.$currentOS.parser();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return outputParser.parse(it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"currentOS = Platform.cur\u2026ntOS.parser().parse(it) }");
        return completionStage;
    }

    @Override
    public boolean isSupported(@NotNull String platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return Platform.Factory.currentOS(platform).getSupported();
    }

    @Override
    @NotNull
    public Platform getPlatform() {
        return Platform.Factory.currentOS();
    }

    private final CompletableFuture<InputStream> execute(String command) {
        CompletableFuture<InputStream> completableFuture = CompletableFuture.supplyAsync(new Supplier(command){
            final /* synthetic */ String $command;
            {
                this.$command = $command;
            }

            public final InputStream get() {
                String[] stringArray = new String[]{" "};
                return new ProcessBuilder(StringsKt.split$default((CharSequence)this.$command, (String[])stringArray, (boolean)false, (int)0, (int)6, null)).redirectErrorStream(true).start().getInputStream();
            }
        });
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"command: String): Comple\u2026start().inputStream\n    }");
        return completableFuture;
    }
}

