/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.usb.parser;

import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.parser.LinuxParserKt;
import com.android.tools.usb.parser.OutputParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/usb/parser/LinuxParser;", "Lcom/android/tools/usb/parser/OutputParser;", "()V", "parse", "", "Lcom/android/tools/usb/UsbDevice;", "output", "Ljava/io/InputStream;", "usb-devices"})
public final class LinuxParser
implements OutputParser {
    @Override
    @NotNull
    public List<UsbDevice> parse(@NotNull InputStream output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Stream<String> lines = new BufferedReader(new InputStreamReader(output, Charsets.UTF_8)).lines();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        UsbDevice curDevice = null;
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            String iSerial;
            MatchResult matchSerial;
            String next = (String)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
            UsbDevice nextDevice = LinuxParserKt.createUsbDevice(next);
            if (nextDevice != null) {
                if (curDevice != null) {
                    result.add(curDevice);
                }
                curDevice = nextDevice;
                continue;
            }
            if (curDevice == null || (matchSerial = LinuxParserKt.access$getSERIAL_REGEX$p().matchEntire((CharSequence)next)) == null || !(((CharSequence)(iSerial = (String)matchSerial.getGroupValues().get(2))).length() > 0)) continue;
            curDevice = UsbDevice.copy$default(curDevice, null, null, null, null, iSerial, null, 47, null);
        }
        if (curDevice != null) {
            result.add(curDevice);
        }
        return result;
    }
}

