/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Location;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class PayloadInputStream
extends InputStream {
    private FileChannel channel;
    private Location boundaries;
    private long position;

    public PayloadInputStream(FileChannel channel, Location location2) throws IOException {
        this.channel = channel;
        this.boundaries = location2;
        this.position = location2.first;
        if (location2.first < 0L || location2.last >= channel.size()) {
            throw new IllegalStateException("Location not within channel boundaries");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.position > this.boundaries.last) {
            return -1;
        }
        byte[] buffer2 = new byte[1];
        this.read(buffer2);
        return buffer2[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.position > this.boundaries.last) {
            return -1;
        }
        long available = this.boundaries.last - this.position + 1L;
        available = Math.min(available, Integer.MAX_VALUE);
        int toRead = Math.min(Math.toIntExact(available), len);
        ByteBuffer buffer2 = ByteBuffer.wrap(b, off, toRead);
        int read2 = this.channel.read(buffer2, this.position);
        this.position += (long)read2;
        return read2;
    }
}

