/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ChunkWithChunks
extends Chunk {
    private final Map<Integer, Chunk> chunks = new LinkedHashMap<Integer, Chunk>();

    protected ChunkWithChunks(ByteBuffer buffer2, Chunk parent) {
        super(buffer2, parent);
    }

    @Override
    protected void init(ByteBuffer buffer2) {
        Chunk chunk;
        int start2;
        super.init(buffer2);
        this.chunks.clear();
        int end2 = this.offset + this.getOriginalChunkSize();
        int position = buffer2.position();
        buffer2.position(start2);
        for (int offset = start2 = this.offset + this.getHeaderSize(); offset < end2; offset += chunk.getOriginalChunkSize()) {
            chunk = Chunk.newInstance(buffer2, this);
            this.chunks.put(offset, chunk);
        }
        buffer2.position(position);
    }

    public final Map<Integer, Chunk> getChunks() {
        return this.chunks;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        for (Chunk chunk : this.getChunks().values()) {
            byte[] chunkBytes = chunk.toByteArray(shrink);
            output.write(chunkBytes);
            this.writePad(output, chunkBytes.length);
        }
    }
}

