/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNodeChunk;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;

public class XmlAttribute
implements SerializableResource {
    public static final int SIZE = 20;
    private final int namespaceIndex;
    private final int nameIndex;
    private final int rawValueIndex;
    private final BinaryResourceValue typedValue;
    private final XmlNodeChunk parent;

    public static XmlAttribute create(ByteBuffer buffer2, XmlNodeChunk parent) {
        int namespace = buffer2.getInt();
        int name = buffer2.getInt();
        int rawValue = buffer2.getInt();
        BinaryResourceValue typedValue = BinaryResourceValue.create(buffer2);
        return new XmlAttribute(namespace, name, rawValue, typedValue, parent);
    }

    private XmlAttribute(int namespaceIndex, int nameIndex, int rawValueIndex, BinaryResourceValue typedValue, XmlNodeChunk parent) {
        this.namespaceIndex = namespaceIndex;
        this.nameIndex = nameIndex;
        this.rawValueIndex = rawValueIndex;
        this.typedValue = typedValue;
        this.parent = parent;
    }

    public int namespaceIndex() {
        return this.namespaceIndex;
    }

    public int nameIndex() {
        return this.nameIndex;
    }

    public int rawValueIndex() {
        return this.rawValueIndex;
    }

    public BinaryResourceValue typedValue() {
        return this.typedValue;
    }

    public XmlNodeChunk parent() {
        return this.parent;
    }

    public final String namespace() {
        return this.getString(this.namespaceIndex());
    }

    public final String name() {
        return this.getString(this.nameIndex());
    }

    public final String rawValue() {
        return this.getString(this.rawValueIndex());
    }

    private String getString(int index2) {
        return this.parent().getString(index2);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) {
        ByteBuffer buffer2 = ByteBuffer.allocate(20).order(ByteOrder.LITTLE_ENDIAN);
        buffer2.putInt(this.namespaceIndex());
        buffer2.putInt(this.nameIndex());
        buffer2.putInt(this.rawValueIndex());
        buffer2.put(this.typedValue().toByteArray(shrink));
        return buffer2.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlAttribute that = (XmlAttribute)o;
        return this.namespaceIndex == that.namespaceIndex && this.nameIndex == that.nameIndex && this.rawValueIndex == that.rawValueIndex && Objects.equals(this.typedValue, that.typedValue) && Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceIndex, this.nameIndex, this.rawValueIndex, this.typedValue, this.parent);
    }

    public String toString() {
        return String.format("XmlAttribute{namespace=%s, name=%s, value=%s}", this.namespace(), this.name(), this.rawValue());
    }
}

