/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.modeling.runners;

import com.intellij.completion.ngram.slp.modeling.Model;
import com.intellij.completion.ngram.slp.modeling.ngram.NGramModel;
import com.intellij.completion.ngram.slp.modeling.runners.ModelRunner;
import com.intellij.completion.ngram.slp.translating.Vocabulary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 62\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u001c\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001bH\u0002J\"\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0 0 0\u001bH\u0002J\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020\u0014J\b\u0010#\u001a\u00020\u0019H\u0002J\u0016\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0002J\u0016\u0010&\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0002J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0 H\u0002J(\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0 0 2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001bH\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0 H\u0002J(\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0 0 2\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001bH\u0002J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014J6\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H.0 0 \"\u0004\b\u0000\u0010.2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H.0 2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\n0 H\u0002J:\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0 0 2$\u00101\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f03020 H\u0002J.\u00100\u001a\b\u0012\u0004\u0012\u00020\n0 2\u001e\u00104\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0302H\u0002J\u001c\u00105\u001a\u00020\f2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f03H\u0002J&\u00105\u001a\b\u0012\u0004\u0012\u00020\f0 2\u0018\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f030 R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00067"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/runners/ModelRunner;", "", "model", "Lcom/intellij/completion/ngram/slp/modeling/Model;", "vocabulary", "Lcom/intellij/completion/ngram/slp/translating/Vocabulary;", "(Lcom/intellij/completion/ngram/slp/modeling/Model;Lcom/intellij/completion/ngram/slp/translating/Vocabulary;)V", "LEARN_PRINT_INTERVAL", "", "MODEL_PRINT_INTERVAL", "", "ent", "", "learnStats", "", "getModel", "()Lcom/intellij/completion/ngram/slp/modeling/Model;", "modelStats", "mrr", "selfTesting", "", "getVocabulary", "()Lcom/intellij/completion/ngram/slp/translating/Vocabulary;", "copyForModel", "forgetTokens", "", "lexed", "Lkotlin/sequences/Sequence;", "", "getFileStats", "Ljava/util/DoubleSummaryStatistics;", "fileProbs", "", "getOrder", "getSelfTesting", "logLearningProgress", "logModelingProgress", "modeled", "logPredictionProgress", "modelSequence", "tokens", "modelTokens", "predictSequence", "predictTokens", "setSelfTesting", "toLines", "K", "lineLengths", "toPredictions", "probConfs", "", "Lkotlin/Pair;", "probConf", "toProb", "Companion", "bd0177eacd27ae4e"})
public class ModelRunner {
    private boolean selfTesting;
    private final long LEARN_PRINT_INTERVAL = 1000000L;
    private long[] learnStats;
    private final int MODEL_PRINT_INTERVAL = 100000;
    private long[] modelStats;
    private double ent;
    private double mrr;
    @NotNull
    private final Model model;
    @NotNull
    private final Vocabulary vocabulary;
    private static final double INV_NEG_LOG_2;
    public static final int DEFAULT_NGRAM_ORDER = 6;
    private static int predictionCutoff;
    public static final Companion Companion;

    @NotNull
    public final ModelRunner copyForModel(@NotNull Model model2) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        return new ModelRunner(model2, this.vocabulary);
    }

    public final void setSelfTesting(boolean selfTesting) {
        this.selfTesting = selfTesting;
    }

    public final boolean getSelfTesting() {
        return this.selfTesting;
    }

    private final void logLearningProgress() {
        long[] lArray = this.learnStats;
        lArray[0] = lArray[0] + 1L;
        if (this.learnStats[0] % this.LEARN_PRINT_INTERVAL == 0L && this.learnStats[1] != 0L) {
            System.out.printf("Counting: %dM tokens processed in %ds\n", MathKt.roundToInt((double)((double)this.learnStats[0] / 1000000.0)), (System.currentTimeMillis() + this.learnStats[1]) / (long)1000);
        }
    }

    private final void forgetTokens(Sequence<? extends Sequence<String>> lexed) {
        this.model.forget(SequencesKt.toList((Sequence)SequencesKt.flatMap(lexed, (Function1)((Function1)new Function1<Sequence<? extends String>, Sequence<? extends Integer>>(this){
            final /* synthetic */ ModelRunner this$0;

            @NotNull
            public final Sequence<Integer> invoke(@NotNull Sequence<String> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.getVocabulary().toIndices(it);
            }
            {
                this.this$0 = modelRunner;
                super(1);
            }
        }))));
    }

    private final List<List<Double>> modelTokens(Sequence<? extends Sequence<String>> lexed) {
        this.vocabulary.setCheckpoint();
        List<List<Double>> lineProbs = null;
        ArrayList lineLengths = new ArrayList();
        List<Double> modeled2 = this.modelSequence(SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.map(lexed, (Function1)((Function1)new Function1<Sequence<? extends String>, Sequence<? extends Integer>>(this){
            final /* synthetic */ ModelRunner this$0;

            @NotNull
            public final Sequence<Integer> invoke(@NotNull Sequence<String> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.getVocabulary().toIndices(it);
            }
            {
                this.this$0 = modelRunner;
                super(1);
            }
        })), (Function1)modelTokens.modeled.2.INSTANCE), (Function1)((Function1)new Function1<List<? extends Integer>, Unit>(lineLengths){
            final /* synthetic */ ArrayList $lineLengths;

            public final void invoke(@NotNull List<Integer> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.$lineLengths.add(it.size());
            }
            {
                this.$lineLengths = arrayList;
                super(1);
            }
        })), (Function1)modelTokens.modeled.4.INSTANCE)));
        lineProbs = this.toLines(modeled2, lineLengths);
        this.logModelingProgress(modeled2);
        this.vocabulary.restoreCheckpoint();
        return lineProbs;
    }

    private final List<Double> modelSequence(List<Integer> tokens) {
        if (this.selfTesting) {
            this.model.forget(tokens);
        }
        List<Double> entropies2 = this.model.model(tokens).stream().map(new Function<T, R>(this){
            final /* synthetic */ ModelRunner this$0;

            public final double apply(Pair<Double, Double> it) {
                Pair<Double, Double> pair = it;
                Intrinsics.checkExpressionValueIsNotNull(pair, (String)"it");
                return ModelRunner.access$toProb(this.this$0, pair);
            }
            {
                this.this$0 = modelRunner;
            }
        }).map(modelSequence.entropies.2.INSTANCE).collect(Collectors.toList());
        if (this.selfTesting) {
            this.model.learn(tokens);
        }
        List<Double> list = entropies2;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"entropies");
        return list;
    }

    private final void logModelingProgress(List<Double> modeled2) {
        DoubleSummaryStatistics stats2 = modeled2.stream().skip(1L).mapToDouble(logModelingProgress.stats.1.INSTANCE).summaryStatistics();
        long prevCount = this.modelStats[0];
        long l = this.modelStats[0];
        DoubleSummaryStatistics doubleSummaryStatistics = stats2;
        Intrinsics.checkExpressionValueIsNotNull((Object)doubleSummaryStatistics, (String)"stats");
        this.modelStats[0] = l + doubleSummaryStatistics.getCount();
        this.ent += stats2.getSum();
        if (this.modelStats[0] / (long)this.MODEL_PRINT_INTERVAL > prevCount / (long)this.MODEL_PRINT_INTERVAL && this.modelStats[1] != 0L) {
            System.out.printf("Modeling: %dK tokens processed in %ds, avg. entropy: %.4f\n", MathKt.roundToInt((double)((double)this.modelStats[0] / 1000.0)), (System.currentTimeMillis() + this.modelStats[1]) / (long)1000, this.ent / (double)this.modelStats[0]);
        }
    }

    private final List<List<Double>> predictTokens(Sequence<? extends Sequence<String>> lexed) {
        this.vocabulary.setCheckpoint();
        List<List<Double>> lineProbs = null;
        ArrayList lineLengths = new ArrayList();
        List<Double> modeled2 = this.predictSequence(SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.map(lexed, (Function1)((Function1)new Function1<Sequence<? extends String>, Sequence<? extends Integer>>(this){
            final /* synthetic */ ModelRunner this$0;

            @NotNull
            public final Sequence<Integer> invoke(@NotNull Sequence<String> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.getVocabulary().toIndices(it);
            }
            {
                this.this$0 = modelRunner;
                super(1);
            }
        })), (Function1)predictTokens.modeled.2.INSTANCE), (Function1)((Function1)new Function1<List<? extends Integer>, Unit>(lineLengths){
            final /* synthetic */ ArrayList $lineLengths;

            public final void invoke(@NotNull List<Integer> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                this.$lineLengths.add(it.size());
            }
            {
                this.$lineLengths = arrayList;
                super(1);
            }
        })), (Function1)predictTokens.modeled.4.INSTANCE)));
        lineProbs = this.toLines(modeled2, lineLengths);
        this.logPredictionProgress(modeled2);
        this.vocabulary.restoreCheckpoint();
        return lineProbs;
    }

    private final List<Double> predictSequence(List<Integer> tokens) {
        Number number;
        int it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        if (this.selfTesting) {
            this.model.forget(tokens);
        }
        List<List<Integer>> preds = this.toPredictions(this.model.predict(tokens));
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)tokens.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            number = preds.get(it).indexOf(tokens.get(it));
            collection.add(number);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            number = Companion.toMRR(it);
            collection.add(number);
        }
        List mrrs = (List)destination$iv$iv;
        if (this.selfTesting) {
            this.model.learn(tokens);
        }
        return mrrs;
    }

    private final void logPredictionProgress(List<Double> modeled2) {
        DoubleSummaryStatistics stats2 = modeled2.stream().skip(1L).mapToDouble(logPredictionProgress.stats.1.INSTANCE).summaryStatistics();
        long prevCount = this.modelStats[0];
        long l = this.modelStats[0];
        DoubleSummaryStatistics doubleSummaryStatistics = stats2;
        Intrinsics.checkExpressionValueIsNotNull((Object)doubleSummaryStatistics, (String)"stats");
        this.modelStats[0] = l + doubleSummaryStatistics.getCount();
        this.mrr += stats2.getSum();
        if (this.modelStats[0] / (long)this.MODEL_PRINT_INTERVAL > prevCount / (long)this.MODEL_PRINT_INTERVAL && this.modelStats[1] != 0L) {
            System.out.printf("Predicting: %dK tokens processed in %ds, avg. MRR: %.4f\n", MathKt.roundToInt((double)((double)this.modelStats[0] / 1000.0)), (System.currentTimeMillis() + this.modelStats[1]) / (long)1000, this.mrr / (double)this.modelStats[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> toProb(@NotNull List<Pair<Double, Double>> probConfs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(probConfs, (String)"probConfs");
        Iterable $this$map$iv = probConfs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = this.toProb((Pair<Double, Double>)it);
            collection.add(d);
        }
        return (List)destination$iv$iv;
    }

    private final double toProb(Pair<Double, Double> probConf) {
        double prob = ((Number)probConf.getFirst()).doubleValue();
        double conf = ((Number)probConf.getSecond()).doubleValue();
        return prob * conf + (1.0 - conf) / (double)this.vocabulary.size();
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<Integer>> toPredictions(List<? extends Map<Integer, Pair<Double, Double>>> probConfs) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = probConfs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map map2 = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Integer> list = this.toPredictions((Map<Integer, Pair<Double, Double>>)it);
            collection.add(list);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> toPredictions(Map<Integer, Pair<Double, Double>> probConf) {
        Object object;
        Collection collection;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = probConf;
        boolean $i$f$map = false;
        Map<Integer, Pair<Double, Double>> map2 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv;
        boolean bl = false;
        Pair pair = iterator.entrySet().iterator();
        while (pair.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = pair.next();
            collection = destination$iv$iv22;
            boolean bl2 = false;
            object = new Pair(it.getKey(), (Object)this.toProb((Pair<Double, Double>)((Pair)it.getValue())));
            collection.add(object);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv22;
        boolean $i$f$sortedByDescending = false;
        $this$mapTo$iv$iv = $this$sortedByDescending$iv;
        boolean destination$iv$iv22 = false;
        Comparator $i$f$mapTo22 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(((Number)it.getSecond()).doubleValue());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = ((Number)it.getSecond()).doubleValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        $this$map$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$mapTo$iv$iv, (Comparator)$i$f$mapTo22), (int)predictionCutoff);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            object = ((Number)it.getFirst()).intValue();
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <K> List<List<K>> toLines(List<? extends K> modeled2, List<Integer> lineLengths) {
        ArrayList perLine = new ArrayList();
        int ix = 0;
        int n = 0;
        int n2 = ((Collection)lineLengths).size();
        while (n < n2) {
            void i;
            ArrayList<K> line = new ArrayList<K>();
            int n3 = 0;
            int n4 = ((Number)lineLengths.get((int)i)).intValue();
            while (n3 < n4) {
                void j;
                line.add(modeled2.get(ix++));
                ++j;
            }
            perLine.add(line);
            ++i;
        }
        return perLine;
    }

    private final DoubleSummaryStatistics getFileStats(Sequence<? extends List<? extends List<Double>>> fileProbs) {
        DoubleSummaryStatistics doubleSummaryStatistics = StreamsKt.asStream((Sequence)SequencesKt.flatMap(fileProbs, (Function1)getFileStats.1.INSTANCE)).mapToDouble(getFileStats.2.INSTANCE).summaryStatistics();
        Intrinsics.checkExpressionValueIsNotNull((Object)doubleSummaryStatistics, (String)"fileProbs\n      .flatMap\u2026     .summaryStatistics()");
        return doubleSummaryStatistics;
    }

    public final int getOrder() {
        if (this.model instanceof NGramModel) {
            return ((NGramModel)this.model).getOrder();
        }
        return -1;
    }

    @NotNull
    public final Model getModel() {
        return this.model;
    }

    @NotNull
    public final Vocabulary getVocabulary() {
        return this.vocabulary;
    }

    public ModelRunner(@NotNull Model model2, @NotNull Vocabulary vocabulary) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)vocabulary, (String)"vocabulary");
        this.model = model2;
        this.vocabulary = vocabulary;
        this.LEARN_PRINT_INTERVAL = 1000000L;
        this.learnStats = new long[2];
        this.MODEL_PRINT_INTERVAL = 100000;
        this.modelStats = new long[2];
    }

    public /* synthetic */ ModelRunner(Model model2, Vocabulary vocabulary, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vocabulary = new Vocabulary();
        }
        this(model2, vocabulary);
    }

    static {
        Companion = new Companion(null);
        double d = 2.0;
        double d2 = -1.0;
        boolean bl = false;
        double d3 = Math.log(d);
        INV_NEG_LOG_2 = d2 / d3;
        predictionCutoff = 10;
    }

    public static final /* synthetic */ double access$toProb(ModelRunner $this, Pair probConf) {
        return $this.toProb((Pair<Double, Double>)probConf);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/ngram/slp/modeling/runners/ModelRunner$Companion;", "", "()V", "DEFAULT_NGRAM_ORDER", "", "INV_NEG_LOG_2", "", "predictionCutoff", "getPredictionCutoff", "()I", "setPredictionCutoff", "(I)V", "toEntropy", "probability", "toMRR", "ix", "bd0177eacd27ae4e"})
    public static final class Companion {
        public final int getPredictionCutoff() {
            return predictionCutoff;
        }

        public final void setPredictionCutoff(int n) {
            predictionCutoff = n;
        }

        public final double toEntropy(double probability) {
            boolean bl = false;
            return Math.log(probability) * INV_NEG_LOG_2;
        }

        public final double toMRR(int ix) {
            return ix >= 0 ? 1.0 / (double)(ix + 1) : 0.0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

