/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.path.ArrayPathToken;
import com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import com.jayway.jsonpath.internal.path.PathToken;
import com.jayway.jsonpath.internal.path.PredicatePathToken;
import com.jayway.jsonpath.internal.path.PropertyPathToken;
import com.jayway.jsonpath.internal.path.WildcardPathToken;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collection;

public class ScanPathToken
extends PathToken {
    private static final Predicate FALSE_PREDICATE = new Predicate(){

        @Override
        public boolean matches(Object model2) {
            return false;
        }
    };

    ScanPathToken() {
    }

    @Override
    public void evaluate(String currentPath, PathRef parent, Object model2, EvaluationContextImpl ctx) {
        PathToken pt = this.next();
        ScanPathToken.walk(pt, currentPath, parent, model2, ctx, ScanPathToken.createScanPredicate(pt, ctx));
    }

    public static void walk(PathToken pt, String currentPath, PathRef parent, Object model2, EvaluationContextImpl ctx, Predicate predicate) {
        if (ctx.jsonProvider().isMap(model2)) {
            ScanPathToken.walkObject(pt, currentPath, parent, model2, ctx, predicate);
        } else if (ctx.jsonProvider().isArray(model2)) {
            ScanPathToken.walkArray(pt, currentPath, parent, model2, ctx, predicate);
        }
    }

    public static void walkArray(PathToken pt, String currentPath, PathRef parent, Object model2, EvaluationContextImpl ctx, Predicate predicate) {
        if (predicate.matches(model2)) {
            if (pt.isLeaf()) {
                pt.evaluate(currentPath, parent, model2, ctx);
            } else {
                PathToken next = pt.next();
                Iterable<?> models = ctx.jsonProvider().toIterable(model2);
                int idx = 0;
                for (Object evalModel : models) {
                    String evalPath = currentPath + "[" + idx + "]";
                    next.setUpstreamArrayIndex(idx);
                    next.evaluate(evalPath, parent, evalModel, ctx);
                    ++idx;
                }
            }
        }
        Iterable<?> models = ctx.jsonProvider().toIterable(model2);
        int idx = 0;
        for (Object evalModel : models) {
            String evalPath = currentPath + "[" + idx + "]";
            ScanPathToken.walk(pt, evalPath, PathRef.create(model2, idx), evalModel, ctx, predicate);
            ++idx;
        }
    }

    public static void walkObject(PathToken pt, String currentPath, PathRef parent, Object model2, EvaluationContextImpl ctx, Predicate predicate) {
        if (predicate.matches(model2)) {
            pt.evaluate(currentPath, parent, model2, ctx);
        }
        Collection<String> properties = ctx.jsonProvider().getPropertyKeys(model2);
        for (String property : properties) {
            String evalPath = currentPath + "['" + property + "']";
            Object propertyModel = ctx.jsonProvider().getMapValue(model2, property);
            if (propertyModel == JsonProvider.UNDEFINED) continue;
            ScanPathToken.walk(pt, evalPath, PathRef.create(model2, property), propertyModel, ctx, predicate);
        }
    }

    private static Predicate createScanPredicate(PathToken target, EvaluationContextImpl ctx) {
        if (target instanceof PropertyPathToken) {
            return new PropertyPathTokenPredicate(target, ctx);
        }
        if (target instanceof ArrayPathToken) {
            return new ArrayPathTokenPredicate(ctx);
        }
        if (target instanceof WildcardPathToken) {
            return new WildcardPathTokenPredicate();
        }
        if (target instanceof PredicatePathToken) {
            return new FilterPathTokenPredicate(target, ctx);
        }
        return FALSE_PREDICATE;
    }

    @Override
    public boolean isTokenDefinite() {
        return false;
    }

    @Override
    public String getPathFragment() {
        return "..";
    }

    private static final class PropertyPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;
        private PropertyPathToken propertyPathToken;

        private PropertyPathTokenPredicate(PathToken target, EvaluationContextImpl ctx) {
            this.ctx = ctx;
            this.propertyPathToken = (PropertyPathToken)target;
        }

        @Override
        public boolean matches(Object model2) {
            if (!this.ctx.jsonProvider().isMap(model2)) {
                return false;
            }
            if (!this.propertyPathToken.isTokenDefinite()) {
                return true;
            }
            if (this.propertyPathToken.isLeaf() && this.ctx.options().contains((Object)Option.DEFAULT_PATH_LEAF_TO_NULL)) {
                return true;
            }
            Collection<String> keys = this.ctx.jsonProvider().getPropertyKeys(model2);
            return keys.containsAll(this.propertyPathToken.getProperties());
        }
    }

    private static final class ArrayPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;

        private ArrayPathTokenPredicate(EvaluationContextImpl ctx) {
            this.ctx = ctx;
        }

        @Override
        public boolean matches(Object model2) {
            return this.ctx.jsonProvider().isArray(model2);
        }
    }

    private static final class WildcardPathTokenPredicate
    implements Predicate {
        private WildcardPathTokenPredicate() {
        }

        @Override
        public boolean matches(Object model2) {
            return true;
        }
    }

    private static final class FilterPathTokenPredicate
    implements Predicate {
        private final EvaluationContextImpl ctx;
        private PredicatePathToken predicatePathToken;

        private FilterPathTokenPredicate(PathToken target, EvaluationContextImpl ctx) {
            this.ctx = ctx;
            this.predicatePathToken = (PredicatePathToken)target;
        }

        @Override
        public boolean matches(Object model2) {
            return this.predicatePathToken.accept(model2, this.ctx.rootDocument(), this.ctx.configuration(), this.ctx);
        }
    }

    private static interface Predicate {
        public boolean matches(Object var1);
    }
}

