/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.context;

import com.openhtmltopdf.context.StandardAttributeResolver;
import com.openhtmltopdf.context.StylesheetFactoryImpl;
import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.extend.lib.DOMTreeResolver;
import com.openhtmltopdf.css.newmatch.CascadedStyle;
import com.openhtmltopdf.css.newmatch.Matcher;
import com.openhtmltopdf.css.newmatch.PageInfo;
import com.openhtmltopdf.css.parser.CSSPrimitiveValue;
import com.openhtmltopdf.css.sheet.FontFaceRule;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import com.openhtmltopdf.css.sheet.Stylesheet;
import com.openhtmltopdf.css.sheet.StylesheetInfo;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StyleReference {
    private SharedContext _context;
    private NamespaceHandler _nsh;
    private Document _doc;
    private final StylesheetFactoryImpl _stylesheetFactory;
    private Matcher _matcher;
    private UserAgentCallback _uac;

    public StyleReference(UserAgentCallback userAgent) {
        this._uac = userAgent;
        this._stylesheetFactory = new StylesheetFactoryImpl(userAgent);
    }

    public CalculatedStyle getRootElementStyle() {
        if (this._context != null && this._doc != null) {
            return this._context.getStyle(this._doc.getDocumentElement());
        }
        return null;
    }

    public void setDocumentContext(SharedContext context, NamespaceHandler nsh, Document doc, UserInterface ui) {
        this._context = context;
        this._nsh = nsh;
        this._doc = doc;
        StandardAttributeResolver attRes = new StandardAttributeResolver(this._nsh, this._uac, ui);
        List<StylesheetInfo> infos = this.getStylesheets();
        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.MATCH_MEDIA_IS, this._context.getMedia());
        this._matcher = new Matcher(new DOMTreeResolver(), attRes, this._stylesheetFactory, this.readAndParseAll(infos, this._context.getMedia()), this._context.getMedia());
    }

    private List<Stylesheet> readAndParseAll(List<StylesheetInfo> infos, String medium) {
        ArrayList<Stylesheet> result2 = new ArrayList<Stylesheet>(infos.size() + 15);
        for (StylesheetInfo info : infos) {
            if (!info.appliesToMedia(medium)) continue;
            Stylesheet sheet = info.getStylesheet();
            if (sheet == null) {
                sheet = this._stylesheetFactory.getStylesheet(info);
            }
            if (sheet != null) {
                if (sheet.getImportRules().size() > 0) {
                    result2.addAll(this.readAndParseAll(sheet.getImportRules(), medium));
                }
                result2.add(sheet);
                continue;
            }
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.LOAD_UNABLE_TO_LOAD_CSS_FROM_URI, info.getUri());
        }
        return result2;
    }

    public boolean isHoverStyled(Element e) {
        return this._matcher.isHoverStyled(e);
    }

    @Deprecated
    public Map<String, CSSPrimitiveValue> getCascadedPropertiesMap(Element e) {
        CascadedStyle cs = this._matcher.getCascadedStyle(e, false);
        LinkedHashMap<String, CSSPrimitiveValue> props = new LinkedHashMap<String, CSSPrimitiveValue>();
        for (PropertyDeclaration pd : cs.getCascadedPropertyDeclarations()) {
            String propName = pd.getPropertyName();
            CSSName cssName = CSSName.getByPropertyName(propName);
            props.put(propName, cs.propertyByName(cssName).getValue());
        }
        return props;
    }

    public CascadedStyle getPseudoElementStyle(Node node, String pseudoElement) {
        Element e = null;
        e = node.getNodeType() == 1 ? (Element)node : (Element)node.getParentNode();
        return this._matcher.getPECascadedStyle(e, pseudoElement);
    }

    public CascadedStyle getCascadedStyle(Element e, boolean restyle) {
        if (e == null) {
            return CascadedStyle.emptyCascadedStyle;
        }
        return this._matcher.getCascadedStyle(e, restyle);
    }

    public String getCSSForAllDescendants(Element e) {
        return this._matcher.getCSSForAllDescendants(e);
    }

    public PageInfo getPageStyle(String pageName, String pseudoPage) {
        return this._matcher.getPageCascadedStyle(pageName, pseudoPage);
    }

    private List<StylesheetInfo> getStylesheets() {
        ArrayList<StylesheetInfo> infos = new ArrayList<StylesheetInfo>();
        long st = System.currentTimeMillis();
        StylesheetInfo defaultStylesheet = this._nsh.getDefaultStylesheet(this._stylesheetFactory);
        if (defaultStylesheet != null) {
            infos.add(defaultStylesheet);
        }
        StylesheetInfo[] refs = this._nsh.getStylesheets(this._doc);
        int inlineStyleCount = 0;
        if (refs != null) {
            for (StylesheetInfo ref : refs) {
                if (!ref.isInline()) {
                    String uri = this._uac.resolveURI(ref.getUri());
                    ref.setUri(uri);
                    continue;
                }
                ref.setUri(this._uac.getBaseURL() + "#inline_style_" + ++inlineStyleCount);
                Stylesheet sheet = this._stylesheetFactory.parse(new StringReader(ref.getContent()), ref);
                ref.setStylesheet(sheet);
                ref.setUri(null);
            }
            infos.addAll(Arrays.asList(refs));
        }
        long el = System.currentTimeMillis() - st;
        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_PARSE_STYLESHEETS_TIME, el);
        return infos;
    }

    public List<FontFaceRule> getFontFaceRules() {
        return this._matcher.getFontFaceRules();
    }

    public void setUserAgentCallback(UserAgentCallback userAgentCallback) {
        this._uac = userAgentCallback;
        this._stylesheetFactory.setUserAgentCallback(userAgentCallback);
    }

    public void setSupportCMYKColors(boolean b) {
        this._stylesheetFactory.setSupportCMYKColors(b);
    }
}

