/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.layout.InlineBoxMeasurements;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.InlineLayoutBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VerticalAlignContext {
    private final List<InlineBoxMeasurements> _measurements = new ArrayList<InlineBoxMeasurements>();
    private int _inlineTop;
    private boolean _inlineTopSet = false;
    private int _inlineBottom;
    private boolean _inlineBottomSet = false;
    private int _paintingTop;
    private boolean _paintingTopSet = false;
    private int _paintingBottom;
    private boolean _paintingBottomSet = false;
    private List<ChildContextData> _children = new ArrayList<ChildContextData>();
    private VerticalAlignContext _parent = null;

    private void moveTrackedValues(int ty) {
        if (this._inlineTopSet) {
            this._inlineTop += ty;
        }
        if (this._inlineBottomSet) {
            this._inlineBottom += ty;
        }
        if (this._paintingTopSet) {
            this._paintingTop += ty;
        }
        if (this._paintingBottomSet) {
            this._paintingBottom += ty;
        }
    }

    public int getInlineBottom() {
        return this._inlineBottom;
    }

    public int getInlineTop() {
        return this._inlineTop;
    }

    public void updateInlineTop(int inlineTop) {
        if (!this._inlineTopSet || inlineTop < this._inlineTop) {
            this._inlineTop = inlineTop;
            this._inlineTopSet = true;
        }
    }

    public void updatePaintingTop(int paintingTop) {
        if (!this._paintingTopSet || paintingTop < this._paintingTop) {
            this._paintingTop = paintingTop;
            this._paintingTopSet = true;
        }
    }

    public void updateInlineBottom(int inlineBottom) {
        if (!this._inlineBottomSet || inlineBottom > this._inlineBottom) {
            this._inlineBottom = inlineBottom;
            this._inlineBottomSet = true;
        }
    }

    public void updatePaintingBottom(int paintingBottom) {
        if (!this._paintingBottomSet || paintingBottom > this._paintingBottom) {
            this._paintingBottom = paintingBottom;
            this._paintingBottomSet = true;
        }
    }

    public int getLineBoxHeight() {
        return this._inlineBottom - this._inlineTop;
    }

    public void pushMeasurements(InlineBoxMeasurements measurements) {
        this._measurements.add(measurements);
        this.updateInlineTop(measurements.getInlineTop());
        this.updateInlineBottom(measurements.getInlineBottom());
        this.updatePaintingTop(measurements.getPaintingTop());
        this.updatePaintingBottom(measurements.getPaintingBottom());
    }

    public InlineBoxMeasurements getParentMeasurements() {
        return this._measurements.get(this._measurements.size() - 1);
    }

    public void popMeasurements() {
        this._measurements.remove(this._measurements.size() - 1);
    }

    public int getPaintingBottom() {
        return this._paintingBottom;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public VerticalAlignContext createChild(Box root) {
        VerticalAlignContext result2 = new VerticalAlignContext();
        VerticalAlignContext vaRoot = this.getRoot();
        result2.setParent(vaRoot);
        InlineBoxMeasurements initial = vaRoot._measurements.get(0);
        result2.pushMeasurements(initial);
        if (vaRoot._children == null) {
            vaRoot._children = new ArrayList<ChildContextData>();
        }
        vaRoot._children.add(new ChildContextData(root, result2));
        return result2;
    }

    public List<ChildContextData> getChildren() {
        return this._children == null ? Collections.emptyList() : this._children;
    }

    public VerticalAlignContext getParent() {
        return this._parent;
    }

    public void setParent(VerticalAlignContext parent) {
        this._parent = parent;
    }

    private VerticalAlignContext getRoot() {
        VerticalAlignContext result2 = this;
        return result2.getParent() != null ? result2.getParent() : this;
    }

    private void merge(VerticalAlignContext context) {
        this.updateInlineBottom(context.getInlineBottom());
        this.updateInlineTop(context.getInlineTop());
        this.updatePaintingBottom(context.getPaintingBottom());
        this.updatePaintingTop(context.getPaintingTop());
    }

    public void alignChildren() {
        List<ChildContextData> children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ChildContextData data = children.get(i);
            data.align();
            this.merge(data.getVerticalAlignContext());
        }
    }

    public void setInitialMeasurements(InlineBoxMeasurements measurements) {
        this._measurements.add(measurements);
    }

    private static final class ChildContextData {
        private final Box _root;
        private final VerticalAlignContext _verticalAlignContext;

        public ChildContextData(Box root, VerticalAlignContext vaContext) {
            this._root = root;
            this._verticalAlignContext = vaContext;
        }

        public VerticalAlignContext getVerticalAlignContext() {
            return this._verticalAlignContext;
        }

        private void moveContextContents(int ty) {
            this.moveInlineContents(this._root, ty);
        }

        private void moveInlineContents(Box box, int ty) {
            if (this.canBeMoved(box)) {
                box.setY(box.getY() + ty);
                if (box instanceof InlineLayoutBox) {
                    InlineLayoutBox iB = (InlineLayoutBox)box;
                    for (int i = 0; i < iB.getInlineChildCount(); ++i) {
                        Object child = iB.getInlineChild(i);
                        if (!(child instanceof Box)) continue;
                        this.moveInlineContents((Box)child, ty);
                    }
                }
            }
        }

        private boolean canBeMoved(Box box) {
            IdentValue vAlign = box.getStyle().getIdent(CSSName.VERTICAL_ALIGN);
            return box == this._root || vAlign != IdentValue.TOP && vAlign != IdentValue.BOTTOM;
        }

        public void align() {
            IdentValue vAlign = this._root.getStyle().getIdent(CSSName.VERTICAL_ALIGN);
            int delta = 0;
            if (vAlign == IdentValue.TOP) {
                delta = this._verticalAlignContext.getRoot().getInlineTop() - this._verticalAlignContext.getInlineTop();
            } else if (vAlign == IdentValue.BOTTOM) {
                delta = this._verticalAlignContext.getRoot().getInlineBottom() - this._verticalAlignContext.getInlineBottom();
            } else {
                throw new RuntimeException("internal error");
            }
            this._verticalAlignContext.moveTrackedValues(delta);
            this.moveContextContents(delta);
        }
    }
}

