/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser;

import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.util.Parsing;
import com.vladsch.flexmark.parser.InlineParserOptions;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequence;
import java.util.ArrayList;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightInlineParserImpl
implements LightInlineParser {
    protected final InlineParserOptions options;
    protected final Parsing myParsing;
    protected Node block;
    protected BasedSequence input;
    protected int index;
    protected ArrayList<BasedSequence> currentText;
    protected Document document;

    public LightInlineParserImpl(DataHolder dataOptions) {
        this.options = new InlineParserOptions(dataOptions);
        this.myParsing = new Parsing(dataOptions);
    }

    @Override
    @NotNull
    public ArrayList<BasedSequence> getCurrentText() {
        if (this.currentText == null) {
            this.currentText = new ArrayList();
        }
        return this.currentText;
    }

    @Override
    @NotNull
    public BasedSequence getInput() {
        return this.input;
    }

    @Override
    public void setInput(BasedSequence input) {
        this.input = input;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(@NotNull Document document) {
        this.document = document;
    }

    @Override
    @NotNull
    public InlineParserOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public Parsing getParsing() {
        return this.myParsing;
    }

    @Override
    @NotNull
    public Node getBlock() {
        return this.block;
    }

    @Override
    public void setBlock(@NotNull Node block) {
        this.block = block;
    }

    @Override
    public void moveNodes(@NotNull Node fromNode, @NotNull Node toNode) {
        if (fromNode != toNode) {
            Node next = fromNode.getNext();
            while (next != null) {
                Node nextNode = next.getNext();
                next.unlink();
                fromNode.appendChild(next);
                if (next == toNode) break;
                next = nextNode;
            }
        }
        fromNode.setCharsFromContent();
    }

    @Override
    public void appendText(@NotNull BasedSequence text) {
        this.getCurrentText().add(text);
    }

    @Override
    public void appendText(@NotNull BasedSequence text, int beginIndex, int endIndex) {
        this.getCurrentText().add(text.subSequence(beginIndex, endIndex));
    }

    @Override
    public void appendNode(@NotNull Node node) {
        this.flushTextNode();
        this.block.appendChild(node);
    }

    @Override
    @NotNull
    public Text appendSeparateText(@NotNull BasedSequence text) {
        Text node = new Text(text);
        this.appendNode(node);
        return node;
    }

    @Override
    public boolean flushTextNode() {
        if (this.currentText != null) {
            this.block.appendChild(new Text(SegmentedSequence.create(this.input, this.currentText)));
            this.currentText = null;
            return true;
        }
        return false;
    }

    @Override
    public BasedSequence match(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher(this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            MatchResult result2 = matcher.toMatchResult();
            return this.input.subSequence(result2.start(), result2.end());
        }
        return null;
    }

    @Override
    public BasedSequence[] matchWithGroups(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher(this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            MatchResult result2 = matcher.toMatchResult();
            int iMax = matcher.groupCount() + 1;
            BasedSequence[] results = new BasedSequence[iMax];
            results[0] = this.input.subSequence(result2.start(), result2.end());
            for (int i = 1; i < iMax; ++i) {
                results[i] = matcher.group(i) != null ? this.input.subSequence(result2.start(i), result2.end(i)) : null;
            }
            return results;
        }
        return null;
    }

    @Override
    public Matcher matcher(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        Matcher matcher = re.matcher(this.input);
        matcher.region(this.index, this.input.length());
        boolean m = matcher.find();
        if (m) {
            this.index = matcher.end();
            return matcher;
        }
        return null;
    }

    @Override
    public char peek() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index);
        }
        return '\u0000';
    }

    @Override
    public char peek(int ahead) {
        if (this.index + ahead < this.input.length()) {
            return this.input.charAt(this.index + ahead);
        }
        return '\u0000';
    }

    @Override
    public boolean spnl() {
        this.match(this.myParsing.SPNL);
        return true;
    }

    @Override
    public boolean nonIndentSp() {
        this.match(this.myParsing.SPNI);
        return true;
    }

    @Override
    public boolean sp() {
        this.match(this.myParsing.SP);
        return true;
    }

    @Override
    public boolean spnlUrl() {
        return this.match(this.myParsing.SPNL_URL) != null;
    }

    @Override
    @Nullable
    public BasedSequence toEOL() {
        return this.match(this.myParsing.REST_OF_LINE);
    }
}

