/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.MultiSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SmallFloat;

public abstract class SimilarityBase
extends Similarity {
    private static final double LOG_2 = Math.log(2.0);
    protected boolean discountOverlaps = true;
    private static final float[] LENGTH_TABLE = new float[256];

    public void setDiscountOverlaps(boolean v) {
        this.discountOverlaps = v;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    @Override
    public final Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Similarity.SimScorer[] weights = new Similarity.SimScorer[termStats.length];
        for (int i = 0; i < termStats.length; ++i) {
            BasicStats stats2 = this.newStats(collectionStats.field(), boost);
            this.fillBasicStats(stats2, collectionStats, termStats[i]);
            weights[i] = new BasicSimScorer(stats2);
        }
        if (weights.length == 1) {
            return weights[0];
        }
        return new MultiSimilarity.MultiSimScorer(weights);
    }

    protected BasicStats newStats(String field, double boost) {
        return new BasicStats(field, boost);
    }

    protected void fillBasicStats(BasicStats stats2, CollectionStatistics collectionStats, TermStatistics termStats) {
        assert (termStats.totalTermFreq() <= collectionStats.sumTotalTermFreq());
        assert (termStats.docFreq() <= collectionStats.sumDocFreq());
        stats2.setNumberOfDocuments(collectionStats.docCount());
        stats2.setNumberOfFieldTokens(collectionStats.sumTotalTermFreq());
        stats2.setAvgFieldLength((double)collectionStats.sumTotalTermFreq() / (double)collectionStats.docCount());
        stats2.setDocFreq(termStats.docFreq());
        stats2.setTotalTermFreq(termStats.totalTermFreq());
    }

    protected abstract double score(BasicStats var1, double var2, double var4);

    protected void explain(List<Explanation> subExpls, BasicStats stats2, double freq, double docLen) {
    }

    protected Explanation explain(BasicStats stats2, Explanation freq, double docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats2, freq.getValue().floatValue(), docLen);
        return Explanation.match((Number)Float.valueOf((float)this.score(stats2, freq.getValue().floatValue(), docLen)), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), computed from:", subs);
    }

    public abstract String toString();

    @Override
    public final long computeNorm(FieldInvertState state) {
        int numTerms = state.getIndexOptions() == IndexOptions.DOCS && state.getIndexCreatedVersionMajor() >= 8 ? state.getUniqueTermCount() : (this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength());
        return SmallFloat.intToByte4(numTerms);
    }

    public static double log2(double x) {
        return Math.log(x) / LOG_2;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            SimilarityBase.LENGTH_TABLE[i] = SmallFloat.byte4ToInt((byte)i);
        }
    }

    final class BasicSimScorer
    extends Similarity.SimScorer {
        final BasicStats stats;

        BasicSimScorer(BasicStats stats2) {
            this.stats = stats2;
        }

        double getLengthValue(long norm) {
            return LENGTH_TABLE[Byte.toUnsignedInt((byte)norm)];
        }

        @Override
        public float score(float freq, long norm) {
            return (float)SimilarityBase.this.score(this.stats, freq, this.getLengthValue(norm));
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            return SimilarityBase.this.explain(this.stats, freq, this.getLengthValue(norm));
        }
    }
}

