/*
 * Decompiled with CFR 0.152.
 */
package javaslang;

import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javaslang.Function1;
import javaslang.Function2;
import javaslang.Tuple;
import javaslang.Tuple3;
import javaslang.control.Option;
import javaslang.control.Try;
import javaslang.\u03bb;

@FunctionalInterface
public interface Function3<T1, T2, T3, R>
extends \u03bb<R> {
    public static final long serialVersionUID = 1L;

    public static <T1, T2, T3, R> Function3<T1, T2, T3, R> of(Function3<T1, T2, T3, R> methodReference) {
        return methodReference;
    }

    public static <T1, T2, T3, R> Function3<T1, T2, T3, Option<R>> lift(Function3<T1, T2, T3, R> partialFunction) {
        return (t1, t2, t3) -> Try.of(() -> partialFunction.apply(t1, t2, t3)).getOption();
    }

    public R apply(T1 var1, T2 var2, T3 var3);

    default public Function2<T2, T3, R> apply(T1 t1) {
        return (t2, t3) -> this.apply(t1, t2, t3);
    }

    default public Function1<T3, R> apply(T1 t1, T2 t2) {
        return t3 -> this.apply(t1, t2, t3);
    }

    @Override
    default public int arity() {
        return 3;
    }

    default public Function1<T1, Function1<T2, Function1<T3, R>>> curried() {
        return t1 -> t2 -> t3 -> this.apply(t1, t2, t3);
    }

    default public Function1<Tuple3<T1, T2, T3>, R> tupled() {
        return t -> this.apply(t._1, t._2, t._3);
    }

    default public Function3<T3, T2, T1, R> reversed() {
        return (t3, t2, t1) -> this.apply(t1, t2, t3);
    }

    default public Function3<T1, T2, T3, R> memoized() {
        if (this.isMemoized()) {
            return this;
        }
        HashMap cache = new HashMap();
        return (Function3<Object, Object, Object, Object> & \u03bb.Memoized)(t1, t2, t3) -> \u03bb.Memoized.of(cache, Tuple.of(t1, t2, t3), this.tupled());
    }

    default public <V> Function3<T1, T2, T3, V> andThen(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after, "after is null");
        return (t1, t2, t3) -> after.apply((R)this.apply(t1, t2, t3));
    }
}

