/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.log.HgHistoryUtil;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgLogCommand {
    private static final Logger LOG = Logger.getInstance((String)HgLogCommand.class.getName());
    @NotNull
    private final Project myProject;
    @NotNull
    private HgVersion myVersion;
    private boolean myIncludeRemoved;
    private boolean myFollowCopies;
    private boolean myLogFile;
    private boolean myLargeFilesWithFollowSupported;

    public void setIncludeRemoved(boolean includeRemoved) {
        this.myIncludeRemoved = includeRemoved;
    }

    public void setFollowCopies(boolean followCopies) {
        this.myFollowCopies = followCopies;
    }

    public void setLogFile(boolean logFile) {
        this.myLogFile = logFile;
    }

    public HgLogCommand(@NotNull Project project) {
        if (project == null) {
            HgLogCommand.$$$reportNull$$$0(0);
        }
        this.myLogFile = true;
        this.myLargeFilesWithFollowSupported = false;
        this.myProject = project;
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            LOG.info("Vcs couldn't be null for project");
            return;
        }
        this.myVersion = vcs.getVersion();
        this.myLargeFilesWithFollowSupported = this.myVersion.isLargeFilesWithFollowSupported();
    }

    public final List<HgFileRevision> execute(HgFile hgFile, int limit, boolean includeFiles) {
        return this.execute(hgFile, limit, includeFiles, null);
    }

    @NotNull
    public HgVersion getVersion() {
        HgVersion hgVersion = this.myVersion;
        if (hgVersion == null) {
            HgLogCommand.$$$reportNull$$$0(1);
        }
        return hgVersion;
    }

    public final List<HgFileRevision> execute(HgFile hgFile, int limit, boolean includeFiles, @Nullable List<String> argsForCmd) {
        if (limit <= 0 && limit != -1 || hgFile == null) {
            return Collections.emptyList();
        }
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(includeFiles, this.myVersion);
        String template = HgChangesetUtil.makeTemplate(templates);
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)this.myProject));
        HgFile originalHgFile = new HgFile(hgFile.getRepo(), originalFileName);
        HgCommandResult result = this.execute(hgFile.getRepo(), template, limit, originalHgFile, argsForCmd);
        return HgHistoryUtil.getCommitRecords(this.myProject, result, new HgFileRevisionLogParser(this.myProject, originalHgFile, this.myVersion));
    }

    @NotNull
    private List<String> createArguments(@NotNull String template, int limit, @Nullable HgFile hgFile, @Nullable List<String> argsForCmd) {
        if (template == null) {
            HgLogCommand.$$$reportNull$$$0(2);
        }
        LinkedList<String> arguments = new LinkedList<String>();
        if (!(!this.myIncludeRemoved || this.myFollowCopies && this.myLogFile)) {
            arguments.add("--removed");
        }
        if (this.myFollowCopies) {
            arguments.add("--follow");
            if (!this.myLargeFilesWithFollowSupported) {
                arguments.add("--config");
                arguments.add("extensions.largefiles=!");
            }
        }
        arguments.add("--template");
        arguments.add(template);
        if (limit != -1) {
            arguments.add("--limit");
            arguments.add(String.valueOf(limit));
        }
        if (argsForCmd != null) {
            arguments.addAll(argsForCmd);
        }
        if (this.myLogFile && hgFile != null) {
            arguments.add(hgFile.getRelativePath());
        }
        LinkedList<String> linkedList = arguments;
        if (linkedList == null) {
            HgLogCommand.$$$reportNull$$$0(3);
        }
        return linkedList;
    }

    @Nullable
    public HgCommandResult execute(@NotNull VirtualFile repo, @NotNull String template, int limit, @Nullable HgFile hgFile, @Nullable List<String> argsForCmd) {
        ShellCommand.CommandResultCollector collector;
        boolean success;
        if (repo == null) {
            HgLogCommand.$$$reportNull$$$0(4);
        }
        if (template == null) {
            HgLogCommand.$$$reportNull$$$0(5);
        }
        return (success = this.execute(repo, template, limit, hgFile, argsForCmd, collector = new ShellCommand.CommandResultCollector(false))) ? collector.getResult() : null;
    }

    public boolean execute(@NotNull VirtualFile repo, @NotNull String template, int limit, @Nullable HgFile hgFile, @Nullable List<String> argsForCmd, @NotNull HgLineProcessListener listener) {
        if (repo == null) {
            HgLogCommand.$$$reportNull$$$0(6);
        }
        if (template == null) {
            HgLogCommand.$$$reportNull$$$0(7);
        }
        if (listener == null) {
            HgLogCommand.$$$reportNull$$$0(8);
        }
        List<String> arguments = this.createArguments(template, limit, hgFile, argsForCmd);
        HgCommandExecutor commandExecutor = new HgCommandExecutor(this.myProject);
        commandExecutor.setOutputAlwaysSuppressed(true);
        return commandExecutor.executeInCurrentThread(repo, "log", arguments, false, listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/command/HgLogCommand";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/command/HgLogCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createArguments";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

