/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.beust.jcommander;

import java.util.EnumSet;
import java.util.List;
import org.gradle.internal.impldep.com.beust.jcommander.DefaultUsageFormatter;
import org.gradle.internal.impldep.com.beust.jcommander.JCommander;
import org.gradle.internal.impldep.com.beust.jcommander.ParameterDescription;
import org.gradle.internal.impldep.com.beust.jcommander.Strings;
import org.gradle.internal.impldep.com.beust.jcommander.WrappedParameter;

public class UnixStyleUsageFormatter
extends DefaultUsageFormatter {
    public UnixStyleUsageFormatter(JCommander commander) {
        super(commander);
    }

    @Override
    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        String prefix;
        WrappedParameter parameter;
        if (sortedParameters.size() > 0) {
            out.append(indent).append("  Options:\n");
        }
        int prefixIndent = 0;
        for (ParameterDescription pd : sortedParameters) {
            parameter = pd.getParameter();
            prefix = (parameter.required() ? "* " : "  ") + pd.getNames();
            if (prefix.length() <= prefixIndent) continue;
            prefixIndent = prefix.length();
        }
        for (ParameterDescription pd : sortedParameters) {
            Class<?> type;
            parameter = pd.getParameter();
            prefix = (parameter.required() ? "* " : "  ") + pd.getNames();
            out.append(indent).append("  ").append(prefix).append(UnixStyleUsageFormatter.s(prefixIndent - prefix.length())).append(" ");
            int initialLinePrefixLength = indent.length() + prefixIndent + 3;
            String description = pd.getDescription();
            Object def = pd.getDefault();
            if (pd.isDynamicParameter()) {
                String syntax = "(syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value)";
                description = description + (description.length() == 0 ? "" : " ") + syntax;
            }
            if (def != null && !pd.isHelp()) {
                String displayedDef = Strings.isStringEmpty(def.toString()) ? "<empty string>" : def.toString();
                String defaultText = "(default: " + (parameter.password() ? "********" : displayedDef) + ")";
                description = description + (description.length() == 0 ? "" : " ") + defaultText;
            }
            if ((type = pd.getParameterized().getType()).isEnum()) {
                String valueList = EnumSet.allOf(type).toString();
                if (!description.contains("Options: " + valueList)) {
                    String possibleValues = "(values: " + valueList + ")";
                    description = description + (description.length() == 0 ? "" : " ") + possibleValues;
                }
            }
            this.wrapDescription(out, indentCount + prefixIndent - 3, initialLinePrefixLength, description);
            out.append("\n");
        }
    }
}

