/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.h2.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.gradle.internal.impldep.org.h2.compress.CompressDeflate;
import org.gradle.internal.impldep.org.h2.compress.CompressLZF;
import org.gradle.internal.impldep.org.h2.compress.Compressor;
import org.gradle.internal.impldep.org.h2.mvstore.Chunk;
import org.gradle.internal.impldep.org.h2.mvstore.Cursor;
import org.gradle.internal.impldep.org.h2.mvstore.DataUtils;
import org.gradle.internal.impldep.org.h2.mvstore.FileStore;
import org.gradle.internal.impldep.org.h2.mvstore.MVMap;
import org.gradle.internal.impldep.org.h2.mvstore.MVStoreException;
import org.gradle.internal.impldep.org.h2.mvstore.MVStoreTool;
import org.gradle.internal.impldep.org.h2.mvstore.Page;
import org.gradle.internal.impldep.org.h2.mvstore.RootReference;
import org.gradle.internal.impldep.org.h2.mvstore.WriteBuffer;
import org.gradle.internal.impldep.org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.gradle.internal.impldep.org.h2.mvstore.type.StringDataType;
import org.gradle.internal.impldep.org.h2.util.MathUtils;
import org.gradle.internal.impldep.org.h2.util.Utils;

public class MVStore
implements AutoCloseable {
    private static final String HDR_H = "H";
    private static final String HDR_BLOCK_SIZE = "blockSize";
    private static final String HDR_FORMAT = "format";
    private static final String HDR_CREATED = "created";
    private static final String HDR_FORMAT_READ = "formatRead";
    private static final String HDR_CHUNK = "chunk";
    private static final String HDR_BLOCK = "block";
    private static final String HDR_VERSION = "version";
    private static final String HDR_CLEAN = "clean";
    private static final String HDR_FLETCHER = "fletcher";
    public static final String META_ID_KEY = "meta.id";
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE_MIN = 2;
    private static final int FORMAT_WRITE_MAX = 2;
    private static final int FORMAT_READ_MIN = 2;
    private static final int FORMAT_READ_MAX = 2;
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private static final int PIPE_LENGTH = 1;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final ReentrantLock serializationLock = new ReentrantLock(true);
    private final ReentrantLock saveChunkLock = new ReentrantLock(true);
    private final AtomicReference<BackgroundWriterThread> backgroundWriterThread = new AtomicReference();
    private ThreadPoolExecutor serializationExecutor;
    private ThreadPoolExecutor bufferSaveExecutor;
    private volatile boolean reuseSpace = true;
    private volatile int state;
    private final FileStore fileStore;
    private final boolean fileStoreShallBeClosed;
    private final int pageSplitSize;
    private final int keysPerPage;
    private final CacheLongKeyLIRS<Page<?, ?>> cache;
    private final CacheLongKeyLIRS<long[]> chunksToC;
    private volatile Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final Queue<RemovedPageInfo> removedPages = new PriorityBlockingQueue<RemovedPageInfo>();
    private final Deque<Chunk> deadChunks = new ArrayDeque<Chunk>();
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final MVMap<String, String> layout;
    private final MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private final HashMap<String, Object> storeHeader = new HashMap();
    private final Queue<WriteBuffer> writeBufferPool = new ArrayBlockingQueue<WriteBuffer>(2);
    private final AtomicInteger lastMapId = new AtomicInteger();
    private int lastChunkId;
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final boolean recoveryMode;
    public final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private volatile long currentVersion;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private final int autoCommitMemory;
    private volatile boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private final int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private volatile MVStoreException panicException;
    private long lastTimeAbsolute;
    private long leafCount;
    private long nonLeafCount;
    private volatile LongConsumer oldestVersionTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(Map<String, Object> map) {
        Object object;
        int n;
        this.recoveryMode = map.containsKey("recoveryMode");
        this.compressionLevel = DataUtils.getConfigParam(map, "compress", 0);
        String string = (String)map.get("fileName");
        FileStore fileStore = (FileStore)map.get("fileStore");
        boolean bl = false;
        if (fileStore == null) {
            if (string != null) {
                fileStore = new FileStore();
                bl = true;
            }
            this.fileStoreShallBeClosed = true;
        } else {
            if (string != null) {
                throw new IllegalArgumentException("fileName && fileStore");
            }
            Boolean bl2 = (Boolean)map.get("fileStoreIsAdopted");
            this.fileStoreShallBeClosed = bl2 != null && bl2 != false;
        }
        this.fileStore = fileStore;
        int n2 = 48;
        CacheLongKeyLIRS.Config config = null;
        CacheLongKeyLIRS.Config config2 = null;
        if (this.fileStore != null) {
            n = DataUtils.getConfigParam(map, "cacheSize", 16);
            if (n > 0) {
                config = new CacheLongKeyLIRS.Config();
                config.maxMemory = (long)n * 1024L * 1024L;
                object = map.get("cacheConcurrency");
                if (object != null) {
                    config.segmentCount = (Integer)object;
                }
            }
            config2 = new CacheLongKeyLIRS.Config();
            config2.maxMemory = 0x100000L;
            n2 = 16384;
        }
        this.cache = config != null ? new CacheLongKeyLIRS(config) : null;
        this.chunksToC = config2 == null ? null : new CacheLongKeyLIRS(config2);
        n2 = DataUtils.getConfigParam(map, "pageSplitSize", n2);
        if (this.cache != null && (long)n2 > this.cache.getMaxItemSize()) {
            n2 = (int)this.cache.getMaxItemSize();
        }
        this.pageSplitSize = n2;
        this.keysPerPage = DataUtils.getConfigParam(map, "keysPerPage", 48);
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)map.get("backgroundExceptionHandler");
        this.layout = new MVMap<String, String>(this, 0, StringDataType.INSTANCE, StringDataType.INSTANCE);
        if (this.fileStore != null) {
            int n3;
            this.retentionTime = this.fileStore.getDefaultRetentionTime();
            n = Math.max(1, Math.min(19, Utils.scaleForAvailableMemory(64))) * 1024;
            n = DataUtils.getConfigParam(map, "autoCommitBufferSize", n);
            this.autoCommitMemory = n * 1024;
            this.autoCompactFillRate = DataUtils.getConfigParam(map, "autoCompactFillRate", 90);
            object = (char[])map.remove("encryptionKey");
            this.storeLock.lock();
            try {
                this.saveChunkLock.lock();
                try {
                    if (bl) {
                        n3 = map.containsKey("readOnly");
                        this.fileStore.open(string, n3 != 0, (char[])object);
                    }
                    if (this.fileStore.size() == 0L) {
                        this.creationTime = this.getTimeAbsolute();
                        this.storeHeader.put(HDR_H, 2);
                        this.storeHeader.put(HDR_BLOCK_SIZE, 4096);
                        this.storeHeader.put(HDR_FORMAT, 2);
                        this.storeHeader.put(HDR_CREATED, this.creationTime);
                        this.setLastChunk(null);
                        this.writeStoreHeader();
                    } else {
                        this.readStoreHeader();
                    }
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
            catch (MVStoreException mVStoreException) {
                this.panic(mVStoreException);
            }
            finally {
                if (object != null) {
                    Arrays.fill((char[])object, '\u0000');
                }
                this.unlockAndCheckPanicCondition();
            }
            this.lastCommitTime = this.getTimeSinceCreation();
            this.meta = this.openMetaMap();
            this.scrubLayoutMap();
            this.scrubMetaMap();
            n3 = DataUtils.getConfigParam(map, "autoCommitDelay", 1000);
            this.setAutoCommitDelay(n3);
        } else {
            this.autoCommitMemory = 0;
            this.autoCompactFillRate = 0;
            this.meta = this.openMetaMap();
        }
        this.onVersionChange(this.currentVersion);
    }

    private MVMap<String, String> openMetaMap() {
        int n;
        String string = this.layout.get(META_ID_KEY);
        if (string == null) {
            n = this.lastMapId.incrementAndGet();
            this.layout.put(META_ID_KEY, Integer.toHexString(n));
        } else {
            n = DataUtils.parseHexInt(string);
        }
        MVMap<String, String> mVMap = new MVMap<String, String>(this, n, StringDataType.INSTANCE, StringDataType.INSTANCE);
        mVMap.setRootPos(this.getRootPos(mVMap.getId()), this.currentVersion - 1L);
        return mVMap;
    }

    private void scrubLayoutMap() {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : new String[]{"name.", "map."}) {
            String string3;
            Iterator<String> iterator = this.layout.keyIterator(string2);
            while (iterator.hasNext() && (string3 = iterator.next()).startsWith(string2)) {
                this.meta.putIfAbsent(string3, this.layout.get(string3));
                this.markMetaChanged();
                hashSet.add(string3);
            }
        }
        Iterator<String> iterator = this.layout.keyIterator("root.");
        while (iterator.hasNext() && (string = (String)iterator.next()).startsWith("root.")) {
            String string4 = string.substring(string.lastIndexOf(46) + 1);
            if (this.meta.containsKey("map." + string4) || DataUtils.parseHexInt(string4) == this.meta.getId()) continue;
            hashSet.add(string);
        }
        for (String string5 : hashSet) {
            this.layout.remove(string5);
        }
    }

    private void scrubMetaMap() {
        String string;
        String string22;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string22 = iterator.next()).startsWith("name.")) {
            int n;
            String string3;
            string = string22.substring("name.".length());
            if (string.equals(string3 = this.getMapName(n = DataUtils.parseHexInt(this.meta.get(string22))))) continue;
            hashSet.add(string22);
        }
        for (String string22 : hashSet) {
            this.meta.remove(string22);
            this.markMetaChanged();
        }
        iterator = this.meta.keyIterator("map.");
        while (iterator.hasNext() && (string22 = iterator.next()).startsWith("map.")) {
            string = DataUtils.getMapName(this.meta.get(string22));
            String string4 = string22.substring("map.".length());
            int n = DataUtils.parseHexInt(string4);
            if (n > this.lastMapId.get()) {
                this.lastMapId.set(n);
            }
            if (string4.equals(this.meta.get("name." + string))) continue;
            this.meta.put("name." + string, string4);
            this.markMetaChanged();
        }
    }

    private void unlockAndCheckPanicCondition() {
        this.storeLock.unlock();
        if (this.getPanicException() != null) {
            this.closeImmediately();
        }
    }

    public void panic(MVStoreException mVStoreException) {
        if (this.isOpen()) {
            this.handleException(mVStoreException);
            this.panicException = mVStoreException;
        }
        throw mVStoreException;
    }

    public MVStoreException getPanicException() {
        return this.panicException;
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("fileName", string);
        return new MVStore(hashMap);
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        int n = this.getMapId(string);
        if (n >= 0) {
            MVMap<K, V> mVMap = this.getMap(n);
            if (mVMap == null) {
                mVMap = this.openMap(n, mapBuilder);
            }
            assert (mapBuilder.getKeyType() == null || mVMap.getKeyType().getClass().equals(mapBuilder.getKeyType().getClass()));
            assert (mapBuilder.getValueType() == null || mVMap.getValueType().getClass().equals(mapBuilder.getValueType().getClass()));
            return (M)mVMap;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        n = this.lastMapId.incrementAndGet();
        assert (this.getMap(n) == null);
        hashMap.put("id", n);
        hashMap.put("createVersion", this.currentVersion);
        Object object = mapBuilder.create(this, hashMap);
        String string2 = Integer.toHexString(n);
        this.meta.put(MVMap.getMapKey(n), ((MVMap)object).asString(string));
        String string3 = this.meta.putIfAbsent("name." + string, string2);
        if (string3 != null) {
            this.meta.remove(MVMap.getMapKey(n));
            return this.openMap(string, mapBuilder);
        }
        long l = this.currentVersion - 1L;
        ((MVMap)object).setRootPos(0L, l);
        this.markMetaChanged();
        MVMap<?, ?> mVMap = this.maps.putIfAbsent(n, (MVMap<?, ?>)object);
        if (mVMap != null) {
            object = mVMap;
        }
        return object;
    }

    public <M extends MVMap<K, V>, K, V> M openMap(int n, MVMap.MapBuilder<M, K, V> mapBuilder) {
        MVMap<K, V> mVMap;
        while ((mVMap = this.getMap(n)) == null) {
            String string = this.meta.get(MVMap.getMapKey(n));
            DataUtils.checkArgument(string != null, "Missing map with id {0}", n);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(DataUtils.parseMap(string));
            hashMap.put("id", (String)((Object)Integer.valueOf(n)));
            mVMap = mapBuilder.create(this, hashMap);
            long l = this.getRootPos(n);
            long l2 = this.currentVersion - 1L;
            mVMap.setRootPos(l, l2);
            if (this.maps.putIfAbsent(n, mVMap) != null) continue;
            break;
        }
        return (M)mVMap;
    }

    public <K, V> MVMap<K, V> getMap(int n) {
        this.checkOpen();
        MVMap<?, ?> mVMap = this.maps.get(n);
        return mVMap;
    }

    public Set<String> getMapNames() {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        this.checkOpen();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("name.")) {
            String string2 = string.substring("name.".length());
            hashSet.add(string2);
        }
        return hashSet;
    }

    public MVMap<String, String> getLayoutMap() {
        this.checkOpen();
        return this.layout;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getLayoutMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l);
        long l2 = chunk.block;
        chunk = this.readChunkHeader(l2);
        MVMap<String, String> mVMap = this.layout.openReadOnly(chunk.layoutRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        Chunk chunk = null;
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.version > l || chunk != null && chunk2.id <= chunk.id) continue;
            chunk = chunk2;
        }
        return chunk;
    }

    public boolean hasMap(String string) {
        return this.meta.containsKey("name." + string);
    }

    public boolean hasData(String string) {
        return this.hasMap(string) && this.getRootPos(this.getMapId(string)) != 0L;
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private void readStoreHeader() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        Object object5 = null;
        boolean bl = true;
        boolean bl2 = false;
        ByteBuffer byteBuffer = this.fileStore.readFully(0L, 8192);
        byte[] byArray = new byte[4096];
        for (n2 = 0; n2 <= 4096; n2 += 4096) {
            byteBuffer.get(byArray);
            try {
                HashMap<String, String> hashMap = DataUtils.parseChecksummedMap(byArray);
                if (hashMap == null) {
                    bl = false;
                    continue;
                }
                long l = DataUtils.readHexLong(hashMap, HDR_VERSION, 0L);
                boolean bl3 = bl = bl && (object5 == null || l == ((Chunk)object5).version);
                if (object5 != null && l <= ((Chunk)object5).version) continue;
                bl2 = true;
                this.storeHeader.putAll(hashMap);
                this.creationTime = DataUtils.readHexLong(hashMap, HDR_CREATED, 0L);
                int n3 = DataUtils.readHexInt(hashMap, HDR_CHUNK, 0);
                long l2 = DataUtils.readHexLong(hashMap, HDR_BLOCK, 2L);
                Chunk chunk3 = this.readChunkHeaderAndFooter(l2, n3);
                if (chunk3 == null) continue;
                object5 = chunk3;
                continue;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        if (!bl2) {
            throw DataUtils.newMVStoreException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        n2 = DataUtils.readHexInt(this.storeHeader, HDR_BLOCK_SIZE, 4096);
        if (n2 != 4096) {
            throw DataUtils.newMVStoreException(5, "Block size {0} is currently not supported", n2);
        }
        long l = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT, 1L);
        if (!this.fileStore.isReadOnly()) {
            if (l > 2L) {
                throw this.getUnsupportedWriteFormatException(l, 2, "The write format {0} is larger than the supported format {1}");
            }
            if (l < 2L) {
                throw this.getUnsupportedWriteFormatException(l, 2, "The write format {0} is smaller than the supported format {1}");
            }
        }
        if ((l = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, l)) > 2L) {
            throw DataUtils.newMVStoreException(5, "The read format {0} is larger than the supported format {1}", l, 2);
        }
        if (l < 2L) {
            throw DataUtils.newMVStoreException(5, "The read format {0} is smaller than the supported format {1}", l, 2);
        }
        boolean bl4 = bl = bl && object5 != null && !this.recoveryMode;
        if (bl) {
            bl = DataUtils.readHexInt(this.storeHeader, HDR_CLEAN, 0) != 0;
        }
        this.chunks.clear();
        long l3 = System.currentTimeMillis();
        int n4 = 1970 + (int)(l3 / 31557600000L);
        if (n4 < 2014) {
            this.creationTime = l3 - (long)this.fileStore.getDefaultRetentionTime();
        } else if (l3 < this.creationTime) {
            this.creationTime = l3;
            this.storeHeader.put(HDR_CREATED, this.creationTime);
        }
        long l4 = this.fileStore.size();
        long l5 = l4 / 4096L;
        Comparator comparator = (chunk, chunk2) -> {
            int n = Long.compare(chunk2.version, chunk.version);
            if (n == 0) {
                n = Long.compare(chunk.block, chunk2.block);
            }
            return n;
        };
        HashMap<Long, Chunk> hashMap = new HashMap<Long, Chunk>();
        if (!bl) {
            object4 = this.discoverChunk(l5);
            if (object4 != null) {
                l5 = ((Chunk)object4).block;
                hashMap.put(l5, (Chunk)object4);
                if (object5 == null || ((Chunk)object4).version > ((Chunk)object5).version) {
                    object5 = object4;
                }
            }
            if (object5 != null) {
                while (true) {
                    hashMap.put(((Chunk)object5).block, (Chunk)object5);
                    if (((Chunk)object5).next == 0L || ((Chunk)object5).next >= l5 || (object3 = this.readChunkHeaderAndFooter(((Chunk)object5).next, ((Chunk)object5).id + 1)) == null || ((Chunk)object3).version <= ((Chunk)object5).version) break;
                    object5 = object3;
                }
            }
        }
        if (bl) {
            object4 = new PriorityQueue(20, Collections.reverseOrder(comparator));
            try {
                this.setLastChunk((Chunk)object5);
                object3 = this.layout.cursor("chunk.");
                while (((Cursor)object3).hasNext() && ((String)((Cursor)object3).next()).startsWith("chunk.")) {
                    object2 = Chunk.fromString((String)((Cursor)object3).getValue());
                    assert (((Chunk)object2).version <= this.currentVersion);
                    this.chunks.putIfAbsent(((Chunk)object2).id, (Chunk)object2);
                    object4.offer((Object)object2);
                    if (object4.size() != 20) continue;
                    object4.poll();
                }
                while (bl && (object2 = (Chunk)object4.poll()) != null) {
                    object = this.readChunkHeaderAndFooter(((Chunk)object2).block, ((Chunk)object2).id);
                    bl = object != null;
                    if (!bl) continue;
                    hashMap.put(((Chunk)object).block, (Chunk)object);
                }
            }
            catch (MVStoreException mVStoreException) {
                bl = false;
            }
        }
        if (!bl) {
            boolean bl5 = false;
            if (!this.recoveryMode) {
                object3 = hashMap.values().toArray(new Chunk[0]);
                Arrays.sort(object3, comparator);
                object2 = new HashMap();
                object = object3;
                n = ((Object)object).length;
                for (int i = 0; i < n; ++i) {
                    Object object6 = object[i];
                    object2.put(((Chunk)object6).id, object6);
                }
                bl5 = this.findLastChunkWithCompleteValidChunkSet((Chunk[])object3, hashMap, (Map<Integer, Chunk>)object2, false);
            }
            if (!bl5) {
                long l6 = l5;
                while ((object = this.discoverChunk(l6)) != null) {
                    l6 = ((Chunk)object).block;
                    hashMap.put(l6, (Chunk)object);
                }
                Chunk[] chunkArray = hashMap.values().toArray(new Chunk[0]);
                Arrays.sort(chunkArray, comparator);
                HashMap<Integer, Chunk> hashMap2 = new HashMap<Integer, Chunk>();
                for (Chunk chunk3 : chunkArray) {
                    hashMap2.put(chunk3.id, chunk3);
                }
                if (!this.findLastChunkWithCompleteValidChunkSet(chunkArray, hashMap, hashMap2, true) && this.lastChunk != null) {
                    throw DataUtils.newMVStoreException(6, "File is corrupted - unable to recover a valid set of chunks", new Object[0]);
                }
            }
        }
        this.fileStore.clear();
        for (Chunk chunk5 : this.chunks.values()) {
            if (chunk5.isSaved()) {
                long l7 = chunk5.block * 4096L;
                n = chunk5.len * 4096;
                this.fileStore.markUsed(l7, n);
            }
            if (chunk5.isLive()) continue;
            this.deadChunks.offer(chunk5);
        }
        assert (this.validateFileLength("on open"));
    }

    private MVStoreException getUnsupportedWriteFormatException(long l, int n, String string) {
        if ((l = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, l)) >= 2L && l <= 2L) {
            string = string + ", and the file was not opened in read-only mode";
        }
        return DataUtils.newMVStoreException(5, string, l, n);
    }

    private boolean findLastChunkWithCompleteValidChunkSet(Chunk[] chunkArray, Map<Long, Chunk> map, Map<Integer, Chunk> map2, boolean bl) {
        for (Chunk chunk : chunkArray) {
            boolean bl2 = true;
            try {
                this.setLastChunk(chunk);
                Cursor<String, String> cursor = this.layout.cursor("chunk.");
                while (cursor.hasNext() && cursor.next().startsWith("chunk.")) {
                    Chunk chunk2 = Chunk.fromString(cursor.getValue());
                    assert (chunk2.version <= this.currentVersion);
                    Chunk chunk3 = this.chunks.putIfAbsent(chunk2.id, chunk2);
                    if (chunk3 != null) {
                        chunk2 = chunk3;
                    }
                    assert (this.chunks.get(chunk2.id) == chunk2);
                    chunk3 = map.get(chunk2.block);
                    if (chunk3 == null || chunk3.id != chunk2.id) {
                        chunk3 = map2.get(chunk2.id);
                        if (chunk3 != null) {
                            chunk2.block = chunk3.block;
                        } else if (chunk2.isLive() && (bl || this.readChunkHeaderAndFooter(chunk2.block, chunk2.id) == null)) {
                            bl2 = false;
                            break;
                        }
                    }
                    if (chunk2.isLive()) continue;
                    chunk2.block = Long.MAX_VALUE;
                    chunk2.len = Integer.MAX_VALUE;
                    if (chunk2.unused == 0L) {
                        chunk2.unused = this.creationTime;
                    }
                    if (chunk2.unusedAtVersion != 0L) continue;
                    chunk2.unusedAtVersion = -1L;
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    void adoptMetaFrom(MVStore mVStore) {
        this.currentVersion = mVStore.currentVersion;
        this.lastMapId.set(mVStore.lastMapId.get());
    }

    private void setLastChunk(Chunk chunk) {
        this.chunks.clear();
        this.lastChunk = chunk;
        this.lastChunkId = 0;
        this.currentVersion = this.lastChunkVersion();
        long l = 0L;
        int n = 0;
        if (chunk != null) {
            this.lastChunkId = chunk.id;
            this.currentVersion = chunk.version;
            l = chunk.layoutRootPos;
            n = chunk.mapId;
            this.chunks.put(chunk.id, chunk);
        }
        this.lastMapId.set(n);
        this.layout.setRootPos(l, this.currentVersion - 1L);
    }

    private Chunk discoverChunk(long l) {
        long l2 = Long.MAX_VALUE;
        Chunk chunk = null;
        while (l != l2) {
            if (l == 2L) {
                return null;
            }
            Chunk chunk2 = this.readChunkFooter(l);
            if (chunk2 != null) {
                l2 = Long.MAX_VALUE;
                chunk2 = this.readChunkHeaderOptionally(chunk2.block, chunk2.id);
                if (chunk2 != null) {
                    chunk = chunk2;
                    l2 = chunk2.block;
                }
            }
            if (--l <= l2 || this.readChunkHeaderOptionally(l) == null) continue;
            l2 = Long.MAX_VALUE;
        }
        return chunk;
    }

    private Chunk readChunkHeaderAndFooter(long l, int n) {
        Chunk chunk;
        Chunk chunk2 = this.readChunkHeaderOptionally(l, n);
        if (chunk2 != null && ((chunk = this.readChunkFooter(l + (long)chunk2.len)) == null || chunk.id != n || chunk.block != chunk2.block)) {
            return null;
        }
        return chunk2;
    }

    private Chunk readChunkFooter(long l) {
        try {
            long l2 = l * 4096L - 128L;
            if (l2 < 0L) {
                return null;
            }
            ByteBuffer byteBuffer = this.fileStore.readFully(l2, 128);
            byte[] byArray = new byte[128];
            byteBuffer.get(byArray);
            HashMap<String, String> hashMap = DataUtils.parseChecksummedMap(byArray);
            if (hashMap != null) {
                return new Chunk(hashMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        Chunk chunk = this.lastChunk;
        if (chunk != null) {
            this.storeHeader.put(HDR_BLOCK, chunk.block);
            this.storeHeader.put(HDR_CHUNK, chunk.id);
            this.storeHeader.put(HDR_VERSION, chunk.version);
        }
        StringBuilder stringBuilder = new StringBuilder(112);
        DataUtils.appendMap(stringBuilder, this.storeHeader);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        int n = DataUtils.getFletcher32(byArray, 0, byArray.length);
        DataUtils.appendMap(stringBuilder, HDR_FLETCHER, n);
        stringBuilder.append('\n');
        byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        this.write(0L, byteBuffer);
    }

    private void write(long l, ByteBuffer byteBuffer) {
        try {
            this.fileStore.writeFully(l, byteBuffer);
        }
        catch (MVStoreException mVStoreException) {
            this.panic(mVStoreException);
        }
    }

    @Override
    public void close() {
        this.closeStore(true, 0);
    }

    public void close(int n) {
        this.closeStore(true, n);
    }

    public void closeImmediately() {
        try {
            this.closeStore(false, 0);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean bl, int n) {
        while (!this.isClosed()) {
            this.stopBackgroundThread(bl);
            this.setOldestVersionTracker(null);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (bl && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> mVMap : this.maps.values()) {
                                if (!mVMap.isClosed()) continue;
                                this.deregisterMapRoot(mVMap.getId());
                            }
                            this.setRetentionTime(0);
                            this.commit();
                            if (n > 0) {
                                this.compactFile(n);
                            } else if (n < 0) {
                                this.doMaintenance(this.autoCompactFillRate);
                            }
                            this.saveChunkLock.lock();
                            try {
                                this.shrinkFileIfPossible(0);
                                this.storeHeader.put(HDR_CLEAN, 1);
                                this.writeStoreHeader();
                                this.sync();
                                assert (this.validateFileLength("on close"));
                            }
                            finally {
                                this.saveChunkLock.unlock();
                            }
                        }
                        this.state = 2;
                        this.clearCaches();
                        for (MVMap<?, ?> mVMap : new ArrayList(this.maps.values())) {
                            mVMap.close();
                        }
                        this.chunks.clear();
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore == null || !this.fileStoreShallBeClosed) continue;
                        this.fileStore.close();
                    }
                }
                finally {
                    this.state = 3;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private Chunk getChunk(long l) {
        int n = DataUtils.getPageChunkId(l);
        Chunk chunk = this.chunks.get(n);
        if (chunk == null) {
            this.checkOpen();
            String string = this.layout.get(Chunk.getMetaKey(n));
            if (string == null) {
                throw DataUtils.newMVStoreException(9, "Chunk {0} not found", n);
            }
            chunk = Chunk.fromString(string);
            if (!chunk.isSaved()) {
                throw DataUtils.newMVStoreException(6, "Chunk {0} is invalid", n);
            }
            this.chunks.put(chunk.id, chunk);
        }
        return chunk;
    }

    private void setWriteVersion(long l) {
        Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
        while (iterator.hasNext()) {
            MVMap<?, ?> mVMap = iterator.next();
            assert (mVMap != this.layout && mVMap != this.meta);
            if (mVMap.setWriteVersion(l) != null) continue;
            iterator.remove();
        }
        this.meta.setWriteVersion(l);
        this.layout.setWriteVersion(l);
        this.onVersionChange(l);
    }

    public long tryCommit() {
        return this.tryCommit(mVStore -> true);
    }

    private long tryCommit(Predicate<MVStore> predicate) {
        if ((!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) && this.storeLock.tryLock()) {
            try {
                if (predicate.test(this)) {
                    this.store(false);
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return this.currentVersion;
    }

    public long commit() {
        return this.commit(mVStore -> true);
    }

    private long commit(Predicate<MVStore> predicate) {
        if (!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) {
            this.storeLock.lock();
            try {
                if (predicate.test(this)) {
                    this.store(true);
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return this.currentVersion;
    }

    private void store(boolean bl) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (!this.saveChunkLock.isHeldByCurrentThread());
        if (this.isOpenOrStopping() && this.hasUnsavedChanges()) {
            this.dropUnusedChunks();
            try {
                this.currentStoreVersion = this.currentVersion++;
                if (this.fileStore == null) {
                    this.setWriteVersion(this.currentVersion);
                    this.metaChanged = false;
                } else {
                    if (this.fileStore.isReadOnly()) {
                        throw DataUtils.newMVStoreException(2, "This store is read-only", new Object[0]);
                    }
                    this.storeNow(bl, 0L, () -> this.reuseSpace ? 0L : this.getAfterLastBlock());
                }
            }
            finally {
                this.currentStoreVersion = -1L;
            }
        }
    }

    private void storeNow(boolean bl, long l, Supplier<Long> supplier) {
        try {
            this.lastCommitTime = this.getTimeSinceCreation();
            int n = this.unsavedMemory;
            long l2 = ++this.currentVersion;
            ArrayList<Page<?, ?>> arrayList = this.collectChangedMapRoots(l2);
            assert (this.storeLock.isHeldByCurrentThread());
            MVStore.submitOrRun(this.serializationExecutor, () -> this.serializeAndStore(bl, l, supplier, arrayList, this.lastCommitTime, l2), bl);
            this.saveNeeded = false;
            this.unsavedMemory = Math.max(0, this.unsavedMemory - n);
        }
        catch (MVStoreException mVStoreException) {
            this.panic(mVStoreException);
        }
        catch (Throwable throwable) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", throwable.toString(), throwable));
        }
    }

    private static void submitOrRun(ThreadPoolExecutor threadPoolExecutor, Runnable runnable, boolean bl) throws ExecutionException {
        if (threadPoolExecutor != null) {
            try {
                Future<?> future = threadPoolExecutor.submit(runnable);
                if (bl || threadPoolExecutor.getQueue().size() > 1) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                assert (threadPoolExecutor.isShutdown());
                Utils.shutdownExecutor(threadPoolExecutor);
            }
        }
        runnable.run();
    }

    private ArrayList<Page<?, ?>> collectChangedMapRoots(long l) {
        Object object;
        long l2 = l - 2L;
        ArrayList arrayList = new ArrayList();
        Object object2 = this.maps.values().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            RootReference<?, ?> rootReference = ((MVMap)object).setWriteVersion(l);
            if (rootReference == null) {
                object2.remove();
                continue;
            }
            if (((MVMap)object).getCreateVersion() >= l || ((MVMap)object).isVolatile() || !((MVMap)object).hasChangesSince(l2)) continue;
            assert (rootReference.version <= l) : rootReference.version + " > " + l;
            Page page = rootReference.root;
            if (page.isSaved() && !page.isLeaf()) continue;
            arrayList.add(page);
        }
        object2 = this.meta.setWriteVersion(l);
        if (this.meta.hasChangesSince(l2) || this.metaChanged) {
            assert (object2 != null && ((RootReference)object2).version <= l) : object2 == null ? "null" : ((RootReference)object2).version + " > " + l;
            object = ((RootReference)object2).root;
            if (!((Page)object).isSaved() || ((Page)object).isLeaf()) {
                arrayList.add((Page<?, ?>)object);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeAndStore(boolean bl, long l, Supplier<Long> supplier, ArrayList<Page<?, ?>> arrayList, long l2, long l3) {
        this.serializationLock.lock();
        try {
            Chunk chunk = this.createChunk(l2, l3);
            this.chunks.put(chunk.id, chunk);
            WriteBuffer writeBuffer = this.getWriteBuffer();
            this.serializeToBuffer(writeBuffer, arrayList, chunk, l, supplier);
            MVStore.submitOrRun(this.bufferSaveExecutor, () -> this.storeBuffer(chunk, writeBuffer, arrayList), bl);
        }
        catch (MVStoreException mVStoreException) {
            this.panic(mVStoreException);
        }
        catch (Throwable throwable) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", throwable.toString(), throwable));
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    private Chunk createChunk(long l, long l2) {
        int n;
        Chunk chunk;
        int n2 = this.lastChunkId;
        if (n2 != 0) {
            Chunk chunk2 = this.chunks.get(n2 &= 0x3FFFFFF);
            assert (chunk2 != null);
            assert (chunk2.isSaved());
            assert (chunk2.version + 1L == l2) : chunk2.version + " " + l2;
            this.layout.put(Chunk.getMetaKey(n2), chunk2.asString());
            l = Math.max(chunk2.time, l);
        }
        while ((chunk = this.chunks.get(n = ++this.lastChunkId & 0x3FFFFFF)) != null) {
            if (chunk.isSaved()) continue;
            MVStoreException mVStoreException = DataUtils.newMVStoreException(3, "Last block {0} not stored, possibly due to out-of-memory", chunk);
            this.panic(mVStoreException);
        }
        chunk = new Chunk(n);
        chunk.pageCount = 0;
        chunk.pageCountLive = 0;
        chunk.maxLen = 0L;
        chunk.maxLenLive = 0L;
        chunk.layoutRootPos = Long.MAX_VALUE;
        chunk.block = Long.MAX_VALUE;
        chunk.len = Integer.MAX_VALUE;
        chunk.time = l;
        chunk.version = l2;
        chunk.next = Long.MAX_VALUE;
        chunk.occupancy = new BitSet();
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeToBuffer(WriteBuffer writeBuffer, ArrayList<Page<?, ?>> arrayList, Chunk chunk, long l, Supplier<Long> supplier) {
        Object object;
        chunk.writeChunkHeader(writeBuffer, 0);
        int n = writeBuffer.position() + 44;
        writeBuffer.position(n);
        long l2 = chunk.version;
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        for (Page<?, ?> page2 : arrayList) {
            object = MVMap.getMapRootKey(page2.getMapId());
            if (page2.getTotalCount() == 0L) {
                this.layout.remove(object);
                continue;
            }
            page2.writeUnsavedRecursive(chunk, writeBuffer, arrayList2);
            long n2 = page2.getPos();
            this.layout.put((String)object, Long.toHexString(n2));
        }
        this.acceptChunkOccupancyChanges(chunk.time, l2);
        RootReference<String, String> rootReference = this.layout.setWriteVersion(l2);
        assert (rootReference != null);
        assert (rootReference.version == l2) : rootReference.version + " != " + l2;
        this.metaChanged = false;
        this.acceptChunkOccupancyChanges(chunk.time, l2);
        this.onVersionChange(l2);
        Page page = rootReference.root;
        page.writeUnsavedRecursive(chunk, writeBuffer, arrayList2);
        chunk.layoutRootPos = page.getPos();
        arrayList.add(page);
        chunk.mapId = this.lastMapId.get();
        chunk.tocPos = writeBuffer.position();
        object = new long[arrayList2.size()];
        int n2 = 0;
        Iterator n3 = arrayList2.iterator();
        while (n3.hasNext()) {
            long n4 = (Long)n3.next();
            object[n2++] = n4;
            writeBuffer.putLong(n4);
            if (DataUtils.isLeafPosition(n4)) {
                ++this.leafCount;
                continue;
            }
            ++this.nonLeafCount;
        }
        this.chunksToC.put(chunk.id, (long[])object);
        int n4 = writeBuffer.position();
        int n5 = MathUtils.roundUpInt(n4 + 128, 4096);
        writeBuffer.limit(n5);
        this.saveChunkLock.lock();
        try {
            Long l3 = supplier.get();
            long l4 = this.fileStore.allocate(writeBuffer.limit(), l, l3);
            chunk.len = writeBuffer.limit() / 4096;
            chunk.block = l4 / 4096L;
            assert (this.validateFileLength(chunk.asString()));
            chunk.next = l > 0L || l3 == l ? this.fileStore.predictAllocation(chunk.len, 0L, 0L) : 0L;
            assert (chunk.pageCountLive == chunk.pageCount) : chunk;
            assert (chunk.occupancy.cardinality() == 0) : chunk;
            writeBuffer.position(0);
            assert (chunk.pageCountLive == chunk.pageCount) : chunk;
            assert (chunk.occupancy.cardinality() == 0) : chunk;
            chunk.writeChunkHeader(writeBuffer, n);
            writeBuffer.position(writeBuffer.limit() - 128);
            writeBuffer.put(chunk.getFooterBytes());
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBuffer(Chunk chunk, WriteBuffer writeBuffer, ArrayList<Page<?, ?>> arrayList) {
        this.saveChunkLock.lock();
        try {
            writeBuffer.position(0);
            long l = chunk.block * 4096L;
            this.write(l, writeBuffer.getBuffer());
            this.releaseWriteBuffer(writeBuffer);
            boolean bl = l + (long)writeBuffer.limit() >= this.fileStore.size();
            boolean bl2 = this.isWriteStoreHeader(chunk, bl);
            this.lastChunk = chunk;
            if (bl2) {
                this.writeStoreHeader();
            }
            if (!bl) {
                this.shrinkFileIfPossible(1);
            }
        }
        catch (MVStoreException mVStoreException) {
            this.panic(mVStoreException);
        }
        catch (Throwable throwable) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", throwable.toString(), throwable));
        }
        finally {
            this.saveChunkLock.unlock();
        }
        for (Page<?, ?> page : arrayList) {
            page.releaseSavedPages();
        }
    }

    private boolean isWriteStoreHeader(Chunk chunk, boolean bl) {
        boolean bl2 = false;
        if (!bl) {
            Chunk chunk2 = this.lastChunk;
            if (chunk2 == null) {
                bl2 = true;
            } else if (chunk2.next != chunk.block) {
                bl2 = true;
            } else {
                long l = DataUtils.readHexLong(this.storeHeader, HDR_VERSION, 0L);
                if (chunk2.version - l > 20L) {
                    bl2 = true;
                } else {
                    for (int i = DataUtils.readHexInt(this.storeHeader, HDR_CHUNK, 0); !bl2 && i <= chunk2.id; ++i) {
                        bl2 = !this.chunks.containsKey(i);
                    }
                }
            }
        }
        if (this.storeHeader.remove(HDR_CLEAN) != null) {
            bl2 = true;
        }
        return bl2;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer writeBuffer = this.writeBufferPool.poll();
        if (writeBuffer != null) {
            writeBuffer.clear();
        } else {
            writeBuffer = new WriteBuffer();
        }
        return writeBuffer;
    }

    private void releaseWriteBuffer(WriteBuffer writeBuffer) {
        if (writeBuffer.capacity() <= 0x400000) {
            this.writeBufferPool.offer(writeBuffer);
        }
    }

    private static boolean canOverwriteChunk(Chunk chunk, long l) {
        return !chunk.isLive() && chunk.unusedAtVersion < l;
    }

    private boolean isSeasonedChunk(Chunk chunk, long l) {
        return this.retentionTime < 0 || chunk.time + (long)this.retentionTime <= l;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long l = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && l < this.lastTimeAbsolute) {
            l = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = l;
        }
        return l;
    }

    private void acceptChunkOccupancyChanges(long l, long l2) {
        assert (this.serializationLock.isHeldByCurrentThread());
        if (this.lastChunk != null) {
            HashSet<Chunk> hashSet = new HashSet<Chunk>();
            while (true) {
                RemovedPageInfo removedPageInfo;
                if ((removedPageInfo = this.removedPages.peek()) != null && removedPageInfo.version < l2) {
                    removedPageInfo = this.removedPages.poll();
                    assert (removedPageInfo != null);
                    assert (removedPageInfo.version < l2) : removedPageInfo + " < " + l2;
                    int n = removedPageInfo.getPageChunkId();
                    Chunk chunk = this.chunks.get(n);
                    assert (!this.isOpen() || chunk != null) : n;
                    if (chunk == null) continue;
                    hashSet.add(chunk);
                    if (!chunk.accountForRemovedPage(removedPageInfo.getPageNo(), removedPageInfo.getPageLength(), removedPageInfo.isPinned(), l, removedPageInfo.version)) continue;
                    this.deadChunks.offer(chunk);
                    continue;
                }
                if (hashSet.isEmpty()) {
                    return;
                }
                for (Chunk chunk : hashSet) {
                    int n = chunk.id;
                    this.layout.put(Chunk.getMetaKey(n), chunk.asString());
                }
                hashSet.clear();
            }
        }
    }

    private void shrinkFileIfPossible(int n) {
        long l;
        assert (this.saveChunkLock.isHeldByCurrentThread());
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long l2 = this.getFileLengthInUse();
        if (l2 >= (l = this.fileStore.size())) {
            return;
        }
        if (n > 0 && l - l2 < 4096L) {
            return;
        }
        int n2 = (int)(100L - l2 * 100L / l);
        if (n2 < n) {
            return;
        }
        if (this.isOpenOrStopping()) {
            this.sync();
        }
        this.fileStore.truncate(l2);
    }

    private long getFileLengthInUse() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long l = this.fileStore.getFileLengthInUse();
        assert (l == this.measureFileLengthInUse()) : l + " != " + this.measureFileLengthInUse();
        return l;
    }

    private long getAfterLastBlock() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        return this.fileStore.getAfterLastBlock();
    }

    private long measureFileLengthInUse() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long l = 2L;
        for (Chunk chunk : this.chunks.values()) {
            if (!chunk.isSaved()) continue;
            l = Math.max(l, chunk.block + (long)chunk.len);
        }
        return l * 4096L;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        long l = this.currentVersion - 1L;
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            if (mVMap.isClosed() || !mVMap.hasChangesSince(l)) continue;
            return true;
        }
        return this.layout.hasChangesSince(l) && l > -1L;
    }

    private Chunk readChunkHeader(long l) {
        long l2 = l * 4096L;
        ByteBuffer byteBuffer = this.fileStore.readFully(l2, 1024);
        return Chunk.readChunkHeader(byteBuffer, l2);
    }

    private Chunk readChunkHeaderOptionally(long l) {
        try {
            Chunk chunk = this.readChunkHeader(l);
            return chunk.block != l ? null : chunk;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Chunk readChunkHeaderOptionally(long l, int n) {
        Chunk chunk = this.readChunkHeaderOptionally(l);
        return chunk == null || chunk.id != n ? null : chunk;
    }

    public void compactMoveChunks() {
        this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean compactMoveChunks(int n, long l) {
        boolean bl = false;
        this.storeLock.lock();
        try {
            this.checkOpen();
            Utils.flushExecutor(this.serializationExecutor);
            this.serializationLock.lock();
            try {
                Utils.flushExecutor(this.bufferSaveExecutor);
                this.saveChunkLock.lock();
                try {
                    if (this.lastChunk != null && this.reuseSpace && this.getFillRate() <= n) {
                        bl = this.compactMoveChunks(l);
                    }
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
            finally {
                this.serializationLock.unlock();
            }
        }
        catch (MVStoreException mVStoreException) {
            this.panic(mVStoreException);
        }
        catch (Throwable throwable) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", throwable.toString(), throwable));
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
        return bl;
    }

    private boolean compactMoveChunks(long l) {
        assert (this.storeLock.isHeldByCurrentThread());
        this.dropUnusedChunks();
        long l2 = this.fileStore.getFirstFree() / 4096L;
        Iterable<Chunk> iterable = this.findChunksToMove(l2, l);
        if (iterable == null) {
            return false;
        }
        this.compactMoveChunks(iterable);
        return true;
    }

    private Iterable<Chunk> findChunksToMove(long l, long l2) {
        long l3 = l2 / 4096L;
        ArrayList arrayList = null;
        if (l3 > 0L) {
            PriorityQueue<Chunk> priorityQueue = new PriorityQueue<Chunk>(this.chunks.size() / 2 + 1, (chunk, chunk2) -> {
                int n = Integer.compare(chunk2.collectPriority, chunk.collectPriority);
                if (n != 0) {
                    return n;
                }
                return Long.signum(chunk2.block - chunk.block);
            });
            long l4 = 0L;
            for (Chunk chunk3 : this.chunks.values()) {
                Chunk chunk4;
                if (!chunk3.isSaved() || chunk3.block <= l) continue;
                chunk3.collectPriority = this.getMovePriority(chunk3);
                priorityQueue.offer(chunk3);
                l4 += (long)chunk3.len;
                while (l4 > l3 && (chunk4 = (Chunk)priorityQueue.poll()) != null) {
                    l4 -= (long)chunk4.len;
                }
            }
            if (!priorityQueue.isEmpty()) {
                ArrayList arrayList2 = new ArrayList(priorityQueue);
                arrayList2.sort(Chunk.PositionComparator.INSTANCE);
                arrayList = arrayList2;
            }
        }
        return arrayList;
    }

    private int getMovePriority(Chunk chunk) {
        return this.fileStore.getMovePriority((int)chunk.block);
    }

    private void compactMoveChunks(Iterable<Chunk> iterable) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (this.serializationLock.isHeldByCurrentThread());
        assert (this.saveChunkLock.isHeldByCurrentThread());
        if (iterable != null) {
            this.writeStoreHeader();
            this.sync();
            Iterator<Chunk> iterator = iterable.iterator();
            assert (iterator.hasNext());
            long l = iterator.next().block;
            long l2 = this.getAfterLastBlock();
            for (Chunk chunk : iterable) {
                this.moveChunk(chunk, l, l2);
            }
            this.store(l, l2);
            this.sync();
            Chunk chunk = this.lastChunk;
            assert (chunk != null);
            long l3 = this.getAfterLastBlock();
            boolean bl = chunk.block < l;
            boolean bl2 = !bl;
            for (Chunk chunk2 : iterable) {
                if (chunk2.block < l2 || !this.moveChunk(chunk2, l2, l3)) continue;
                assert (chunk2.block < l2);
                bl2 = true;
            }
            assert (l3 >= this.getAfterLastBlock());
            if (bl2) {
                boolean bl3 = this.moveChunkInside(chunk, l2);
                this.store(l2, l3);
                this.sync();
                long l4 = bl3 || bl ? l3 : chunk.block;
                boolean bl4 = bl3 = !bl3 && this.moveChunkInside(chunk, l4);
                if (this.moveChunkInside(this.lastChunk, l4) || bl3) {
                    this.store(l4, -1L);
                }
            }
            this.shrinkFileIfPossible(0);
            this.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(long l, long l2) {
        this.saveChunkLock.unlock();
        try {
            this.serializationLock.unlock();
            try {
                this.storeNow(true, l, () -> l2);
            }
            finally {
                this.serializationLock.lock();
            }
        }
        finally {
            this.saveChunkLock.lock();
        }
    }

    private boolean moveChunkInside(Chunk chunk, long l) {
        boolean bl;
        boolean bl2 = bl = chunk.block >= l && this.fileStore.predictAllocation(chunk.len, l, -1L) < l && this.moveChunk(chunk, l, -1L);
        assert (!bl || chunk.block + (long)chunk.len <= l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveChunk(Chunk chunk, long l, long l2) {
        long l3;
        if (!this.chunks.containsKey(chunk.id)) {
            return false;
        }
        long l4 = chunk.block * 4096L;
        int n = chunk.len * 4096;
        WriteBuffer writeBuffer = this.getWriteBuffer();
        try {
            writeBuffer.limit(n);
            ByteBuffer byteBuffer = this.fileStore.readFully(l4, n);
            Chunk chunk2 = Chunk.readChunkHeader(byteBuffer, l4);
            int n2 = byteBuffer.position();
            writeBuffer.position(n2);
            writeBuffer.put(byteBuffer);
            long l5 = this.fileStore.allocate(n, l, l2);
            l3 = l5 / 4096L;
            assert (l2 > 0L || l3 <= chunk.block) : l3 + " " + chunk;
            writeBuffer.position(0);
            chunk2.block = l3;
            chunk2.next = 0L;
            chunk2.writeChunkHeader(writeBuffer, n2);
            writeBuffer.position(n - 128);
            writeBuffer.put(chunk2.getFooterBytes());
            writeBuffer.position(0);
            this.write(l5, writeBuffer.getBuffer());
        }
        finally {
            this.releaseWriteBuffer(writeBuffer);
        }
        this.fileStore.free(l4, n);
        chunk.block = l3;
        chunk.next = 0L;
        this.layout.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        return true;
    }

    public void sync() {
        this.checkOpen();
        FileStore fileStore = this.fileStore;
        if (fileStore != null) {
            fileStore.sync();
        }
    }

    public void compactFile(int n) {
        this.setRetentionTime(0);
        long l = System.nanoTime() + (long)n * 1000000L;
        while (this.compact(95, 0x1000000)) {
            this.sync();
            this.compactMoveChunks(95, 0x1000000L);
            if (System.nanoTime() - l <= 0L) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int n, int n2) {
        block7: {
            if (this.reuseSpace && this.lastChunk != null) {
                this.checkOpen();
                if (n > 0 && this.getChunksFillRate() < n) {
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break block7;
                    try {
                        boolean bl = this.rewriteChunks(n2, 100);
                        this.storeLock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.storeLock.unlock();
                            throw throwable;
                        }
                        catch (InterruptedException interruptedException) {
                            throw new RuntimeException(interruptedException);
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rewriteChunks(int n, int n2) {
        this.serializationLock.lock();
        try {
            TxCounter txCounter = this.registerVersionUsage();
            try {
                this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
                Iterable<Chunk> iterable = this.findOldChunks(n, n2);
                if (iterable != null) {
                    HashSet<Integer> hashSet = MVStore.createIdSet(iterable);
                    boolean bl = !hashSet.isEmpty() && this.compactRewrite(hashSet) > 0;
                    return bl;
                }
            }
            finally {
                this.deregisterVersionUsage(txCounter);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public int getChunksFillRate() {
        return this.getChunksFillRate(true);
    }

    public int getRewritableChunksFillRate() {
        return this.getChunksFillRate(false);
    }

    private int getChunksFillRate(boolean bl) {
        long l = 1L;
        long l2 = 1L;
        long l3 = this.getTimeSinceCreation();
        for (Chunk chunk : this.chunks.values()) {
            if (!bl && !this.isRewritable(chunk, l3)) continue;
            assert (chunk.maxLen >= 0L);
            l += chunk.maxLen;
            l2 += chunk.maxLenLive;
        }
        int n = (int)(100L * l2 / l);
        return n;
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public int getPageCount() {
        int n = 0;
        for (Chunk chunk : this.chunks.values()) {
            n += chunk.pageCount;
        }
        return n;
    }

    public int getLivePageCount() {
        int n = 0;
        for (Chunk chunk : this.chunks.values()) {
            n += chunk.pageCountLive;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getProjectedFillRate(int n) {
        this.saveChunkLock.lock();
        try {
            int n2;
            int n3 = 0;
            long l = 1L;
            long l2 = 1L;
            long l3 = this.getTimeSinceCreation();
            for (Chunk chunk : this.chunks.values()) {
                assert (chunk.maxLen >= 0L);
                if (!this.isRewritable(chunk, l3) || chunk.getFillRate() > n) continue;
                assert (chunk.maxLen >= chunk.maxLenLive);
                n3 += chunk.len;
                l += chunk.maxLen;
                l2 += chunk.maxLenLive;
            }
            int n4 = (int)((long)n3 * l2 / l);
            int n5 = n2 = this.fileStore.getProjectedFillRate(n3 - n4);
            return n5;
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    public int getFillRate() {
        this.saveChunkLock.lock();
        try {
            int n = this.fileStore.getFillRate();
            return n;
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    private Iterable<Chunk> findOldChunks(int n, int n2) {
        assert (this.lastChunk != null);
        long l = this.getTimeSinceCreation();
        PriorityQueue<Chunk> priorityQueue = new PriorityQueue<Chunk>(this.chunks.size() / 4 + 1, (chunk, chunk2) -> {
            int n = Integer.compare(chunk2.collectPriority, chunk.collectPriority);
            if (n == 0) {
                n = Long.compare(chunk2.maxLenLive, chunk.maxLenLive);
            }
            return n;
        });
        long l2 = 0L;
        long l3 = this.lastChunk.version + 1L;
        for (Chunk chunk3 : this.chunks.values()) {
            Chunk chunk4;
            int n3 = chunk3.getFillRate();
            if (!this.isRewritable(chunk3, l) || n3 > n2) continue;
            long l4 = Math.max(1L, l3 - chunk3.version);
            chunk3.collectPriority = (int)((long)(n3 * 1000) / l4);
            l2 += chunk3.maxLenLive;
            priorityQueue.offer(chunk3);
            while (l2 > (long)n && (chunk4 = priorityQueue.poll()) != null) {
                l2 -= chunk4.maxLenLive;
            }
        }
        return priorityQueue.isEmpty() ? null : priorityQueue;
    }

    private boolean isRewritable(Chunk chunk, long l) {
        return chunk.isRewritable() && this.isSeasonedChunk(chunk, l);
    }

    private int compactRewrite(Set<Integer> set) {
        assert (this.storeLock.isHeldByCurrentThread());
        assert (this.currentStoreVersion < 0L);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
        int n = this.rewriteChunks(set, false);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.currentVersion);
        return n += this.rewriteChunks(set, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int rewriteChunks(Set<Integer> set, boolean bl) {
        int n = 0;
        for (int n2 : set) {
            Chunk chunk = this.chunks.get(n2);
            long[] lArray = this.getToC(chunk);
            if (lArray == null) continue;
            int n3 = 0;
            while ((n3 = chunk.occupancy.nextClearBit(n3)) < chunk.pageCount) {
                MVMap<String, String> mVMap;
                long l = lArray[n3];
                int n4 = DataUtils.getPageMapId(l);
                MVMap<String, String> mVMap2 = n4 == this.layout.getId() ? this.layout : (mVMap = n4 == this.meta.getId() ? this.meta : this.getMap(n4));
                if (mVMap != null && !mVMap.isClosed()) {
                    assert (!mVMap.isSingleWriter());
                    if (bl || DataUtils.isLeafPosition(l)) {
                        long l2 = DataUtils.getPagePos(n2, l);
                        this.serializationLock.unlock();
                        try {
                            if (mVMap.rewritePage(l2)) {
                                ++n;
                                if (mVMap == this.meta) {
                                    this.markMetaChanged();
                                }
                            }
                        }
                        finally {
                            this.serializationLock.lock();
                        }
                    }
                }
                ++n3;
            }
        }
        return n;
    }

    private static HashSet<Integer> createIdSet(Iterable<Chunk> iterable) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Chunk chunk : iterable) {
            hashSet.add(chunk.id);
        }
        return hashSet;
    }

    <K, V> Page<K, V> readPage(MVMap<K, V> mVMap, long l) {
        try {
            if (!DataUtils.isPageSaved(l)) {
                throw DataUtils.newMVStoreException(6, "Position 0", new Object[0]);
            }
            Page<K, V> page = this.readPageFromCache(l);
            if (page == null) {
                Chunk chunk = this.getChunk(l);
                int n = DataUtils.getPageOffset(l);
                try {
                    ByteBuffer byteBuffer = chunk.readBufferForPage(this.fileStore, n, l);
                    page = Page.read(byteBuffer, l, mVMap);
                }
                catch (MVStoreException mVStoreException) {
                    throw mVStoreException;
                }
                catch (Exception exception) {
                    throw DataUtils.newMVStoreException(6, "Unable to read the page at position {0}, chunk {1}, offset {2}", l, chunk.id, n, exception);
                }
                this.cachePage(page);
            }
            return page;
        }
        catch (MVStoreException mVStoreException) {
            if (this.recoveryMode) {
                return mVMap.createEmptyLeaf();
            }
            throw mVStoreException;
        }
    }

    private long[] getToC(Chunk chunk) {
        if (chunk.tocPos == 0) {
            return null;
        }
        long[] lArray = this.chunksToC.get(chunk.id);
        if (lArray == null) {
            lArray = chunk.readToC(this.fileStore);
            this.chunksToC.put(chunk.id, lArray, lArray.length * 8);
        }
        assert (lArray.length == chunk.pageCount) : lArray.length + " != " + chunk.pageCount;
        return lArray;
    }

    private <K, V> Page<K, V> readPageFromCache(long l) {
        return this.cache == null ? null : this.cache.get(l);
    }

    void accountForRemovedPage(long l, long l2, boolean bl, int n) {
        assert (DataUtils.isPageSaved(l));
        if (n < 0) {
            n = this.calculatePageNo(l);
        }
        RemovedPageInfo removedPageInfo = new RemovedPageInfo(l, bl, l2, n);
        this.removedPages.add(removedPageInfo);
    }

    private int calculatePageNo(long l) {
        int n = -1;
        Chunk chunk = this.getChunk(l);
        long[] lArray = this.getToC(chunk);
        if (lArray != null) {
            int n2 = DataUtils.getPageOffset(l);
            int n3 = 0;
            int n4 = lArray.length - 1;
            while (n3 <= n4) {
                int n5 = n3 + n4 >>> 1;
                long l2 = DataUtils.getPageOffset(lArray[n5]);
                if (l2 < (long)n2) {
                    n3 = n5 + 1;
                    continue;
                }
                if (l2 > (long)n2) {
                    n4 = n5 - 1;
                    continue;
                }
                n = n5;
                break;
            }
        }
        return n;
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public int getKeysPerPage() {
        return this.keysPerPage;
    }

    public long getMaxPageSize() {
        return this.cache == null ? Long.MAX_VALUE : this.cache.getMaxItemSize() >> 4;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
    }

    public boolean isVersioningRequired() {
        return this.fileStore != null || this.versionsToKeep > 0;
    }

    public void setVersionsToKeep(int n) {
        this.versionsToKeep = n;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long l;
        long l2 = this.oldestVersionToKeep.get();
        l2 = Math.max(l2 - (long)this.versionsToKeep, -1L);
        if (this.fileStore != null && (l = this.lastChunkVersion() - 1L) != -1L && l < l2) {
            l2 = l;
        }
        return l2;
    }

    private void setOldestVersionToKeep(long l) {
        long l2;
        boolean bl;
        while (!(bl = l <= (l2 = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(l2, l))) {
        }
        if (this.oldestVersionTracker != null) {
            this.oldestVersionTracker.accept(l);
        }
    }

    public void setOldestVersionTracker(LongConsumer longConsumer) {
        this.oldestVersionTracker = longConsumer;
    }

    private long lastChunkVersion() {
        Chunk chunk = this.lastChunk;
        return chunk == null ? 0L : chunk.version;
    }

    private boolean isKnownVersion(long l) {
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.isEmpty()) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getLayoutMap(l);
        try {
            String string;
            Iterator<String> iterator = mVMap.keyIterator("chunk.");
            while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
                if (this.layout.containsKey(string)) continue;
                String string2 = mVMap.get(string);
                Chunk chunk2 = Chunk.fromString(string2);
                Chunk chunk3 = this.readChunkHeaderAndFooter(chunk2.block, chunk2.id);
                if (chunk3 != null) continue;
                return false;
            }
        }
        catch (MVStoreException mVStoreException) {
            return false;
        }
        return true;
    }

    public void registerUnsavedMemory(int n) {
        this.unsavedMemory += n;
        int n2 = this.unsavedMemory;
        if (n2 > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void beforeWrite(MVMap<?, ?> mVMap) {
        if (this.saveNeeded && this.fileStore != null && this.isOpenOrStopping() && (this.storeLock.isHeldByCurrentThread() || !mVMap.getRoot().isLockedByCurrentThread()) && mVMap != this.layout) {
            this.saveNeeded = false;
            if (this.autoCommitMemory > 0 && this.needStore()) {
                if (this.requireStore() && !mVMap.isSingleWriter()) {
                    this.commit(MVStore::requireStore);
                } else {
                    this.tryCommit(MVStore::needStore);
                }
            }
        }
    }

    private boolean requireStore() {
        return 3 * this.unsavedMemory > 4 * this.autoCommitMemory;
    }

    private boolean needStore() {
        return this.unsavedMemory > this.autoCommitMemory;
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = this.meta.get("setting.storeVersion");
        return string == null ? 0 : DataUtils.parseHexInt(string);
    }

    public void setStoreVersion(int n) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            this.markMetaChanged();
            this.meta.put("setting.storeVersion", Integer.toHexString(n));
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(long l) {
        this.storeLock.lock();
        try {
            block23: {
                Object object;
                TxCounter txCounter;
                this.checkOpen();
                this.currentVersion = l;
                if (l == 0L) {
                    this.layout.setInitialRoot(this.layout.createEmptyLeaf(), -1L);
                    this.meta.setInitialRoot(this.meta.createEmptyLeaf(), -1L);
                    this.layout.put(META_ID_KEY, Integer.toHexString(this.meta.getId()));
                    this.deadChunks.clear();
                    this.removedPages.clear();
                    this.chunks.clear();
                    this.clearCaches();
                    if (this.fileStore != null) {
                        this.saveChunkLock.lock();
                        try {
                            this.fileStore.clear();
                        }
                        finally {
                            this.saveChunkLock.unlock();
                        }
                    }
                    this.lastChunk = null;
                    this.versions.clear();
                    this.setWriteVersion(l);
                    this.metaChanged = false;
                    for (MVMap<?, ?> mVMap : this.maps.values()) {
                        mVMap.close();
                    }
                    return;
                }
                DataUtils.checkArgument(this.isKnownVersion(l), "Unknown version {0}", l);
                while ((txCounter = this.versions.peekLast()) != null && txCounter.version >= l) {
                    this.versions.removeLast();
                }
                this.currentTxCounter = new TxCounter(l);
                if (!this.layout.rollbackRoot(l)) {
                    object = this.getLayoutMap(l);
                    this.layout.setInitialRoot(((MVMap)object).getRootPage(), l);
                }
                if (!this.meta.rollbackRoot(l)) {
                    this.meta.setRootPos(this.getRootPos(this.meta.getId()), l - 1L);
                }
                this.metaChanged = false;
                for (MVMap mVMap : new ArrayList(this.maps.values())) {
                    int n = mVMap.getId();
                    if (mVMap.getCreateVersion() >= l) {
                        mVMap.close();
                        this.maps.remove(n);
                        continue;
                    }
                    if (mVMap.rollbackRoot(l)) continue;
                    mVMap.setRootPos(this.getRootPos(n), l - 1L);
                }
                this.deadChunks.clear();
                this.removedPages.clear();
                this.clearCaches();
                this.serializationLock.lock();
                try {
                    object = this.getChunkForVersion(l);
                    if (object == null) break block23;
                    this.saveChunkLock.lock();
                    try {
                        this.setLastChunk((Chunk)object);
                        this.storeHeader.put(HDR_CLEAN, 1);
                        this.writeStoreHeader();
                        this.readStoreHeader();
                    }
                    finally {
                        this.saveChunkLock.unlock();
                    }
                }
                finally {
                    this.serializationLock.unlock();
                }
            }
            this.onVersionChange(this.currentVersion);
            assert (!this.hasUnsavedChanges());
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
    }

    private void clearCaches() {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.chunksToC != null) {
            this.chunksToC.clear();
        }
    }

    private long getRootPos(int n) {
        String string = this.layout.get(MVMap.getMapRootKey(n));
        return string == null ? 0L : DataUtils.parseHexLong(string);
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (!this.isOpenOrStopping()) {
            throw DataUtils.newMVStoreException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.layout && mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int n = mVMap.getId();
        String string2 = this.getMapName(n);
        if (string2 != null && !string2.equals(string)) {
            String string3 = Integer.toHexString(n);
            String string4 = this.meta.putIfAbsent("name." + string, string3);
            DataUtils.checkArgument(string4 == null || string4.equals(string3), "A map named {0} already exists", string);
            this.meta.put(MVMap.getMapKey(n), mVMap.asString(string));
            this.meta.remove("name." + string2);
            this.markMetaChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMap(MVMap<?, ?> mVMap) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            DataUtils.checkArgument(this.layout != this.meta && mVMap != this.meta, "Removing the meta map is not allowed", new Object[0]);
            RootReference<?, ?> rootReference = mVMap.clearIt();
            mVMap.close();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            int n = mVMap.getId();
            String string = this.getMapName(n);
            if (this.meta.remove(MVMap.getMapKey(n)) != null) {
                this.markMetaChanged();
            }
            if (this.meta.remove("name." + string) != null) {
                this.markMetaChanged();
            }
            if (!this.isVersioningRequired()) {
                this.maps.remove(n);
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    void deregisterMapRoot(int n) {
        if (this.layout.remove(MVMap.getMapRootKey(n)) != null) {
            this.markMetaChanged();
        }
    }

    public void removeMap(String string) {
        int n = this.getMapId(string);
        if (n > 0) {
            MVMap mVMap = this.getMap(n);
            if (mVMap == null) {
                mVMap = this.openMap(string, MVStoreTool.getGenericMapBuilder());
            }
            this.removeMap(mVMap);
        }
    }

    public String getMapName(int n) {
        String string = this.meta.get(MVMap.getMapKey(n));
        return string == null ? null : DataUtils.getMapName(string);
    }

    private int getMapId(String string) {
        String string2 = this.meta.get("name." + string);
        return string2 == null ? -1 : DataUtils.parseHexInt(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeInBackground() {
        block21: {
            try {
                if (!this.isOpenOrStopping() || this.isReadOnly()) {
                    return;
                }
                long l = this.getTimeSinceCreation();
                if (l > this.lastCommitTime + (long)this.autoCommitDelay) {
                    this.tryCommit();
                    if (this.autoCompactFillRate < 0) {
                        this.compact(-this.getTargetFillRate(), this.autoCommitMemory);
                    }
                }
                int n = this.getFillRate();
                if (this.fileStore.isFragmented() && n < this.autoCompactFillRate) {
                    if (this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int n2 = this.autoCommitMemory;
                            if (this.isIdle()) {
                                n2 *= 4;
                            }
                            this.compactMoveChunks(101, n2);
                        }
                        finally {
                            this.unlockAndCheckPanicCondition();
                        }
                    }
                } else if (n >= this.autoCompactFillRate && this.lastChunk != null) {
                    int n3 = this.getRewritableChunksFillRate();
                    int n4 = n3 = this.isIdle() ? 100 - (100 - n3) / 2 : n3;
                    if (n3 < this.getTargetFillRate() && this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int n5 = this.autoCommitMemory * n / Math.max(n3, 1);
                            if (!this.isIdle()) {
                                n5 /= 4;
                            }
                            if (this.rewriteChunks(n5, n3)) {
                                this.dropUnusedChunks();
                            }
                        }
                        finally {
                            this.storeLock.unlock();
                        }
                    }
                }
                this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
                if (this.backgroundExceptionHandler != null) break block21;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaintenance(int n) {
        if (this.autoCompactFillRate > 0 && this.lastChunk != null && this.reuseSpace) {
            try {
                int n2 = -1;
                for (int i = 0; i < 5; ++i) {
                    int n3;
                    int n4 = n3 = this.getFillRate();
                    if (n3 > n && ((n4 = this.getProjectedFillRate(100)) > n || n4 <= n2)) break;
                    n2 = n4;
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break;
                    try {
                        int n5 = this.autoCommitMemory * n / Math.max(n4, 1);
                        if ((n4 >= n3 || this.rewriteChunks(n5, n) && this.dropUnusedChunks() != 0 || i <= 0) && this.compactMoveChunks(101, n5)) continue;
                        break;
                    }
                    finally {
                        this.unlockAndCheckPanicCondition();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }

    private int getTargetFillRate() {
        int n = this.autoCompactFillRate;
        if (!this.isIdle()) {
            n /= 2;
        }
        return n;
    }

    private boolean isIdle() {
        return this.autoCompactLastFileOpCount == this.fileStore.getWriteCount() + this.fileStore.getReadCount();
    }

    private void handleException(Throwable throwable) {
        block3: {
            if (this.backgroundExceptionHandler != null) {
                try {
                    this.backgroundExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                }
                catch (Throwable throwable2) {
                    if (throwable == throwable2) break block3;
                    throwable.addSuppressed(throwable2);
                }
            }
        }
    }

    public void setCacheSize(int n) {
        long l = (long)n * 1024L * 1024L;
        if (this.cache != null) {
            this.cache.setMaxMemory(l);
            this.cache.clear();
        }
    }

    private boolean isOpen() {
        return this.state == 0;
    }

    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            boolean bl = this.state == 3;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread(boolean bl) {
        BackgroundWriterThread backgroundWriterThread;
        while ((backgroundWriterThread = this.backgroundWriterThread.get()) != null) {
            if (!this.backgroundWriterThread.compareAndSet(backgroundWriterThread, null)) continue;
            if (backgroundWriterThread != Thread.currentThread()) {
                Object object = backgroundWriterThread.sync;
                synchronized (object) {
                    backgroundWriterThread.sync.notifyAll();
                }
                if (bl) {
                    try {
                        backgroundWriterThread.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Utils.shutdownExecutor(this.serializationExecutor);
            this.serializationExecutor = null;
            Utils.shutdownExecutor(this.bufferSaveExecutor);
            this.bufferSaveExecutor = null;
            break;
        }
    }

    public void setAutoCommitDelay(int n) {
        int n2;
        BackgroundWriterThread backgroundWriterThread;
        if (this.autoCommitDelay == n) {
            return;
        }
        this.autoCommitDelay = n;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread(true);
        if (n > 0 && this.isOpen() && this.backgroundWriterThread.compareAndSet(null, backgroundWriterThread = new BackgroundWriterThread(this, n2 = Math.max(1, n / 10), this.fileStore.toString()))) {
            backgroundWriterThread.start();
            this.serializationExecutor = Utils.createSingleThreadExecutor("H2-serialization");
            this.bufferSaveExecutor = Utils.createSingleThreadExecutor("H2-save");
        }
    }

    public boolean isBackgroundThread() {
        return Thread.currentThread() == this.backgroundWriterThread.get();
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(Page<?, ?> page) {
        if (this.cache != null) {
            this.cache.put(page.getPos(), page, page.getMemory());
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() >> 20);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() >> 20);
    }

    public CacheLongKeyLIRS<Page<?, ?>> getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    public int getCacheHitRatio() {
        return MVStore.getCacheHitRatio(this.cache);
    }

    public int getTocCacheHitRatio() {
        return MVStore.getCacheHitRatio(this.chunksToC);
    }

    private static int getCacheHitRatio(CacheLongKeyLIRS<?> cacheLongKeyLIRS) {
        if (cacheLongKeyLIRS == null) {
            return 0;
        }
        long l = cacheLongKeyLIRS.getHits();
        return (int)(100L * l / (l + cacheLongKeyLIRS.getMisses() + 1L));
    }

    public int getLeafRatio() {
        return (int)(this.leafCount * 100L / Math.max(1L, this.leafCount + this.nonLeafCount));
    }

    public double getUpdateFailureRatio() {
        long l = this.updateCounter;
        long l2 = this.updateAttemptCounter;
        RootReference<String, String> rootReference = this.layout.getRoot();
        l += rootReference.updateCounter;
        l2 += rootReference.updateAttemptCounter;
        rootReference = this.meta.getRoot();
        l += rootReference.updateCounter;
        l2 += rootReference.updateAttemptCounter;
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            RootReference<?, ?> rootReference2 = mVMap.getRoot();
            l += rootReference2.updateCounter;
            l2 += rootReference2.updateAttemptCounter;
        }
        return l2 == 0L ? 0.0 : 1.0 - (double)l / (double)l2;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while ((txCounter = this.currentTxCounter).incrementAndGet() <= 0) {
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.decrementAndGet();
        }
        return txCounter;
    }

    public void deregisterVersionUsage(TxCounter txCounter) {
        if (this.decrementVersionUsageCounter(txCounter)) {
            if (this.storeLock.isHeldByCurrentThread()) {
                this.dropUnusedVersions();
            } else if (this.storeLock.tryLock()) {
                try {
                    this.dropUnusedVersions();
                }
                finally {
                    this.storeLock.unlock();
                }
            }
        }
    }

    public boolean decrementVersionUsageCounter(TxCounter txCounter) {
        return txCounter != null && txCounter.decrementAndGet() <= 0;
    }

    private void onVersionChange(long l) {
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(l);
        txCounter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        while ((txCounter = this.versions.peek()) != null && txCounter.get() < 0) {
            this.versions.poll();
        }
        long l = (txCounter != null ? txCounter : this.currentTxCounter).version;
        this.setOldestVersionToKeep(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dropUnusedChunks() {
        assert (this.storeLock.isHeldByCurrentThread());
        int n = 0;
        if (!this.deadChunks.isEmpty()) {
            long l = this.getOldestVersionToKeep();
            long l2 = this.getTimeSinceCreation();
            this.saveChunkLock.lock();
            try {
                Chunk chunk;
                while ((chunk = this.deadChunks.poll()) != null && (this.isSeasonedChunk(chunk, l2) && MVStore.canOverwriteChunk(chunk, l) || !this.deadChunks.offerFirst(chunk))) {
                    if (this.chunks.remove(chunk.id) == null) continue;
                    long[] lArray = this.chunksToC.remove(chunk.id);
                    if (lArray != null && this.cache != null) {
                        for (long l3 : lArray) {
                            long l4 = DataUtils.getPagePos(chunk.id, l3);
                            this.cache.remove(l4);
                        }
                    }
                    if (this.layout.remove(Chunk.getMetaKey(chunk.id)) != null) {
                        this.markMetaChanged();
                    }
                    if (chunk.isSaved()) {
                        this.freeChunkSpace(chunk);
                    }
                    ++n;
                }
            }
            finally {
                this.saveChunkLock.unlock();
            }
        }
        return n;
    }

    private void freeChunkSpace(Chunk chunk) {
        long l = chunk.block * 4096L;
        int n = chunk.len * 4096;
        this.freeFileSpace(l, n);
    }

    private void freeFileSpace(long l, int n) {
        this.fileStore.free(l, n);
        assert (this.validateFileLength(l + ":" + n));
    }

    private boolean validateFileLength(String string) {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + string;
        return true;
    }

    public static final class Builder {
        private final HashMap<String, Object> config;

        private Builder(HashMap<String, Object> hashMap) {
            this.config = hashMap;
        }

        public Builder() {
            this.config = new HashMap();
        }

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder autoCommitDisabled() {
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int n) {
            return this.set("autoCommitBufferSize", n);
        }

        public Builder autoCompactFillRate(int n) {
            return this.set("autoCompactFillRate", n);
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encryptionKey", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder keysPerPage(int n) {
            return this.set("keysPerPage", n);
        }

        public Builder recoveryMode() {
            return this.set("recoveryMode", 1);
        }

        public Builder cacheSize(int n) {
            return this.set("cacheSize", n);
        }

        public Builder cacheConcurrency(int n) {
            return this.set("cacheConcurrency", n);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int n) {
            return this.set("pageSplitSize", n);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return this.set("backgroundExceptionHandler", uncaughtExceptionHandler);
        }

        public Builder fileStore(FileStore fileStore) {
            return this.set("fileStore", fileStore);
        }

        public Builder adoptFileStore(FileStore fileStore) {
            this.set("fileStoreIsAdopted", true);
            return this.set("fileStore", fileStore);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            return new Builder(DataUtils.parseMap(string));
        }
    }

    private static class RemovedPageInfo
    implements Comparable<RemovedPageInfo> {
        final long version;
        final long removedPageInfo;

        RemovedPageInfo(long l, boolean bl, long l2, int n) {
            this.removedPageInfo = RemovedPageInfo.createRemovedPageInfo(l, bl, n);
            this.version = l2;
        }

        @Override
        public int compareTo(RemovedPageInfo removedPageInfo) {
            return Long.compare(this.version, removedPageInfo.version);
        }

        int getPageChunkId() {
            return DataUtils.getPageChunkId(this.removedPageInfo);
        }

        int getPageNo() {
            return DataUtils.getPageOffset(this.removedPageInfo);
        }

        int getPageLength() {
            return DataUtils.getPageMaxLength(this.removedPageInfo);
        }

        boolean isPinned() {
            return (this.removedPageInfo & 1L) == 1L;
        }

        private static long createRemovedPageInfo(long l, boolean bl, int n) {
            long l2 = l & 0xFFFFFFC00000003EL | (long)n << 6 & 0xFFFFFFFFL;
            if (bl) {
                l2 |= 1L;
            }
            return l2;
        }

        public String toString() {
            return "RemovedPageInfo{version=" + this.version + ", chunk=" + this.getPageChunkId() + ", pageNo=" + this.getPageNo() + ", len=" + this.getPageLength() + (this.isPinned() ? ", pinned" : "") + '}';
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore mVStore, int n, String string) {
            super("MVStore background writer " + string);
            this.store = mVStore;
            this.sleep = n;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.isBackgroundThread()) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.store.isBackgroundThread()) break;
                this.store.writeInBackground();
            }
        }
    }

    public static final class TxCounter {
        public final long version;
        private volatile int counter;
        private static final AtomicIntegerFieldUpdater<TxCounter> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(TxCounter.class, "counter");

        TxCounter(long l) {
            this.version = l;
        }

        int get() {
            return this.counter;
        }

        int incrementAndGet() {
            return counterUpdater.incrementAndGet(this);
        }

        int decrementAndGet() {
            return counterUpdater.decrementAndGet(this);
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }
}

