/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical;

import org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;
import org.gradle.internal.impldep.org.junit.platform.engine.ExecutionRequest;
import org.gradle.internal.impldep.org.junit.platform.engine.TestEngine;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutor;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.SameThreadHierarchicalTestExecutorService;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.MAINTAINED, since="1.0")
public abstract class HierarchicalTestEngine<C extends EngineExecutionContext>
implements TestEngine {
    @Override
    public final void execute(ExecutionRequest request) {
        try (HierarchicalTestExecutorService executorService = this.createExecutorService(request);){
            C executionContext = this.createExecutionContext(request);
            ThrowableCollector.Factory throwableCollectorFactory = this.createThrowableCollectorFactory(request);
            new HierarchicalTestExecutor<C>(request, executionContext, executorService, throwableCollectorFactory).execute().get();
        }
        catch (Exception exception) {
            throw new JUnitException("Error executing tests for engine " + this.getId(), exception);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3")
    protected HierarchicalTestExecutorService createExecutorService(ExecutionRequest request) {
        return new SameThreadHierarchicalTestExecutorService();
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3")
    protected ThrowableCollector.Factory createThrowableCollectorFactory(ExecutionRequest request) {
        return OpenTest4JAwareThrowableCollector::new;
    }

    protected abstract C createExecutionContext(ExecutionRequest var1);
}

