/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.image.PGraphicsDevice;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SunGraphicsEnvironment;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0016\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000eH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001aH\u0014J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006&"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphicsEnvironment;", "Lsun/java2d/SunGraphicsEnvironment;", "()V", "xResolution", "", "getXResolution", "()D", "yResolution", "getYResolution", "createGraphics", "Ljava/awt/Graphics2D;", "img", "Ljava/awt/image/BufferedImage;", "getAllFonts", "", "Ljava/awt/Font;", "()[Ljava/awt/Font;", "getAvailableFontFamilyNames", "", "()[Ljava/lang/String;", "requestedLocale", "Ljava/util/Locale;", "(Ljava/util/Locale;)[Ljava/lang/String;", "getDefaultScreenDevice", "Ljava/awt/GraphicsDevice;", "getNumScreens", "", "getScreenDevices", "()[Ljava/awt/GraphicsDevice;", "isDisplayLocal", "", "makeScreenDevice", "p0", "setDefaultDeviceSize", "", "width", "height", "Companion", "projector-awt-common"})
public final class PGraphicsEnvironment
extends SunGraphicsEnvironment {
    @NotNull
    public static final Companion Companion;
    private final double xResolution;
    private final double yResolution;
    private static boolean clientDoesWindowManagement;
    @NotNull
    private static final ArrayList<PGraphicsDevice> devices;
    @NotNull
    private static final PGraphicsEnvironment instance;

    private PGraphicsEnvironment() {
        this.xResolution = 96.0;
        this.yResolution = 96.0;
    }

    public final double getXResolution() {
        return this.xResolution;
    }

    public final double getYResolution() {
        return this.yResolution;
    }

    @Override
    @NotNull
    public GraphicsDevice[] getScreenDevices() {
        Collection $this$toTypedArray$iv = devices;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        GraphicsDevice[] graphicsDeviceArray = thisCollection$iv.toArray(new GraphicsDevice[0]);
        if (graphicsDeviceArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return graphicsDeviceArray;
    }

    @Override
    @NotNull
    public GraphicsDevice getDefaultScreenDevice() {
        return Companion.getDefaultDevice();
    }

    @Override
    @NotNull
    public Graphics2D createGraphics(@NotNull BufferedImage img) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return new SunGraphics2D(BufImgSurfaceData.createData(img), Color.WHITE, Color.WHITE, (Font)ArraysKt.first((Object[])PFontManager.INSTANCE.getAllInstalledFonts()));
    }

    @Override
    @NotNull
    public Font[] getAllFonts() {
        return PFontManager.INSTANCE.getAllInstalledFonts();
    }

    @Override
    @NotNull
    public String[] getAvailableFontFamilyNames() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        return this.getAvailableFontFamilyNames(locale);
    }

    @Override
    @NotNull
    public String[] getAvailableFontFamilyNames(@NotNull Locale requestedLocale) {
        Intrinsics.checkNotNullParameter((Object)requestedLocale, (String)"requestedLocale");
        return PFontManager.INSTANCE.getInstalledFontFamilyNames(requestedLocale);
    }

    public final void setDefaultDeviceSize(int width, int height) {
        Companion.getDefaultDevice().getBounds().setSize(width, height);
        PGraphicsEnvironment.Companion.fireDisplaysChanged();
    }

    @Override
    protected int getNumScreens() {
        return devices.size();
    }

    @Override
    public boolean isDisplayLocal() {
        return false;
    }

    @Override
    @NotNull
    protected GraphicsDevice makeScreenDevice(int p0) {
        PGraphicsDevice pGraphicsDevice = devices.get(p0);
        Intrinsics.checkNotNullExpressionValue((Object)pGraphicsDevice, (String)"devices[p0]");
        return pGraphicsDevice;
    }

    @NotNull
    public static final PGraphicsEnvironment getInstance() {
        return Companion.getInstance();
    }

    static {
        ArrayList<PGraphicsDevice> arrayList;
        Companion = new Companion(null);
        ArrayList<PGraphicsDevice> $this$devices_u24lambda_u2d0 = arrayList = new ArrayList<PGraphicsDevice>();
        boolean bl = false;
        $this$devices_u24lambda_u2d0.add(new PGraphicsDevice("Screen0"));
        devices = arrayList;
        instance = new PGraphicsEnvironment();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00172\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b0\u001aR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphicsEnvironment$Companion;", "", "()V", "clientDoesWindowManagement", "", "getClientDoesWindowManagement", "()Z", "setClientDoesWindowManagement", "(Z)V", "defaultDevice", "Lorg/jetbrains/projector/awt/image/PGraphicsDevice;", "getDefaultDevice", "()Lorg/jetbrains/projector/awt/image/PGraphicsDevice;", "devices", "Ljava/util/ArrayList;", "getDevices", "()Ljava/util/ArrayList;", "instance", "Lorg/jetbrains/projector/awt/image/PGraphicsEnvironment;", "getInstance$annotations", "getInstance", "()Lorg/jetbrains/projector/awt/image/PGraphicsEnvironment;", "fireDisplaysChanged", "", "setupDisplays", "additionalDisplays", "", "Lkotlin/Pair;", "Ljava/awt/Rectangle;", "", "projector-awt-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getClientDoesWindowManagement() {
            return clientDoesWindowManagement;
        }

        public final void setClientDoesWindowManagement(boolean bl) {
            clientDoesWindowManagement = bl;
        }

        @NotNull
        public final ArrayList<PGraphicsDevice> getDevices() {
            return devices;
        }

        @NotNull
        public final PGraphicsDevice getDefaultDevice() {
            PGraphicsDevice pGraphicsDevice = this.getDevices().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)pGraphicsDevice, (String)"devices[0]");
            return pGraphicsDevice;
        }

        /*
         * WARNING - void declaration
         */
        public final void setupDisplays(@NotNull List<? extends Pair<? extends Rectangle, Double>> additionalDisplays) {
            Intrinsics.checkNotNullParameter(additionalDisplays, (String)"additionalDisplays");
            this.getDevices().clear();
            Iterable $this$forEachIndexed$iv = additionalDisplays;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int i = n;
                boolean bl = false;
                PGraphicsDevice element = new PGraphicsDevice("Screen" + i);
                element.getBounds().setBounds((Rectangle)it.getFirst());
                element.setScaleFactor(((Number)it.getSecond()).doubleValue());
                Companion.getDevices().add(element);
            }
            this.fireDisplaysChanged();
        }

        private final void fireDisplaysChanged() {
            this.getInstance().displayChanged();
            Iterable $this$forEach$iv = PWindow.Companion.getWindows();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PWindow it = (PWindow)element$iv;
                boolean bl = false;
                it.updateGraphics$projector_awt_common();
            }
        }

        @NotNull
        public final PGraphicsEnvironment getInstance() {
            return instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

