/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticList;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DanglingTopLevelModifierListStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ReanalyzableStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.analysis.utils.printer.PsiUtilsKt;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\rH\u0002J(\u0010\u001f\u001a\u00020 *\b\u0012\u0004\u0012\u00020\u00170!2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "firProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "structureElements", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "createDanglingModifierListStructure", "container", "createDeclarationStructure", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "createStructureElement", "getAllDiagnosticsForFile", "", "Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "diagnosticCheckerFilter", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "getAllStructureElements", "getStructureElementFor", "element", "getStructureElementForDeclaration", "getStructureKtElement", "collectDiagnosticsFromStructureElements", "", "", "isInsideSuperClassCall", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFileStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FileStructureElementDiagnostics.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics\n+ 4 FileStructureElementDiagnosticList.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticList\n*L\n1#1,200:1\n1855#2:201\n1855#2,2:205\n1856#2:211\n1855#2,2:212\n40#3,2:202\n43#3,4:207\n16#4:204\n*S KotlinDebug\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n*L\n117#1:201\n118#1:205,2\n117#1:211\n159#1:212,2\n118#1:202,2\n118#1:207,4\n118#1:204\n*E\n"})
public final class FileStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final FirFile firFile;
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final FirProvider firProvider;
    @NotNull
    private final ConcurrentHashMap<KtElement, FileStructureElement> structureElements;

    private FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents) {
        this.ktFile = ktFile;
        this.firFile = firFile;
        this.moduleComponents = moduleComponents;
        this.firProvider = FirProviderKt.getFirProvider(this.firFile.getModuleData().getSession());
        this.structureElements = new ConcurrentHashMap();
    }

    @NotNull
    public final FileStructureElement getStructureElementFor(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtDeclaration declaration2 = this.getStructureKtElement(element3);
        KtElement container2 = null;
        if (declaration2 != null) {
            container2 = (KtElement)declaration2;
        } else {
            KtElement ktElement;
            KtModifierList modifierList = (KtModifierList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element3), KtModifierList.class, (boolean)false);
            if (modifierList != null && modifierList.getNextSibling() instanceof PsiErrorElement) {
                ktElement = (KtElement)modifierList;
            } else {
                KtFile ktFile = element3.getContainingKtFile();
                Intrinsics.checkNotNull((Object)ktFile);
                ktElement = (KtElement)ktFile;
            }
            container2 = ktElement;
        }
        return this.getStructureElementForDeclaration(container2);
    }

    private final KtDeclaration getStructureKtElement(KtElement element3) {
        KtPrimaryConstructor resultedContainer;
        KtDeclaration container2 = FirElementBuilderKt.getNonLocalContainingOrThisDeclaration((PsiElement)element3, (Function1<? super KtDeclaration, Boolean>)((Function1)getStructureKtElement.container.1.INSTANCE));
        KtPrimaryConstructor ktPrimaryConstructor = resultedContainer = container2 instanceof KtClassOrObject && this.isInsideSuperClassCall((KtClassOrObject)container2, element3) ? ((KtClassOrObject)container2).getPrimaryConstructor() : null;
        return ktPrimaryConstructor != null ? (KtDeclaration)ktPrimaryConstructor : container2;
    }

    private final boolean isInsideSuperClassCall(KtClassOrObject $this$isInsideSuperClassCall, KtElement element3) {
        for (KtSuperTypeListEntry entry : $this$isInsideSuperClassCall.getSuperTypeListEntries()) {
            if (!(entry instanceof KtSuperTypeCallEntry) || !org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt.isAncestor((PsiElement)((PsiElement)entry), (PsiElement)((PsiElement)element3), (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private final FileStructureElement getStructureElementForDeclaration(KtElement declaration2) {
        FileStructureElement structureElement2;
        FileStructureElement fileStructureElement = structureElement2 = this.structureElements.compute(declaration2, (arg_0, arg_1) -> FileStructure.getStructureElementForDeclaration$lambda$0((Function2)new Function2<KtElement, FileStructureElement, FileStructureElement>(this, declaration2){
            final /* synthetic */ FileStructure this$0;
            final /* synthetic */ KtElement $declaration;
            {
                this.this$0 = $receiver;
                this.$declaration = $declaration;
                super(2);
            }

            @Nullable
            public final FileStructureElement invoke(@NotNull KtElement ktElement, @Nullable FileStructureElement structureElement2) {
                FileStructureElement fileStructureElement;
                Intrinsics.checkNotNullParameter((Object)ktElement, (String)"<anonymous parameter 0>");
                if (structureElement2 == null) {
                    fileStructureElement = FileStructure.access$createStructureElement(this.this$0, this.$declaration);
                } else if (structureElement2 instanceof ReanalyzableStructureElement && !((ReanalyzableStructureElement)structureElement2).isUpToDate()) {
                    ReanalyzableStructureElement reanalyzableStructureElement = (ReanalyzableStructureElement)structureElement2;
                    KtElement ktElement2 = this.$declaration;
                    Intrinsics.checkNotNull((Object)ktElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDeclaration");
                    fileStructureElement = reanalyzableStructureElement.reanalyze((KtDeclaration)ktElement2);
                } else {
                    fileStructureElement = structureElement2;
                }
                return fileStructureElement;
            }
        }, arg_0, arg_1));
        if (fileStructureElement == null) {
            throw new IllegalStateException(("FileStructureElement for was not defined for \n" + PsiUtilsKt.getElementTextInContext(declaration2)).toString());
        }
        return fileStructureElement;
    }

    @NotNull
    public final Collection<KtPsiDiagnostic> getAllDiagnosticsForFile(@NotNull DiagnosticCheckerFilter diagnosticCheckerFilter) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticCheckerFilter), (String)"diagnosticCheckerFilter");
        Collection<FileStructureElement> structureElements = this.getAllStructureElements();
        List $this$getAllDiagnosticsForFile_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.collectDiagnosticsFromStructureElements($this$getAllDiagnosticsForFile_u24lambda_u241, structureElements, diagnosticCheckerFilter);
        return CollectionsKt.build((List)list2);
    }

    private final void collectDiagnosticsFromStructureElements(Collection<KtPsiDiagnostic> $this$collectDiagnosticsFromStructureElements, Collection<? extends FileStructureElement> structureElements, DiagnosticCheckerFilter diagnosticCheckerFilter) {
        Iterable $this$forEach$iv = structureElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List diagnostics2;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv$iv$iv;
            boolean $i$f$forEach3;
            FileStructureElementDiagnosticList this_$iv$iv;
            FileStructureElement structureElement2 = (FileStructureElement)element$iv;
            boolean bl2 = false;
            FileStructureElementDiagnostics this_$iv = structureElement2.getDiagnostics();
            boolean $i$f$forEach4 = false;
            if (diagnosticCheckerFilter.getRunCommonCheckers()) {
                this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByCommonCheckers(this_$iv);
                $i$f$forEach3 = false;
                $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
                $i$f$forEach2 = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    diagnostics2 = (List)element$iv$iv$iv;
                    bl = false;
                    $this$collectDiagnosticsFromStructureElements.addAll(diagnostics2);
                }
            }
            if (!diagnosticCheckerFilter.getRunExtendedCheckers()) continue;
            this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByExtendedCheckers(this_$iv);
            $i$f$forEach3 = false;
            $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
            $i$f$forEach2 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                diagnostics2 = (List)element$iv$iv$iv;
                bl = false;
                $this$collectDiagnosticsFromStructureElements.addAll(diagnostics2);
            }
        }
    }

    @NotNull
    public final Collection<FileStructureElement> getAllStructureElements() {
        Object[] objectArray = new FileStructureElement[]{this.getStructureElementFor((KtElement)this.ktFile)};
        Set structureElements = SetsKt.mutableSetOf((Object[])objectArray);
        this.ktFile.accept((PsiElementVisitor)new KtVisitorVoid(this, structureElements){
            final /* synthetic */ FileStructure this$0;
            final /* synthetic */ Set<FileStructureElement> $structureElements;
            {
                this.this$0 = $receiver;
                this.$structureElements = $structureElements;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                element3.acceptChildren((PsiElementVisitor)this);
            }

            public void visitDeclaration(@NotNull KtDeclaration dcl) {
                Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                FileStructureElement structureElement2 = this.this$0.getStructureElementFor((KtElement)dcl);
                ((Collection)this.$structureElements).add(structureElement2);
                if (!(structureElement2 instanceof ReanalyzableStructureElement)) {
                    dcl.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitModifierList(@NotNull KtModifierList list2) {
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                if (Intrinsics.areEqual((Object)list2.getParent(), (Object)FileStructure.access$getKtFile$p(this.this$0))) {
                    ((Collection)this.$structureElements).add(this.this$0.getStructureElementFor((KtElement)list2));
                }
            }
        });
        return structureElements;
    }

    private final FileStructureElement createDeclarationStructure(KtDeclaration declaration2) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceNonLocalFirDeclaration(declaration2, this.moduleComponents.getFirFileBuilder(), this.firProvider, this.firFile);
        FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE);
        if (firDeclaration instanceof FirPrimaryConstructor) {
            Iterable $this$forEach$iv = ((FirPrimaryConstructor)firDeclaration).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameter parameter2 = (FirValueParameter)element$iv;
                boolean bl = false;
                FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(parameter2);
                if (firProperty != null) {
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(firProperty, FirResolvePhase.BODY_RESOLVE);
                }
            }
        }
        return FileElementFactory.INSTANCE.createFileStructureElement(firDeclaration, declaration2, this.firFile, this.moduleComponents);
    }

    private final FileStructureElement createDanglingModifierListStructure(KtElement container2) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceByTraversingWholeTree(container2, this.moduleComponents.getFirFileBuilder(), this.firFile);
        FirDanglingModifierList firDanglingModifierList = firDeclaration instanceof FirDanglingModifierList ? (FirDanglingModifierList)firDeclaration : null;
        if (firDanglingModifierList == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No dangling modifier found", null, null, null, (PsiElement)container2, null, 46, null);
            throw null;
        }
        FirDanglingModifierList firDanglingModifierList2 = firDanglingModifierList;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(firDanglingModifierList2, FirResolvePhase.BODY_RESOLVE);
        FirDeclaration firDeclaration2 = firDanglingModifierList2;
        KtFile ktFile = container2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        return new DanglingTopLevelModifierListStructureElement(this.firFile, firDeclaration2, this.moduleComponents, (KtAnnotated)ktFile);
    }

    private final FileStructureElement createStructureElement(KtElement container2) {
        FileStructureElement fileStructureElement;
        if (container2 instanceof KtFile) {
            FirFile firFile = this.moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(this.ktFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firFile, FirResolvePhase.IMPORTS);
            this.moduleComponents.getFirModuleLazyDeclarationResolver().lazyResolve(firFile.getAnnotationsContainer(), this.moduleComponents.getScopeSessionProvider().getScopeSession(), FirResolvePhase.BODY_RESOLVE);
            fileStructureElement = new RootStructureElement(firFile, (KtFile)container2, this.moduleComponents);
        } else if (container2 instanceof KtDeclaration) {
            fileStructureElement = this.createDeclarationStructure((KtDeclaration)container2);
        } else if (container2 instanceof KtModifierList && ((KtModifierList)container2).getNextSibling() instanceof PsiErrorElement) {
            fileStructureElement = this.createDanglingModifierListStructure(container2);
        } else {
            throw new IllegalStateException(("Invalid container " + container2).toString());
        }
        return fileStructureElement;
    }

    private static final FileStructureElement getStructureElementForDeclaration$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileStructureElement)$tmp0.invoke(p0, p1);
    }

    public /* synthetic */ FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents, DefaultConstructorMarker $constructor_marker) {
        this(ktFile, firFile, moduleComponents);
    }

    public static final /* synthetic */ FileStructureElement access$createStructureElement(FileStructure $this, KtElement container2) {
        return $this.createStructureElement(container2);
    }

    public static final /* synthetic */ KtFile access$getKtFile$p(FileStructure $this) {
        return $this.ktFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure$Companion;", "", "()V", "build", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileStructure build(@NotNull KtFile ktFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
            FirFile firFile = moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(ktFile);
            return new FileStructure(ktFile, firFile, moduleComponents, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

