/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.base.analysis;

import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a*\u0010\n\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"exclusions", "", "", "shouldBeHiddenAsInternalImplementationDetail", "", "fqName", "locationFqName", "usesOutdatedCoroutinesPackage", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isExcludedFromAutoImport", "Lorg/jetbrains/kotlin/name/FqName;", "project", "Lcom/intellij/openapi/project/Project;", "contextFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.base.analysis"})
@JvmName(name="AutoImportUtils")
@SourceDebugExtension(value={"SMAP\nAutoImportUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoImportUtils.kt\norg/jetbrains/kotlin/base/analysis/AutoImportUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1747#2,3:50\n*S KotlinDebug\n*F\n+ 1 AutoImportUtils.kt\norg/jetbrains/kotlin/base/analysis/AutoImportUtils\n*L\n26#1:50,3\n*E\n"})
public final class AutoImportUtils {
    @NotNull
    private static final List<String> exclusions;

    private static final boolean shouldBeHiddenAsInternalImplementationDetail(String fqName2, String locationFqName) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)fqName2, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && (StringsKt.isBlank((CharSequence)locationFqName) || !StringsKt.startsWith$default((String)fqName2, (String)locationFqName, (boolean)false, (int)2, null));
    }

    private static final boolean usesOutdatedCoroutinesPackage(String fqName2, LanguageVersionSettings languageVersionSettings2) {
        return StringsKt.startsWith$default((String)fqName2, (String)"kotlin.coroutines.experimental.", (boolean)false, (int)2, null) && languageVersionSettings2.supportsFeature(LanguageFeature.ReleaseCoroutines);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    public static final boolean isExcludedFromAutoImport(@NotNull FqName $this$isExcludedFromAutoImport, @NotNull Project project2, @Nullable KtFile contextFile, @Nullable LanguageVersionSettings languageVersionSettings2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isExcludedFromAutoImport, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string2 = $this$isExcludedFromAutoImport.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.asString()");
        String fqName2 = string2;
        if (JavaProjectCodeInsightSettings.getSettings((Project)project2).isExcluded(fqName2)) return true;
        if (languageVersionSettings2 != null) {
            if (AutoImportUtils.usesOutdatedCoroutinesPackage(fqName2, languageVersionSettings2)) return true;
        }
        if ((object = contextFile) == null || (object = object.getPackageFqName()) == null || (object = object.asString()) == null) {
            object = "";
        }
        if (!AutoImportUtils.shouldBeHiddenAsInternalImplementationDetail(fqName2, (String)object)) return false;
        return true;
    }

    public static /* synthetic */ boolean isExcludedFromAutoImport$default(FqName fqName2, Project project2, KtFile ktFile, LanguageVersionSettings languageVersionSettings2, int n, Object object) {
        if ((n & 4) != 0) {
            KtFile ktFile2 = ktFile;
            languageVersionSettings2 = ktFile2 != null ? LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)ktFile2) : null;
        }
        return AutoImportUtils.isExcludedFromAutoImport(fqName2, project2, ktFile, languageVersionSettings2);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.jvm.internal", "kotlin.coroutines.experimental.intrinsics", "kotlin.coroutines.intrinsics", "kotlin.coroutines.experimental.jvm.internal", "kotlin.coroutines.jvm.internal", "kotlin.reflect.jvm.internal"};
        exclusions = CollectionsKt.listOf((Object[])objectArray);
    }
}

