/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.types.FirIntersectionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirDefinitelyNotNullableChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirDefinitelyNotNullableChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirDefinitelyNotNullableChecker INSTANCE = new FirDefinitelyNotNullableChecker();

    private FirDefinitelyNotNullableChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirResolvedTypeRef firResolvedTypeRef = typeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)typeRef : null;
        FirTypeRef firTypeRef = firResolvedTypeRef != null ? firResolvedTypeRef.getDelegatedTypeRef() : null;
        FirIntersectionTypeRef firIntersectionTypeRef = firTypeRef instanceof FirIntersectionTypeRef ? (FirIntersectionTypeRef)firTypeRef : null;
        if (firIntersectionTypeRef == null) {
            return;
        }
        FirIntersectionTypeRef intersection = firIntersectionTypeRef;
        if (intersection.isMarkedNullable()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)intersection.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getNULLABLE_ON_DEFINITELY_NOT_NULLABLE(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (!FirTypeUtilsKt.isLeftValidForDefinitelyNotNullable(intersection)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)intersection.getLeftType().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINCORRECT_LEFT_COMPONENT_OF_INTERSECTION(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (!FirTypeUtilsKt.isRightValidForDefinitelyNotNullable(intersection)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)intersection.getRightType().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINCORRECT_RIGHT_COMPONENT_OF_INTERSECTION(), (DiagnosticContext)context2, null, (int)8, null);
        }
    }
}

