/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtLocalVariableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPackageSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolKind;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithModality;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\f\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/KtIconProvider;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getBaseIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "getIcon", "ktSymbol", "flags", "", "getVisibilityIcon", "kotlin.base.resources"})
public final class KtIconProvider {
    @NotNull
    public static final KtIconProvider INSTANCE = new KtIconProvider();
    @NotNull
    private static final Logger LOG;

    private KtIconProvider() {
    }

    @Nullable
    public final Icon getIcon(@NotNull KtAnalysisSession $this$getIcon, @NotNull KtSymbol ktSymbol) {
        Icon icon;
        PsiElement declaration2;
        Intrinsics.checkNotNullParameter((Object)$this$getIcon, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ktSymbol, (String)"ktSymbol");
        PsiElement psiElement2 = declaration2 = ktSymbol.getPsi();
        boolean bl = psiElement2 != null ? psiElement2.isValid() : false;
        if (bl) {
            int flags;
            boolean isClass = declaration2 instanceof PsiClass || declaration2 instanceof KtClass;
            int n = flags = isClass ? 0 : 1;
            if (declaration2 instanceof KtDeclaration) {
                icon = this.getIcon($this$getIcon, ktSymbol, flags);
                if (icon == null) {
                    icon = ((KtDeclaration)declaration2).getIcon(flags);
                }
            } else {
                icon = declaration2.getIcon(flags);
            }
        } else {
            icon = this.getIcon($this$getIcon, ktSymbol, 0);
        }
        return icon;
    }

    private final Icon getIcon(KtAnalysisSession $this$getIcon, KtSymbol symbol2, int flags) {
        Icon icon = this.getBaseIcon($this$getIcon, symbol2);
        if (icon == null) {
            return null;
        }
        Icon result2 = icon;
        if ((flags & 1) > 0) {
            RowIcon rowIcon = new RowIcon(2);
            rowIcon.setIcon(result2, 0);
            rowIcon.setIcon(this.getVisibilityIcon($this$getIcon, symbol2), 1);
            result2 = (Icon)rowIcon;
        }
        return result2;
    }

    @Nullable
    public final Icon getBaseIcon(@NotNull KtAnalysisSession $this$getBaseIcon, @NotNull KtSymbol symbol2) {
        Icon icon;
        block18: {
            KtSymbol ktSymbol;
            block20: {
                boolean isAbstract;
                block19: {
                    block17: {
                        Intrinsics.checkNotNullParameter((Object)$this$getBaseIcon, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                        KtSymbolWithModality ktSymbolWithModality = symbol2 instanceof KtSymbolWithModality ? (KtSymbolWithModality)symbol2 : null;
                        isAbstract = (ktSymbolWithModality != null ? ktSymbolWithModality.getModality() : null) == Modality.ABSTRACT;
                        ktSymbol = symbol2;
                        if (!(ktSymbol instanceof KtPackageSymbol)) break block17;
                        icon = AllIcons.Nodes.Package;
                        break block18;
                    }
                    if (!(ktSymbol instanceof KtFunctionLikeSymbol)) break block19;
                    boolean isExtension = ((KtFunctionLikeSymbol)symbol2).isExtension();
                    boolean isMember = ((KtFunctionLikeSymbol)symbol2).getSymbolKind() == KtSymbolKind.CLASS_MEMBER;
                    icon = isExtension && isAbstract ? KotlinIcons.ABSTRACT_EXTENSION_FUNCTION : (isExtension && !isAbstract ? KotlinIcons.EXTENSION_FUNCTION : (isMember && isAbstract ? PlatformIcons.ABSTRACT_METHOD_ICON : (isMember && !isAbstract ? IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Method) : KotlinIcons.FUNCTION)));
                    break block18;
                }
                if (!(ktSymbol instanceof KtClassOrObjectSymbol)) break block20;
                switch (WhenMappings.$EnumSwitchMapping$0[((KtClassOrObjectSymbol)symbol2).getClassKind().ordinal()]) {
                    case 1: {
                        icon = isAbstract ? KotlinIcons.ABSTRACT_CLASS : KotlinIcons.CLASS;
                        break block18;
                    }
                    case 2: {
                        icon = KotlinIcons.ENUM;
                        break block18;
                    }
                    case 3: {
                        icon = KotlinIcons.ANNOTATION;
                        break block18;
                    }
                    case 4: {
                        icon = KotlinIcons.INTERFACE;
                        break block18;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        icon = KotlinIcons.OBJECT;
                        break block18;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (ktSymbol instanceof KtValueParameterSymbol) {
                icon = KotlinIcons.PARAMETER;
            } else if (ktSymbol instanceof KtLocalVariableSymbol) {
                icon = ((KtLocalVariableSymbol)symbol2).isVal() ? KotlinIcons.VAL : KotlinIcons.VAR;
            } else if (ktSymbol instanceof KtPropertySymbol) {
                icon = ((KtPropertySymbol)symbol2).isVal() ? KotlinIcons.FIELD_VAL : KotlinIcons.FIELD_VAR;
            } else if (ktSymbol instanceof KtTypeParameterSymbol) {
                icon = IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Class);
            } else if (ktSymbol instanceof KtTypeAliasSymbol) {
                icon = KotlinIcons.TYPE_ALIAS;
            } else {
                LOG.warn("No icon for symbol: " + symbol2);
                icon = null;
            }
        }
        return icon;
    }

    private final Icon getVisibilityIcon(KtAnalysisSession $this$getVisibilityIcon, KtSymbol symbol2) {
        Visibility visibility2;
        KtSymbolWithVisibility ktSymbolWithVisibility = symbol2 instanceof KtSymbolWithVisibility ? (KtSymbolWithVisibility)symbol2 : null;
        Visibility visibility3 = ktSymbolWithVisibility != null && (ktSymbolWithVisibility = ktSymbolWithVisibility.getVisibility()) != null ? ktSymbolWithVisibility.normalize() : (visibility2 = null);
        return Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Public.INSTANCE) ? PlatformIcons.PUBLIC_ICON : (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Protected.INSTANCE) ? IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Protected) : ((Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Private.INSTANCE) ? true : Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.PrivateToThis.INSTANCE)) ? IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Private) : (Intrinsics.areEqual((Object)visibility2, (Object)Visibilities.Internal.INSTANCE) ? IconManager.Companion.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Local) : null)));
    }

    static {
        Logger logger = Logger.getInstance(KtIconProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(KtIconProvider::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KtClassKind.values().length];
            try {
                nArray[KtClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.ENUM_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.ANNOTATION_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.INTERFACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.ANONYMOUS_OBJECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.OBJECT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KtClassKind.COMPANION_OBJECT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

