/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal.refactoringTesting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.internal.refactoringTesting.FileSystemChangesTracker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000'\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\t\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/FileSystemChangesTracker;", "Lcom/intellij/openapi/Disposable;", "()V", "createdFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCreatedFiles", "()Ljava/util/Set;", "trackerListener", "org/jetbrains/kotlin/idea/actions/internal/refactoringTesting/FileSystemChangesTracker$trackerListener$1", "Lorg/jetbrains/kotlin/idea/actions/internal/refactoringTesting/FileSystemChangesTracker$trackerListener$1;", "dispose", "", "reset", "kotlin.idea"})
public final class FileSystemChangesTracker
implements Disposable {
    @NotNull
    private final trackerListener.1 trackerListener = new VirtualFileListener(this){
        @NotNull
        private final Set<VirtualFile> createdFilesMutable;
        private volatile boolean disposed;
        {
            this.createdFilesMutable = new LinkedHashSet<E>();
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this, (Disposable)$receiver);
            Disposer.register((Disposable)$receiver, (Disposable)this);
        }

        @NotNull
        public final Set<VirtualFile> getCreatedFilesMutable() {
            return this.createdFilesMutable;
        }

        public synchronized void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.createdFilesMutable.clear();
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
            this.createdFilesMutable.add(virtualFile2);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
            this.createdFilesMutable.add(virtualFile2);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile2 = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"event.file");
            this.createdFilesMutable.add(virtualFile2);
        }
    };
    @NotNull
    private final Set<VirtualFile> createdFiles = this.trackerListener.getCreatedFilesMutable();

    public final void reset() {
        this.trackerListener.getCreatedFilesMutable().clear();
    }

    @NotNull
    public final Set<VirtualFile> getCreatedFiles() {
        return this.createdFiles;
    }

    public void dispose() {
        this.trackerListener.dispose();
    }
}

