/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis;

import com.intellij.ProjectTopics;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.EntityStorageSnapshot;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.analysis.LibraryDependencyCandidatesAndSdkInfos;
import org.jetbrains.kotlin.idea.base.analysis.LibraryDependencyCandidatesAndSdkInfosBuilder;
import org.jetbrains.kotlin.idea.base.analysis.libraries.LibraryDependencyCandidate;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.IdeBuiltInsLoadingState;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinStdlibCache;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinStdlibCacheKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoListener;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfoKt;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfoKt;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.ModuleEntityChangeListener;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.idea.caches.project.DefaultLibraryDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.IdeaModelInfosCache;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.caches.project.LibraryDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.LibraryDependenciesFilterKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleInfosFromIdeaModelKt;
import org.jetbrains.kotlin.idea.caches.project.SharedNativeLibraryToNativeInteropFallbackDependenciesFilter;
import org.jetbrains.kotlin.idea.caches.project.StrictEqualityForPlatformSpecificCandidatesFilter;
import org.jetbrains.kotlin.idea.caches.trackers.ModuleModificationTracker;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0004\u001e\u001f !B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\f\u0010\u0018\u001a\u00060\u0019R\u00020\u0000H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u001b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dH\u0002R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache;", "moduleDependenciesCache", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache;", "computeLibrariesAndSdksUsedWith", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache$LibraryDependencies;", "libraryInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "computeLibrariesAndSdksUsedWithNoFilter", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependencyCandidatesAndSdkInfos;", "dispose", "", "filterForBuiltins", "", "Lorg/jetbrains/kotlin/idea/base/analysis/libraries/LibraryDependencyCandidate;", "dependencyLibraries", "getLibraryDependencies", "library", "getLibraryUsageIndex", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryUsageIndex;", "stdlibJvmDependencies", "", "allDependencyCandidates", "", "Companion", "LibraryDependenciesInnerCache", "LibraryUsageIndex", "ModuleDependenciesCache", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,574:1\n1360#2:575\n1446#2,5:576\n1360#2:581\n1446#2,2:582\n766#2:584\n857#2,2:585\n1448#2,3:587\n857#2:590\n1747#2,3:591\n858#2:594\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl\n*L\n132#1:575\n132#1:576,5\n155#1:581\n155#1:582,2\n156#1:584\n156#1:585,2\n155#1:587,3\n195#1:590\n196#1:591,3\n195#1:594\n*E\n"})
public final class LibraryDependenciesCacheImpl
implements LibraryDependenciesCache,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LibraryDependenciesInnerCache cache;
    @NotNull
    private final ModuleDependenciesCache moduleDependenciesCache;

    public LibraryDependenciesCacheImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.cache = new LibraryDependenciesInnerCache();
        this.moduleDependenciesCache = new ModuleDependenciesCache();
        Disposer.register((Disposable)this, (Disposable)this.cache);
        Disposer.register((Disposable)this, (Disposable)this.moduleDependenciesCache);
    }

    @Override
    @NotNull
    public LibraryDependenciesCache.LibraryDependencies getLibraryDependencies(@NotNull LibraryInfo library2) {
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        return (LibraryDependenciesCache.LibraryDependencies)this.cache.get(library2);
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    private final LibraryDependenciesCache.LibraryDependencies computeLibrariesAndSdksUsedWith(LibraryInfo libraryInfo) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        LibraryDependencyCandidatesAndSdkInfos libraryDependencyCandidatesAndSdkInfos = this.computeLibrariesAndSdksUsedWithNoFilter(libraryInfo);
        List<LibraryInfo> additionalDependenciesForLibrarySources = null;
        LibraryDependenciesFilter libraryDependenciesFilter = null;
        if (BuildSystemTypeKt.isMavenized(this.project)) {
            libraryDependenciesFilter = StrictEqualityForPlatformSpecificCandidatesFilter.INSTANCE;
            additionalDependenciesForLibrarySources = this.stdlibJvmDependencies(libraryInfo, libraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
        } else {
            libraryDependenciesFilter = LibraryDependenciesFilterKt.union(DefaultLibraryDependenciesFilter.INSTANCE, SharedNativeLibraryToNativeInteropFallbackDependenciesFilter.INSTANCE);
            additionalDependenciesForLibrarySources = CollectionsKt.emptyList();
        }
        Iterable iterable = libraryDependenciesFilter.invoke(libraryInfo.getPlatform(), libraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
        boolean $i$f$flatMap = false;
        void var8_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LibraryDependencyCandidate it = (LibraryDependencyCandidate)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLibraries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List libraries = (List)destination$iv$iv;
        return new LibraryDependenciesCache.LibraryDependencies(libraryInfo, libraries, CollectionsKt.toList((Iterable)libraryDependencyCandidatesAndSdkInfos.getSdkInfos()), additionalDependenciesForLibrarySources);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LibraryInfo> stdlibJvmDependencies(LibraryInfo libraryInfo, Collection<? extends LibraryDependencyCandidate> allDependencyCandidates) {
        void $this$flatMapTo$iv$iv;
        if (!JvmPlatformKt.isJvm((TargetPlatform)libraryInfo.getPlatform())) {
            return CollectionsKt.emptyList();
        }
        KotlinStdlibCache stdlibCache = KotlinStdlibCache.Companion.getInstance(libraryInfo.getProject());
        if (!stdlibCache.isStdlib(libraryInfo)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = allDependencyCandidates;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            LibraryDependencyCandidate candidate2 = (LibraryDependencyCandidate)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = candidate2.getLibraries();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                LibraryInfo library2 = (LibraryInfo)element$iv$iv2;
                boolean bl2 = false;
                if (!stdlibCache.isStdlibDependency(library2)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final LibraryDependencyCandidatesAndSdkInfos computeLibrariesAndSdksUsedWithNoFilter(LibraryInfo libraryInfo) {
        LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfos = new LibraryDependencyCandidatesAndSdkInfosBuilder(null, null, 3, null);
        Sequence<Module> modulesLibraryIsUsedIn2 = this.getLibraryUsageIndex().getModulesLibraryIsUsedIn(libraryInfo);
        for (Module module2 : modulesLibraryIsUsedIn2) {
            ProgressManager.checkCanceled();
            libraryDependencyCandidatesAndSdkInfos.plusAssign(this.moduleDependenciesCache.get(module2));
        }
        Set<LibraryDependencyCandidate> filteredLibraries = this.filterForBuiltins(libraryInfo, (Set<LibraryDependencyCandidate>)libraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
        return new LibraryDependencyCandidatesAndSdkInfos((Collection<? extends LibraryDependencyCandidate>)filteredLibraries, libraryDependencyCandidatesAndSdkInfos.getSdkInfos());
    }

    /*
     * WARNING - void declaration
     */
    private final Set<LibraryDependencyCandidate> filterForBuiltins(LibraryInfo libraryInfo, Set<LibraryDependencyCandidate> dependencyLibraries) {
        Set set2;
        if (!IdeBuiltInsLoadingState.INSTANCE.isFromClassLoader() && KotlinStdlibCacheKt.isCoreKotlinLibrary(libraryInfo, this.project)) {
            void destination$iv;
            void $this$filterTo$iv;
            Iterable iterable = dependencyLibraries;
            Collection collection = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                boolean bl;
                block6: {
                    LibraryDependencyCandidate dep = (LibraryDependencyCandidate)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = dep.getLibraries();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            LibraryInfo it = (LibraryInfo)element$iv2;
                            boolean bl3 = false;
                            if (!KotlinStdlibCacheKt.isCoreKotlinLibrary(it, this.project)) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv.add(element$iv);
            }
            set2 = (Set)destination$iv;
        } else {
            set2 = dependencyLibraries;
        }
        return set2;
    }

    private final LibraryUsageIndex getLibraryUsageIndex() {
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this.project, () -> LibraryDependenciesCacheImpl.getLibraryUsageIndex$lambda$5(this));
        Intrinsics.checkNotNull((Object)object);
        return (LibraryUsageIndex)object;
    }

    private static final CachedValueProvider.Result getLibraryUsageIndex$lambda$5(LibraryDependenciesCacheImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{ModuleModificationTracker.Companion.getInstance(this$0.project), JavaLibraryModificationTracker.getInstance((Project)this$0.project)};
        return new CachedValueProvider.Result((Object)this$0.new LibraryUsageIndex(), objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,574:1\n29#2,3:575\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$Companion\n*L\n92#1:575,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LibraryDependenciesCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<LibraryDependenciesCache> serviceClass$iv = LibraryDependenciesCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (LibraryDependenciesCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u00052\u00020\u0006:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryDependenciesCache$LibraryDependencies;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl;)V", "calculate", "key", "checkKeyValidity", "", "checkValueValidity", "value", "jdkNameChanged", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "previousName", "", "jdkRemoved", "libraryInfosRemoved", "libraryInfos", "", "rootsChanged", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "subscribe", "ModelChangeListener", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,574:1\n1747#2,3:575\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache\n*L\n228#1:575,3\n*E\n"})
    private final class LibraryDependenciesInnerCache
    extends SynchronizedFineGrainedEntityCache<LibraryInfo, LibraryDependenciesCache.LibraryDependencies>
    implements LibraryInfoListener,
    ModuleRootListener,
    ProjectJdkTable.Listener {
        public LibraryDependenciesInnerCache() {
            super(LibraryDependenciesCacheImpl.this.project, false, true);
        }

        @Override
        protected void subscribe() {
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            connection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
            Topic topic = ProjectTopics.PROJECT_ROOTS;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"PROJECT_ROOTS");
            connection.subscribe(topic, (Object)this);
            connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new ModelChangeListener());
            Topic topic2 = ProjectJdkTable.JDK_TABLE_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"JDK_TABLE_TOPIC");
            connection.subscribe(topic2, (Object)this);
        }

        @Override
        public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
            Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
            FineGrainedEntityCache.invalidateEntries$default(this, (Function2)new Function2<LibraryInfo, LibraryDependenciesCache.LibraryDependencies, Boolean>(libraryInfos){
                final /* synthetic */ Collection<LibraryInfo> $libraryInfos;
                {
                    this.$libraryInfos = $libraryInfos;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull LibraryInfo k, @NotNull LibraryDependenciesCache.LibraryDependencies v) {
                    Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return this.$libraryInfos.contains(k) || LibraryDependenciesInnerCache.access$libraryInfosRemoved$haveOutdatedLibraries(v, this.$libraryInfos);
                }
            }, null, 2, null);
        }

        public void jdkRemoved(@NotNull Sdk jdk2) {
            Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
            FineGrainedEntityCache.invalidateEntries$default(this, (Function2)new Function2<LibraryInfo, LibraryDependenciesCache.LibraryDependencies, Boolean>(jdk2){
                final /* synthetic */ Sdk $jdk;
                {
                    this.$jdk = $jdk;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull LibraryInfo libraryInfo, @NotNull LibraryDependenciesCache.LibraryDependencies v) {
                    boolean bl;
                    block3: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        Iterable iterable = v.getSdk();
                        Sdk sdk2 = this.$jdk;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SdkInfo it = (SdkInfo)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getSdk(), (Object)sdk2)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, null, 2, null);
        }

        public void jdkNameChanged(@NotNull Sdk jdk2, @NotNull String previousName) {
            Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
            Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
            this.jdkRemoved(jdk2);
        }

        @Override
        @NotNull
        public LibraryDependenciesCache.LibraryDependencies calculate(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return LibraryDependenciesCacheImpl.this.computeLibrariesAndSdksUsedWith(key);
        }

        @Override
        protected void checkKeyValidity(@NotNull LibraryInfo key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            key.checkValidity();
        }

        @Override
        protected void checkValueValidity(@NotNull LibraryDependenciesCache.LibraryDependencies value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            value2.checkValidity();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCausedByWorkspaceModelChangesOnly()) {
                return;
            }
            Set sdks2 = SdkInfoKt.allSdks$default(this.getProject(), null, 1, null);
            this.invalidateEntries((Function2)new Function2<LibraryInfo, LibraryDependenciesCache.LibraryDependencies, Boolean>((Set<? extends Sdk>)sdks2){
                final /* synthetic */ Set<Sdk> $sdks;
                {
                    this.$sdks = $sdks;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull LibraryInfo libraryInfo, @NotNull LibraryDependenciesCache.LibraryDependencies value2) {
                    boolean bl;
                    block3: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        Iterable iterable = value2.getSdk();
                        Set<Sdk> set2 = this.$sdks;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SdkInfo it = (SdkInfo)element$iv;
                                boolean bl2 = false;
                                if (!(!set2.contains(it.getSdk()))) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean libraryInfosRemoved$haveOutdatedLibraries(LibraryDependenciesCache.LibraryDependencies $this$libraryInfosRemoved_u24haveOutdatedLibraries, Collection<? extends LibraryInfo> $libraryInfos) {
            LibraryInfo it;
            boolean bl;
            Iterable $this$any$iv = $this$libraryInfosRemoved_u24haveOutdatedLibraries.getLibraries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (LibraryInfo)element$iv;
                    boolean bl2 = false;
                    if (!$libraryInfos.contains(it)) continue;
                    return true;
                }
                bl = false;
            }
            if (bl) return true;
            $this$any$iv = $this$libraryInfosRemoved_u24haveOutdatedLibraries.getSourcesOnlyDependencies();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                Object element$iv;
                if (!iterator2.hasNext()) return false;
                element$iv = iterator2.next();
                it = (LibraryInfo)element$iv;
                boolean bl3 = false;
            } while (!$libraryInfos.contains(it));
            return true;
        }

        public static final /* synthetic */ boolean access$libraryInfosRemoved$haveOutdatedLibraries(LibraryDependenciesCache.LibraryDependencies $receiver, Collection $libraryInfos) {
            return LibraryDependenciesInnerCache.libraryInfosRemoved$haveOutdatedLibraries($receiver, $libraryInfos);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache$ModelChangeListener;", "Lorg/jetbrains/kotlin/idea/base/util/caching/ModuleEntityChangeListener;", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryDependenciesInnerCache;)V", "entitiesChanged", "", "outdated", "", "Lcom/intellij/openapi/module/Module;", "kotlin.base.analysis"})
        public final class ModelChangeListener
        extends ModuleEntityChangeListener {
            public ModelChangeListener() {
                super(LibraryDependenciesInnerCache.this.getProject(), false, 2, null);
            }

            @Override
            protected void entitiesChanged(@NotNull List<? extends Module> outdated) {
                Intrinsics.checkNotNullParameter(outdated, (String)"outdated");
                LibraryDependenciesInnerCache.this.invalidate(true);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$LibraryUsageIndex;", "", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl;)V", "modulesLibraryIsUsedIn", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/module/Module;", "getModulesLibraryIsUsedIn", "Lkotlin/sequences/Sequence;", "libraryInfo", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "kotlin.base.analysis"})
    private final class LibraryUsageIndex {
        @NotNull
        private final MultiMap<Library, Module> modulesLibraryIsUsedIn;

        public LibraryUsageIndex() {
            this.modulesLibraryIsUsedIn = (MultiMap)ActionsKt.runReadAction((Function0)((Function0)new Function0<MultiMap<Library, Module>>(LibraryDependenciesCacheImpl.this){
                final /* synthetic */ LibraryDependenciesCacheImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final MultiMap<Library, Module> invoke() {
                    MultiMap multiMap = MultiMap.createSet();
                    Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createSet()");
                    MultiMap map2 = multiMap;
                    LibraryInfoCache libraryCache = LibraryInfoCache.Companion.getInstance(LibraryDependenciesCacheImpl.access$getProject$p(this.this$0));
                    for (Module module2 : ModuleManager.Companion.getInstance(LibraryDependenciesCacheImpl.access$getProject$p(this.this$0)).getModules()) {
                        OrderEntry[] orderEntryArray;
                        ProgressManager.checkCanceled();
                        Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module2).getOrderEntries(), (String)"getInstance(module).orderEntries");
                        for (OrderEntry entry : orderEntryArray) {
                            Library library2;
                            if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() == null) continue;
                            Library keyLibrary = libraryCache.deduplicatedLibrary(library2);
                            map2.putValue((Object)keyLibrary, (Object)module2);
                        }
                    }
                    return map2;
                }
            }));
        }

        @NotNull
        public final Sequence<Module> getModulesLibraryIsUsedIn(@NotNull LibraryInfo libraryInfo) {
            Intrinsics.checkNotNullParameter((Object)libraryInfo, (String)"libraryInfo");
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Module>, Continuation<? super Unit>, Object>(LibraryDependenciesCacheImpl.this, this, libraryInfo, null){
                Object L$1;
                Object L$2;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ LibraryDependenciesCacheImpl this$0;
                final /* synthetic */ LibraryUsageIndex this$1;
                final /* synthetic */ LibraryInfo $libraryInfo;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$libraryInfo = $libraryInfo;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2;
                    Iterator<E> iterator2;
                    IdeaModelInfosCache ideaModelInfosCache;
                    SequenceScope $this$sequence;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            $this$sequence = (SequenceScope)this.L$0;
                            ideaModelInfosCache = ModuleInfosFromIdeaModelKt.getIdeaModelInfosCache(LibraryDependenciesCacheImpl.access$getProject$p(this.this$0));
                            iterator2 = LibraryUsageIndex.access$getModulesLibraryIsUsedIn$p(this.this$1).get((Object)this.$libraryInfo.getLibrary()).iterator();
                            break;
                        }
                        case 1: {
                            void $result;
                            iterator2 = (Iterator<E>)this.L$2;
                            ideaModelInfosCache = (IdeaModelInfosCache)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator2.hasNext()) {
                        boolean bl;
                        Module module2;
                        block8: {
                            void $this$any$iv;
                            module2 = (Module)iterator2.next();
                            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module");
                            Collection<ModuleSourceInfo> mappedModuleInfos = ideaModelInfosCache.getModuleInfosForModule(module2);
                            Iterable iterable = mappedModuleInfos;
                            LibraryInfo libraryInfo = this.$libraryInfo;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    ModuleSourceInfo it = (ModuleSourceInfo)element$iv;
                                    boolean bl2 = false;
                                    if (!IdeaModuleInfoUtils.canDependOn(it.getPlatform(), libraryInfo, KotlinFacetUtils.isHMPPEnabled(module2))) continue;
                                    bl = true;
                                    break block8;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        this.L$0 = $this$sequence;
                        this.L$1 = ideaModelInfosCache;
                        this.L$2 = iterator2;
                        this.label = 1;
                        object2 = $this$sequence.yield((Object)module2, (Continuation)this);
                        if (object2 != object3) continue;
                        return object3;
                    }
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Module> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public static final /* synthetic */ MultiMap access$getModulesLibraryIsUsedIn$p(LibraryUsageIndex $this) {
            return $this.modulesLibraryIsUsedIn;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J&\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0002JV\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u001fj\b\u0012\u0004\u0012\u00020\u0002` 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\"0\u001dH\u0002J`\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00032\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u001fj\b\u0012\u0004\u0012\u00020\u0002` 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\"0\u001dH\u0002J\u0011\u0010%\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0097\u0002JV\u0010&\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u001fj\b\u0012\u0004\u0012\u00020\u0002` 2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\"0\u001dH\u0002J\u0018\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0016J\u0016\u0010-\u001a\u00020\n2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0010\u00101\u001a\u00020\n2\u0006\u0010\u000b\u001a\u000202H\u0016J\b\u00103\u001a\u00020\nH\u0014\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependencyCandidatesAndSdkInfos;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "Lcom/intellij/openapi/projectRoots/ProjectJdkTable$Listener;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/LibraryInfoListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "(Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl;)V", "beforeChanged", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "calculate", "key", "checkKeyValidity", "checkValueValidity", "value", "collectOutdatedModules", "moduleEntity", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "outdatedModules", "", "computeLibrariesAndSdksUsedIn", "Lorg/jetbrains/kotlin/idea/base/analysis/LibraryDependencyCandidatesAndSdkInfosBuilder;", "module", "tmpResults", "", "trace", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "loops", "", "dumpLoopsIfPossible", "newValue", "get", "internalGet", "jdkNameChanged", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "previousName", "", "jdkRemoved", "libraryInfosRemoved", "libraryInfos", "", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LibraryInfo;", "rootsChanged", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "subscribe", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nLibraryDependenciesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,574:1\n1#2:575\n1855#3,2:576\n1313#4,2:578\n*S KotlinDebug\n*F\n+ 1 LibraryDependenciesCache.kt\norg/jetbrains/kotlin/idea/base/analysis/LibraryDependenciesCacheImpl$ModuleDependenciesCache\n*L\n487#1:576,2\n529#1:578,2\n*E\n"})
    private final class ModuleDependenciesCache
    extends SynchronizedFineGrainedEntityCache<Module, LibraryDependencyCandidatesAndSdkInfos>
    implements WorkspaceModelChangeListener,
    ProjectJdkTable.Listener,
    LibraryInfoListener,
    ModuleRootListener {
        public ModuleDependenciesCache() {
            super(LibraryDependenciesCacheImpl.this.project, false, false, 4, null);
        }

        @Override
        protected void subscribe() {
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)this);
            connection.subscribe(LibraryInfoListener.Companion.getTOPIC(), (Object)this);
            Topic topic = ProjectJdkTable.JDK_TABLE_TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"JDK_TABLE_TOPIC");
            connection.subscribe(topic, (Object)this);
            Topic topic2 = ProjectTopics.PROJECT_ROOTS;
            Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"PROJECT_ROOTS");
            connection.subscribe(topic2, (Object)this);
        }

        @Override
        @RequiresReadLock
        @NotNull
        public LibraryDependencyCandidatesAndSdkInfos get(@NotNull Module key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ActionsKt.assertReadAccessAllowed();
            return this.internalGet(key, new HashMap(), new LinkedHashSet<Module>(), new HashMap());
        }

        private final LibraryDependencyCandidatesAndSdkInfos internalGet(Module key, Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> tmpResults, LinkedHashSet<Module> trace, Map<Module, Set<Module>> loops) {
            LibraryDependencyCandidatesAndSdkInfos existedValue2;
            LibraryDependencyCandidatesAndSdkInfos libraryDependencyCandidatesAndSdkInfos;
            this.checkKeyAndDisposeIllegalEntry(key);
            LibraryDependencyCandidatesAndSdkInfos libraryDependencyCandidatesAndSdkInfos2 = (LibraryDependencyCandidatesAndSdkInfos)this.useCache((Function1)new Function1<Map<Module, LibraryDependencyCandidatesAndSdkInfos>, LibraryDependencyCandidatesAndSdkInfos>(this, key){
                final /* synthetic */ ModuleDependenciesCache this$0;
                final /* synthetic */ Module $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(1);
                }

                @Nullable
                public final LibraryDependencyCandidatesAndSdkInfos invoke(@NotNull Map<Module, LibraryDependencyCandidatesAndSdkInfos> cache2) {
                    Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                    ModuleDependenciesCache.access$checkEntitiesIfRequired(this.this$0, cache2);
                    return cache2.get(this.$key);
                }
            });
            if (libraryDependencyCandidatesAndSdkInfos2 != null) {
                LibraryDependencyCandidatesAndSdkInfos it = libraryDependencyCandidatesAndSdkInfos2;
                boolean bl = false;
                return it;
            }
            ProgressManager.checkCanceled();
            LibraryDependencyCandidatesAndSdkInfos newValue = this.computeLibrariesAndSdksUsedIn(key, tmpResults, trace, loops).build();
            if (FineGrainedEntityCache.Companion.isValidityChecksEnabled()) {
                this.checkValueValidity(newValue);
            }
            if ((libraryDependencyCandidatesAndSdkInfos = (existedValue2 = !((Collection)trace).isEmpty() ? this.dumpLoopsIfPossible(key, newValue, tmpResults, trace, loops) : (LibraryDependencyCandidatesAndSdkInfos)this.useCache((Function1)new Function1<Map<Module, LibraryDependencyCandidatesAndSdkInfos>, LibraryDependencyCandidatesAndSdkInfos>(key, newValue, tmpResults){
                final /* synthetic */ Module $key;
                final /* synthetic */ LibraryDependencyCandidatesAndSdkInfos $newValue;
                final /* synthetic */ Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> $tmpResults;
                {
                    this.$key = $key;
                    this.$newValue = $newValue;
                    this.$tmpResults = $tmpResults;
                    super(1);
                }

                @Nullable
                public final LibraryDependencyCandidatesAndSdkInfos invoke(@NotNull Map<Module, LibraryDependencyCandidatesAndSdkInfos> cache2) {
                    Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                    LibraryDependencyCandidatesAndSdkInfos existedValue2 = cache2.putIfAbsent(this.$key, this.$newValue);
                    for (Map.Entry<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> entry : this.$tmpResults.entrySet()) {
                        cache2.putIfAbsent(entry.getKey(), entry.getValue().build());
                    }
                    return existedValue2;
                }
            }))) == null) {
                libraryDependencyCandidatesAndSdkInfos = newValue;
            }
            return libraryDependencyCandidatesAndSdkInfos;
        }

        private final LibraryDependencyCandidatesAndSdkInfos dumpLoopsIfPossible(Module key, LibraryDependencyCandidatesAndSdkInfos newValue, Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> tmpResults, LinkedHashSet<Module> trace, Map<Module, Set<Module>> loops) {
            Set<Module> set2 = loops.get(key);
            if (set2 == null) {
                return null;
            }
            Set<Module> currentLoop = set2;
            if (loops.containsKey(CollectionsKt.last((Iterable)trace))) {
                return null;
            }
            return (LibraryDependencyCandidatesAndSdkInfos)this.useCache((Function1)new Function1<Map<Module, LibraryDependencyCandidatesAndSdkInfos>, LibraryDependencyCandidatesAndSdkInfos>(key, newValue, tmpResults, currentLoop, loops){
                final /* synthetic */ Module $key;
                final /* synthetic */ LibraryDependencyCandidatesAndSdkInfos $newValue;
                final /* synthetic */ Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> $tmpResults;
                final /* synthetic */ Set<Module> $currentLoop;
                final /* synthetic */ Map<Module, Set<Module>> $loops;
                {
                    this.$key = $key;
                    this.$newValue = $newValue;
                    this.$tmpResults = $tmpResults;
                    this.$currentLoop = $currentLoop;
                    this.$loops = $loops;
                    super(1);
                }

                @Nullable
                public final LibraryDependencyCandidatesAndSdkInfos invoke(@NotNull Map<Module, LibraryDependencyCandidatesAndSdkInfos> cache2) {
                    Intrinsics.checkNotNullParameter(cache2, (String)"cache");
                    LibraryDependencyCandidatesAndSdkInfos existedValue2 = cache2.putIfAbsent(this.$key, this.$newValue);
                    this.$tmpResults.remove(this.$key);
                    for (Module loopModule : this.$currentLoop) {
                        if (this.$tmpResults.remove(loopModule) != null) {
                            LibraryDependencyCandidatesAndSdkInfosBuilder it;
                            boolean bl = false;
                            cache2.putIfAbsent(loopModule, it.build());
                        }
                        this.$loops.remove(loopModule);
                    }
                    return existedValue2;
                }
            });
        }

        private final LibraryDependencyCandidatesAndSdkInfosBuilder computeLibrariesAndSdksUsedIn(Module module2, Map<Module, LibraryDependencyCandidatesAndSdkInfosBuilder> tmpResults, LinkedHashSet<Module> trace, Map<Module, Set<Module>> loops) {
            ProgressManager.checkCanceled();
            if (!trace.add(module2)) {
                boolean $i$a$-check-LibraryDependenciesCacheImpl$ModuleDependenciesCache$computeLibrariesAndSdksUsedIn$22 = false;
                String $i$a$-check-LibraryDependenciesCacheImpl$ModuleDependenciesCache$computeLibrariesAndSdksUsedIn$22 = "recursion detected";
                throw new IllegalStateException($i$a$-check-LibraryDependenciesCacheImpl$ModuleDependenciesCache$computeLibrariesAndSdksUsedIn$22.toString());
            }
            LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfos = new LibraryDependencyCandidatesAndSdkInfosBuilder(null, null, 3, null);
            tmpResults.put(module2, libraryDependencyCandidatesAndSdkInfos);
            HashSet<Module> modulesToVisit = new HashSet<Module>();
            LibraryInfoCache infoCache = LibraryInfoCache.Companion.getInstance(this.getProject());
            ModuleRootManager.getInstance((Module)module2).orderEntries().process((RootPolicy)new RootPolicy<Unit>(modulesToVisit, infoCache, libraryDependencyCandidatesAndSdkInfos, this){
                final /* synthetic */ HashSet<Module> $modulesToVisit;
                final /* synthetic */ LibraryInfoCache $infoCache;
                final /* synthetic */ LibraryDependencyCandidatesAndSdkInfosBuilder $libraryDependencyCandidatesAndSdkInfos;
                final /* synthetic */ ModuleDependenciesCache this$0;
                {
                    this.$modulesToVisit = $modulesToVisit;
                    this.$infoCache = $infoCache;
                    this.$libraryDependencyCandidatesAndSdkInfos = $libraryDependencyCandidatesAndSdkInfos;
                    this.this$0 = $receiver;
                }

                public void visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, @NotNull Unit value2) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)moduleOrderEntry, (String)"moduleOrderEntry");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        Module module2 = moduleOrderEntry.getModule();
                        if (module2 == null) break block0;
                        Module module3 = module2;
                        HashSet<Module> hashSet = this.$modulesToVisit;
                        Module p0 = module3;
                        boolean bl = false;
                        hashSet.add(p0);
                    }
                }

                public void visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, @NotNull Unit value2) {
                    Object object;
                    block6: {
                        block5: {
                            LibraryEx libraryEx;
                            Intrinsics.checkNotNullParameter((Object)libraryOrderEntry, (String)"libraryOrderEntry");
                            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                            ProgressManager.checkCanceled();
                            Library $this$safeAs$iv = libraryOrderEntry.getLibrary();
                            boolean $i$f$safeAs = false;
                            Library library2 = $this$safeAs$iv;
                            if (!(library2 instanceof LibraryEx)) {
                                library2 = null;
                            }
                            if ((object = (LibraryEx)library2) == null) break block5;
                            LibraryEx it = libraryEx = object;
                            boolean bl = false;
                            object = !it.isDisposed() ? libraryEx : null;
                            if (object != null) break block6;
                        }
                        return;
                    }
                    LibraryEx libraryEx = object;
                    LibraryDependencyCandidate libraryDependencyCandidate = LibraryDependencyCandidate.Companion.fromLibraryOrNull(this.$infoCache.get((Library)libraryEx));
                    if (libraryDependencyCandidate == null) {
                        return;
                    }
                    LibraryDependencyCandidate candidate2 = libraryDependencyCandidate;
                    this.$libraryDependencyCandidatesAndSdkInfos.plusAssign(candidate2);
                }

                public void visitJdkOrderEntry(@NotNull JdkOrderEntry jdkOrderEntry, @NotNull Unit value2) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)jdkOrderEntry, (String)"jdkOrderEntry");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        ProgressManager.checkCanceled();
                        Sdk sdk2 = jdkOrderEntry.getJdk();
                        if (sdk2 == null) break block0;
                        Sdk sdk3 = sdk2;
                        LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfosBuilder = this.$libraryDependencyCandidatesAndSdkInfos;
                        ModuleDependenciesCache moduleDependenciesCache = this.this$0;
                        Sdk jdk2 = sdk3;
                        boolean bl = false;
                        libraryDependencyCandidatesAndSdkInfosBuilder.plusAssign(new SdkInfo(ModuleDependenciesCache.access$getProject(moduleDependenciesCache), jdk2));
                    }
                }
            }, (Object)Unit.INSTANCE);
            block0: for (Module moduleToVisit : modulesToVisit) {
                LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfosBuilder;
                ProgressManager.checkCanceled();
                if (Intrinsics.areEqual((Object)moduleToVisit, (Object)module2) || !trace.contains(moduleToVisit)) continue;
                List reversedTrace = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)trace));
                ModuleDependenciesCache $this$computeLibrariesAndSdksUsedIn_u24lambda_u243 = this;
                boolean bl = false;
                LibraryDependencyCandidatesAndSdkInfosBuilder shared = null;
                HashSet loop = new HashSet();
                HashSet<LibraryDependencyCandidatesAndSdkInfosBuilder> duplicates2 = new HashSet<LibraryDependencyCandidatesAndSdkInfosBuilder>();
                for (Module traceModule : reversedTrace) {
                    ((Collection)loop).add(traceModule);
                    if (loops.get(traceModule) != null) {
                        Set<Module> it;
                        boolean bl2 = false;
                        CollectionsKt.addAll((Collection)loop, (Iterable)it);
                    }
                    loops.put(traceModule, loop);
                    LibraryDependencyCandidatesAndSdkInfosBuilder traceModuleLibraryDependencyCandidatesAndSdkInfos = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)traceModule);
                    if (shared == null && !duplicates2.add(traceModuleLibraryDependencyCandidatesAndSdkInfos)) {
                        shared = traceModuleLibraryDependencyCandidatesAndSdkInfos;
                    }
                    if (traceModule != moduleToVisit) continue;
                }
                if ((libraryDependencyCandidatesAndSdkInfosBuilder = shared) == null) {
                    libraryDependencyCandidatesAndSdkInfosBuilder = (LibraryDependencyCandidatesAndSdkInfosBuilder)CollectionsKt.first((Iterable)duplicates2);
                }
                LibraryDependencyCandidatesAndSdkInfosBuilder sharedLibraryDependencyCandidatesAndSdkInfos = libraryDependencyCandidatesAndSdkInfosBuilder;
                sharedLibraryDependencyCandidatesAndSdkInfos.plusAssign(libraryDependencyCandidatesAndSdkInfos);
                for (Module traceModule : reversedTrace) {
                    LibraryDependencyCandidatesAndSdkInfosBuilder traceModuleLibraryDependencyCandidatesAndSdkInfos = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)traceModule);
                    if (traceModuleLibraryDependencyCandidatesAndSdkInfos == sharedLibraryDependencyCandidatesAndSdkInfos) {
                        if (traceModule != moduleToVisit) continue;
                        continue block0;
                    }
                    sharedLibraryDependencyCandidatesAndSdkInfos.plusAssign(traceModuleLibraryDependencyCandidatesAndSdkInfos);
                    tmpResults.put(traceModule, sharedLibraryDependencyCandidatesAndSdkInfos);
                    if (loops.get(traceModule) != null) {
                        Set<Module> loop2;
                        boolean bl3 = false;
                        for (Module loopModule : loop2) {
                            LibraryDependencyCandidatesAndSdkInfosBuilder value2;
                            if (Intrinsics.areEqual((Object)loopModule, (Object)traceModule) || (value2 = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)loopModule)) == sharedLibraryDependencyCandidatesAndSdkInfos) continue;
                            sharedLibraryDependencyCandidatesAndSdkInfos.plusAssign(value2);
                            tmpResults.put(loopModule, sharedLibraryDependencyCandidatesAndSdkInfos);
                        }
                    }
                    if (traceModule != moduleToVisit) continue;
                    continue block0;
                }
            }
            for (Module moduleToVisit : modulesToVisit) {
                LibraryDependencyCandidatesAndSdkInfos libraryDependencyCandidatesAndSdkInfos2;
                ProgressManager.checkCanceled();
                if (Intrinsics.areEqual((Object)moduleToVisit, (Object)module2) || trace.contains(moduleToVisit)) continue;
                LibraryDependencyCandidatesAndSdkInfosBuilder libraryDependencyCandidatesAndSdkInfosBuilder = tmpResults.get(moduleToVisit);
                if (libraryDependencyCandidatesAndSdkInfosBuilder != null) {
                    libraryDependencyCandidatesAndSdkInfos2 = libraryDependencyCandidatesAndSdkInfosBuilder;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)moduleToVisit, (String)"moduleToVisit");
                    libraryDependencyCandidatesAndSdkInfos2 = this.internalGet(moduleToVisit, tmpResults, trace, loops);
                }
                LibraryDependencyCandidatesAndSdkInfos moduleToVisitLibraryDependencyCandidatesAndSdkInfos = libraryDependencyCandidatesAndSdkInfos2;
                LibraryDependencyCandidatesAndSdkInfosBuilder moduleLibraryDependencyCandidatesAndSdkInfos = (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)module2);
                CollectionsKt.addAll((Collection)moduleLibraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates(), (Iterable)moduleToVisitLibraryDependencyCandidatesAndSdkInfos.getLibraryDependencyCandidates());
            }
            trace.remove(module2);
            return (LibraryDependencyCandidatesAndSdkInfosBuilder)MapsKt.getValue(tmpResults, (Object)module2);
        }

        @Override
        @NotNull
        public LibraryDependencyCandidatesAndSdkInfos calculate(@NotNull Module key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            throw new UnsupportedOperationException("calculate(Module) should not be invoked due to custom impl of get()");
        }

        @Override
        protected void checkKeyValidity(@NotNull Module key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            ModuleSourceInfoKt.checkValidity(key);
        }

        @Override
        protected void checkValueValidity(@NotNull LibraryDependencyCandidatesAndSdkInfos value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Iterable $this$forEach$iv = value2.getLibraryDependencyCandidates();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LibraryDependencyCandidate it = (LibraryDependencyCandidate)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = it.getLibraries();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    LibraryInfo libraryInfo = (LibraryInfo)element$iv2;
                    boolean bl2 = false;
                    libraryInfo.checkValidity();
                }
            }
        }

        public void jdkRemoved(@NotNull Sdk jdk2) {
            Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
            FineGrainedEntityCache.invalidateEntries$default(this, (Function2)new Function2<Module, LibraryDependencyCandidatesAndSdkInfos, Boolean>(jdk2){
                final /* synthetic */ Sdk $jdk;
                {
                    this.$jdk = $jdk;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull Module module2, @NotNull LibraryDependencyCandidatesAndSdkInfos candidates2) {
                    boolean bl;
                    block3: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter((Object)module2, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)candidates2, (String)"candidates");
                        Iterable iterable = candidates2.getSdkInfos();
                        Sdk sdk2 = this.$jdk;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SdkInfo it = (SdkInfo)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getSdk(), (Object)sdk2)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, null, 2, null);
        }

        public void jdkNameChanged(@NotNull Sdk jdk2, @NotNull String previousName) {
            Intrinsics.checkNotNullParameter((Object)jdk2, (String)"jdk");
            Intrinsics.checkNotNullParameter((Object)previousName, (String)"previousName");
            this.jdkRemoved(jdk2);
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.isCausedByWorkspaceModelChangesOnly()) {
                return;
            }
            Set sdks2 = SdkInfoKt.allSdks$default(this.getProject(), null, 1, null);
            this.invalidateEntries((Function2)new Function2<Module, LibraryDependencyCandidatesAndSdkInfos, Boolean>((Set<? extends Sdk>)sdks2){
                final /* synthetic */ Set<Sdk> $sdks;
                {
                    this.$sdks = $sdks;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull Module module2, @NotNull LibraryDependencyCandidatesAndSdkInfos candidates2) {
                    boolean bl;
                    block3: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter((Object)module2, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)candidates2, (String)"candidates");
                        Iterable iterable = candidates2.getSdkInfos();
                        Set<Sdk> set2 = this.$sdks;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SdkInfo it = (SdkInfo)element$iv;
                                boolean bl2 = false;
                                if (!(!set2.contains(it.getSdk()))) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, null);
        }

        public void beforeChanged(@NotNull VersionedStorageChange event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EntityStorageSnapshot storageBefore = event.getStorageBefore();
            Collection collection = event.getChanges(ModuleEntity.class);
            if (collection.isEmpty()) {
                boolean bl = false;
                return;
            }
            List changes = (List)collection;
            Set outdatedModules = new LinkedHashSet();
            for (EntityChange change : changes) {
                ModuleEntity moduleEntity;
                if ((ModuleEntity)change.getOldEntity() == null) continue;
                this.collectOutdatedModules(moduleEntity, (EntityStorage)storageBefore, outdatedModules);
            }
            FineGrainedEntityCache.invalidateKeys$default(this, outdatedModules, null, 2, null);
        }

        private final void collectOutdatedModules(ModuleEntity moduleEntity, EntityStorage storage, Set<Module> outdatedModules) {
            ModuleBridge moduleBridge = ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)storage);
            if (moduleBridge == null) {
                return;
            }
            ModuleBridge module2 = moduleBridge;
            if (!outdatedModules.add((Module)module2)) {
                return;
            }
            Sequence $this$forEach$iv = storage.referrers((SymbolicEntityId)moduleEntity.getSymbolicId(), ModuleEntity.class);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleEntity it = (ModuleEntity)element$iv;
                boolean bl = false;
                this.collectOutdatedModules(it, storage, outdatedModules);
            }
        }

        @Override
        public void libraryInfosRemoved(@NotNull Collection<? extends LibraryInfo> libraryInfos) {
            Intrinsics.checkNotNullParameter(libraryInfos, (String)"libraryInfos");
            HashSet infos = CollectionsKt.toHashSet((Iterable)libraryInfos);
            this.invalidateEntries((Function2)new Function2<Module, LibraryDependencyCandidatesAndSdkInfos, Boolean>((HashSet<LibraryInfo>)infos){
                final /* synthetic */ HashSet<LibraryInfo> $infos;
                {
                    this.$infos = $infos;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull Module module2, @NotNull LibraryDependencyCandidatesAndSdkInfos v) {
                    boolean bl;
                    block7: {
                        void $this$any$iv;
                        Intrinsics.checkNotNullParameter((Object)module2, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                        Iterable iterable = v.getLibraryDependencyCandidates();
                        HashSet<LibraryInfo> hashSet = this.$infos;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                boolean bl2;
                                block6: {
                                    LibraryDependencyCandidate candidate2 = (LibraryDependencyCandidate)element$iv;
                                    boolean bl3 = false;
                                    Iterable $this$any$iv2 = candidate2.getLibraries();
                                    boolean $i$f$any2 = false;
                                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (T element$iv2 : $this$any$iv2) {
                                            LibraryInfo it = (LibraryInfo)element$iv2;
                                            boolean bl4 = false;
                                            if (!hashSet.contains(it)) continue;
                                            bl2 = true;
                                            break block6;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (!bl2) continue;
                                bl = true;
                                break block7;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, null);
        }

        public static final /* synthetic */ void access$checkEntitiesIfRequired(ModuleDependenciesCache $this, Map cache2) {
            $this.checkEntitiesIfRequired(cache2);
        }

        public static final /* synthetic */ Project access$getProject(ModuleDependenciesCache $this) {
            return $this.getProject();
        }
    }
}

