/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptAcceptedLocation;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptIdeConfigurationKt;
import kotlin.script.experimental.util.PropertiesCollection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBinaryExtensionKt;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindMatcher;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R \u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysis/RootKindMatcherImpl;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/RootKindMatcher;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getFileIndex", "()Lcom/intellij/openapi/roots/ProjectFileIndex;", "fileIndex$delegate", "Lkotlin/Lazy;", "matches", "", "filter", "Lorg/jetbrains/kotlin/idea/base/projectStructure/RootKindFilter;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "containsAllowedLocations", "", "Lkotlin/script/experimental/api/ScriptAcceptedLocation;", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nRootKindMatcherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootKindMatcherImpl.kt\norg/jetbrains/kotlin/idea/base/analysis/RootKindMatcherImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1747#2,3:155\n*S KotlinDebug\n*F\n+ 1 RootKindMatcherImpl.kt\norg/jetbrains/kotlin/idea/base/analysis/RootKindMatcherImpl\n*L\n152#1:155,3\n*E\n"})
public final class RootKindMatcherImpl
implements RootKindMatcher {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy fileIndex$delegate;

    public RootKindMatcherImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.fileIndex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProjectFileIndex>(this){
            final /* synthetic */ RootKindMatcherImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProjectFileIndex invoke() {
                return ProjectRootManager.getInstance((Project)RootKindMatcherImpl.access$getProject$p(this.this$0)).getFileIndex();
            }
        }));
    }

    private final ProjectFileIndex getFileIndex() {
        Lazy lazy = this.fileIndex$delegate;
        return (ProjectFileIndex)lazy.getValue();
    }

    @Override
    public boolean matches(@NotNull RootKindFilter filter2, @NotNull VirtualFile virtualFile2) {
        RootKindFilter correctedFilter;
        List<ScriptAcceptedLocation> scriptScope;
        ScriptCompilationConfiguration scriptConfiguration;
        boolean kotlinExcludeLibrarySources;
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        ProgressManager.checkCanceled();
        boolean bl = kotlinExcludeLibrarySources = !filter2.getIncludeLibrarySourceFiles() && !filter2.getIncludeScriptsOutsideSourceRoots() && FileUtils.isKotlinFileType(virtualFile2);
        if (kotlinExcludeLibrarySources && !filter2.getIncludeProjectSourceFiles()) {
            return false;
        }
        if (!(virtualFile2 instanceof VirtualFileWindow) && this.getFileIndex().isInSourceContent(virtualFile2)) {
            return filter2.getIncludeProjectSourceFiles();
        }
        if (kotlinExcludeLibrarySources) {
            return false;
        }
        ScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition(virtualFile2, this.project);
        ScriptCompilationConfiguration scriptCompilationConfiguration2 = scriptConfiguration = scriptDefinition != null ? scriptDefinition.getCompilationConfiguration() : null;
        List<ScriptAcceptedLocation> list2 = scriptScope = scriptCompilationConfiguration2 != null ? scriptCompilationConfiguration2.get(ScriptIdeConfigurationKt.getAcceptedLocations(ScriptIdeConfigurationKt.getIde(ScriptCompilationConfiguration.Companion))) : null;
        if (scriptScope != null) {
            boolean includeEverything = this.containsAllowedLocations(scriptScope) || ScratchUtil.isScratch((VirtualFile)virtualFile2);
            boolean includeLibrariesForScripts = includeEverything || scriptScope.contains((Object)ScriptAcceptedLocation.Libraries);
            boolean includeProjectSourceFilesForScripts = includeEverything || scriptScope.contains((Object)ScriptAcceptedLocation.Sources) || scriptScope.contains((Object)ScriptAcceptedLocation.Tests);
            boolean bl2 = filter2.getIncludeProjectSourceFiles() && includeProjectSourceFilesForScripts;
            boolean bl3 = filter2.getIncludeLibrarySourceFiles() && includeLibrariesForScripts;
            boolean bl4 = filter2.getIncludeLibraryClassFiles() && includeLibrariesForScripts;
            boolean bl5 = filter2.getIncludeScriptDependencies() && includeLibrariesForScripts;
            boolean bl6 = filter2.getIncludeScriptsOutsideSourceRoots() && includeEverything;
            v4 = filter2.copy(bl2, bl4, bl3, bl5, bl6);
        } else {
            v4 = correctedFilter = RootKindFilter.copy$default(filter2, false, false, false, false, false, 15, null);
        }
        if (correctedFilter.getIncludeScriptsOutsideSourceRoots()) {
            if (this.getFileIndex().isInContent(virtualFile2) || ScratchUtil.isScratch((VirtualFile)virtualFile2)) {
                return true;
            }
            Object object = scriptConfiguration;
            return object != null && (object = ((PropertiesCollection)object).get(ScriptIdeConfigurationKt.getAcceptedLocations(ScriptIdeConfigurationKt.getIde(ScriptCompilationConfiguration.Companion)))) != null ? this.containsAllowedLocations((List<? extends ScriptAcceptedLocation>)object) : false;
        }
        if (!correctedFilter.getIncludeLibraryClassFiles() && !correctedFilter.getIncludeLibrarySourceFiles()) {
            return false;
        }
        boolean canContainClassFiles = false;
        boolean isBinary = false;
        if (virtualFile2.isDirectory()) {
            canContainClassFiles = true;
            isBinary = false;
        } else {
            CharSequence charSequence2 = virtualFile2.getNameSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"virtualFile.nameSequence");
            CharSequence nameSequence = charSequence2;
            if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kt", (boolean)false, (int)2, null)) {
                canContainClassFiles = false;
                isBinary = false;
            } else if (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".class", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kotlin_builtins", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".kotlin_metadata", (boolean)false, (int)2, null)) {
                canContainClassFiles = false;
                isBinary = true;
            } else {
                FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence());
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getInstance().getFileTyp\u2026virtualFile.nameSequence)");
                FileType fileType2 = fileType;
                canContainClassFiles = Intrinsics.areEqual((Object)fileType2, (Object)ArchiveFileType.INSTANCE) || virtualFile2.isDirectory();
                isBinary = KotlinBinaryExtensionKt.isKotlinBinary(fileType2);
            }
        }
        if (correctedFilter.getIncludeLibraryClassFiles() && (isBinary || canContainClassFiles)) {
            GlobalSearchScope classFileScope;
            if (this.getFileIndex().isInLibraryClasses(virtualFile2)) {
                return true;
            }
            GlobalSearchScope globalSearchScope = classFileScope = correctedFilter.getIncludeScriptDependencies() ? ScriptConfigurationManager.Companion.getInstance(this.project).getAllScriptsDependenciesClassFilesScope() : null;
            if (classFileScope != null && classFileScope.contains(virtualFile2)) {
                return true;
            }
        }
        if (correctedFilter.getIncludeLibrarySourceFiles() && !isBinary) {
            GlobalSearchScope sourceFileScope;
            if (this.getFileIndex().isInLibrarySource(virtualFile2)) {
                return true;
            }
            GlobalSearchScope globalSearchScope = sourceFileScope = correctedFilter.getIncludeScriptDependencies() ? ScriptConfigurationManager.Companion.getInstance(this.project).getAllScriptDependenciesSourcesScope() : null;
            if (sourceFileScope != null && sourceFileScope.contains(virtualFile2) && (virtualFile2 instanceof VirtualFileWindow || !this.getFileIndex().isInSourceContent(virtualFile2))) {
                return true;
            }
        }
        return false;
    }

    private final boolean containsAllowedLocations(List<? extends ScriptAcceptedLocation> $this$containsAllowedLocations) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$containsAllowedLocations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScriptAcceptedLocation it = (ScriptAcceptedLocation)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(it == ScriptAcceptedLocation.Everywhere || it == ScriptAcceptedLocation.Project)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ Project access$getProject$p(RootKindMatcherImpl $this) {
        return $this.project;
    }
}

