/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis.api.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.ShortenCommand;
import org.jetbrains.kotlin.analysis.api.components.ShortenOption;
import org.jetbrains.kotlin.analysis.api.lifetime.KtDefaultLifetimeTokenProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KtReadActionConfinementLifetimeToken;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.idea.base.psi.imports.ImportInsertionKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005\u001aD\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013*\u00020\u0014\u00a8\u0006\u0015"}, d2={"shortenReferences", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "classShortenOption", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenOption;", "callableShortenOption", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "shortenReferencesInRange", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "deleteQualifier", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "invokeShortening", "", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenCommand;", "kotlin.base.analysis-api.utils"})
@SourceDebugExtension(value={"SMAP\nshortenUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 shortenUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/ShortenUtilsKt\n+ 2 KtReadActionConfinementLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtReadActionConfinementLifetimeTokenKt\n+ 3 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 4 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n93#2:94\n94#2,3:114\n98#2:128\n32#3,7:95\n55#4:102\n54#4,3:103\n75#4,8:106\n54#4,3:117\n75#4,8:120\n1#5:129\n*S KotlinDebug\n*F\n+ 1 shortenUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/ShortenUtilsKt\n*L\n49#1:94\n49#1:114,3\n49#1:128\n50#1:95,7\n50#1:102\n50#1:103,3\n50#1:106,8\n50#1:117,3\n50#1:120,8\n*E\n"})
public final class ShortenUtilsKt {
    public static final void shortenReferences(@NotNull KtElement element3, @NotNull Function1<? super KtClassLikeSymbol, ? extends ShortenOption> classShortenOption, @NotNull Function1<? super KtCallableSymbol, ? extends ShortenOption> callableShortenOption) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(classShortenOption, (String)"classShortenOption");
        Intrinsics.checkNotNullParameter(callableShortenOption, (String)"callableShortenOption");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"element.containingKtFile");
        TextRange textRange = element3.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        ShortenUtilsKt.shortenReferencesInRange(ktFile, textRange, classShortenOption, callableShortenOption);
    }

    public static /* synthetic */ void shortenReferences$default(KtElement ktElement, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = ShortenOption.Companion.getDefaultClassShortenOption();
        }
        if ((n & 4) != 0) {
            function12 = ShortenOption.Companion.getDefaultCallableShortenOption();
        }
        ShortenUtilsKt.shortenReferences(ktElement, function1, function12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void shortenReferencesInRange(@NotNull KtFile file2, @NotNull TextRange range2, @NotNull Function1<? super KtClassLikeSymbol, ? extends ShortenOption> classShortenOption, @NotNull Function1<? super KtCallableSymbol, ? extends ShortenOption> callableShortenOption) {
        ShortenCommand shortenCommand2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(classShortenOption, (String)"classShortenOption");
        Intrinsics.checkNotNullParameter(callableShortenOption, (String)"callableShortenOption");
        boolean $i$f$allowAnalysisOnEdt = false;
        Boolean bl = KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            $i$a$-allowAnalysisOnEdt-ShortenUtilsKt$shortenReferencesInRange$shortenCommand$1 = false;
            nonDefaultLifetimeTokenFactory$iv = null;
            $i$f$analyze = false;
            Project project2 = ((KtElement)file2).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KtAnalysisSessionProvider ktAnalysisSessionProvider = KtAnalysisSessionProvider.Companion.getInstance(project2);
            $i$f$analyse = false;
            factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
            KtAnalysisSessionProvider ktAnalysisSessionProvider2 = this_$iv$iv;
            analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)file2, factory$iv$iv);
            $i$f$analyse = false;
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
            factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
            try {
                $this$shortenReferencesInRange_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv$iv;
                $i$a$-analyze$default-ShortenUtilsKt$shortenReferencesInRange$shortenCommand$1$1 = false;
                var17_16 = $this$shortenReferencesInRange_u24lambda_u241_u24lambda_u240.collectPossibleReferenceShortenings(file2, range2, classShortenOption, callableShortenOption);
            }
            finally {
                factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
            }
            shortenCommand2 = var17_16;
        } else {
            KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().set(true);
            try {
                $i$a$-allowAnalysisOnEdt-ShortenUtilsKt$shortenReferencesInRange$shortenCommand$1 = false;
                nonDefaultLifetimeTokenFactory$iv = null;
                $i$f$analyze = false;
                Project project3 = ((KtElement)file2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project3);
                $i$f$analyse = false;
                factory$iv$iv = KtDefaultLifetimeTokenProvider.Companion.getService(this_$iv$iv.getProject()).getDefaultLifetimeTokenFactory();
                this_$iv$iv$iv = this_$iv$iv;
                analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)file2, factory$iv$iv);
                $i$f$analyse = false;
                this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
                factory$iv$iv.beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
                try {
                    $this$shortenReferencesInRange_u24lambda_u241_u24lambda_u240 = analysisSession$iv$iv$iv;
                    $i$a$-analyze$default-ShortenUtilsKt$shortenReferencesInRange$shortenCommand$1$1 = false;
                    var17_16 = $this$shortenReferencesInRange_u24lambda_u241_u24lambda_u240.collectPossibleReferenceShortenings(file2, range2, classShortenOption, callableShortenOption);
                }
                finally {
                    factory$iv$iv.afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
                    this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
                }
                ShortenCommand shortenCommand3 = var17_16;
                shortenCommand2 = shortenCommand3;
            }
            finally {
                KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().set(false);
            }
        }
        ShortenCommand shortenCommand4 = shortenCommand2;
        ShortenUtilsKt.invokeShortening(shortenCommand4);
    }

    public static /* synthetic */ void shortenReferencesInRange$default(KtFile ktFile, TextRange textRange, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            TextRange textRange2 = ktFile.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"file.textRange");
            textRange = textRange2;
        }
        if ((n & 4) != 0) {
            function1 = ShortenOption.Companion.getDefaultClassShortenOption();
        }
        if ((n & 8) != 0) {
            function12 = ShortenOption.Companion.getDefaultCallableShortenOption();
        }
        ShortenUtilsKt.shortenReferencesInRange(ktFile, textRange, function1, function12);
    }

    @NotNull
    public static final List<KtElement> invokeShortening(@NotNull ShortenCommand $this$invokeShortening) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeShortening, (String)"<this>");
        KtFile ktFile = (KtFile)$this$invokeShortening.getTargetFile().getElement();
        if (ktFile == null) {
            return CollectionsKt.emptyList();
        }
        KtFile targetFile2 = ktFile;
        for (FqName nameToImport : $this$invokeShortening.getImportsToAdd()) {
            ImportInsertionKt.addImport$default(targetFile2, nameToImport, false, null, null, 14, null);
        }
        for (FqName nameToImport : $this$invokeShortening.getStarImportsToAdd()) {
            ImportInsertionKt.addImport$default(targetFile2, nameToImport, true, null, null, 12, null);
        }
        List shorteningResults = new ArrayList();
        for (SmartPsiElementPointer<KtUserType> smartPsiElementPointer : $this$invokeShortening.getTypesToShorten()) {
            KtUserType type2;
            if ((KtUserType)smartPsiElementPointer.getElement() == null) continue;
            type2.deleteQualifier();
            shorteningResults.add(type2);
        }
        for (SmartPsiElementPointer<KtUserType> smartPsiElementPointer : $this$invokeShortening.getQualifiersToShorten()) {
            KtExpression it;
            KtDotQualifiedExpression call;
            if ((KtDotQualifiedExpression)smartPsiElementPointer.getElement() == null) continue;
            if (ShortenUtilsKt.deleteQualifier(call) == null) continue;
            boolean bl = false;
            shorteningResults.add(it);
        }
        return shorteningResults;
    }

    private static final KtExpression deleteQualifier(KtDotQualifiedExpression $this$deleteQualifier) {
        KtExpression ktExpression = $this$deleteQualifier.getSelectorExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression selectorExpression = ktExpression;
        PsiElement psiElement2 = $this$deleteQualifier.replace((PsiElement)selectorExpression);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        return (KtExpression)psiElement2;
    }
}

