/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/KotlinJavaScriptStdlibDetectorFacility;", "Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "()V", "IS_JS_LIBRARY_STD_LIB", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "supportedLibraryKind", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "getSupportedLibraryKind", "()Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "getStdlibJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "kotlin.base.platforms"})
@ApiStatus.Internal
public final class KotlinJavaScriptStdlibDetectorFacility
extends StdlibDetectorFacility {
    @NotNull
    public static final KotlinJavaScriptStdlibDetectorFacility INSTANCE = new KotlinJavaScriptStdlibDetectorFacility();
    @NotNull
    private static final Key<Boolean> IS_JS_LIBRARY_STD_LIB;

    private KotlinJavaScriptStdlibDetectorFacility() {
        super(null);
    }

    @Override
    @NotNull
    protected KotlinLibraryKind getSupportedLibraryKind() {
        return KotlinJavaScriptLibraryKind.INSTANCE;
    }

    @Override
    @Nullable
    public VirtualFile getStdlibJar(@NotNull List<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        for (VirtualFile virtualFile2 : roots2) {
            VirtualFile jar;
            if (virtualFile2.getFileSystem().getProtocol() != "jar") continue;
            String string2 = virtualFile2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"root.url");
            String name2 = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)string2, (String)"!/", null, (int)2, null), (char)'/', null, (int)2, null);
            if (!Intrinsics.areEqual((Object)name2, (Object)"kotlin-stdlib-js.jar") && !Intrinsics.areEqual((Object)name2, (Object)"kotlin-jslib.jar") && !PathUtil.INSTANCE.getKOTLIN_STDLIB_JS_JAR_PATTERN().matcher(name2).matches() && !PathUtil.INSTANCE.getKOTLIN_JS_LIBRARY_JAR_PATTERN().matcher(name2).matches() || VfsUtilCore.getVirtualFileForJar((VirtualFile)virtualFile2) == null) continue;
            Boolean isJSStdLib = (Boolean)jar.getUserData(IS_JS_LIBRARY_STD_LIB);
            if (isJSStdLib == null) {
                isJSStdLib = LibraryUtils.isKotlinJavascriptStdLibrary((File)new File(jar.getPath()));
                jar.putUserData(IS_JS_LIBRARY_STD_LIB, (Object)isJSStdLib);
            }
            if (!isJSStdLib.booleanValue()) continue;
            return jar;
        }
        return null;
    }

    static {
        Key key = Key.create((String)"IS_JS_LIBRARY_STD_LIB");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<Boolean>(\"IS_JS_LIBRARY_STD_LIB\")");
        IS_JS_LIBRARY_STD_LIB = key;
    }
}

