/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryKindRegistry;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.roots.IndexableFileScanner;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.idea.base.platforms.IdePlatformKindProjectStructure;
import org.jetbrains.kotlin.idea.base.platforms.KotlinCommonLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJvmEffectiveLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKind;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "findKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "classRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getEffectiveKind", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "nonJvmOrNull", "Companion", "KnownLibraryKindForIndex", "LibraryKindScanner", "kotlin.base.platforms"})
@SourceDebugExtension(value={"SMAP\nLibraryEffectiveKindProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryEffectiveKindProvider.kt\norg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class LibraryEffectiveKindProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<PersistentLibraryKind<?>> LIBRARY_KIND_KEY;
    @NotNull
    private static final Key<VirtualFile[]> CLASS_ROOTS_KEY;
    @NotNull
    private static final UnknownLibraryKind NEEDS_TO_BE_CLARIFIED_KIND;
    @NotNull
    private static final VirtualFileGist<PersistentLibraryKind<?>> KOTLIN_LIBRARY_KIND_GIST;

    public LibraryEffectiveKindProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PersistentLibraryKind<?> findKind(VirtualFile[] classRoots) {
        VirtualFile virtualFile2 = (VirtualFile)ArraysKt.firstOrNull((Object[])classRoots);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        virtualFile3.putUserData(CLASS_ROOTS_KEY, (Object)classRoots);
        try {
            PersistentLibraryKind persistentLibraryKind = (PersistentLibraryKind)ActionsKt.runReadAction((Function0)new Function0<PersistentLibraryKind<?>>(this, virtualFile3){
                final /* synthetic */ LibraryEffectiveKindProvider this$0;
                final /* synthetic */ VirtualFile $virtualFile;
                {
                    this.this$0 = $receiver;
                    this.$virtualFile = $virtualFile;
                    super(0);
                }

                public final PersistentLibraryKind<?> invoke() {
                    return (PersistentLibraryKind)LibraryEffectiveKindProvider.access$getKOTLIN_LIBRARY_KIND_GIST$cp().getFileData(LibraryEffectiveKindProvider.access$getProject$p(this.this$0), this.$virtualFile);
                }
            });
            return persistentLibraryKind;
        }
        finally {
            RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)virtualFile3), CLASS_ROOTS_KEY);
        }
    }

    @Nullable
    public final PersistentLibraryKind<?> getEffectiveKind(@NotNull Library library2) {
        PersistentLibraryKind<?> persistentLibraryKind;
        block9: {
            PersistentLibraryKind<?> nonJvmOrNull;
            PersistentLibraryKind<?> platformKind;
            Object object;
            block11: {
                VirtualFile classRoot;
                Object[] classRoots;
                block10: {
                    PersistentLibraryKind<?> persistentLibraryKind2;
                    block8: {
                        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                        if (!(library2 instanceof LibraryEx)) {
                            String string2 = "Failed requirement.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        if (((LibraryEx)library2).isDisposed()) {
                            return null;
                        }
                        PersistentLibraryKind<?> kind2 = ((LibraryEx)library2).getKind();
                        if (!(kind2 instanceof KotlinLibraryKind)) break block8;
                        persistentLibraryKind = kind2;
                        break block9;
                    }
                    Object[] objectArray = library2.getFiles(OrderRootType.CLASSES);
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"library.getFiles(OrderRootType.CLASSES)");
                    classRoots = objectArray;
                    VirtualFile virtualFile2 = (VirtualFile)ArraysKt.firstOrNull((Object[])classRoots);
                    if (virtualFile2 == null) {
                        return null;
                    }
                    classRoot = virtualFile2;
                    object = (PersistentLibraryKind<?>)classRoot.getUserData(LIBRARY_KIND_KEY);
                    if (object == null) break block10;
                    PersistentLibraryKind<?> it = persistentLibraryKind2 = object;
                    boolean bl = false;
                    object = !Intrinsics.areEqual((Object)it, (Object)NEEDS_TO_BE_CLARIFIED_KIND) ? persistentLibraryKind2 : null;
                    if (object != null) break block11;
                }
                PersistentLibraryKind<?> persistentLibraryKind3 = this.findKind((VirtualFile[])classRoots);
                if (persistentLibraryKind3 != null) {
                    PersistentLibraryKind<?> it = persistentLibraryKind3;
                    boolean bl = false;
                    classRoot.putUserData(LIBRARY_KIND_KEY, it);
                    object = it;
                } else {
                    object = null;
                }
            }
            PersistentLibraryKind<?> persistentLibraryKind4 = platformKind = object;
            persistentLibraryKind = nonJvmOrNull = persistentLibraryKind4 != null ? this.nonJvmOrNull(persistentLibraryKind4) : null;
        }
        return persistentLibraryKind;
    }

    private final PersistentLibraryKind<?> nonJvmOrNull(PersistentLibraryKind<?> $this$nonJvmOrNull) {
        PersistentLibraryKind<?> persistentLibraryKind;
        PersistentLibraryKind<?> it = persistentLibraryKind = $this$nonJvmOrNull;
        boolean bl = false;
        return !Intrinsics.areEqual(it, (Object)KotlinJvmEffectiveLibraryKind.INSTANCE) ? persistentLibraryKind : null;
    }

    private static final PersistentLibraryKind KOTLIN_LIBRARY_KIND_GIST$lambda$3(Project project2, VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile[] virtualFileArray = (VirtualFile[])file2.getUserData(CLASS_ROOTS_KEY);
        if (virtualFileArray == null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[]{file2};
            virtualFileArray = virtualFileArray2;
        }
        VirtualFile[] classRoots = virtualFileArray;
        LibraryKindScanner.Companion.runScannerOutsideScanningSession(classRoots);
        PersistentLibraryKind<?> platformKind = (PersistentLibraryKind<?>)file2.getUserData(LIBRARY_KIND_KEY);
        if (Intrinsics.areEqual((Object)platformKind, (Object)NEEDS_TO_BE_CLARIFIED_KIND)) {
            IdePlatformKind idePlatformKind = IdePlatformKindProjectStructure.Companion.getLibraryPlatformKind(file2);
            if (idePlatformKind == null) {
                idePlatformKind = IdePlatformKindUtil.getIdePlatformKind((TargetPlatform)JvmPlatforms.INSTANCE.getDefaultJvmPlatform());
            }
            IdePlatformKind matchingPlatformKind = idePlatformKind;
            platformKind = IdePlatformKindProjectStructure.Companion.getLibraryKind(matchingPlatformKind);
        }
        return platformKind;
    }

    public static final /* synthetic */ VirtualFileGist access$getKOTLIN_LIBRARY_KIND_GIST$cp() {
        return KOTLIN_LIBRARY_KIND_GIST;
    }

    public static final /* synthetic */ Project access$getProject$p(LibraryEffectiveKindProvider $this) {
        return $this.project;
    }

    static {
        Key key = Key.create((String)"LibraryEffectiveKind");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(\"LibraryEffectiveKind\")");
        LIBRARY_KIND_KEY = key;
        Key key2 = Key.create((String)"LibraryClassRoots");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(\"LibraryClassRoots\")");
        CLASS_ROOTS_KEY = key2;
        UnknownLibraryKind unknownLibraryKind = UnknownLibraryKind.getOrCreate((String)"Needs to be clarified");
        Intrinsics.checkNotNullExpressionValue((Object)unknownLibraryKind, (String)"getOrCreate(\"Needs to be clarified\")");
        NEEDS_TO_BE_CLARIFIED_KIND = unknownLibraryKind;
        VirtualFileGist virtualFileGist = GistManager.getInstance().newVirtualFileGist("kotlin-library-kind", 1, new DataExternalizer<PersistentLibraryKind<?>>(){

            public void save(@NotNull DataOutput out, @NotNull PersistentLibraryKind<?> value2) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter(value2, (String)"value");
                String kindId = value2.getKindId();
                IOUtil.writeString((String)kindId, (DataOutput)out);
            }

            @Nullable
            public PersistentLibraryKind<?> read(@NotNull DataInput in) {
                LibraryKind libraryKind;
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                String kindId = IOUtil.readString((DataInput)in);
                return Intrinsics.areEqual((Object)kindId, (Object)KotlinJvmEffectiveLibraryKind.INSTANCE.getKindId()) ? (PersistentLibraryKind)KotlinJvmEffectiveLibraryKind.INSTANCE : ((libraryKind = LibraryKindRegistry.Companion.getInstance().findKindById(kindId)) instanceof PersistentLibraryKind ? (PersistentLibraryKind)libraryKind : null);
            }
        }, LibraryEffectiveKindProvider::KOTLIN_LIBRARY_KIND_GIST$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileGist, (String)"getInstance().newVirtual\u2026   platformKind\n        }");
        KOTLIN_LIBRARY_KIND_GIST = virtualFileGist;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002R\u001b\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$Companion;", "", "()V", "CLASS_ROOTS_KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCLASS_ROOTS_KEY", "()Lcom/intellij/openapi/util/Key;", "KOTLIN_LIBRARY_KIND_GIST", "Lcom/intellij/util/gist/VirtualFileGist;", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getKOTLIN_LIBRARY_KIND_GIST$annotations", "LIBRARY_KIND_KEY", "getLIBRARY_KIND_KEY", "NEEDS_TO_BE_CLARIFIED_KIND", "Lcom/intellij/openapi/roots/impl/libraries/UnknownLibraryKind;", "getNEEDS_TO_BE_CLARIFIED_KIND", "()Lcom/intellij/openapi/roots/impl/libraries/UnknownLibraryKind;", "kotlin.base.platforms"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<PersistentLibraryKind<?>> getLIBRARY_KIND_KEY() {
            return LIBRARY_KIND_KEY;
        }

        @NotNull
        public final Key<VirtualFile[]> getCLASS_ROOTS_KEY() {
            return CLASS_ROOTS_KEY;
        }

        @NotNull
        public final UnknownLibraryKind getNEEDS_TO_BE_CLARIFIED_KIND() {
            return NEEDS_TO_BE_CLARIFIED_KIND;
        }

        @JvmStatic
        private static /* synthetic */ void getKOTLIN_LIBRARY_KIND_GIST$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;", "", "(Ljava/lang/String;I)V", "COMMON", "JS", "UNKNOWN", "kotlin.base.platforms"})
    private static final class KnownLibraryKindForIndex
    extends Enum<KnownLibraryKindForIndex> {
        public static final /* enum */ KnownLibraryKindForIndex COMMON = new KnownLibraryKindForIndex();
        public static final /* enum */ KnownLibraryKindForIndex JS = new KnownLibraryKindForIndex();
        public static final /* enum */ KnownLibraryKindForIndex UNKNOWN = new KnownLibraryKindForIndex();
        private static final /* synthetic */ KnownLibraryKindForIndex[] $VALUES;

        public static KnownLibraryKindForIndex[] values() {
            return (KnownLibraryKindForIndex[])$VALUES.clone();
        }

        public static KnownLibraryKindForIndex valueOf(String value2) {
            return Enum.valueOf(KnownLibraryKindForIndex.class, value2);
        }

        static {
            $VALUES = knownLibraryKindForIndexArray = new KnownLibraryKindForIndex[]{KnownLibraryKindForIndex.COMMON, KnownLibraryKindForIndex.JS, KnownLibraryKindForIndex.UNKNOWN};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$LibraryKindScanner;", "Lcom/intellij/util/indexing/roots/IndexableFileScanner;", "()V", "startSession", "Lcom/intellij/util/indexing/roots/IndexableFileScanner$ScanSession;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "ScannerVisitor", "kotlin.base.platforms"})
    public static final class LibraryKindScanner
    implements IndexableFileScanner {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public IndexableFileScanner.ScanSession startSession(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ScannerVisitor scannerVisitor = new ScannerVisitor();
            return new IndexableFileScanner.ScanSession(scannerVisitor){
                final /* synthetic */ ScannerVisitor $scannerVisitor;
                {
                    this.$scannerVisitor = $scannerVisitor;
                }

                @Nullable
                public IndexableFileScanner.IndexableFileVisitor createVisitor(@NotNull IndexableSetOrigin indexableSetOrigin) {
                    Intrinsics.checkNotNullParameter((Object)indexableSetOrigin, (String)"indexableSetOrigin");
                    if (indexableSetOrigin instanceof LibraryOrigin) {
                        return new IndexableFileScanner.IndexableFileVisitor(this.$scannerVisitor, indexableSetOrigin){
                            final /* synthetic */ ScannerVisitor $scannerVisitor;
                            final /* synthetic */ IndexableSetOrigin $indexableSetOrigin;
                            {
                                this.$scannerVisitor = $scannerVisitor;
                                this.$indexableSetOrigin = $indexableSetOrigin;
                            }

                            public void visitFile(@NotNull VirtualFile fileOrDir) {
                                Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                                this.$scannerVisitor.visitFile(fileOrDir);
                            }

                            public void visitingFinished() {
                                List roots2 = ((LibraryOrigin)this.$indexableSetOrigin).getClassRoots();
                                this.$scannerVisitor.visitingFinished(roots2);
                            }
                        };
                    }
                    return null;
                }
            };
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$LibraryKindScanner$Companion;", "", "()V", "runScannerOutsideScanningSession", "", "classRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "kotlin.base.platforms"})
        public static final class Companion {
            private Companion() {
            }

            public final void runScannerOutsideScanningSession(@NotNull VirtualFile[] classRoots) {
                Intrinsics.checkNotNullParameter((Object)classRoots, (String)"classRoots");
                ScannerVisitor scannerVisitor = new ScannerVisitor();
                int n = classRoots.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile classRoot = classRoots[j];
                    VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
                    VfsUtil.visitChildrenRecursively((VirtualFile)classRoot, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(scannerVisitor, optionArray){
                        final /* synthetic */ ScannerVisitor $scannerVisitor;
                        {
                            this.$scannerVisitor = $scannerVisitor;
                            super($super_call_param$1);
                        }

                        public boolean visitFile(@NotNull VirtualFile file2) {
                            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                            this.$scannerVisitor.visitFile(file2);
                            return true;
                        }
                    }));
                }
                scannerVisitor.visitingFinished(ArraysKt.toList((Object[])classRoots));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$LibraryKindScanner$ScannerVisitor;", "", "()V", "classFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Lorg/jetbrains/annotations/NotNull;", "getClassFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "kotlinJavaScriptMetaFileType", "getKotlinJavaScriptMetaFileType", "result", "Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;", "getResult", "()Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;", "setResult", "(Lorg/jetbrains/kotlin/idea/base/platforms/LibraryEffectiveKindProvider$KnownLibraryKindForIndex;)V", "visitFile", "", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "visitingFinished", "roots", "", "kotlin.base.platforms"})
        private static final class ScannerVisitor {
            @NotNull
            private final FileType classFileType;
            @NotNull
            private final FileType kotlinJavaScriptMetaFileType;
            @Nullable
            private KnownLibraryKindForIndex result;

            public ScannerVisitor() {
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByExtension("class");
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getInstance().getFileTypeByExtension(\"class\")");
                this.classFileType = fileType;
                FileType fileType2 = FileTypeRegistry.getInstance().getFileTypeByExtension("kjsm");
                Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getInstance().getFileTypeByExtension(\"kjsm\")");
                this.kotlinJavaScriptMetaFileType = fileType2;
            }

            @NotNull
            public final FileType getClassFileType() {
                return this.classFileType;
            }

            @NotNull
            public final FileType getKotlinJavaScriptMetaFileType() {
                return this.kotlinJavaScriptMetaFileType;
            }

            @Nullable
            public final KnownLibraryKindForIndex getResult() {
                return this.result;
            }

            public final void setResult(@Nullable KnownLibraryKindForIndex knownLibraryKindForIndex) {
                this.result = knownLibraryKindForIndex;
            }

            public final void visitFile(@NotNull VirtualFile fileOrDir) {
                block0: {
                    FileType fileType;
                    block2: {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                            if (this.result == KnownLibraryKindForIndex.UNKNOWN) break block0;
                            FileType fileType2 = fileOrDir.getFileType();
                            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"fileOrDir.fileType");
                            fileType = fileType2;
                            if (!Intrinsics.areEqual((Object)fileType, (Object)this.classFileType)) break block1;
                            this.result = KnownLibraryKindForIndex.UNKNOWN;
                            break block0;
                        }
                        if (!Intrinsics.areEqual((Object)fileType, (Object)this.kotlinJavaScriptMetaFileType)) break block2;
                        this.result = KnownLibraryKindForIndex.JS;
                        break block0;
                    }
                    if (!Intrinsics.areEqual((Object)fileType, (Object)KotlinBuiltInFileType.INSTANCE) || !Intrinsics.areEqual((Object)fileOrDir.getExtension(), (Object)"kotlin_metadata") || this.result != null) break block0;
                    this.result = KnownLibraryKindForIndex.COMMON;
                }
            }

            public final void visitingFinished(@NotNull Collection<? extends VirtualFile> roots2) {
                Intrinsics.checkNotNullParameter(roots2, (String)"roots");
                KnownLibraryKindForIndex knownLibraryKindForIndex = this.result;
                PersistentLibraryKind platformKind = switch (knownLibraryKindForIndex == null ? -1 : WhenMappings.$EnumSwitchMapping$0[knownLibraryKindForIndex.ordinal()]) {
                    case 1 -> KotlinCommonLibraryKind.INSTANCE;
                    case 2 -> KotlinJavaScriptLibraryKind.INSTANCE;
                    default -> (PersistentLibraryKind)Companion.getNEEDS_TO_BE_CLARIFIED_KIND();
                };
                for (VirtualFile virtualFile2 : roots2) {
                    virtualFile2.putUserData(Companion.getLIBRARY_KIND_KEY(), (Object)platformKind);
                }
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[KnownLibraryKindForIndex.values().length];
                    try {
                        nArray[KnownLibraryKindForIndex.COMMON.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[KnownLibraryKindForIndex.JS.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

