/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.psi.imports;

import com.intellij.psi.PsiFile;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.imports.KotlinImportPathComparator;
import org.jetbrains.kotlin.idea.base.psi.imports.KotlinImportPathComparatorKt;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntry;
import org.jetbrains.kotlin.idea.core.formatter.KotlinPackageEntryTable;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\u000fB\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/imports/KotlinImportPathComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "Lkotlin/Comparator;", "packageTable", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;", "(Lorg/jetbrains/kotlin/idea/core/formatter/KotlinPackageEntryTable;)V", "bestEntryMatchIndex", "", "path", "ignoreAlias", "", "compare", "import1", "import2", "Companion", "kotlin.base.psi"})
@ApiStatus.Internal
public final class KotlinImportPathComparator
implements Comparator<ImportPath> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinPackageEntryTable packageTable;

    private KotlinImportPathComparator(KotlinPackageEntryTable packageTable) {
        this.packageTable = packageTable;
    }

    @Override
    public int compare(@NotNull ImportPath import1, @NotNull ImportPath import2) {
        Intrinsics.checkNotNullParameter((Object)import1, (String)"import1");
        Intrinsics.checkNotNullParameter((Object)import2, (String)"import2");
        boolean ignoreAlias = import1.hasAlias() && import2.hasAlias();
        Function1[] function1Array = new Function1[]{new Function1<ImportPath, Comparable<?>>(this, ignoreAlias){
            final /* synthetic */ KotlinImportPathComparator this$0;
            final /* synthetic */ boolean $ignoreAlias;
            {
                this.this$0 = $receiver;
                this.$ignoreAlias = $ignoreAlias;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(@NotNull ImportPath importPath) {
                Intrinsics.checkNotNullParameter((Object)importPath, (String)"import");
                return KotlinImportPathComparator.access$bestEntryMatchIndex(this.this$0, importPath, this.$ignoreAlias);
            }
        }, compare.2.INSTANCE};
        return ComparisonsKt.compareValuesBy((Object)import1, (Object)import2, (Function1[])function1Array);
    }

    private final int bestEntryMatchIndex(ImportPath path2, boolean ignoreAlias) {
        KotlinPackageEntry bestEntryMatch = null;
        int bestIndex = -1;
        KotlinPackageEntry[] kotlinPackageEntryArray = this.packageTable.getEntries();
        int n = kotlinPackageEntryArray.length;
        for (int j = 0; j < n; ++j) {
            int index = j;
            KotlinPackageEntry entry = kotlinPackageEntryArray[j];
            if (!KotlinImportPathComparatorKt.access$isBetterMatchForPackageThan(entry, bestEntryMatch, path2, ignoreAlias)) continue;
            bestEntryMatch = entry;
            bestIndex = index;
        }
        return bestIndex;
    }

    public static final /* synthetic */ int access$bestEntryMatchIndex(KotlinImportPathComparator $this, ImportPath path2, boolean ignoreAlias) {
        return $this.bestEntryMatchIndex(path2, ignoreAlias);
    }

    public /* synthetic */ KotlinImportPathComparator(KotlinPackageEntryTable packageTable, DefaultConstructorMarker $constructor_marker) {
        this(packageTable);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/base/psi/imports/KotlinImportPathComparator$Companion;", "", "()V", "create", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "Lkotlin/Comparator;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.base.psi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<ImportPath> create(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KotlinPackageEntryTable kotlinPackageEntryTable = CodeStyleUtilsKt.getKotlinCustomSettings((PsiFile)((PsiFile)file2)).PACKAGES_IMPORT_LAYOUT;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinPackageEntryTable, (String)"file.kotlinCustomSettings.PACKAGES_IMPORT_LAYOUT");
            KotlinPackageEntryTable packagesImportLayout = kotlinPackageEntryTable;
            return new KotlinImportPathComparator(packagesImportLayout, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

