/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWithIfExpressionSurrounder;", "Lorg/jetbrains/kotlin/idea/core/surroundWith/KotlinExpressionSurrounder;", "withElse", "", "(Z)V", "getWithElse", "()Z", "getTemplateDescription", "", "isApplicable", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "surroundExpression", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinWithIfExpressionSurrounder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinWithIfExpressionSurrounder.kt\norg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWithIfExpressionSurrounder\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n*L\n1#1,47:1\n19#2:48\n*S KotlinDebug\n*F\n+ 1 KotlinWithIfExpressionSurrounder.kt\norg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWithIfExpressionSurrounder\n*L\n35#1:48\n*E\n"})
public final class KotlinWithIfExpressionSurrounder
extends KotlinExpressionSurrounder {
    private final boolean withElse;

    public KotlinWithIfExpressionSurrounder(boolean withElse) {
        this.withElse = withElse;
    }

    public final boolean getWithElse() {
        return this.withElse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isApplicable(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!super.isApplicable(expression2)) return false;
        KotlinType kotlinType = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (kotlinType == null) return false;
        boolean bl = TypeUtilsKt.isBoolean((KotlinType)kotlinType);
        if (!bl) return false;
        return true;
    }

    @Override
    @NotNull
    protected TextRange surroundExpression(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
        PsiElement psiElement2 = expression2.replace((PsiElement)factory2.createIf(expression2, (KtExpression)factory2.createBlock("blockStubContentToBeRemovedLater"), (KtExpression)(this.withElse ? factory2.createEmptyBody() : null)));
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        KtExpression replaceResult = (KtExpression)psiElement2;
        KtExpression ktExpression = KtPsiUtil.deparenthesizeOnce((KtExpression)replaceResult);
        Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        KtIfExpression ifExpression2 = (KtIfExpression)ktExpression;
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)ifExpression2));
        KtExpression ktExpression2 = ifExpression2.getThen();
        KtBlockExpression $this$sure$iv = ktExpression2 instanceof KtBlockExpression ? (KtBlockExpression)ktExpression2 : null;
        boolean $i$f$sure = false;
        KtBlockExpression ktBlockExpression = $this$sure$iv;
        if (ktBlockExpression == null) {
            boolean bl = false;
            String string2 = "Then branch should exist and be a block expression";
            throw new AssertionError((Object)string2);
        }
        List list2 = ktBlockExpression.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ifExpression.then as? Kt\u2026ion\"\n        }.statements");
        TextRange firstStatementInThenRange = ((KtExpression)CollectionsKt.first((List)list2)).getTextRange();
        editor2.getDocument().deleteString(firstStatementInThenRange.getStartOffset(), firstStatementInThenRange.getEndOffset());
        return new TextRange(firstStatementInThenRange.getStartOffset(), firstStatementInThenRange.getStartOffset());
    }

    @NlsSafe
    @NotNull
    public String getTemplateDescription() {
        return "if (expr) { ... }" + (this.withElse ? " else { ... }" : "");
    }
}

