/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0011\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0011\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007\u0012\u0013\b\u0002\u0010\n\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0\u0007\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u00002\b\u0010\"\u001a\u0004\u0018\u00010#H&\u00a2\u0006\u0002\u0010$J'\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u00002\u0006\u0010%\u001a\u00020&2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0014J\u0013\u0010+\u001a\u00020\u001d2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\r\u0010.\u001a\u00070\b\u00a2\u0006\u0002\b\u000bH\u0016J\u001d\u0010/\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u00100J\u001d\u0010/\u001a\u0004\u0018\u00018\u00002\u0006\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u00103J\u000b\u00104\u001a\u00070\b\u00a2\u0006\u0002\b\tJ#\u00105\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010)\u001a\u00020*H\u0086\u0002J\u001d\u00106\u001a\u00020\u001d2\u0006\u0010!\u001a\u00028\u00002\u0006\u00107\u001a\u000202H&\u00a2\u0006\u0002\u00108J\u001e\u00109\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020*J\u0015\u0010:\u001a\u00020\u001d2\u0006\u0010;\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010<J\u0018\u0010=\u001a\u00020 2\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0004J\u001b\u0010>\u001a\u00020 2\u0011\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007H\u0004J\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0002H\u0014J\b\u0010@\u001a\u00020\u001dH\u0016J\b\u0010A\u001a\u00020\bH\u0016J\b\u0010B\u001a\u00020\u001dH\u0014R\u0019\u0010\r\u001a\u00070\b\u00a2\u0006\u0002\b\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u00078\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\n\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000b0\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00162\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00168\u0006@@X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001eR\u001d\u0010\u0006\u001a\r\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "TElement", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "elementType", "Ljava/lang/Class;", "textGetter", "Lkotlin/Function0;", "", "Lcom/intellij/codeInspection/util/IntentionName;", "familyNameGetter", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "(Ljava/lang/Class;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "defaultText", "getDefaultText", "()Ljava/lang/String;", "defaultTextGetter", "getDefaultTextGetter", "()Lkotlin/jvm/functions/Function0;", "getElementType", "()Ljava/lang/Class;", "<set-?>", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/IntentionBasedInspection;", "inspection", "getInspection", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/IntentionBasedInspection;", "setInspection$kotlin_code_insight_api", "(Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/IntentionBasedInspection;)V", "isKotlinOnlyIntention", "", "()Z", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "checkFile", "file", "Lcom/intellij/psi/PsiFile;", "equals", "other", "", "getFamilyName", "getTarget", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiElement;", "offset", "", "(ILcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiElement;", "getText", "invoke", "isApplicableTo", "caretOffset", "(Lcom/intellij/psi/PsiElement;I)Z", "isAvailable", "preparePsiElementForWriteIfNeeded", "target", "(Lcom/intellij/psi/PsiElement;)Z", "setFamilyNameGetter", "setTextGetter", "skipProcessingFurtherElementsAfter", "startInWriteAction", "toString", "visitTargetTypeOnlyOnce", "kotlin.code-insight.api"})
@SourceDebugExtension(value={"SMAP\nSelfTargetingIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelfTargetingIntention.kt\norg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,161:1\n76#2:162\n76#2:163\n*S KotlinDebug\n*F\n+ 1 SelfTargetingIntention.kt\norg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention\n*L\n113#1:162\n119#1:163\n*E\n"})
public abstract class SelfTargetingIntention<TElement extends PsiElement>
implements IntentionAction {
    @NotNull
    private final Class<TElement> elementType;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private Function0<String> textGetter;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private Function0<String> familyNameGetter;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Function0<String> defaultTextGetter;
    private final boolean isKotlinOnlyIntention;
    @FileModifier.SafeFieldForPreview
    @Nullable
    private IntentionBasedInspection<TElement> inspection;

    public SelfTargetingIntention(@NotNull Class<TElement> elementType, @NotNull Function0<String> textGetter, @NotNull Function0<String> familyNameGetter) {
        Intrinsics.checkNotNullParameter(elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        Intrinsics.checkNotNullParameter(familyNameGetter, (String)"familyNameGetter");
        this.elementType = elementType;
        this.textGetter = textGetter;
        this.familyNameGetter = familyNameGetter;
        this.defaultTextGetter = this.textGetter;
        this.isKotlinOnlyIntention = true;
    }

    public /* synthetic */ SelfTargetingIntention(Class clazz, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function02 = function0;
        }
        this(clazz, (Function0<String>)function0, (Function0<String>)function02);
    }

    @NotNull
    public final Class<TElement> getElementType() {
        return this.elementType;
    }

    @NotNull
    protected final String getDefaultText() {
        return (String)this.defaultTextGetter.invoke();
    }

    @NotNull
    protected final Function0<String> getDefaultTextGetter() {
        return this.defaultTextGetter;
    }

    protected final void setTextGetter(@NotNull Function0<String> textGetter) {
        Intrinsics.checkNotNullParameter(textGetter, (String)"textGetter");
        this.textGetter = textGetter;
    }

    @NotNull
    public final String getText() {
        return (String)this.textGetter.invoke();
    }

    @NotNull
    public String getFamilyName() {
        return (String)this.familyNameGetter.invoke();
    }

    protected final void setFamilyNameGetter(@Nls @NotNull Function0<String> familyNameGetter) {
        Intrinsics.checkNotNullParameter(familyNameGetter, (String)"familyNameGetter");
        this.familyNameGetter = familyNameGetter;
    }

    public abstract boolean isApplicableTo(@NotNull TElement var1, int var2);

    public abstract void applyTo(@NotNull TElement var1, @Nullable Editor var2);

    public void applyTo(@NotNull TElement element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.applyTo(element3, editor2);
    }

    protected boolean isKotlinOnlyIntention() {
        return this.isKotlinOnlyIntention;
    }

    protected boolean checkFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return BaseIntentionAction.canModify((PsiElement)((PsiElement)file2));
    }

    @Nullable
    public final TElement getTarget(int offset2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.checkFile(file2)) {
            return null;
        }
        PsiElement leaf1 = file2.findElementAt(offset2);
        PsiElement leaf2 = file2.findElementAt(offset2 - 1);
        PsiElement commonParent = leaf1 != null && leaf2 != null ? PsiTreeUtil.findCommonParent((PsiElement)leaf1, (PsiElement)leaf2) : null;
        Sequence elementsToCheck = SequencesKt.emptySequence();
        if (leaf1 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)leaf1), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;
                {
                    this.$commonParent = $commonParent;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$commonParent);
                }
            })));
        }
        if (leaf2 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)leaf2), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;
                {
                    this.$commonParent = $commonParent;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it, (Object)this.$commonParent);
                }
            })));
        }
        if (commonParent != null && !(commonParent instanceof PsiFile)) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)PsiUtilsKt.getParentsWithSelf((PsiElement)commonParent));
        }
        for (PsiElement element3 : elementsToCheck) {
            if (this.elementType.isInstance(element3)) {
                ProgressManager.checkCanceled();
                Intrinsics.checkNotNull((Object)element3, (String)"null cannot be cast to non-null type TElement of org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention");
                if (this.isApplicableTo(element3, offset2)) {
                    return (TElement)element3;
                }
                if (this.visitTargetTypeOnlyOnce()) {
                    return null;
                }
            }
            TextRange textRange = element3.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
            if (!PsiUtilsKt.containsInside((TextRange)textRange, (int)offset2) || !this.skipProcessingFurtherElementsAfter(element3)) continue;
            break;
        }
        return null;
    }

    @Nullable
    public final TElement getTarget(@NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.isKotlinOnlyIntention() && !(file2 instanceof KtFile)) {
            return null;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        return this.getTarget(offset2, file2);
    }

    protected boolean skipProcessingFurtherElementsAfter(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtBlockExpression;
    }

    protected boolean visitTargetTypeOnlyOnce() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT((boolean)true);
        }
        try {
            boolean bl = this.getTarget(editor2, file2) != null;
            return bl;
        }
        finally {
            boolean $i$f$isUnitTestMode2 = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT((boolean)false);
            }
        }
    }

    @Nullable
    public final IntentionBasedInspection<TElement> getInspection() {
        return this.inspection;
    }

    public final void setInspection$kotlin_code_insight_api(@Nullable IntentionBasedInspection<TElement> intentionBasedInspection) {
        this.inspection = intentionBasedInspection;
    }

    public final void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (editor2 == null) {
            return;
        }
        TElement TElement = this.getTarget(editor2, file2);
        if (TElement == null) {
            return;
        }
        TElement target2 = TElement;
        if (!this.preparePsiElementForWriteIfNeeded(target2)) {
            return;
        }
        this.applyTo(target2, project2, editor2);
    }

    protected boolean preparePsiElementForWriteIfNeeded(@NotNull TElement target2) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        if (this.startInWriteAction()) {
            return true;
        }
        return FileModificationService.getInstance().preparePsiElementForWrite(target2);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    public boolean equals(@Nullable Object other2) {
        if (other2 instanceof IntentionWrapper) {
            return Intrinsics.areEqual((Object)this, (Object)((IntentionWrapper)other2).getAction());
        }
        if (other2 instanceof IntentionBasedInspection.IntentionBasedQuickFix) {
            return Intrinsics.areEqual((Object)this, ((IntentionBasedInspection.IntentionBasedQuickFix)((Object)other2)).getIntention());
        }
        return other2 instanceof SelfTargetingIntention && Intrinsics.areEqual(this.getClass(), other2.getClass()) && Intrinsics.areEqual((Object)this.getText(), (Object)((SelfTargetingIntention)other2).getText());
    }
}

