/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiShortNamesCache;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.caches.KotlinShortNamesCache;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsNoResolveKt;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.PsiUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000bH\u0002J.\u0010\u0015\u001a\u00020\u00122\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120\u000b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u000bJ$\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00120\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/AllClassesCompletion;", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "kotlinIndicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "prefixMatcher", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "kindFilter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "", "includeTypeAliases", "includeJavaClassesNotToBeUsed", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lcom/intellij/codeInsight/completion/PrefixMatcher;Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;Lkotlin/jvm/functions/Function1;ZZ)V", "addAdaptedJavaCompletion", "", "collector", "Lcom/intellij/psi/PsiClass;", "collect", "classifierDescriptorCollector", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "javaClassCollector", "collectClassesFromScope", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isNotToBeUsed", "javaClass", "kotlin.completion.impl-k1"})
@SourceDebugExtension(value={"SMAP\nAllClassesCompletion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllClassesCompletion.kt\norg/jetbrains/kotlin/idea/completion/AllClassesCompletion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,106:1\n1282#2,2:107\n*S KotlinDebug\n*F\n+ 1 AllClassesCompletion.kt\norg/jetbrains/kotlin/idea/completion/AllClassesCompletion\n*L\n75#1:107,2\n*E\n"})
public final class AllClassesCompletion {
    @NotNull
    private final CompletionParameters parameters;
    @NotNull
    private final KotlinIndicesHelper kotlinIndicesHelper;
    @NotNull
    private final PrefixMatcher prefixMatcher;
    @NotNull
    private final ResolutionFacade resolutionFacade;
    @NotNull
    private final Function1<ClassKind, Boolean> kindFilter;
    private final boolean includeTypeAliases;
    private final boolean includeJavaClassesNotToBeUsed;

    public AllClassesCompletion(@NotNull CompletionParameters parameters2, @NotNull KotlinIndicesHelper kotlinIndicesHelper, @NotNull PrefixMatcher prefixMatcher, @NotNull ResolutionFacade resolutionFacade2, @NotNull Function1<? super ClassKind, Boolean> kindFilter, boolean includeTypeAliases, boolean includeJavaClassesNotToBeUsed) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)kotlinIndicesHelper, (String)"kotlinIndicesHelper");
        Intrinsics.checkNotNullParameter((Object)prefixMatcher, (String)"prefixMatcher");
        Intrinsics.checkNotNullParameter((Object)resolutionFacade2, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter(kindFilter, (String)"kindFilter");
        this.parameters = parameters2;
        this.kotlinIndicesHelper = kotlinIndicesHelper;
        this.prefixMatcher = prefixMatcher;
        this.resolutionFacade = resolutionFacade2;
        this.kindFilter = kindFilter;
        this.includeTypeAliases = includeTypeAliases;
        this.includeJavaClassesNotToBeUsed = includeJavaClassesNotToBeUsed;
    }

    public final void collect(@NotNull Function1<? super ClassifierDescriptorWithTypeParameters, Unit> classifierDescriptorCollector, @NotNull Function1<? super PsiClass, Unit> javaClassCollector) {
        Intrinsics.checkNotNullParameter(classifierDescriptorCollector, (String)"classifierDescriptorCollector");
        Intrinsics.checkNotNullParameter(javaClassCollector, (String)"javaClassCollector");
        for (PackageViewDescriptor builtInPackage : this.resolutionFacade.getModuleDescriptor().getBuiltIns().getBuiltInPackagesImportedByDefault()) {
            this.collectClassesFromScope(builtInPackage.getMemberScope(), (Function1<? super ClassDescriptor, Unit>)((Function1)new Function1<ClassDescriptor, Unit>(classifierDescriptorCollector){
                final /* synthetic */ Function1<ClassifierDescriptorWithTypeParameters, Unit> $classifierDescriptorCollector;
                {
                    this.$classifierDescriptorCollector = $classifierDescriptorCollector;
                    super(1);
                }

                public final void invoke(@NotNull ClassDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it.getContainingDeclaration() instanceof ClassDescriptor) {
                        this.$classifierDescriptorCollector.invoke((Object)it);
                    }
                }
            }));
        }
        KotlinIndicesHelper.processKotlinClasses$default(this.kotlinIndicesHelper, (Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ AllClassesCompletion this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AllClassesCompletion.access$getPrefixMatcher$p(this.this$0).prefixMatches(it);
            }
        }, null, this.kindFilter, classifierDescriptorCollector, 2, null);
        if (this.includeTypeAliases) {
            this.kotlinIndicesHelper.processTopLevelTypeAliases(CompletionUtilsKt.asStringNameFilter(this.prefixMatcher), classifierDescriptorCollector);
        }
        PsiFile psiFile2 = this.parameters.getOriginalFile();
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        if (JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)((KtFile)psiFile2)))) {
            this.addAdaptedJavaCompletion(javaClassCollector);
        }
    }

    private final void collectClassesFromScope(MemberScope scope2, Function1<? super ClassDescriptor, Unit> collector2) {
        for (DeclarationDescriptor descriptor2 : MemberScopeKt.getDescriptorsFiltered$default((MemberScope)scope2, (DescriptorKindFilter)DescriptorKindFilter.CLASSIFIERS, null, (int)2, null)) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            ClassKind classKind = ((ClassDescriptor)descriptor2).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)classKind, (String)"descriptor.kind");
            if (((Boolean)this.kindFilter.invoke((Object)classKind)).booleanValue() && this.prefixMatcher.prefixMatches(((ClassDescriptor)descriptor2).getName().asString())) {
                collector2.invoke((Object)descriptor2);
            }
            MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue((Object)memberScope2, (String)"descriptor.unsubstitutedInnerClassesScope");
            this.collectClassesFromScope(memberScope2, collector2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addAdaptedJavaCompletion(Function1<? super PsiClass, Unit> collector2) {
        Object object;
        KotlinShortNamesCache shortNamesCache;
        Object object2;
        Object object3;
        block4: {
            Object[] $this$firstOrNull$iv = PsiShortNamesCache.EP_NAME.getExtensions((AreaInstance)this.parameters.getEditor().getProject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiShortNamesCache it = (PsiShortNamesCache)element$iv;
                boolean bl = false;
                if (!(it instanceof KotlinShortNamesCache)) continue;
                object3 = element$iv;
                break block4;
            }
            object3 = null;
        }
        if ((object2 = (shortNamesCache = (KotlinShortNamesCache)((Object)object3))) != null && (object2 = ((KotlinShortNamesCache)((Object)object2)).getDisableSearch()) != null) {
            ((ThreadLocal)object2).set(true);
        }
        try {
            AllClassesGetter.processJavaClasses((CompletionParameters)this.parameters, (PrefixMatcher)this.prefixMatcher, (boolean)true, arg_0 -> AllClassesCompletion.addAdaptedJavaCompletion$lambda$1((Function1)new Function1<PsiClass, Unit>(this, collector2){
                final /* synthetic */ AllClassesCompletion this$0;
                final /* synthetic */ Function1<PsiClass, Unit> $collector;
                {
                    this.this$0 = $receiver;
                    this.$collector = $collector;
                    super(1);
                }

                public final void invoke(PsiClass psiClass2) {
                    PsiClass psiClass3 = psiClass2;
                    Intrinsics.checkNotNull((Object)psiClass3);
                    if (!(psiClass3 instanceof KtLightClass)) {
                        ClassKind kind2;
                        if (PsiUtilsKt.isSyntheticKotlinClass(psiClass2)) {
                            return;
                        }
                        ClassKind classKind = psiClass2.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : (psiClass2.isInterface() ? ClassKind.INTERFACE : (kind2 = psiClass2.isEnum() ? ClassKind.ENUM_CLASS : ClassKind.CLASS));
                        if (((Boolean)AllClassesCompletion.access$getKindFilter$p(this.this$0).invoke((Object)kind2)).booleanValue() && !AllClassesCompletion.access$isNotToBeUsed(this.this$0, psiClass2)) {
                            this.$collector.invoke((Object)psiClass2);
                        }
                    }
                }
            }, arg_0));
            object = shortNamesCache;
            if (object == null || (object = object.getDisableSearch()) == null) return;
        }
        catch (Throwable throwable) {
            Object object4 = shortNamesCache;
            if (object4 == null || (object4 = object4.getDisableSearch()) == null) throw throwable;
            ((ThreadLocal)object4).set(false);
            throw throwable;
        }
        ((ThreadLocal)object).set(false);
    }

    private final boolean isNotToBeUsed(PsiClass javaClass) {
        FqName fqName2;
        if (this.includeJavaClassesNotToBeUsed) {
            return false;
        }
        FqName fqName3 = fqName2 = JavaPsiUtils.getKotlinFqName((PsiElement)javaClass);
        return fqName3 != null ? CompletionUtilsNoResolveKt.isJavaClassNotToBeUsedInKotlin(fqName3) : false;
    }

    private static final void addAdaptedJavaCompletion$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ PrefixMatcher access$getPrefixMatcher$p(AllClassesCompletion $this) {
        return $this.prefixMatcher;
    }

    public static final /* synthetic */ Function1 access$getKindFilter$p(AllClassesCompletion $this) {
        return $this.kindFilter;
    }

    public static final /* synthetic */ boolean access$isNotToBeUsed(AllClassesCompletion $this, PsiClass javaClass) {
        return $this.isNotToBeUsed(javaClass);
    }
}

