/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/AddRequiresDirectiveFacility;", "", "()V", "addModuleRequirement", "", "module", "Lcom/intellij/psi/PsiJavaModule;", "requiredName", "", "canAddModuleRequirement", "findAddingPlace", "Lcom/intellij/psi/PsiElement;", "getLBrace", "kotlin.project-configuration"})
@ApiStatus.Internal
public final class AddRequiresDirectiveFacility {
    @NotNull
    public static final AddRequiresDirectiveFacility INSTANCE = new AddRequiresDirectiveFacility();

    private AddRequiresDirectiveFacility() {
    }

    public final boolean canAddModuleRequirement(@NotNull PsiJavaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return this.getLBrace(module2) != null;
    }

    public final boolean addModuleRequirement(@NotNull PsiJavaModule module2, @NotNull String requiredName) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredName, (String)"requiredName");
        if (!module2.isValid() || !this.canAddModuleRequirement(module2) || JavaPsiUtils.findRequireDirective(module2, requiredName) != null) {
            return false;
        }
        PsiJavaParserFacade psiJavaParserFacade = JavaPsiFacade.getInstance((Project)module2.getProject()).getParserFacade();
        Intrinsics.checkNotNullExpressionValue((Object)psiJavaParserFacade, (String)"getInstance(module.project).parserFacade");
        PsiJavaParserFacade parserFacade = psiJavaParserFacade;
        PsiJavaModule psiJavaModule = parserFacade.createModuleFromText("module TempModuleName { requires " + requiredName + "; }", (PsiElement)module2);
        Intrinsics.checkNotNullExpressionValue((Object)psiJavaModule, (String)"parserFacade.createModul\u2026requiredName; }\", module)");
        PsiJavaModule tempModule = psiJavaModule;
        Iterable iterable = tempModule.getRequires();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"tempModule.requires");
        PsiRequiresStatement requiresStatement = (PsiRequiresStatement)CollectionsKt.first((Iterable)iterable);
        PsiElement psiElement2 = this.findAddingPlace(module2);
        if (psiElement2 == null) {
            return false;
        }
        PsiElement addingPlace = psiElement2;
        addingPlace.getParent().addAfter((PsiElement)requiresStatement, addingPlace);
        return true;
    }

    private final PsiElement getLBrace(PsiJavaModule module2) {
        PsiJavaModuleReferenceElement psiJavaModuleReferenceElement = module2.getNameIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)psiJavaModuleReferenceElement, (String)"module.nameIdentifier");
        PsiJavaModuleReferenceElement nameElement = psiJavaModuleReferenceElement;
        for (PsiElement element3 = nameElement.getNextSibling(); element3 != null; element3 = element3.getNextSibling()) {
            if (!PsiUtil.isJavaToken((PsiElement)element3, (IElementType)JavaTokenType.LBRACE)) continue;
            return element3;
        }
        return null;
    }

    private final PsiElement findAddingPlace(PsiJavaModule module2) {
        PsiRequiresStatement addingPlace;
        Iterable iterable = module2.getRequires();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"module.requires");
        PsiRequiresStatement psiRequiresStatement = addingPlace = (PsiRequiresStatement)CollectionsKt.lastOrNull((Iterable)iterable);
        return psiRequiresStatement != null ? (PsiElement)psiRequiresStatement : this.getLBrace(module2);
    }
}

