/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.CodeFragmentContextUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.GetterDescriptor;
import org.jetbrains.kotlin.load.java.PropertiesConventionUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0014H\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001e*\u00020\u0017H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinSourcePositionProvider;", "Lcom/intellij/debugger/engine/SourcePositionProvider;", "()V", "computeSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "descriptor", "Lcom/intellij/debugger/ui/tree/FieldDescriptor;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "nearest", "", "Lcom/intellij/debugger/ui/tree/LocalVariableDescriptor;", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/kotlin/idea/debugger/core/GetterDescriptor;", "computeSourcePositionForDeclaration", "declaringType", "Lcom/sun/jdi/ReferenceType;", "declarationSelector", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "name", "", "computeSourcePositionForPropertyDeclaration", "findClassByType", "Lcom/intellij/psi/PsiElement;", "type", "getLastSourcePosition", "getPropertyDeclarationNameVariations", "", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nKotlinSourcePositionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourcePositionProvider.kt\norg/jetbrains/kotlin/idea/debugger/KotlinSourcePositionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,190:1\n1549#2:191\n1620#2,3:192\n288#2,2:195\n1#3:197\n142#4:198\n*S KotlinDebug\n*F\n+ 1 KotlinSourcePositionProvider.kt\norg/jetbrains/kotlin/idea/debugger/KotlinSourcePositionProvider\n*L\n103#1:191\n103#1:192,3\n113#1:195,2\n168#1:198\n*E\n"})
public final class KotlinSourcePositionProvider
extends SourcePositionProvider {
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor2, @NotNull Project project2, @NotNull DebuggerContextImpl context2, boolean nearest) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getFrameProxy() == null || DumbService.Companion.isDumb(project2)) {
            return null;
        }
        NodeDescriptor nodeDescriptor = descriptor2;
        return nodeDescriptor instanceof FieldDescriptor ? this.computeSourcePosition((FieldDescriptor)descriptor2, context2, nearest) : (nodeDescriptor instanceof GetterDescriptor ? this.computeSourcePosition((GetterDescriptor)descriptor2, context2, nearest) : (nodeDescriptor instanceof LocalVariableDescriptor ? this.computeSourcePosition((LocalVariableDescriptor)descriptor2, context2, nearest) : null));
    }

    private final SourcePosition computeSourcePosition(LocalVariableDescriptor descriptor2, DebuggerContextImpl context2, boolean nearest) {
        PsiElement psiElement2 = PositionUtil.getContextElement((StackFrameContext)((StackFrameContext)context2));
        if (psiElement2 == null) {
            return null;
        }
        PsiElement place = psiElement2;
        if (!(place.getContainingFile() instanceof KtFile)) {
            return null;
        }
        PsiElement psiElement3 = CodeFragmentContextUtilsKt.getContextElement(place);
        if (psiElement3 == null) {
            return null;
        }
        PsiElement contextElement = psiElement3;
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, 2, null);
        String string2 = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.name");
        KtExpressionCodeFragment codeFragment = ktPsiFactory.createExpressionCodeFragment(string2, contextElement);
        KtExpression expression2 = codeFragment.getContentElement();
        if (expression2 instanceof KtSimpleNameExpression) {
            SourceElement sourceElement;
            VariableDescriptor declarationDescriptor;
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)expression2, BodyResolveMode.PARTIAL);
            VariableDescriptor variableDescriptor = declarationDescriptor = BindingContextUtils.extractVariableDescriptorFromReference((BindingContext)bindingContext2, (KtElement)((KtElement)expression2));
            Object object = sourceElement = variableDescriptor != null ? variableDescriptor.getSource() : null;
            if (sourceElement instanceof KotlinSourceElement) {
                PsiElement psiElement4 = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
                if (psiElement4 == null) {
                    return null;
                }
                PsiElement element3 = psiElement4;
                if (nearest) {
                    return DebuggerContextUtil.findNearest((DebuggerContextImpl)context2, (PsiElement)element3, (PsiFile)element3.getContainingFile());
                }
                return SourcePosition.createFromOffset((PsiFile)element3.getContainingFile(), (int)element3.getTextOffset());
            }
        }
        return null;
    }

    private final SourcePosition computeSourcePositionForDeclaration(String name2, ReferenceType declaringType, DebuggerContextImpl context2, boolean nearest) {
        return this.computeSourcePositionForDeclaration(declaringType, context2, nearest, (Function1<? super KtDeclaration, Boolean>)((Function1)new Function1<KtDeclaration, Boolean>(name2){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$name);
            }
        }));
    }

    private final SourcePosition computeSourcePositionForPropertyDeclaration(String name2, ReferenceType declaringType, DebuggerContextImpl context2, boolean nearest) {
        return this.computeSourcePositionForDeclaration(declaringType, context2, nearest, (Function1<? super KtDeclaration, Boolean>)((Function1)new Function1<KtDeclaration, Boolean>(name2, this){
            final /* synthetic */ String $name;
            final /* synthetic */ KotlinSourcePositionProvider this$0;
            {
                this.$name = $name;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getName(), (Object)this.$name) || CollectionsKt.contains((Iterable)KotlinSourcePositionProvider.access$getPropertyDeclarationNameVariations(this.this$0, this.$name), (Object)it.getName());
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getPropertyDeclarationNameVariations(String $this$getPropertyDeclarationNameVariations) {
        void $this$mapTo$iv$iv;
        Name name2 = Name.guessByFirstCharacter((String)$this$getPropertyDeclarationNameVariations);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"guessByFirstCharacter(this)");
        Name name3 = name2;
        Iterable $this$map$iv = PropertiesConventionUtilKt.possibleGetMethodNames((Name)name3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Name name4 = (Name)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.asString());
        }
        return (List)destination$iv$iv;
    }

    private final SourcePosition computeSourcePositionForDeclaration(ReferenceType declaringType, DebuggerContextImpl context2, boolean nearest, Function1<? super KtDeclaration, Boolean> declarationSelector) {
        Object v3;
        KtClassOrObject myClass;
        block4: {
            Project project2 = context2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
            PsiElement psiElement2 = this.findClassByType(project2, declaringType, context2);
            PsiElement psiElement3 = psiElement2 != null ? psiElement2.getNavigationElement() : null;
            KtClassOrObject ktClassOrObject = psiElement3 instanceof KtClassOrObject ? (KtClassOrObject)psiElement3 : null;
            if (ktClassOrObject == null) {
                return null;
            }
            myClass = ktClassOrObject;
            Iterable $this$firstOrNull$iv = myClass.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)declarationSelector.invoke(element$iv)).booleanValue()) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        KtDeclaration ktDeclaration = v3;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration declaration2 = ktDeclaration;
        if (nearest) {
            return DebuggerContextUtil.findNearest((DebuggerContextImpl)context2, (PsiElement)((PsiElement)declaration2), (PsiFile)myClass.getContainingFile());
        }
        return SourcePosition.createFromOffset((PsiFile)declaration2.getContainingFile(), (int)declaration2.getTextOffset());
    }

    private final SourcePosition computeSourcePosition(FieldDescriptor descriptor2, DebuggerContextImpl context2, boolean nearest) {
        String fieldName;
        block3: {
            block2: {
                fieldName = descriptor2.getField().name();
                if (Intrinsics.areEqual((Object)fieldName, (Object)"this$0") || Intrinsics.areEqual((Object)fieldName, (Object)"receiver$0")) break block2;
                Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
                if (!StringsKt.startsWith$default((String)fieldName, (String)"this_", (boolean)false, (int)2, null)) break block3;
            }
            return null;
        }
        ReferenceType referenceType = descriptor2.getField().declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"descriptor.field.declaringType()");
        return this.computeSourcePositionForDeclaration(fieldName, referenceType, context2, nearest);
    }

    private final SourcePosition computeSourcePosition(GetterDescriptor descriptor2, DebuggerContextImpl context2, boolean nearest) {
        String name2 = descriptor2.getName();
        ReferenceType type2 = descriptor2.getGetter().declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type");
        SourcePosition sourcePosition2 = this.computeSourcePositionForPropertyDeclaration(name2, type2, context2, nearest);
        if (sourcePosition2 != null) {
            SourcePosition it = sourcePosition2;
            boolean bl = false;
            return it;
        }
        if (type2 instanceof ClassType) {
            List interfaces = CollectionsKt.distinct((Iterable)SafeUtilKt.safeAllInterfaces((ClassType)type2));
            for (InterfaceType intf : interfaces) {
                SourcePosition sourcePosition3 = this.computeSourcePositionForPropertyDeclaration(name2, intf, context2, nearest);
                if (sourcePosition3 == null) continue;
                SourcePosition it = sourcePosition3;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final PsiElement findClassByType(Project project2, ReferenceType type2, DebuggerContextImpl context2) {
        PsiElement element3;
        DebuggerSession session = context2.getDebuggerSession();
        DebuggerSession debuggerSession = session;
        if (debuggerSession == null || (debuggerSession = debuggerSession.getSearchScope()) == null) {
            debuggerSession = GlobalSearchScope.allScope((Project)project2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)debuggerSession, (String)"session?.searchScope ?: \u2026chScope.allScope(project)");
        DebuggerSession scope2 = debuggerSession;
        String string2 = JvmClassName.byInternalName((String)type2.name()).getFqNameForClassNameWithoutDollars().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"byInternalName(type.name\u2026WithoutDollars.asString()");
        String className = string2;
        PsiClass myClass = JavaPsiFacade.getInstance((Project)project2).findClass(className, (GlobalSearchScope)scope2);
        if (myClass != null) {
            return (PsiElement)myClass;
        }
        SourcePosition position = this.getLastSourcePosition(type2, context2);
        if (position != null && (element3 = position.getElementAt()) != null) {
            PsiElement $this$getStrictParentOfType$iv = element3;
            boolean $i$f$getStrictParentOfType = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
        }
        return null;
    }

    private final SourcePosition getLastSourcePosition(ReferenceType type2, DebuggerContextImpl context2) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        if (debugProcess != null) {
            try {
                List<Location> locations = SafeUtilKt.safeAllLineLocations(type2);
                if (!((Collection)locations).isEmpty()) {
                    Location lastLocation = locations.get(locations.size() - 1);
                    return debugProcess.getPositionManager().getSourcePosition(lastLocation);
                }
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final /* synthetic */ List access$getPropertyDeclarationNameVariations(KotlinSourcePositionProvider $this, String $receiver) {
        return $this.getPropertyDeclarationNameVariations($receiver);
    }
}

