/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilterKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "lines", "Lcom/intellij/util/Range;", "", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;)V", "declarationPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "declarationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "getCallingExpressionLines", "getMethodName", "", "locationMatches", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "nameMatches", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nKotlinMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,138:1\n1747#2,3:139\n526#3:142\n511#3,6:143\n187#4,3:149\n*S KotlinDebug\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter\n*L\n76#1:139,3\n101#1:142\n101#1:143,6\n102#1:149,3\n*E\n"})
public class KotlinMethodFilter
implements NamedMethodFilter {
    @Nullable
    private final Range<Integer> lines;
    @NotNull
    private final CallableMemberInfo methodInfo;
    @Nullable
    private final SmartPsiElementPointer<KtDeclaration> declarationPtr;

    public KotlinMethodFilter(@Nullable KtDeclaration declaration2, @Nullable Range<Integer> lines, @NotNull CallableMemberInfo methodInfo) {
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        this.lines = lines;
        this.methodInfo = methodInfo;
        KtDeclaration ktDeclaration = declaration2;
        this.declarationPtr = ktDeclaration != null ? PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)ktDeclaration)) : null;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @Nullable Location location2, @Nullable StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        if (location2 == null || !this.nameMatches(location2, frameProxy)) {
            return false;
        }
        Object object = ReadAction.nonBlocking(() -> KotlinMethodFilter.locationMatches$lambda$0(this, process2, location2)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nonBlocking<Boolean> {\n \u2026 }.executeSynchronously()");
        return (Boolean)object;
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return this.locationMatches(process2, location2, null);
    }

    private final boolean declarationMatches(DebugProcessImpl process2, Location location2) {
        boolean bl;
        block9: {
            CompoundPositionManager compoundPositionManager = process2.getPositionManager();
            Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"process.positionManager");
            Pair pair = KotlinMethodFilterKt.access$getMethodDescriptorAndDeclaration((PositionManager)compoundPositionManager, location2);
            DeclarationDescriptor currentDescriptor = (DeclarationDescriptor)pair.component1();
            KtDeclaration currentDeclaration = (KtDeclaration)pair.component2();
            if (currentDescriptor == null || currentDeclaration == null) {
                return false;
            }
            if (!(currentDescriptor instanceof CallableMemberDescriptor)) {
                return false;
            }
            if (((CallableMemberDescriptor)currentDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                return false;
            }
            if (this.methodInfo.isInvoke()) {
                return true;
            }
            KtDeclaration ktDeclaration = this.declarationPtr;
            if (ktDeclaration == null || (ktDeclaration = (KtDeclaration)ktDeclaration.getElement()) == null) {
                return true;
            }
            KtDeclaration declaration2 = ktDeclaration;
            PsiManager psiManager2 = currentDeclaration.getManager();
            if (psiManager2.areElementsEquivalent((PsiElement)currentDeclaration, (PsiElement)declaration2)) {
                return true;
            }
            Set set2 = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)((CallableDescriptor)currentDescriptor));
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAllOverriddenDescriptors(currentDescriptor)");
            Iterable $this$any$iv = set2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor baseOfCurrent = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    Project project2 = currentDeclaration.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"currentDeclaration.project");
                    Intrinsics.checkNotNullExpressionValue((Object)baseOfCurrent, (String)"baseOfCurrent");
                    PsiElement currentBaseDeclaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(project2, (DeclarationDescriptor)baseOfCurrent);
                    if (!psiManager2.areElementsEquivalent((PsiElement)declaration2, currentBaseDeclaration)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.lines;
    }

    @NotNull
    public String getMethodName() {
        return this.methodInfo.getName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean nameMatches(Location location2, StackFrameProxyImpl frameProxy) {
        Map.Entry it;
        void $this$any$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        String targetMethodName = this.getMethodName();
        boolean isNameMangledInBytecode = this.methodInfo.isNameMangledInBytecode();
        String string2 = method2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"method.name()");
        String actualMethodName = DebuggerUtils.INSTANCE.trimIfMangledInBytecode(string2, isNameMangledInBytecode);
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)targetMethodName)) return true;
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)(targetMethodName + "$default"))) return true;
        if (DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(actualMethodName)) {
            if (Intrinsics.areEqual((Object)KotlinMethodFilterKt.access$getMethodNameInCallerFrame(frameProxy), (Object)targetMethodName)) return true;
        }
        Map<LocalVariable, ClosedRange<Location>> map2 = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method2);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = iterator3.next();
            boolean bl = false;
            if (!((ClosedRange)it2.getValue()).contains((Comparable)location2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry element$iv;
            if (!iterator2.hasNext()) return false;
            it = element$iv = iterator2.next();
            boolean bl = false;
        } while (!KotlinMethodFilterKt.access$isInlinedFromFunction((LocalVariable)it.getKey(), targetMethodName, isNameMangledInBytecode));
        return true;
    }

    private static final Boolean locationMatches$lambda$0(KotlinMethodFilter this$0, DebugProcessImpl $process, Location $location) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$process, (String)"$process");
        return this$0.declarationMatches($process, $location);
    }
}

