/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.FacetEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.EntityStorageSnapshot;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCache;
import org.jetbrains.kotlin.idea.base.util.caching.FineGrainedEntityCacheKt;
import org.jetbrains.kotlin.idea.base.util.caching.SynchronizedFineGrainedEntityCache;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettingsListener;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetModificationTracker;
import org.jetbrains.kotlin.idea.facet.KotlinFacetUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u00052\u00020\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J'\u0010\u0014\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u00152\b\u0010\u0016\u001a\u0004\u0018\u0001H\u00152\b\u0010\u0017\u001a\u0004\u0018\u0001H\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u000bH\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetSettingsProviderImpl;", "Lorg/jetbrains/kotlin/idea/base/util/caching/SynchronizedFineGrainedEntityCache;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/config/KotlinFacetSettings;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerSettingsListener;", "Lorg/jetbrains/kotlin/config/KotlinFacetSettingsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeChanged", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "calculate", "key", "checkKeyValidity", "getInitializedSettings", "module", "getSettings", "settingsChanged", "T", "oldSettings", "newSettings", "(Ljava/lang/Object;Ljava/lang/Object;)V", "subscribe", "kotlin.base.facet"})
@SourceDebugExtension(value={"SMAP\nKotlinFacetSettingsProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFacetSettingsProviderImpl.kt\norg/jetbrains/kotlin/idea/facet/KotlinFacetSettingsProviderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class KotlinFacetSettingsProviderImpl
extends SynchronizedFineGrainedEntityCache<Module, KotlinFacetSettings>
implements WorkspaceModelChangeListener,
KotlinCompilerSettingsListener,
KotlinFacetSettingsProvider {
    public KotlinFacetSettingsProviderImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, false, false, 4, null);
    }

    @Override
    @Nullable
    public KotlinFacetSettings getSettings(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Object object = KotlinFacet.Companion.get(module2);
        return object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null ? object.getSettings() : null;
    }

    @Override
    @NotNull
    public KotlinFacetSettings getInitializedSettings(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return (KotlinFacetSettings)ActionsKt.runReadAction((Function0)((Function0)new Function0<KotlinFacetSettings>(this, module2){
            final /* synthetic */ KotlinFacetSettingsProviderImpl this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super(0);
            }

            @NotNull
            public final KotlinFacetSettings invoke() {
                return (KotlinFacetSettings)this.this$0.get(this.$module);
            }
        }));
    }

    @Override
    @NotNull
    public KotlinFacetSettings calculate(@NotNull Module key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KotlinFacetSettings kotlinFacetSettings = this.getSettings(key);
        if (kotlinFacetSettings == null) {
            kotlinFacetSettings = new KotlinFacetSettings();
        }
        KotlinFacetSettings kotlinFacetSettings2 = kotlinFacetSettings;
        KotlinFacetUtils.initializeIfNeeded$default(kotlinFacetSettings2, key, null, null, null, 12, null);
        return kotlinFacetSettings2;
    }

    @Override
    protected void subscribe() {
        MessageBusConnection busConnection = this.getProject().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(WorkspaceModelTopics.CHANGED, (Object)this);
        busConnection.subscribe(KotlinCompilerSettingsListener.Companion.getTOPIC(), (Object)this);
    }

    @Override
    protected void checkKeyValidity(@NotNull Module key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (key.isDisposed()) {
            throw new AlreadyDisposedException("Module '" + key.getName() + "' is already disposed");
        }
    }

    @Override
    public <T> void settingsChanged(@Nullable T oldSettings, @Nullable T newSettings) {
        FineGrainedEntityCache.invalidate$default(this, false, 1, null);
    }

    public void beforeChanged(@NotNull VersionedStorageChange event) {
        ModuleBridge it;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List moduleChanges = event.getChanges(ModuleEntity.class);
        List facetChanges = event.getChanges(FacetEntity.class);
        if (moduleChanges.isEmpty() && facetChanges.isEmpty()) {
            return;
        }
        EntityStorageSnapshot storageBefore = event.getStorageBefore();
        EntityStorageSnapshot storageAfter = event.getStorageAfter();
        Set outdated = new LinkedHashSet();
        for (EntityChange moduleChange : moduleChanges) {
            ModuleEntity moduleEntity;
            if ((ModuleEntity)FineGrainedEntityCacheKt.oldEntity(moduleChange) == null) continue;
            if (ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)((EntityStorage)storageBefore)) == null) continue;
            boolean bl = false;
            outdated.add(it);
        }
        for (EntityChange facetChange : facetChanges) {
            Object object;
            ModuleBridge it2;
            FacetEntity facetEntity;
            Object object2 = (FacetEntity)FineGrainedEntityCacheKt.oldEntity(facetChange);
            if (object2 != null) {
                facetEntity = object2;
                it = facetEntity;
                boolean bl = false;
                object2 = KotlinFacetModificationTracker.Companion.isKotlinFacet((FacetEntity)it) ? facetEntity : null;
                if (object2 != null) {
                    FacetEntity oldKotlinFacetEntity = object2;
                    boolean bl2 = false;
                    if (ModuleEntityUtils.findModule((ModuleEntity)oldKotlinFacetEntity.getModule(), (EntityStorage)((EntityStorage)storageBefore)) != null) {
                        boolean bl3 = false;
                        outdated.add(it2);
                    }
                }
            }
            if ((object = (FacetEntity)FineGrainedEntityCacheKt.newEntity(facetChange)) == null) continue;
            facetEntity = object;
            it = facetEntity;
            boolean bl = false;
            object = KotlinFacetModificationTracker.Companion.isKotlinFacet((FacetEntity)it) ? facetEntity : null;
            if (object == null) continue;
            FacetEntity newKotlinFacetEntity = object;
            boolean bl4 = false;
            if (ModuleEntityUtils.findModule((ModuleEntity)newKotlinFacetEntity.getModule(), (EntityStorage)((EntityStorage)storageAfter)) == null) continue;
            boolean bl5 = false;
            outdated.add(it2);
        }
        FineGrainedEntityCache.invalidateKeys$default(this, outdated, null, 2, null);
    }
}

