/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.idea.formatter.CommonAlignmentStrategy;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlock;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilder;
import org.jetbrains.kotlin.idea.formatter.SyntheticKotlinBlock;
import org.jetbrains.kotlin.idea.formatter.trailingComma.TrailingCommaHelper;
import org.jetbrains.kotlin.idea.formatter.trailingComma.UtilKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001c\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eJS\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2'\u0010\u001a\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001bj\u0002` 2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002JG\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\t2'\u0010\u001a\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001bj\u0002` H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0002J\u001a\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u00112\b\u0010*\u001a\u0004\u0018\u00010+H$JN\u0010,\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bH$J\u0012\u00100\u001a\u0004\u0018\u00010.2\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020\u0011H\u0002J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H$J\u0012\u00104\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J9\u00105\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001bj\u0002` 2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0002J\n\u00109\u001a\u0004\u0018\u00010+H$J\u0010\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\u0011H$J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\b\u0010@\u001a\u00020\tH\u0002J\b\u0010A\u001a\u00020\tH$J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eH$J\u0010\u0010C\u001a\u00020=2\u0006\u0010>\u001a\u00020?H$J\u0006\u0010D\u001a\u00020EJ)\u0010F\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001bj\u0002` H\u0002J\u0010\u0010G\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010H\u001a\u00020\u0011J\b\u0010I\u001a\u00020\u0011H$J\u0006\u0010J\u001a\u00020\u0011J\u001c\u0010K\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001c\u0010M\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J$\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u001b2\u0006\u0010O\u001a\u0002072\u0006\u0010P\u001a\u000207H\u0002Jw\u0010Q\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001bj\u0002` 2\n\b\u0002\u00106\u001a\u0004\u0018\u0001072\n\b\u0002\u00108\u001a\u0004\u0018\u0001072\b\b\u0002\u0010R\u001a\u00020\u00112\u0014\b\u0002\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u001b2\u0014\b\u0002\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u001bH\u0002J9\u0010U\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001bj\u0002` 2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0002J&\u0010V\u001a\u0004\u0018\u00010\u0003*\u00020\u00032\u0006\u0010W\u001a\u00020\u00112\u0006\u0010X\u001a\u0002072\u0006\u0010P\u001a\u000207H\u0002J\u001e\u0010Y\u001a\u00020\u000f*\u00020\u000f2\b\u0010/\u001a\u0004\u0018\u00010\u001f2\u0006\u00102\u001a\u00020\u0011H\u0002J*\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010[\u001a\u00020\u000f2\b\b\u0002\u0010\\\u001a\u00020?H\u0002JL\u0010]\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\\\u001a\u00020?2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010^\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010_\u001a\u0004\u0018\u00010\u000fH\u0002J&\u0010`\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010^\u001a\u0004\u0018\u00010\u00032\b\u0010_\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\u00020\u0011*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0011*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006a"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock;", "", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacingBuilder", "Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;", "alignmentStrategy", "Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;", "overrideChildren", "Lkotlin/sequences/Sequence;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lorg/jetbrains/kotlin/idea/formatter/KotlinSpacingBuilder;Lorg/jetbrains/kotlin/idea/formatter/CommonAlignmentStrategy;Lkotlin/sequences/Sequence;)V", "mySubBlocks", "", "Lcom/intellij/formatting/ASTBlock;", "addTrailingComma", "", "getAddTrailingComma", "(Lcom/intellij/lang/ASTNode;)Z", "wrapForFirstCallInChainIsAllowed", "getWrapForFirstCallInChainIsAllowed", "buildChildren", "Lcom/intellij/formatting/Block;", "buildSubBlock", "child", "wrappingStrategy", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "childElement", "Lcom/intellij/formatting/Wrap;", "Lorg/jetbrains/kotlin/idea/formatter/WrappingStrategy;", "buildSubBlocks", "buildSubBlocksForChildNode", "childrenAlignmentStrategy", "collectBinaryExpressionChildren", "", "result", "", "createAlignmentStrategy", "alignOption", "defaultAlignment", "Lcom/intellij/formatting/Alignment;", "createBlock", "indent", "Lcom/intellij/formatting/Indent;", "wrap", "createChildIndent", "createIndentForQualifierExpression", "enforceIndentToChildren", "createSyntheticSpacingNodeBlock", "createWrapForQualifierExpression", "defaultTrailingCommaWrappingStrategy", "leftAnchor", "Lcom/intellij/psi/tree/IElementType;", "rightAnchor", "getAlignment", "getAlignmentForCaseBranch", "shouldAlignInColumns", "getChildAttributes", "Lcom/intellij/formatting/ChildAttributes;", "newChildIndex", "", "getChildrenAlignmentStrategy", "getNullAlignmentStrategy", "getSubBlocks", "getSuperChildAttributes", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getWrappingStrategy", "isInCodeChunk", "isIncomplete", "isIncompleteInSuper", "isLeaf", "splitSubBlocksOnDot", "nodeSubBlocks", "splitSubBlocksOnElvis", "thisOrPrevIsMultiLineElement", "typeOfFirstElement", "typeOfLastElement", "trailingCommaWrappingStrategy", "checkTrailingComma", "filter", "additionalCheck", "trailingCommaWrappingStrategyWithMultiLineCheck", "notDelimiterSiblingNodeInSequence", "forward", "delimiterType", "processBlock", "replaceBlock", "block", "index", "splitAtIndex", "anchor", "parentBlock", "wrapToBlock", "kotlin.formatter"})
@SourceDebugExtension(value={"SMAP\nKotlinCommonBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCommonBlock.kt\norg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,1214:1\n1#2:1215\n1549#3:1216\n1620#3,3:1217\n142#4:1220\n*S KotlinDebug\n*F\n+ 1 KotlinCommonBlock.kt\norg/jetbrains/kotlin/idea/formatter/KotlinCommonBlock\n*L\n524#1:1216\n524#1:1217,3\n700#1:1220\n*E\n"})
public abstract class KotlinCommonBlock {
    @NotNull
    private final ASTNode node;
    @NotNull
    private final CodeStyleSettings settings;
    @NotNull
    private final KotlinSpacingBuilder spacingBuilder;
    @NotNull
    private final CommonAlignmentStrategy alignmentStrategy;
    @Nullable
    private final Sequence<ASTNode> overrideChildren;
    @Nullable
    private volatile List<? extends ASTBlock> mySubBlocks;

    public KotlinCommonBlock(@NotNull ASTNode node2, @NotNull CodeStyleSettings settings2, @NotNull KotlinSpacingBuilder spacingBuilder, @NotNull CommonAlignmentStrategy alignmentStrategy, @Nullable Sequence<? extends ASTNode> overrideChildren) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacingBuilder, (String)"spacingBuilder");
        Intrinsics.checkNotNullParameter((Object)alignmentStrategy, (String)"alignmentStrategy");
        this.node = node2;
        this.settings = settings2;
        this.spacingBuilder = spacingBuilder;
        this.alignmentStrategy = alignmentStrategy;
        this.overrideChildren = overrideChildren;
    }

    public /* synthetic */ KotlinCommonBlock(ASTNode aSTNode, CodeStyleSettings codeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, CommonAlignmentStrategy commonAlignmentStrategy, Sequence sequence2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            sequence2 = null;
        }
        this(aSTNode, codeStyleSettings, kotlinSpacingBuilder, commonAlignmentStrategy, (Sequence<? extends ASTNode>)sequence2);
    }

    @NotNull
    public final TextRange getTextRange() {
        if (this.overrideChildren != null) {
            return new TextRange(((ASTNode)SequencesKt.first(this.overrideChildren)).getStartOffset(), ((ASTNode)SequencesKt.last(this.overrideChildren)).getTextRange().getEndOffset());
        }
        TextRange textRange = this.node.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"node.textRange");
        return textRange;
    }

    @NotNull
    protected abstract ASTBlock createBlock(@NotNull ASTNode var1, @NotNull CommonAlignmentStrategy var2, @Nullable Indent var3, @Nullable Wrap var4, @NotNull CodeStyleSettings var5, @NotNull KotlinSpacingBuilder var6, @Nullable Sequence<? extends ASTNode> var7);

    public static /* synthetic */ ASTBlock createBlock$default(KotlinCommonBlock kotlinCommonBlock, ASTNode aSTNode, CommonAlignmentStrategy commonAlignmentStrategy, Indent indent, Wrap wrap2, CodeStyleSettings codeStyleSettings, KotlinSpacingBuilder kotlinSpacingBuilder, Sequence sequence2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBlock");
        }
        if ((n & 0x40) != 0) {
            sequence2 = null;
        }
        return kotlinCommonBlock.createBlock(aSTNode, commonAlignmentStrategy, indent, wrap2, codeStyleSettings, kotlinSpacingBuilder, (Sequence<? extends ASTNode>)sequence2);
    }

    @NotNull
    protected abstract ASTBlock createSyntheticSpacingNodeBlock(@NotNull ASTNode var1);

    @NotNull
    protected abstract List<Block> getSubBlocks();

    @NotNull
    protected abstract ChildAttributes getSuperChildAttributes(int var1);

    protected abstract boolean isIncompleteInSuper();

    @NotNull
    protected abstract CommonAlignmentStrategy getAlignmentForCaseBranch(boolean var1);

    @Nullable
    protected abstract Alignment getAlignment();

    @NotNull
    protected abstract CommonAlignmentStrategy createAlignmentStrategy(boolean var1, @Nullable Alignment var2);

    @NotNull
    protected abstract CommonAlignmentStrategy getNullAlignmentStrategy();

    public final boolean isLeaf() {
        return this.node.getFirstChildNode() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isIncomplete() {
        if (this.isIncompleteInSuper()) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.node.getElementType(), (Object)KtNodeTypes.MODIFIER_LIST)) return false;
        ASTNode aSTNode = this.node.getTreeParent();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.CLASS_BODY)) return false;
        return true;
    }

    @NotNull
    public final List<Block> buildChildren() {
        if (this.mySubBlocks != null) {
            List<? extends ASTBlock> list2 = this.mySubBlocks;
            Intrinsics.checkNotNull(list2);
            return list2;
        }
        List<ASTBlock> nodeSubBlocks = this.buildSubBlocks();
        if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(this.node.getElementType())) {
            nodeSubBlocks = this.splitSubBlocksOnDot(nodeSubBlocks);
        } else {
            PsiElement psi2 = this.node.getPsi();
            if (psi2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)psi2).getOperationToken(), (Object)KtTokens.ELVIS)) {
                nodeSubBlocks = this.splitSubBlocksOnElvis(nodeSubBlocks);
            }
        }
        this.mySubBlocks = nodeSubBlocks;
        return nodeSubBlocks;
    }

    private final List<ASTBlock> splitSubBlocksOnDot(List<? extends ASTBlock> nodeSubBlocks) {
        ASTNode aSTNode = this.node.getTreeParent();
        boolean bl = aSTNode != null ? KotlinCommonBlockKt.access$isQualifier(aSTNode) : false;
        if (bl || KotlinCommonBlockKt.access$isCallChainWithoutWrap(this.node)) {
            return nodeSubBlocks;
        }
        int operationBlockIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p());
        if (operationBlockIndex == -1) {
            return nodeSubBlocks;
        }
        ASTBlock block2 = (ASTBlock)CollectionsKt.first(nodeSubBlocks);
        Wrap wrap2 = this.createWrapForQualifierExpression(this.node);
        boolean enforceIndentToChildren = KotlinCommonBlockKt.access$anyCallInCallChainIsWrapped(this.node);
        Indent indent = this.createIndentForQualifierExpression(enforceIndentToChildren);
        ASTBlock newBlock = this.processBlock(block2, wrap2, enforceIndentToChildren);
        return KotlinCommonBlock.splitAtIndex$default(this, this.replaceBlock(nodeSubBlocks, newBlock, 0), operationBlockIndex, indent, wrap2, null, null, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    private final ASTBlock processBlock(ASTBlock $this$processBlock, Wrap wrap2, boolean enforceIndentToChildren) {
        void it;
        Wrap wrap3;
        ASTNode currentNode = FormatterUtilKt.requireNode($this$processBlock);
        boolean enforceIndent = enforceIndentToChildren && KotlinCommonBlockKt.access$anyCallInCallChainIsWrapped(currentNode);
        Indent indent = this.createIndentForQualifierExpression(enforceIndent);
        List list2 = $this$processBlock.getSubBlocks();
        Intrinsics.checkNotNull((Object)list2, (String)"null cannot be cast to non-null type kotlin.collections.List<com.intellij.formatting.ASTBlock>");
        List subBlocks = list2;
        IElementType iElementType = currentNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"currentNode.elementType");
        IElementType elementType = iElementType;
        if (!Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.POSTFIX_EXPRESSION) && !KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(elementType)) {
            return $this$processBlock;
        }
        int index = 0;
        if (this.getWrapForFirstCallInChainIsAllowed(currentNode)) {
            wrap3 = wrap2;
            if (wrap3 == null) {
                wrap3 = this.createWrapForQualifierExpression(currentNode);
            }
        } else {
            wrap3 = null;
        }
        Wrap resultWrap = wrap3;
        ASTBlock newBlock = this.processBlock((ASTBlock)subBlocks.get(index), resultWrap, enforceIndent);
        List<ASTBlock> list3 = this.replaceBlock(subBlocks, newBlock, index);
        KotlinCommonBlock kotlinCommonBlock = this;
        boolean bl = false;
        int operationIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(subBlocks, KotlinCommonBlockKt.access$getQUALIFIED_OPERATION$p());
        return kotlinCommonBlock.wrapToBlock((List<? extends ASTBlock>)(operationIndex != -1 ? KotlinCommonBlock.splitAtIndex$default(this, (List)it, operationIndex, indent, resultWrap, null, null, 24, null) : it), currentNode, $this$processBlock);
    }

    private final List<ASTBlock> replaceBlock(List<? extends ASTBlock> $this$replaceBlock, ASTBlock block2, int index) {
        List list2;
        List $this$replaceBlock_u24lambda_u241 = list2 = CollectionsKt.toMutableList((Collection)$this$replaceBlock);
        boolean bl = false;
        $this$replaceBlock_u24lambda_u241.set(index, block2);
        return list2;
    }

    static /* synthetic */ List replaceBlock$default(KotlinCommonBlock kotlinCommonBlock, List list2, ASTBlock aSTBlock, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replaceBlock");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return kotlinCommonBlock.replaceBlock(list2, aSTBlock, n);
    }

    private final boolean getWrapForFirstCallInChainIsAllowed(ASTNode $this$wrapForFirstCallInChainIsAllowed) {
        ASTNode aSTNode = KotlinCommonBlockKt.access$unwrapQualifier($this$wrapForFirstCallInChainIsAllowed);
        if (!(aSTNode != null ? KotlinCommonBlockKt.access$isCall(aSTNode) : false)) {
            return false;
        }
        return CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).WRAP_FIRST_METHOD_IN_CALL_CHAIN || KotlinCommonBlockKt.access$receiverIsCall($this$wrapForFirstCallInChainIsAllowed);
    }

    private final Wrap createWrapForQualifierExpression(ASTNode node2) {
        return this.getWrapForFirstCallInChainIsAllowed(node2) && KotlinCommonBlockKt.access$receiverIsCall(node2) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings).METHOD_CALL_CHAIN_WRAP, (boolean)true) : null;
    }

    private final Indent createIndentForQualifierExpression(boolean enforceIndentToChildren) {
        Indent.Type indentType = CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_FOR_CHAINED_CALLS ? (enforceIndentToChildren ? Indent.Type.CONTINUATION : Indent.Type.CONTINUATION_WITHOUT_FIRST) : Indent.Type.NORMAL;
        Indent indent = Indent.getIndent((Indent.Type)indentType, (boolean)false, (boolean)enforceIndentToChildren);
        Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getIndent(\n            i\u2026dentToChildren,\n        )");
        return indent;
    }

    private final ASTBlock wrapToBlock(List<? extends ASTBlock> $this$wrapToBlock, ASTNode anchor, ASTBlock parentBlock) {
        return (ASTBlock)CollectionsKt.single(this.splitAtIndex($this$wrapToBlock, 0, null, null, anchor, parentBlock));
    }

    private final List<ASTBlock> splitAtIndex(List<? extends ASTBlock> $this$splitAtIndex, int index, Indent indent, Wrap wrap2, ASTNode anchor, ASTBlock parentBlock) {
        ASTBlock operationBlock = $this$splitAtIndex.get(index);
        Function1 createParentSyntheticSpacingBlock2 = parentBlock != null ? (Function1)new Function1<ASTNode, ASTBlock>(parentBlock){
            final /* synthetic */ ASTBlock $parentBlock;
            {
                this.$parentBlock = $parentBlock;
                super(1);
            }

            @NotNull
            public final ASTBlock invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$parentBlock;
            }
        } : (Function1)new Function1<ASTNode, ASTBlock>(this){
            final /* synthetic */ KotlinCommonBlock this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ASTBlock invoke(@NotNull ASTNode it) {
                ASTNode aSTNode;
                ASTNode parent2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ASTNode aSTNode2 = it.getTreeParent();
                if (aSTNode2 == null) {
                    aSTNode2 = KotlinCommonBlock.access$getNode$p(this.this$0);
                }
                if ((parent2 = aSTNode2).getElementType() == KtNodeTypes.OPERATION_REFERENCE) {
                    aSTNode = parent2.getTreeParent();
                    if (aSTNode == null) {
                        aSTNode = parent2;
                    }
                } else {
                    aSTNode = parent2;
                }
                ASTNode skipOperationNodeParent = aSTNode;
                return this.this$0.createSyntheticSpacingNodeBlock(skipOperationNodeParent);
            }
        };
        ASTNode aSTNode = anchor;
        if (aSTNode == null) {
            aSTNode = FormatterUtilKt.requireNode(operationBlock);
        }
        SyntheticKotlinBlock operationSyntheticBlock = new SyntheticKotlinBlock(aSTNode, $this$splitAtIndex.subList(index, $this$splitAtIndex.size()), null, indent, wrap2, this.spacingBuilder, (Function1<? super ASTNode, ? extends ASTBlock>)createParentSyntheticSpacingBlock2);
        return CollectionsKt.plus((Collection)$this$splitAtIndex.subList(0, index), (Object)operationSyntheticBlock);
    }

    static /* synthetic */ List splitAtIndex$default(KotlinCommonBlock kotlinCommonBlock, List list2, int n, Indent indent, Wrap wrap2, ASTNode aSTNode, ASTBlock aSTBlock, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: splitAtIndex");
        }
        if ((n2 & 8) != 0) {
            aSTNode = null;
        }
        if ((n2 & 0x10) != 0) {
            aSTBlock = null;
        }
        return kotlinCommonBlock.splitAtIndex(list2, n, indent, wrap2, aSTNode, aSTBlock);
    }

    private final List<ASTBlock> splitSubBlocksOnElvis(List<? extends ASTBlock> nodeSubBlocks) {
        int elvisIndex = KotlinCommonBlockKt.access$indexOfBlockWithType(nodeSubBlocks, KotlinCommonBlockKt.access$getELVIS_SET$p());
        if (elvisIndex >= 0) {
            Indent indent = CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ELVIS ? Indent.getContinuationIndent() : Indent.getNormalIndent();
            return KotlinCommonBlock.splitAtIndex$default(this, nodeSubBlocks, elvisIndex, indent, null, null, null, 24, null);
        }
        return nodeSubBlocks;
    }

    private final Indent createChildIndent(ASTNode child2) {
        ASTNode prev2;
        ASTNode childParent = child2.getTreeParent();
        IElementType iElementType = child2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"child.elementType");
        IElementType childType = iElementType;
        if (childParent != null && this.isInCodeChunk(childParent)) {
            return Indent.getNoneIndent();
        }
        if (childParent != null && childParent.getPsi() instanceof KtDeclaration && (prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child2)) != null && KtTokens.COMMENTS.contains(prev2.getElementType()) && KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(prev2, false, 2, null) == null) {
            return Indent.getNoneIndent();
        }
        for (ASTNode strategy : KotlinCommonBlockKt.access$getINDENT_RULES$p()) {
            Indent indent = strategy.getIndent(child2, this.settings);
            if (indent == null) continue;
            return indent;
        }
        if (childParent != null) {
            IElementType iElementType2 = childParent.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"childParent.elementType");
            IElementType parentType = iElementType2;
            if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST || parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
                ASTNode prev3 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(child2);
                if (!(childType != KtTokens.RPAR || prev3 != null && prev3.getElementType() == KtTokens.COMMA && KotlinCommonBlockKt.access$hasDoubleLineBreakBefore(child2))) {
                    return Indent.getNoneIndent();
                }
                return CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getContinuationWithoutFirstIndent() : Indent.getNormalIndent();
            }
            if (parentType == KtNodeTypes.TYPE_PARAMETER_LIST || parentType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                return Indent.getContinuationWithoutFirstIndent();
            }
        }
        return Indent.getNoneIndent();
    }

    private final boolean isInCodeChunk(ASTNode node2) {
        ASTNode aSTNode = node2.getTreeParent();
        if (aSTNode == null) {
            return false;
        }
        ASTNode parent2 = aSTNode;
        if (!Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.BLOCK)) {
            return false;
        }
        IElementType iElementType = parent2.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"parent.elementType");
        IElementType parentType = iElementType;
        return Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.SCRIPT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.BLOCK_CODE_FRAGMENT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.EXPRESSION_CODE_FRAGMENT) || Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.TYPE_CODE_FRAGMENT);
    }

    @NotNull
    public final ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes;
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType type2 = iElementType;
        if (this.isInCodeChunk(this.node)) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }
        if (Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.IF)) {
            ASTBlock elseBlock;
            List<? extends ASTBlock> list2 = this.mySubBlocks;
            ASTBlock aSTBlock = elseBlock = list2 != null ? (ASTBlock)CollectionsKt.getOrNull(list2, (int)newChildIndex) : null;
            if (elseBlock != null && Intrinsics.areEqual((Object)FormatterUtilKt.requireNode(elseBlock).getElementType(), (Object)KtTokens.ELSE_KEYWORD)) {
                ChildAttributes childAttributes2 = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
                Intrinsics.checkNotNullExpressionValue((Object)childAttributes2, (String)"DELEGATE_TO_NEXT_CHILD");
                return childAttributes2;
            }
        }
        if (newChildIndex > 0) {
            List<? extends ASTBlock> list3 = this.mySubBlocks;
            ASTBlock prevBlock = list3 != null ? list3.get(newChildIndex - 1) : null;
            ASTBlock aSTBlock = prevBlock;
            if (Intrinsics.areEqual((Object)(aSTBlock != null && (aSTBlock = aSTBlock.getNode()) != null ? aSTBlock.getElementType() : null), (Object)KtNodeTypes.MODIFIER_LIST)) {
                return new ChildAttributes(Indent.getNoneIndent(), null);
            }
        }
        IElementType iElementType2 = type2;
        if ((((((KotlinCommonBlockKt.access$getCODE_BLOCKS$p().contains(iElementType2) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHEN)) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.IF)) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FOR)) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHILE)) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.DO_WHILE)) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.WHEN_ENTRY)) {
            childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        } else if ((Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.TRY) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.CATCH)) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FINALLY)) {
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        } else if (KotlinCommonBlockKt.access$getQUALIFIED_EXPRESSIONS$p().contains(iElementType2)) {
            childAttributes = new ChildAttributes(Indent.getContinuationWithoutFirstIndent(), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) ? true : Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.VALUE_ARGUMENT_LIST)) {
            List<Block> subBlocks = this.getSubBlocks();
            if (newChildIndex != 1 && newChildIndex != 0 && newChildIndex < subBlocks.size()) {
                Block block2 = subBlocks.get(newChildIndex);
                childAttributes = new ChildAttributes(block2.getIndent(), block2.getAlignment());
            } else {
                Indent indent = Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.VALUE_PARAMETER_LIST) && !CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_PARAMETER_LISTS || Intrinsics.areEqual((Object)type2, (Object)KtNodeTypes.VALUE_ARGUMENT_LIST) && !CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_IN_ARGUMENT_LISTS ? Indent.getNormalIndent() : Indent.getContinuationIndent();
                childAttributes = new ChildAttributes(indent, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.DOC_COMMENT)) {
            childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.PARENTHESIZED)) {
            childAttributes = this.getSuperChildAttributes(newChildIndex);
        } else {
            List<Block> blocks2 = this.getSubBlocks();
            if (newChildIndex != 0) {
                boolean isIncomplete;
                boolean bl = isIncomplete = newChildIndex < blocks2.size() ? blocks2.get(newChildIndex - 1).isIncomplete() : this.isIncompleteInSuper();
                if (isIncomplete) {
                    Block lastInParent;
                    if (blocks2.size() == newChildIndex && !CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)this.settings).CONTINUATION_INDENT_FOR_EXPRESSION_BODIES && (lastInParent = (Block)CollectionsKt.last(blocks2)) instanceof ASTBlock) {
                        ASTNode aSTNode = ((ASTBlock)lastInParent).getNode();
                        if (KtTokens.ALL_ASSIGNMENTS.contains((IElementType)(aSTNode != null ? aSTNode.getElementType() : null))) {
                            return new ChildAttributes(Indent.getNormalIndent(), null);
                        }
                    }
                    return this.getSuperChildAttributes(newChildIndex);
                }
            }
            if (blocks2.size() > newChildIndex) {
                Block block3 = blocks2.get(newChildIndex);
                return new ChildAttributes(block3.getIndent(), block3.getAlignment());
            }
            childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        }
        return childAttributes;
    }

    private final CommonAlignmentStrategy getChildrenAlignmentStrategy() {
        CommonAlignmentStrategy commonAlignmentStrategy;
        KotlinCommonCodeStyleSettings kotlinCommonSettings = CodeStyleUtilsKt.getKotlinCommonSettings(this.settings);
        KotlinCodeStyleSettings kotlinCustomSettings = CodeStyleUtilsKt.getKotlinCustomSettings(this.settings);
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType parentType = iElementType;
        if (parentType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS;
            IElementType iElementType2 = KtNodeTypes.VALUE_PARAMETER;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"VALUE_PARAMETER");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType2, kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS);
        } else if (parentType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            boolean bl = kotlinCommonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
            IElementType iElementType3 = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"VALUE_ARGUMENT");
            commonAlignmentStrategy = KotlinCommonBlockKt.access$getAlignmentForChildInParenthesis(bl, iElementType3, kotlinCommonSettings.ALIGN_MULTILINE_METHOD_BRACKETS);
        } else {
            commonAlignmentStrategy = parentType == KtNodeTypes.WHEN ? this.getAlignmentForCaseBranch(kotlinCustomSettings.ALIGN_IN_COLUMNS_CASE_BRANCH) : (parentType == KtNodeTypes.WHEN_ENTRY ? this.alignmentStrategy : (KotlinCommonBlockKt.access$getBINARY_EXPRESSIONS$p().contains(parentType) && KotlinCommonBlockKt.access$getALIGN_FOR_BINARY_OPERATIONS$p().contains(KotlinCommonBlockKt.access$getOperationType(this.node)) ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION, this.getAlignment()) : (parentType == KtNodeTypes.SUPER_TYPE_LIST ? this.createAlignmentStrategy(kotlinCommonSettings.ALIGN_MULTILINE_EXTENDS_LIST, this.getAlignment()) : (parentType == KtNodeTypes.PARENTHESIZED ? (CommonAlignmentStrategy)new CommonAlignmentStrategy(kotlinCommonSettings){
                @Nullable
                private Alignment bracketsAlignment;
                {
                    this.bracketsAlignment = $kotlinCommonSettings.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
                }

                @Nullable
                public Alignment getAlignment(@NotNull ASTNode node2) {
                    Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                    IElementType iElementType = node2.getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
                    IElementType childNodeType = iElementType;
                    ASTNode prev2 = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(node2);
                    if (prev2 != null && prev2.getElementType() == TokenType.ERROR_ELEMENT || childNodeType == TokenType.ERROR_ELEMENT) {
                        return this.bracketsAlignment;
                    }
                    if (childNodeType == KtTokens.LPAR || childNodeType == KtTokens.RPAR) {
                        return this.bracketsAlignment;
                    }
                    return null;
                }
            } : (Intrinsics.areEqual((Object)parentType, (Object)KtNodeTypes.TYPE_CONSTRAINT_LIST) ? this.createAlignmentStrategy(true, this.getAlignment()) : this.getNullAlignmentStrategy())))));
        }
        return commonAlignmentStrategy;
    }

    private final ASTBlock buildSubBlock(ASTNode child2, CommonAlignmentStrategy alignmentStrategy, Function1<? super ASTNode, ? extends Wrap> wrappingStrategy, Sequence<? extends ASTNode> overrideChildren) {
        ASTNode operationNode;
        Wrap childWrap = (Wrap)wrappingStrategy.invoke((Object)child2);
        if (child2.getElementType() == KtNodeTypes.OPERATION_REFERENCE && (operationNode = child2.getFirstChildNode()) != null) {
            return this.createBlock(operationNode, alignmentStrategy, this.createChildIndent(child2), childWrap, this.settings, this.spacingBuilder, overrideChildren);
        }
        return this.createBlock(child2, alignmentStrategy, this.createChildIndent(child2), childWrap, this.settings, this.spacingBuilder, overrideChildren);
    }

    static /* synthetic */ ASTBlock buildSubBlock$default(KotlinCommonBlock kotlinCommonBlock, ASTNode aSTNode, CommonAlignmentStrategy commonAlignmentStrategy, Function1 function1, Sequence sequence2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSubBlock");
        }
        if ((n & 8) != 0) {
            sequence2 = null;
        }
        return kotlinCommonBlock.buildSubBlock(aSTNode, commonAlignmentStrategy, (Function1<? super ASTNode, ? extends Wrap>)function1, (Sequence<? extends ASTNode>)sequence2);
    }

    private final List<ASTBlock> buildSubBlocks() {
        Sequence sequence2;
        CommonAlignmentStrategy childrenAlignmentStrategy = this.getChildrenAlignmentStrategy();
        Function1<ASTNode, Wrap> wrappingStrategy = this.getWrappingStrategy();
        if (this.overrideChildren != null) {
            sequence2 = this.overrideChildren;
        } else if (Intrinsics.areEqual((Object)this.node.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) {
            KtBinaryExpression binaryExpression;
            PsiElement psiElement2 = this.node.getPsi();
            KtBinaryExpression ktBinaryExpression = binaryExpression = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (binaryExpression != null && KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
                sequence2 = PsiUtilsKt.children((ASTNode)this.node);
            } else {
                List binaryExpressionChildren = new ArrayList();
                this.collectBinaryExpressionChildren(this.node, binaryExpressionChildren);
                sequence2 = CollectionsKt.asSequence((Iterable)binaryExpressionChildren);
            }
        } else {
            sequence2 = PsiUtilsKt.children((ASTNode)this.node);
        }
        Sequence childNodes = sequence2;
        return SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter(childNodes, (Function1)buildSubBlocks.1.INSTANCE), (Function1)((Function1)new Function1<ASTNode, Sequence<? extends ASTBlock>>(this, childrenAlignmentStrategy, wrappingStrategy){
            final /* synthetic */ KotlinCommonBlock this$0;
            final /* synthetic */ CommonAlignmentStrategy $childrenAlignmentStrategy;
            final /* synthetic */ Function1<ASTNode, Wrap> $wrappingStrategy;
            {
                this.this$0 = $receiver;
                this.$childrenAlignmentStrategy = $childrenAlignmentStrategy;
                this.$wrappingStrategy = $wrappingStrategy;
                super(1);
            }

            @NotNull
            public final Sequence<ASTBlock> invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return KotlinCommonBlock.access$buildSubBlocksForChildNode(this.this$0, it, this.$childrenAlignmentStrategy, this.$wrappingStrategy);
            }
        })));
    }

    private final Sequence<ASTBlock> buildSubBlocksForChildNode(ASTNode node2, CommonAlignmentStrategy childrenAlignmentStrategy, Function1<? super ASTNode, ? extends Wrap> wrappingStrategy) {
        if (Intrinsics.areEqual((Object)node2.getElementType(), (Object)KtNodeTypes.FUN)) {
            // empty if block
        }
        Object[] objectArray = new ASTBlock[]{KotlinCommonBlock.buildSubBlock$default(this, node2, childrenAlignmentStrategy, wrappingStrategy, null, 8, null)};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private final void collectBinaryExpressionChildren(ASTNode node2, List<ASTNode> result2) {
        for (ASTNode child2 : PsiUtilsKt.children((ASTNode)node2)) {
            if (Intrinsics.areEqual((Object)child2.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION)) {
                this.collectBinaryExpressionChildren(child2, result2);
                continue;
            }
            result2.add(child2);
        }
    }

    private final Function1<ASTNode, Wrap> getWrappingStrategy() {
        KotlinCommonCodeStyleSettings commonSettings = CodeStyleUtilsKt.getKotlinCommonSettings(this.settings);
        IElementType iElementType = this.node.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"node.elementType");
        IElementType elementType = iElementType;
        ASTNode aSTNode = this.node.getTreeParent();
        IElementType parentElementType = aSTNode != null ? aSTNode.getElementType() : null;
        PsiElement nodePsi = this.node.getPsi();
        if (elementType == KtNodeTypes.VALUE_ARGUMENT_LIST) {
            int wrapSetting = commonSettings.CALL_PARAMETERS_WRAP;
            if (!(this.getAddTrailingComma(this.node) || wrapSetting != 1 && wrapSetting != 4)) {
                Intrinsics.checkNotNullExpressionValue((Object)nodePsi, (String)"nodePsi");
                if (!KotlinCommonBlockKt.needWrapArgumentList(nodePsi)) {
                    return getWrappingStrategy.1.INSTANCE;
                }
            }
            IElementType iElementType2 = KtNodeTypes.VALUE_ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"VALUE_ARGUMENT");
            boolean bl = this.getAddTrailingComma(this.node);
            KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
            IElementType iElementType3 = (IElementType)ktSingleValueToken;
            KtSingleValueToken ktSingleValueToken2 = KtTokens.RPAR;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken2, (String)"RPAR");
            return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(wrapSetting, iElementType2, bl, this.trailingCommaWrappingStrategyWithMultiLineCheck(iElementType3, (IElementType)ktSingleValueToken2));
        }
        if (elementType == KtNodeTypes.VALUE_PARAMETER_LIST) {
            IElementType wrapSetting = parentElementType;
            if ((Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.FUN) ? true : Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR)) ? true : Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.SECONDARY_CONSTRUCTOR)) {
                int n = commonSettings.METHOD_PARAMETERS_WRAP;
                IElementType iElementType4 = KtNodeTypes.VALUE_PARAMETER;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"VALUE_PARAMETER");
                boolean bl = this.getAddTrailingComma(this.node);
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType5 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken3 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken3, (String)"RPAR");
                return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, iElementType4, bl, this.trailingCommaWrappingStrategyWithMultiLineCheck(iElementType5, (IElementType)ktSingleValueToken3));
            }
            if (Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.FUNCTION_TYPE)) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType6 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken4 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken4, (String)"RPAR");
                return this.defaultTrailingCommaWrappingStrategy(iElementType6, (IElementType)ktSingleValueToken4);
            }
            if (Intrinsics.areEqual((Object)wrapSetting, (Object)KtNodeTypes.FUNCTION_LITERAL)) {
                PsiElement psiElement2 = nodePsi.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"nodePsi.parent");
                if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(psiElement2, this.settings)) {
                    KtSingleValueToken ktSingleValueToken = KtTokens.LBRACE;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACE");
                    IElementType iElementType7 = (IElementType)ktSingleValueToken;
                    KtSingleValueToken ktSingleValueToken5 = KtTokens.ARROW;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken5, (String)"ARROW");
                    Function1<ASTNode, Boolean> check2 = this.thisOrPrevIsMultiLineElement(iElementType7, (IElementType)ktSingleValueToken5);
                    return (Function1)new Function1<ASTNode, Wrap>(check2){
                        final /* synthetic */ Function1<ASTNode, Boolean> $check;
                        {
                            this.$check = $check;
                            super(1);
                        }

                        @Nullable
                        public final Wrap invoke(@NotNull ASTNode childElement) {
                            Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                            return KotlinCommonBlockKt.access$createWrapAlwaysIf(KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null) == null || (Boolean)this.$check.invoke((Object)childElement) != false);
                        }
                    };
                }
            }
        } else if (elementType == KtNodeTypes.FUNCTION_LITERAL) {
            Intrinsics.checkNotNullExpressionValue((Object)nodePsi, (String)"nodePsi");
            if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(nodePsi, this.settings)) {
                return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, (IElementType)KtTokens.LBRACE, (IElementType)KtTokens.ARROW, false, null, null, 28, null);
            }
        } else if (elementType == KtNodeTypes.WHEN_ENTRY) {
            Intrinsics.checkNotNullExpressionValue((Object)nodePsi, (String)"nodePsi");
            if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(nodePsi, this.settings)) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LBRACE;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACE");
                IElementType iElementType8 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken6 = KtTokens.ARROW;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken6, (String)"ARROW");
                Function1<ASTNode, Boolean> check3 = this.thisOrPrevIsMultiLineElement(iElementType8, (IElementType)ktSingleValueToken6);
                return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, null, (IElementType)KtTokens.ARROW, false, null, (Function1)new Function1<ASTNode, Boolean>(check3){
                    final /* synthetic */ Function1<ASTNode, Boolean> $check;
                    {
                        this.$check = $check;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ASTNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return KotlinCommonBlockKt.access$getSiblingWithoutWhitespaceAndComments(it, true) != null && (Boolean)this.$check.invoke((Object)it) != false;
                    }
                }, 13, null);
            }
        } else if (elementType == KtNodeTypes.DESTRUCTURING_DECLARATION) {
            Intrinsics.checkNotNull((Object)nodePsi, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
            KtDestructuringDeclaration cfr_ignored_0 = (KtDestructuringDeclaration)nodePsi;
            if (((KtDestructuringDeclaration)nodePsi).getValOrVarKeyword() == null) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType9 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken7 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken7, (String)"RPAR");
                return this.defaultTrailingCommaWrappingStrategy(iElementType9, (IElementType)ktSingleValueToken7);
            }
            if (TrailingCommaHelper.INSTANCE.trailingCommaExistsOrCanExist(nodePsi, this.settings)) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LPAR");
                IElementType iElementType10 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken8 = KtTokens.RPAR;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken8, (String)"RPAR");
                Function1<ASTNode, Boolean> check4 = this.thisOrPrevIsMultiLineElement(iElementType10, (IElementType)ktSingleValueToken8);
                return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, (IElementType)KtTokens.LPAR, (IElementType)KtTokens.RPAR, false, getWrappingStrategy.4.INSTANCE, (Function1)new Function1<ASTNode, Boolean>(check4){
                    final /* synthetic */ Function1<ASTNode, Boolean> $check;
                    {
                        this.$check = $check;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ASTNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return KotlinCommonBlockKt.access$getSiblingWithoutWhitespaceAndComments(it, true) != null && (Boolean)this.$check.invoke((Object)it) != false;
                    }
                }, 4, null);
            }
        } else {
            if (elementType == KtNodeTypes.INDICES) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACKET");
                IElementType iElementType11 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken9 = KtTokens.RBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken9, (String)"RBRACKET");
                return this.defaultTrailingCommaWrappingStrategy(iElementType11, (IElementType)ktSingleValueToken9);
            }
            if (elementType == KtNodeTypes.TYPE_PARAMETER_LIST) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LT");
                IElementType iElementType12 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken10 = KtTokens.GT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken10, (String)"GT");
                return this.defaultTrailingCommaWrappingStrategy(iElementType12, (IElementType)ktSingleValueToken10);
            }
            if (elementType == KtNodeTypes.TYPE_ARGUMENT_LIST) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LT");
                IElementType iElementType13 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken11 = KtTokens.GT;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken11, (String)"GT");
                return this.defaultTrailingCommaWrappingStrategy(iElementType13, (IElementType)ktSingleValueToken11);
            }
            if (elementType == KtNodeTypes.COLLECTION_LITERAL_EXPRESSION) {
                KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACKET");
                IElementType iElementType14 = (IElementType)ktSingleValueToken;
                KtSingleValueToken ktSingleValueToken12 = KtTokens.RBRACKET;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken12, (String)"RBRACKET");
                return this.defaultTrailingCommaWrappingStrategy(iElementType14, (IElementType)ktSingleValueToken12);
            }
            if (elementType == KtNodeTypes.SUPER_TYPE_LIST) {
                Wrap wrap2 = Wrap.createWrap((int)commonSettings.EXTENDS_LIST_WRAP, (boolean)false);
                return (Function1)new Function1<ASTNode, Wrap>(wrap2){
                    final /* synthetic */ Wrap $wrap;
                    {
                        this.$wrap = $wrap;
                        super(1);
                    }

                    @Nullable
                    public final Wrap invoke(@NotNull ASTNode childElement) {
                        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                        return childElement.getPsi() instanceof KtSuperTypeListEntry ? this.$wrap : null;
                    }
                };
            }
            if (elementType == KtNodeTypes.CLASS_BODY) {
                int n = commonSettings.ENUM_CONSTANTS_WRAP;
                IElementType iElementType15 = KtNodeTypes.ENUM_ENTRY;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType15, (String)"ENUM_ENTRY");
                return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(n, iElementType15, false, null, 12, null);
            }
            if (elementType == KtNodeTypes.MODIFIER_LIST) {
                PsiElement parent2 = this.node.getTreeParent().getPsi();
                if (parent2 instanceof KtParameter) {
                    int n = commonSettings.PARAMETER_ANNOTATION_WRAP;
                    TokenSet tokenSet = KotlinCommonBlockKt.access$getANNOTATIONS$p();
                    ASTNode aSTNode2 = this.node.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                    return KotlinCommonBlockKt.access$getWrappingStrategyForItemList(n, tokenSet, !KotlinCommonBlockKt.access$isFirstParameter(aSTNode2));
                }
                if (parent2 instanceof KtClassOrObject ? true : parent2 instanceof KtTypeAlias) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(commonSettings.CLASS_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
                if (parent2 instanceof KtNamedFunction ? true : parent2 instanceof KtSecondaryConstructor) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(commonSettings.METHOD_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
                if (parent2 instanceof KtProperty) {
                    return KotlinCommonBlockKt.getWrappingStrategyForItemList$default(((KtProperty)parent2).isLocal() ? commonSettings.VARIABLE_ANNOTATION_WRAP : commonSettings.FIELD_ANNOTATION_WRAP, KotlinCommonBlockKt.access$getANNOTATIONS$p(), false, 4, null);
                }
            } else {
                if (elementType == KtNodeTypes.VALUE_PARAMETER) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.PARAMETER_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtClassOrObject || nodePsi instanceof KtTypeAlias) {
                    return KotlinCommonBlockKt.access$wrapAfterAnnotation(commonSettings.CLASS_ANNOTATION_WRAP);
                }
                if (nodePsi instanceof KtNamedFunction || nodePsi instanceof KtSecondaryConstructor) {
                    return (Function1)new Function1<ASTNode, Wrap>(commonSettings, this){
                        final /* synthetic */ KotlinCommonCodeStyleSettings $commonSettings;
                        final /* synthetic */ KotlinCommonBlock this$0;
                        {
                            this.$commonSettings = $commonSettings;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @Nullable
                        public final Wrap invoke(@NotNull ASTNode childElement) {
                            Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                            Wrap wrap2 = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, this.$commonSettings.METHOD_ANNOTATION_WRAP);
                            if (wrap2 != null) {
                                Wrap it = wrap2;
                                boolean bl = false;
                                return it;
                            }
                            ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
                            return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.EQ) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).WRAP_EXPRESSION_BODY_FUNCTIONS, (boolean)true) : null;
                        }
                    };
                }
                if (nodePsi instanceof KtProperty) {
                    return (Function1)new Function1<ASTNode, Wrap>(nodePsi, commonSettings, this){
                        final /* synthetic */ PsiElement $nodePsi;
                        final /* synthetic */ KotlinCommonCodeStyleSettings $commonSettings;
                        final /* synthetic */ KotlinCommonBlock this$0;
                        {
                            this.$nodePsi = $nodePsi;
                            this.$commonSettings = $commonSettings;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @Nullable
                        public final Wrap invoke(@NotNull ASTNode childElement) {
                            Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                            int wrapSetting = ((KtProperty)this.$nodePsi).isLocal() ? this.$commonSettings.VARIABLE_ANNOTATION_WRAP : this.$commonSettings.FIELD_ANNOTATION_WRAP;
                            Wrap wrap2 = KotlinCommonBlockKt.access$getWrapAfterAnnotation(childElement, wrapSetting);
                            if (wrap2 != null) {
                                Wrap it = wrap2;
                                boolean bl = false;
                                return it;
                            }
                            ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
                            return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.EQ) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).ASSIGNMENT_WRAP, (boolean)true) : null;
                        }
                    };
                }
                if (nodePsi instanceof KtBinaryExpression) {
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)KtTokens.EQ)) {
                        return (Function1)new Function1<ASTNode, Wrap>(this){
                            final /* synthetic */ KotlinCommonBlock this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @Nullable
                            public final Wrap invoke(@NotNull ASTNode childElement) {
                                Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                                ASTNode aSTNode = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(childElement, false, 2, null);
                                return Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtNodeTypes.OPERATION_REFERENCE) ? Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).ASSIGNMENT_WRAP, (boolean)true) : null;
                            }
                        };
                    }
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)nodePsi).getOperationToken(), (Object)KtTokens.ELVIS)) {
                        PsiElement $this$getStrictParentOfType$iv = nodePsi;
                        boolean $i$f$getStrictParentOfType = false;
                        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtStringTemplateExpression.class, (boolean)true) == null) {
                            return (Function1)new Function1<ASTNode, Wrap>(this){
                                final /* synthetic */ KotlinCommonBlock this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Wrap invoke(@NotNull ASTNode childElement) {
                                    Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                                    if (!Intrinsics.areEqual((Object)childElement.getElementType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) return null;
                                    PsiElement psiElement2 = childElement.getPsi();
                                    KtOperationReferenceExpression ktOperationReferenceExpression = psiElement2 instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement2 : null;
                                    if (!Intrinsics.areEqual((Object)(ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getOperationSignTokenType() : null), (Object)KtTokens.ELVIS)) return null;
                                    Wrap wrap2 = Wrap.createWrap((int)CodeStyleUtilsKt.getKotlinCustomSettings((CodeStyleSettings)KotlinCommonBlock.access$getSettings$p((KotlinCommonBlock)this.this$0)).WRAP_ELVIS_EXPRESSIONS, (boolean)true);
                                    return wrap2;
                                }
                            };
                        }
                    }
                    return getWrappingStrategy.11.INSTANCE;
                }
            }
        }
        return getWrappingStrategy.12.INSTANCE;
    }

    private final Function1<ASTNode, Wrap> defaultTrailingCommaWrappingStrategy(IElementType leftAnchor, IElementType rightAnchor) {
        return (Function1)new Function1<ASTNode, Wrap>(this, leftAnchor, rightAnchor){
            final /* synthetic */ KotlinCommonBlock this$0;
            final /* synthetic */ IElementType $leftAnchor;
            final /* synthetic */ IElementType $rightAnchor;
            {
                this.this$0 = $receiver;
                this.$leftAnchor = $leftAnchor;
                this.$rightAnchor = $rightAnchor;
                super(1);
            }

            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                return (Wrap)KotlinCommonBlock.access$trailingCommaWrappingStrategyWithMultiLineCheck(this.this$0, this.$leftAnchor, this.$rightAnchor).invoke((Object)childElement);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private final boolean getAddTrailingComma(ASTNode $this$addTrailingComma) {
        block6: {
            if (UtilKt.addTrailingCommaIsAllowedFor(CodeStyleUtilsKt.getKotlinCustomSettings(this.settings), $this$addTrailingComma)) break block6;
            v0 = $this$addTrailingComma.getLastChildNode();
            if (v0 == null) ** GOTO lbl-1000
            it = v0;
            $i$a$-let-KotlinCommonBlock$addTrailingComma$1 = false;
            v1 = KotlinCommonBlockKt.getSiblingWithoutWhitespaceAndComments$default(it, false, 2, null);
            v0 = v1;
            if (v1 != null) {
                v2 = v0.getElementType();
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            if (v2 != KtTokens.COMMA) ** GOTO lbl-1000
        }
        v3 = $this$addTrailingComma.getPsi();
        if (v3 != null) {
            p0 = v3;
            $i$a$-let-KotlinCommonBlock$addTrailingComma$2 = false;
            v4 = FormatterUtilKt.isMultiline(p0);
        } else {
            v4 = false;
        }
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        return v5;
    }

    private final ASTNode notDelimiterSiblingNodeInSequence(ASTNode $this$notDelimiterSiblingNodeInSequence, boolean forward, IElementType delimiterType, IElementType typeOfLastElement) {
        ASTNode sibling = null;
        for (ASTNode element3 : SequencesKt.takeWhile((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings((ASTNode)$this$notDelimiterSiblingNodeInSequence, (boolean)forward), (Function1)notDelimiterSiblingNodeInSequence.1.INSTANCE), (Function1)((Function1)new Function1<ASTNode, Boolean>(typeOfLastElement){
            final /* synthetic */ IElementType $typeOfLastElement;
            {
                this.$typeOfLastElement = $typeOfLastElement;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it.getElementType(), (Object)this.$typeOfLastElement);
            }
        }))) {
            IElementType elementType;
            Intrinsics.checkNotNullExpressionValue((Object)element3.getElementType(), (String)"element.elementType");
            if (!forward) {
                sibling = element3;
                if (Intrinsics.areEqual((Object)elementType, (Object)delimiterType) || Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EOL_COMMENT)) continue;
                break;
            }
            if (!Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EOL_COMMENT)) break;
            sibling = element3;
        }
        return sibling;
    }

    private final Function1<ASTNode, Boolean> thisOrPrevIsMultiLineElement(IElementType typeOfFirstElement, IElementType typeOfLastElement) {
        return (Function1)new Function1<ASTNode, Boolean>(typeOfFirstElement, typeOfLastElement, this){
            final /* synthetic */ IElementType $typeOfFirstElement;
            final /* synthetic */ IElementType $typeOfLastElement;
            final /* synthetic */ KotlinCommonBlock this$0;
            {
                this.$typeOfFirstElement = $typeOfFirstElement;
                this.$typeOfLastElement = $typeOfLastElement;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ASTNode childElement) {
                Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                KtSingleValueToken delimiterType = KtTokens.COMMA;
                IElementType iElementType = childElement.getElementType();
                if ((((Intrinsics.areEqual((Object)iElementType, (Object)this.$typeOfFirstElement) ? true : Intrinsics.areEqual((Object)iElementType, (Object)this.$typeOfLastElement)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)delimiterType)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EOL_COMMENT)) ? true : KtTokens.WHITESPACES.contains(iElementType)) {
                    return false;
                }
                PsiElement psiElement2 = childElement.getPsi();
                if (psiElement2 == null) {
                    return false;
                }
                PsiElement psi2 = psiElement2;
                if (FormatterUtilKt.isMultiline(psi2)) {
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)delimiterType, (String)"delimiterType");
                ASTNode aSTNode = KotlinCommonBlock.access$notDelimiterSiblingNodeInSequence(this.this$0, childElement, false, (IElementType)delimiterType, this.$typeOfFirstElement);
                int startOffset = aSTNode != null ? aSTNode.getStartOffset() : PsiUtilsKt.getStartOffset((PsiElement)psi2);
                ASTNode aSTNode2 = KotlinCommonBlock.access$notDelimiterSiblingNodeInSequence(this.this$0, childElement, true, (IElementType)delimiterType, this.$typeOfLastElement);
                int endOffset2 = aSTNode2 != null && (aSTNode2 = aSTNode2.getPsi()) != null ? PsiUtilsKt.getEndOffset((PsiElement)aSTNode2) : PsiUtilsKt.getEndOffset((PsiElement)psi2);
                PsiElement psiElement3 = psi2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"psi.parent");
                return FormatterUtilKt.containsLineBreakInChild(psiElement3, startOffset, endOffset2);
            }
        };
    }

    private final Function1<ASTNode, Wrap> trailingCommaWrappingStrategyWithMultiLineCheck(IElementType leftAnchor, IElementType rightAnchor) {
        return KotlinCommonBlock.trailingCommaWrappingStrategy$default(this, leftAnchor, rightAnchor, true, null, this.thisOrPrevIsMultiLineElement(leftAnchor, rightAnchor), 8, null);
    }

    private final Function1<ASTNode, Wrap> trailingCommaWrappingStrategy(IElementType leftAnchor, IElementType rightAnchor, boolean checkTrailingComma, Function1<? super ASTNode, Boolean> filter2, Function1<? super ASTNode, Boolean> additionalCheck) {
        return (Function1)new Function1<ASTNode, Wrap>(filter2, checkTrailingComma, this, rightAnchor, leftAnchor, additionalCheck){
            final /* synthetic */ Function1<ASTNode, Boolean> $filter;
            final /* synthetic */ boolean $checkTrailingComma;
            final /* synthetic */ KotlinCommonBlock this$0;
            final /* synthetic */ IElementType $rightAnchor;
            final /* synthetic */ IElementType $leftAnchor;
            final /* synthetic */ Function1<ASTNode, Boolean> $additionalCheck;
            {
                this.$filter = $filter;
                this.$checkTrailingComma = $checkTrailingComma;
                this.this$0 = $receiver;
                this.$rightAnchor = $rightAnchor;
                this.$leftAnchor = $leftAnchor;
                this.$additionalCheck = $additionalCheck;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Wrap invoke(@NotNull ASTNode childElement) {
                boolean bl;
                block5: {
                    block6: {
                        block7: {
                            IElementType childElementType;
                            block4: {
                                Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
                                if (!((Boolean)this.$filter.invoke((Object)childElement)).booleanValue()) {
                                    return null;
                                }
                                IElementType iElementType = childElement.getElementType();
                                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"childElement.elementType");
                                childElementType = iElementType;
                                if (!this.$checkTrailingComma) break block4;
                                ASTNode aSTNode = childElement.getTreeParent();
                                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"childElement.treeParent");
                                if (!KotlinCommonBlock.access$getAddTrailingComma(this.this$0, aSTNode)) break block5;
                            }
                            if (this.$rightAnchor != null && this.$rightAnchor == childElementType) break block6;
                            if (this.$leftAnchor == null) break block7;
                            ASTNode aSTNode = KotlinCommonBlockKt.access$getPrevWithoutWhitespace(childElement);
                            if (this.$leftAnchor == (aSTNode != null ? aSTNode.getElementType() : null)) break block6;
                        }
                        if (!((Boolean)this.$additionalCheck.invoke((Object)childElement)).booleanValue()) break block5;
                    }
                    bl = true;
                    return KotlinCommonBlockKt.access$createWrapAlwaysIf(bl);
                }
                bl = false;
                return KotlinCommonBlockKt.access$createWrapAlwaysIf(bl);
            }
        };
    }

    static /* synthetic */ Function1 trailingCommaWrappingStrategy$default(KotlinCommonBlock kotlinCommonBlock, IElementType iElementType, IElementType iElementType2, boolean bl, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: trailingCommaWrappingStrategy");
        }
        if ((n & 1) != 0) {
            iElementType = null;
        }
        if ((n & 2) != 0) {
            iElementType2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            function1 = trailingCommaWrappingStrategy.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function12 = trailingCommaWrappingStrategy.2.INSTANCE;
        }
        return kotlinCommonBlock.trailingCommaWrappingStrategy(iElementType, iElementType2, bl, (Function1<? super ASTNode, Boolean>)function1, (Function1<? super ASTNode, Boolean>)function12);
    }

    public static final /* synthetic */ ASTNode access$getNode$p(KotlinCommonBlock $this) {
        return $this.node;
    }

    public static final /* synthetic */ Sequence access$buildSubBlocksForChildNode(KotlinCommonBlock $this, ASTNode node2, CommonAlignmentStrategy childrenAlignmentStrategy, Function1 wrappingStrategy) {
        return $this.buildSubBlocksForChildNode(node2, childrenAlignmentStrategy, (Function1<? super ASTNode, ? extends Wrap>)wrappingStrategy);
    }

    public static final /* synthetic */ CodeStyleSettings access$getSettings$p(KotlinCommonBlock $this) {
        return $this.settings;
    }

    public static final /* synthetic */ Function1 access$trailingCommaWrappingStrategyWithMultiLineCheck(KotlinCommonBlock $this, IElementType leftAnchor, IElementType rightAnchor) {
        return $this.trailingCommaWrappingStrategyWithMultiLineCheck(leftAnchor, rightAnchor);
    }

    public static final /* synthetic */ ASTNode access$notDelimiterSiblingNodeInSequence(KotlinCommonBlock $this, ASTNode $receiver, boolean forward, IElementType delimiterType, IElementType typeOfLastElement) {
        return $this.notDelimiterSiblingNodeInSequence($receiver, forward, delimiterType, typeOfLastElement);
    }

    public static final /* synthetic */ boolean access$getAddTrailingComma(KotlinCommonBlock $this, ASTNode $receiver) {
        return $this.getAddTrailingComma($receiver);
    }
}

