/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleCodeInsightCommon;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.SettingsScriptBuilder;
import org.jetbrains.kotlin.idea.projectConfiguration.RepositoryDescription;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0004J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000eJ\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u000eJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH&\u00a2\u0006\u0002\u0010\u001eJ\u001a\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u000e2\b\b\u0002\u0010!\u001a\u00020\u0019H\u0002J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u000eH\u0002R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/SettingsScriptBuilder;", "T", "Lcom/intellij/psi/PsiFile;", "", "scriptFile", "(Lcom/intellij/psi/PsiFile;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lcom/intellij/psi/PsiFile;", "addIncludedModules", "", "modules", "", "", "addMavenCentralPluginRepository", "addPluginRepository", "repository", "Lorg/jetbrains/kotlin/idea/projectConfiguration/RepositoryDescription;", "addPluginRepositoryExpression", "expression", "addResolutionStrategy", "pluginId", "appendExpressionToBlockIfAbsent", "offset", "", "build", "buildPsiFile", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/psi/PsiFile;", "findBlockBody", "blockName", "startFrom", "getOrAppendInnerBlockBody", "getOrCreatePluginManagementBody", "getOrPrependTopLevelBlockBody", "kotlin.gradle.code-insight-common"})
public abstract class SettingsScriptBuilder<T extends PsiFile> {
    @NotNull
    private final T scriptFile;
    @NotNull
    private final StringBuilder builder;

    public SettingsScriptBuilder(@NotNull T scriptFile) {
        Intrinsics.checkNotNullParameter(scriptFile, (String)"scriptFile");
        this.scriptFile = scriptFile;
        this.builder = new StringBuilder(this.scriptFile.getText());
    }

    private final int findBlockBody(String blockName, int startFrom) {
        int blockOffset = this.builder.indexOf(blockName, startFrom);
        if (blockOffset < 0) {
            return -1;
        }
        return StringsKt.indexOf$default((CharSequence)this.builder, (char)'{', (int)(blockOffset + 1), (boolean)false, (int)4, null) + 1;
    }

    static /* synthetic */ int findBlockBody$default(SettingsScriptBuilder settingsScriptBuilder, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBlockBody");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return settingsScriptBuilder.findBlockBody(string2, n);
    }

    private final int getOrPrependTopLevelBlockBody(String blockName) {
        int blockBody = SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
        if (blockBody >= 0) {
            return blockBody;
        }
        this.builder.insert(0, blockName + " {}\n");
        return SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
    }

    private final int getOrAppendInnerBlockBody(String blockName, int offset2) {
        int repositoriesBody = this.findBlockBody(blockName, offset2);
        if (repositoriesBody >= 0) {
            return repositoriesBody;
        }
        this.builder.insert(offset2, "\n" + blockName + " {}\n");
        return this.findBlockBody(blockName, offset2);
    }

    private final void appendExpressionToBlockIfAbsent(String expression2, int offset2) {
        int braceCount = 1;
        int blockEnd = offset2;
        int i2 = offset2;
        int n = StringsKt.getLastIndex((CharSequence)this.builder);
        if (i2 <= n) {
            while (true) {
                char c;
                if ((c = this.builder.charAt(i2)) == '{') {
                    ++braceCount;
                } else if (c == '}') {
                    --braceCount;
                }
                if (braceCount == 0) {
                    blockEnd = i2;
                    break;
                }
                if (i2 == n) break;
                ++i2;
            }
        }
        String string2 = this.builder.substring(offset2, blockEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.substring(offset, blockEnd)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)((Object)StringsKt.trim((CharSequence)expression2)).toString(), (boolean)false, (int)2, null)) {
            this.builder.insert(blockEnd, "\n" + expression2 + "\n");
        }
    }

    private final int getOrCreatePluginManagementBody() {
        return this.getOrPrependTopLevelBlockBody("pluginManagement");
    }

    protected final void addPluginRepositoryExpression(@NotNull String expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        int repositoriesBody = this.getOrAppendInnerBlockBody("repositories", this.getOrCreatePluginManagementBody());
        this.appendExpressionToBlockIfAbsent(expression2, repositoriesBody);
    }

    public final void addMavenCentralPluginRepository() {
        this.addPluginRepositoryExpression("mavenCentral()");
    }

    public abstract void addPluginRepository(@NotNull RepositoryDescription var1);

    public final void addResolutionStrategy(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        int resolutionStrategyBody = this.getOrAppendInnerBlockBody("resolutionStrategy", this.getOrCreatePluginManagementBody());
        int eachPluginBody = this.getOrAppendInnerBlockBody("eachPlugin", resolutionStrategyBody);
        this.appendExpressionToBlockIfAbsent(StringsKt.trimIndent((String)("\n                if (requested.id.id == \"" + pluginId + "\") {\n                    useModule(\"org.jetbrains.kotlin:kotlin-gradle-plugin:${requested.version}\")\n                }\n            ")), eachPluginBody);
    }

    public final void addIncludedModules(@NotNull List<String> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        this.builder.append(CollectionsKt.joinToString$default((Iterable)modules2, null, (CharSequence)"include ", (CharSequence)"\n", (int)0, null, (Function1)addIncludedModules.1.INSTANCE, (int)25, null));
    }

    @NotNull
    public final String build() {
        String string2 = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        return string2;
    }

    @NotNull
    public abstract T buildPsiFile(@NotNull Project var1);
}

