/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.CommonRenderers;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.IncompatibleExpectedActualClassScopesRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.LanguageFeatureMessageRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.MultiplatformDiagnosticRenderingMode;
import org.jetbrains.kotlin.diagnostics.rendering.PlatformIncompatibilityDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.base.fe10.highlighting.KotlinBaseFe10HighlightingBundle;
import org.jetbrains.kotlin.idea.highlighter.HtmlTabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.highlighter.IdeMultiplatformDiagnosticRenderingMode;
import org.jetbrains.kotlin.idea.highlighter.IdeRenderers;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataHtmlRenderer;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

public final class IdeErrorMessages {
    private static final DiagnosticFactoryToRendererMap MAP = new DiagnosticFactoryToRendererMap("IDE");

    @NlsSafe
    @NotNull
    public static String render(@NotNull UnboundDiagnostic diagnostic) {
        DiagnosticRenderer renderer2;
        if (diagnostic == null) {
            IdeErrorMessages.$$$reportNull$$$0(0);
        }
        if ((renderer2 = MAP.get(diagnostic.getFactory())) != null) {
            String string2 = renderer2.render(diagnostic);
            if (string2 == null) {
                IdeErrorMessages.$$$reportNull$$$0(1);
            }
            return string2;
        }
        String string3 = DefaultErrorMessages.render((UnboundDiagnostic)diagnostic);
        if (string3 == null) {
            IdeErrorMessages.$$$reportNull$$$0(2);
        }
        return string3;
    }

    @TestOnly
    public static boolean hasIdeSpecificMessage(@NotNull UnboundDiagnostic diagnostic) {
        if (diagnostic == null) {
            IdeErrorMessages.$$$reportNull$$$0(3);
        }
        return MAP.get(diagnostic.getFactory()) != null;
    }

    private IdeErrorMessages() {
    }

    static {
        MAP.put(Errors.TYPE_MISMATCH, KotlinBaseFe10HighlightingBundle.htmlMessage("html.type.mismatch.table.tr.td.required.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS, KotlinBaseFe10HighlightingBundle.htmlMessage("html.type.mismatch.table.tr.td.required.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_MISMATCH_DUE_TO_TYPE_PROJECTIONS, KotlinBaseFe10HighlightingBundle.htmlMessage("html.type.mismatch.table.tr.td.required.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.br.projected.type.2.restricts.use.of.br.3.html", new Object[0]), object -> {
            RenderingContext context2 = RenderingContext.of((Object[])new Object[]{object.getExpectedType(), object.getExpressionType(), object.getReceiverType(), object.getCallableDescriptor()});
            return new String[]{IdeRenderers.HTML_RENDER_TYPE.render(object.getExpectedType(), context2), IdeRenderers.HTML_RENDER_TYPE.render(object.getExpressionType(), context2), IdeRenderers.HTML_RENDER_TYPE.render(object.getReceiverType(), context2), IdeRenderers.HTML.render((DeclarationDescriptor)object.getCallableDescriptor(), context2)};
        });
        MAP.put(Errors.ASSIGN_OPERATOR_AMBIGUITY, KotlinBaseFe10HighlightingBundle.htmlMessage("html.assignment.operators.ambiguity.all.these.functions.match.ul.0.ul.table.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS, KotlinBaseFe10HighlightingBundle.htmlMessage("html.type.inference.failed.0.html", new Object[0]), IdeRenderers.HTML_TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER, KotlinBaseFe10HighlightingBundle.htmlMessage("html.type.inference.failed.0.html", new Object[0]), IdeRenderers.HTML_TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR, KotlinBaseFe10HighlightingBundle.htmlMessage("html.type.inference.failed.0.html", new Object[0]), IdeRenderers.HTML_TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER);
        MAP.put(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH, HtmlTabledDescriptorRenderer.tableForTypes(KotlinBaseFe10HighlightingBundle.message("type.inference.failed.expected.type.mismatch", new Object[0]), KotlinBaseFe10HighlightingBundle.message("required.space", new Object[0]), TabledDescriptorRenderer.TextElementType.STRONG, KotlinBaseFe10HighlightingBundle.message("found.space", new Object[0]), TabledDescriptorRenderer.TextElementType.ERROR), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED, "<html>{0}</html>", IdeRenderers.HTML_TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER);
        MAP.put(Errors.WRONG_SETTER_PARAMETER_TYPE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.setter.parameter.type.must.be.equal.to.the.type.of.the.property.table.tr.td.expected.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.WRONG_GETTER_RETURN_TYPE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.getter.return.type.must.be.equal.to.the.type.of.the.property.table.tr.td.expected.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.ITERATOR_AMBIGUITY, KotlinBaseFe10HighlightingBundle.htmlMessage("html.method.iterator.is.ambiguous.for.this.expression.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.UPPER_BOUND_VIOLATED, KotlinBaseFe10HighlightingBundle.htmlMessage("html.type.argument.is.not.within.its.bounds.table.tr.td.expected.td.td.0.td.tr.tr.td.found.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.TYPE_MISMATCH_IN_FOR_LOOP, KotlinBaseFe10HighlightingBundle.htmlMessage("html.loop.parameter.type.mismatch.table.tr.td.iterated.values.td.td.0.td.tr.tr.td.parameter.td.td.1.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.return.type.is.0.which.is.not.a.subtype.of.overridden.br.1.html", new Object[0]), IdeRenderers.HTML_RENDER_RETURN_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_WITH_ANNOTATIONS_WHITELIST);
        MAP.put(Errors.RETURN_TYPE_MISMATCH_ON_INHERITANCE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.return.types.of.inherited.members.are.incompatible.br.0.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.PROPERTY_TYPE_MISMATCH_ON_OVERRIDE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.property.type.is.0.which.is.not.a.subtype.type.of.overridden.br.1.html", new Object[0]), IdeRenderers.HTML_RENDER_RETURN_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_TYPE_MISMATCH_ON_OVERRIDE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.var.property.type.is.0.which.is.not.a.type.of.overridden.br.1.html", new Object[0]), IdeRenderers.HTML_RENDER_RETURN_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.PROPERTY_TYPE_MISMATCH_ON_INHERITANCE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.types.of.inherited.properties.are.incompatible.br.0.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_TYPE_MISMATCH_ON_INHERITANCE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.types.of.inherited.var.properties.do.not.match.br.0.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_OVERRIDDEN_BY_VAL, KotlinBaseFe10HighlightingBundle.htmlMessage("html.val.property.cannot.override.var.property.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.VAR_OVERRIDDEN_BY_VAL_BY_DELEGATION, KotlinBaseFe10HighlightingBundle.htmlMessage("html.val.property.cannot.override.var.property.br.1.html", new Object[0]), (DiagnosticParameterRenderer)IdeRenderers.HTML, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED, KotlinBaseFe10HighlightingBundle.htmlMessage("html.0.is.not.abstract.and.does.not.implement.abstract.member.br.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.ABSTRACT_CLASS_MEMBER_NOT_IMPLEMENTED, KotlinBaseFe10HighlightingBundle.htmlMessage("html.0.is.not.abstract.and.does.not.implement.abstract.base.class.member.br.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED, KotlinBaseFe10HighlightingBundle.htmlMessage("html.0.must.override.1.br.because.it.inherits.many.implementations.of.it.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT, (DiagnosticParameterRenderer)IdeRenderers.HTML);
        MAP.put(Errors.RESULT_TYPE_MISMATCH, KotlinBaseFe10HighlightingBundle.htmlMessage("html.function.return.type.mismatch.table.tr.td.expected.td.td.1.td.tr.tr.td.found.td.td.2.td.tr.table.html", new Object[0]), (DiagnosticParameterRenderer)CommonRenderers.STRING, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE, (DiagnosticParameterRenderer)IdeRenderers.HTML_RENDER_TYPE);
        MAP.put(Errors.OVERLOAD_RESOLUTION_AMBIGUITY, KotlinBaseFe10HighlightingBundle.htmlMessage("html.overload.resolution.ambiguity.all.these.functions.match.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.CALLABLE_REFERENCE_RESOLUTION_AMBIGUITY, KotlinBaseFe10HighlightingBundle.htmlMessage("html.overload.resolution.ambiguity.all.these.functions.match.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_REFERENCES);
        MAP.put(Errors.NONE_APPLICABLE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.none.of.the.following.functions.can.be.called.with.the.arguments.supplied.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.CANNOT_COMPLETE_RESOLVE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.cannot.choose.among.the.following.candidates.without.completing.type.inference.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER, KotlinBaseFe10HighlightingBundle.htmlMessage("html.unresolved.reference.br.none.of.the.following.candidates.is.applicable.because.of.receiver.type.mismatch.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY, KotlinBaseFe10HighlightingBundle.htmlMessage("html.overload.resolution.ambiguity.on.method.0.all.these.functions.match.ul.1.ul.html", new Object[0]), (DiagnosticParameterRenderer)CommonRenderers.STRING, IdeRenderers.HTML_AMBIGUOUS_CALLS);
        MAP.put(Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.property.delegate.must.have.a.0.method.none.of.the.following.functions.are.suitable.ul.1.ul.html", new Object[0]), (DiagnosticParameterRenderer)CommonRenderers.STRING, IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.DELEGATE_PD_METHOD_NONE_APPLICABLE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.0.method.may.be.missing.none.of.the.following.functions.will.be.called.ul.1.ul.html", new Object[0]), (DiagnosticParameterRenderer)CommonRenderers.STRING, IdeRenderers.HTML_NONE_APPLICABLE_CALLS);
        MAP.put(Errors.COMPATIBILITY_WARNING, KotlinBaseFe10HighlightingBundle.htmlMessage("html.candidate.resolution.will.be.changed.soon.please.use.fully.qualified.name.to.invoke.the.following.closer.candidate.explicitly.ul.0.ul.html", new Object[0]), IdeRenderers.HTML_COMPATIBILITY_CANDIDATE);
        MAP.put(ErrorsJvm.CONFLICTING_JVM_DECLARATIONS, KotlinBaseFe10HighlightingBundle.htmlMessage("html.platform.declaration.clash.0.html", new Object[0]), IdeRenderers.HTML_CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(ErrorsJvm.ACCIDENTAL_OVERRIDE, KotlinBaseFe10HighlightingBundle.htmlMessage("html.accidental.override.0.html", new Object[0]), IdeRenderers.HTML_CONFLICTING_JVM_DECLARATIONS_DATA);
        MAP.put(Errors.EXCEPTION_FROM_ANALYZER, KotlinBaseFe10HighlightingBundle.htmlMessage("html.internal.error.occurred.while.analyzing.this.expression.br.0.html", new Object[0]), IdeRenderers.HTML_THROWABLE);
        MAP.put(ErrorsJs.JSCODE_ERROR, KotlinBaseFe10HighlightingBundle.htmlMessage("html.javascript.0.html", new Object[0]), (DiagnosticParameterRenderer)JsCallDataHtmlRenderer.INSTANCE);
        MAP.put(ErrorsJs.JSCODE_WARNING, KotlinBaseFe10HighlightingBundle.htmlMessage("html.javascript.0.html", new Object[0]), (DiagnosticParameterRenderer)JsCallDataHtmlRenderer.INSTANCE);
        MAP.put(Errors.UNSUPPORTED_FEATURE, "<html>{0}</html>", (DiagnosticParameterRenderer)new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.UNSUPPORTED, true));
        MAP.put(Errors.EXPERIMENTAL_FEATURE_WARNING, "<html>{0}</html>", (DiagnosticParameterRenderer)new LanguageFeatureMessageRenderer(LanguageFeatureMessageRenderer.Type.WARNING, true));
        MAP.put(Errors.NO_ACTUAL_FOR_EXPECT, KotlinBaseFe10HighlightingBundle.htmlMessage("html.expected.0.has.no.actual.declaration.in.module.1.2.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.DECLARATION_NAME_WITH_KIND, (DiagnosticParameterRenderer)Renderers.MODULE_WITH_PLATFORM, DefaultErrorMessages.adaptGenerics1((DiagnosticParameterRenderer)new PlatformIncompatibilityDiagnosticRenderer((MultiplatformDiagnosticRenderingMode)IdeMultiplatformDiagnosticRenderingMode.INSTANCE)));
        MAP.put(Errors.ACTUAL_WITHOUT_EXPECT, KotlinBaseFe10HighlightingBundle.htmlMessage("html.0.has.no.corresponding.expected.declaration.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM, DefaultErrorMessages.adaptGenerics1((DiagnosticParameterRenderer)new PlatformIncompatibilityDiagnosticRenderer((MultiplatformDiagnosticRenderingMode)IdeMultiplatformDiagnosticRenderingMode.INSTANCE)));
        MAP.put(Errors.NO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS, KotlinBaseFe10HighlightingBundle.htmlMessage("html.actual.class.0.has.no.corresponding.members.for.expected.class.members.1.html", new Object[0]), (DiagnosticParameterRenderer)Renderers.NAME, DefaultErrorMessages.adaptGenerics2((DiagnosticParameterRenderer)new IncompatibleExpectedActualClassScopesRenderer((MultiplatformDiagnosticRenderingMode)IdeMultiplatformDiagnosticRenderingMode.INSTANCE)));
        MAP.put((DiagnosticFactory0)ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR.getErrorFactory(), KotlinBaseFe10HighlightingBundle.htmlMessage("html.method.contains.from.concurrenthashmap.may.have.unexpected.semantics.it.calls.containsvalue.instead.of.containskey.br.use.explicit.form.of.the.call.to.containskey.containsvalue.contains.or.cast.the.value.to.kotlin.collections.map.instead.br.see.https.youtrack.jetbrains.com.issue.kt.18053.for.more.details.html", new Object[0]));
        MAP.put((DiagnosticFactory0)ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR.getWarningFactory(), KotlinBaseFe10HighlightingBundle.htmlMessage("html.method.contains.from.concurrenthashmap.may.have.unexpected.semantics.it.calls.containsvalue.instead.of.containskey.br.use.explicit.form.of.the.call.to.containskey.containsvalue.contains.or.cast.the.value.to.kotlin.collections.map.instead.br.see.https.youtrack.jetbrains.com.issue.kt.18053.for.more.details.html", new Object[0]));
        MAP.setImmutable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/highlighter/IdeErrorMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/highlighter/IdeErrorMessages";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasIdeSpecificMessage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

