/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractRangeInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceRangeToWithRangeUntilInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceRangeToWithUntilInspectionKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceUntilWithRangeUntilInspection;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.idea.util.RangeKtExpressionType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AbstractReplaceRangeToWithRangeUntilInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractRangeInspection;", "()V", "visitRange", "", "range", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "type", "Lorg/jetbrains/kotlin/idea/util/RangeKtExpressionType;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "ReplaceWithUntilQuickFix", "Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithRangeUntilInspection;", "Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection;", "kotlin.idea"})
public abstract class AbstractReplaceRangeToWithRangeUntilInspection
extends AbstractRangeInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private AbstractReplaceRangeToWithRangeUntilInspection() {
        super(null, null, 3, null);
    }

    @Override
    public void visitRange(@NotNull KtExpression range2, @NotNull Lazy<? extends BindingContext> context2, @NotNull RangeKtExpressionType type2, @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
            case 4: {
            }
        }
        boolean useRangeUntil = ReplaceUntilWithRangeUntilInspection.Companion.isPossibleToUseRangeUntil((KtElement)range2, context2);
        if (useRangeUntil ^ this instanceof ReplaceRangeToWithRangeUntilInspection) {
            return;
        }
        if (!AbstractReplaceRangeToWithRangeUntilInspection.Companion.isApplicable(range2, (Lazy<? extends BindingContext>)context2, useRangeUntil)) {
            return;
        }
        String desc2 = useRangeUntil ? KotlinBundle.message("inspection.replace.range.to.with.rangeUntil.display.name", new Object[0]) : KotlinBundle.message("inspection.replace.range.to.with.until.display.name", new Object[0]);
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceWithUntilQuickFix(useRangeUntil)};
        holder.registerProblem((PsiElement)range2, desc2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
    }

    public /* synthetic */ AbstractReplaceRangeToWithRangeUntilInspection(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J&\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u000f\u001a\u00020\b*\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AbstractReplaceRangeToWithRangeUntilInspection$Companion;", "", "()V", "applyFix", "", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "useRangeUntil", "", "applyFixIfApplicable", "expression", "isApplicable", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isMinusOne", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nReplaceRangeToWithUntilInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceRangeToWithUntilInspection.kt\norg/jetbrains/kotlin/idea/inspections/AbstractReplaceRangeToWithRangeUntilInspection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void applyFixIfApplicable(@NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Lazy context2 = LazyKt.lazy((Function0)((Function0)new Function0<BindingContext>(expression2){
                final /* synthetic */ KtExpression $expression;
                {
                    this.$expression = $expression;
                    super(0);
                }

                @NotNull
                public final BindingContext invoke() {
                    return ResolutionUtils.analyze((KtElement)this.$expression, BodyResolveMode.PARTIAL_NO_ADDITIONAL);
                }
            }));
            boolean useRangeUntil = ReplaceUntilWithRangeUntilInspection.Companion.isPossibleToUseRangeUntil((KtElement)expression2, (Lazy<? extends BindingContext>)context2);
            if (this.isApplicable(expression2, (Lazy<? extends BindingContext>)context2, useRangeUntil)) {
                this.applyFix(expression2, useRangeUntil);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isApplicable(KtExpression expression2, Lazy<? extends BindingContext> context2, boolean useRangeUntil) {
            KtExpression right2;
            Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(expression2);
            if (pair == null) {
                return false;
            }
            Pair<KtExpression, KtExpression> pair2 = pair;
            KtExpression left = (KtExpression)pair2.component1();
            KtExpression ktExpression = right2 = (KtExpression)pair2.component2();
            KtExpression ktExpression2 = ktExpression;
            if (ktExpression == null) return false;
            KtExpression ktExpression3 = ReplaceRangeToWithUntilInspectionKt.access$deparenthesize(ktExpression2);
            ktExpression2 = ktExpression3;
            if (ktExpression3 == null) return false;
            if (!this.isMinusOne(ktExpression2)) return false;
            boolean bl = true;
            if (!bl) return false;
            KtExpression ktExpression4 = left;
            if (ktExpression4 == null) return false;
            boolean bl2 = Intrinsics.areEqual((Object)org.jetbrains.kotlin.idea.inspections.AbstractReplaceRangeToWithRangeUntilInspection$Companion.isApplicable$isRangeUntilOrUntilApplicable(ktExpression4, context2, useRangeUntil), (Object)true);
            if (!bl2) return false;
            Intrinsics.checkNotNullExpressionValue((Object)right2, (String)"right");
            if (!Intrinsics.areEqual((Object)org.jetbrains.kotlin.idea.inspections.AbstractReplaceRangeToWithRangeUntilInspection$Companion.isApplicable$isRangeUntilOrUntilApplicable(right2, context2, useRangeUntil), (Object)true)) return false;
            return true;
        }

        private final void applyFix(KtExpression element3, boolean useRangeUntil) {
            Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(element3);
            if (pair == null) {
                return;
            }
            Pair<KtExpression, KtExpression> args = pair;
            String operator = useRangeUntil ? "..<" : " until ";
            Project project2 = element3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            Object[] objectArray = new Object[2];
            if ((KtExpression)args.getFirst() == null) {
                Object cfr_ignored_0 = objectArray[0];
                return;
            }
            KtExpression ktExpression = (KtExpression)args.getSecond();
            Object object = ktExpression != null ? ReplaceRangeToWithUntilInspectionKt.access$deparenthesize(ktExpression) : null;
            KtBinaryExpression ktBinaryExpression = object instanceof KtBinaryExpression ? (KtBinaryExpression)object : null;
            if (ktBinaryExpression == null || (ktBinaryExpression = ktBinaryExpression.getLeft()) == null) {
                return;
            }
            objectArray[1] = ktBinaryExpression;
            element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project2, false, 2, null), (String)("$0" + operator + "$1"), (Object[])objectArray, (boolean)false, (int)4, null));
        }

        private final boolean isMinusOne(KtExpression $this$isMinusOne) {
            ConstantValue constantValue;
            if (!($this$isMinusOne instanceof KtBinaryExpression)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((KtBinaryExpression)$this$isMinusOne).getOperationToken(), (Object)KtTokens.MINUS)) {
                return false;
            }
            KtExpression ktExpression = ((KtBinaryExpression)$this$isMinusOne).getRight();
            ConstantValue constantValue2 = constantValue = ktExpression != null ? AbstractRangeInspection.Companion.constantValueOrNull$default(AbstractRangeInspection.Companion, ktExpression, null, 1, null) : null;
            Object object = constantValue2 != null ? constantValue2.getValue() : null;
            Number number2 = object instanceof Number ? (Number)((Number)object) : (Number)null;
            if (number2 == null) {
                return false;
            }
            int rightValue = number2.intValue();
            return rightValue == 1;
        }

        private static final Boolean isApplicable$isRangeUntilOrUntilApplicable(KtExpression $this$isApplicable_u24isRangeUntilOrUntilApplicable, Lazy<? extends BindingContext> $context, boolean $useRangeUntil) {
            Boolean bl;
            KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$isApplicable_u24isRangeUntilOrUntilApplicable, (BindingContext)((BindingContext)$context.getValue()));
            if (kotlinType != null) {
                KotlinType it = kotlinType;
                boolean bl2 = false;
                bl = TypeUtilsKt.isPrimitiveNumberType((KotlinType)it) && ($useRangeUntil || !TypeUtilsKt.isDouble((KotlinType)it) && !TypeUtilsKt.isFloat((KotlinType)it));
            } else {
                bl = null;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AbstractReplaceRangeToWithRangeUntilInspection$ReplaceWithUntilQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "useRangeUntil", "", "(Z)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class ReplaceWithUntilQuickFix
    implements LocalQuickFix {
        private final boolean useRangeUntil;

        public ReplaceWithUntilQuickFix(boolean useRangeUntil) {
            this.useRangeUntil = useRangeUntil;
        }

        @NotNull
        public String getName() {
            return this.useRangeUntil ? KotlinBundle.message("replace.with.rangeUntil.quick.fix.text", new Object[0]) : KotlinBundle.message("replace.with.until.quick.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            KtExpression element3 = (KtExpression)psiElement2;
            Companion.applyFix(element3, this.useRangeUntil);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RangeKtExpressionType.values().length];
            try {
                nArray[RangeKtExpressionType.UNTIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.RANGE_UNTIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.DOWN_TO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RangeKtExpressionType.RANGE_TO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

