/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.inspections.collections.SimplifiableCallInspection;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u00010\n*\u00020\rH\u0002\u00a8\u0006\u0011\u00b2\u0006\u0010\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "findConversionAndResolvedCall", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallInspection$Conversion;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Conversion", "Holder", "SimplifyCallFix", "kotlin.idea", "resolvedCall"})
public final class SimplifiableCallInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor((Function1)((Function1)new Function1<KtCallExpression, Unit>(this, holder){
            final /* synthetic */ SimplifiableCallInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtCallExpression callExpression2) {
                Intrinsics.checkNotNullParameter((Object)callExpression2, (String)"callExpression");
                KtExpression ktExpression = callExpression2.getCalleeExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression calleeExpression2 = ktExpression;
                Pair pair = SimplifiableCallInspection.access$findConversionAndResolvedCall(this.this$0, callExpression2);
                if (pair == null) {
                    return;
                }
                Pair pair2 = pair;
                Conversion conversion2 = (Conversion)pair2.component1();
                ResolvedCall resolvedCall2 = (ResolvedCall)pair2.component2();
                if (!((Boolean)conversion2.getCallChecker().invoke((Object)resolvedCall2)).booleanValue()) {
                    return;
                }
                String string2 = (String)conversion2.getAnalyzer().invoke((Object)callExpression2);
                if (string2 == null) {
                    return;
                }
                String replacement2 = string2;
                Object[] objectArray = new Object[]{conversion2.getShortName(), replacement2};
                String string3 = KotlinBundle.message("0.call.could.be.simplified.to.1", objectArray);
                objectArray = new LocalQuickFix[]{new SimplifyCallFix(conversion2.getShortName(), replacement2)};
                this.$holder.registerProblem((PsiElement)calleeExpression2, string3, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
            }
        }));
    }

    private final Pair<Conversion, ResolvedCall<?>> findConversionAndResolvedCall(KtCallExpression $this$findConversionAndResolvedCall) {
        KtExpression ktExpression = $this$findConversionAndResolvedCall.getCalleeExpression();
        String string2 = ktExpression != null ? ktExpression.getText() : null;
        if (string2 == null) {
            return null;
        }
        String calleeText = string2;
        Lazy resolvedCall$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResolvedCall<? extends CallableDescriptor>>($this$findConversionAndResolvedCall){
            final /* synthetic */ KtCallExpression $this_findConversionAndResolvedCall;
            {
                this.$this_findConversionAndResolvedCall = $receiver;
                super(0);
            }

            @Nullable
            public final ResolvedCall<? extends CallableDescriptor> invoke() {
                return ResolutionUtils.resolveToCall$default((KtElement)this.$this_findConversionAndResolvedCall, null, 1, null);
            }
        }));
        for (Conversion conversion2 : Holder.INSTANCE.getConversions()) {
            if (!Intrinsics.areEqual((Object)conversion2.getShortName(), (Object)calleeText)) continue;
            ResolvedCall<?> resolvedCall2 = SimplifiableCallInspection.findConversionAndResolvedCall$lambda$0((Lazy<? extends ResolvedCall<? extends CallableDescriptor>>)resolvedCall$delegate);
            boolean bl = resolvedCall2 != null ? FunctionUtilsKt.isCalling(resolvedCall2, conversion2.getFqName()) : false;
            if (!bl) continue;
            ResolvedCall<?> resolvedCall3 = SimplifiableCallInspection.findConversionAndResolvedCall$lambda$0((Lazy<? extends ResolvedCall<? extends CallableDescriptor>>)resolvedCall$delegate);
            Intrinsics.checkNotNull(resolvedCall3);
            return TuplesKt.to((Object)conversion2, resolvedCall3);
        }
        return null;
    }

    private static final ResolvedCall<?> findConversionAndResolvedCall$lambda$0(Lazy<? extends ResolvedCall<? extends CallableDescriptor>> $resolvedCall$delegate) {
        Lazy<? extends ResolvedCall<? extends CallableDescriptor>> lazy = $resolvedCall$delegate;
        return (ResolvedCall)lazy.getValue();
    }

    public static final /* synthetic */ Pair access$findConversionAndResolvedCall(SimplifiableCallInspection $this, KtCallExpression $receiver) {
        return $this.findConversionAndResolvedCall($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u0012\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005H\u00c6\u0003J\u0019\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003JE\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00052\u0018\b\u0002\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallInspection$Conversion;", "", "callFqName", "", "analyzer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callChecker", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getAnalyzer", "()Lkotlin/jvm/functions/Function1;", "getCallChecker", "getCallFqName", "()Ljava/lang/String;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "shortName", "getShortName", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class Conversion {
        @NotNull
        private final String callFqName;
        @NotNull
        private final Function1<KtCallExpression, String> analyzer;
        @NotNull
        private final Function1<ResolvedCall<?>, Boolean> callChecker;
        @NotNull
        private final FqName fqName;
        @NotNull
        private final String shortName;

        public Conversion(@NotNull String callFqName, @NotNull Function1<? super KtCallExpression, String> analyzer, @NotNull Function1<? super ResolvedCall<?>, Boolean> callChecker) {
            Intrinsics.checkNotNullParameter((Object)callFqName, (String)"callFqName");
            Intrinsics.checkNotNullParameter(analyzer, (String)"analyzer");
            Intrinsics.checkNotNullParameter(callChecker, (String)"callChecker");
            this.callFqName = callFqName;
            this.analyzer = analyzer;
            this.callChecker = callChecker;
            this.fqName = new FqName(this.callFqName);
            String string2 = this.fqName.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fqName.shortName().asString()");
            this.shortName = string2;
        }

        public /* synthetic */ Conversion(String string2, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function12 = 1.INSTANCE;
            }
            this(string2, (Function1<? super KtCallExpression, String>)function1, function12);
        }

        @NotNull
        public final String getCallFqName() {
            return this.callFqName;
        }

        @NotNull
        public final Function1<KtCallExpression, String> getAnalyzer() {
            return this.analyzer;
        }

        @NotNull
        public final Function1<ResolvedCall<?>, Boolean> getCallChecker() {
            return this.callChecker;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        @NotNull
        public final String getShortName() {
            return this.shortName;
        }

        @NotNull
        public final String component1() {
            return this.callFqName;
        }

        @NotNull
        public final Function1<KtCallExpression, String> component2() {
            return this.analyzer;
        }

        @NotNull
        public final Function1<ResolvedCall<?>, Boolean> component3() {
            return this.callChecker;
        }

        @NotNull
        public final Conversion copy(@NotNull String callFqName, @NotNull Function1<? super KtCallExpression, String> analyzer, @NotNull Function1<? super ResolvedCall<?>, Boolean> callChecker) {
            Intrinsics.checkNotNullParameter((Object)callFqName, (String)"callFqName");
            Intrinsics.checkNotNullParameter(analyzer, (String)"analyzer");
            Intrinsics.checkNotNullParameter(callChecker, (String)"callChecker");
            return new Conversion(callFqName, analyzer, callChecker);
        }

        public static /* synthetic */ Conversion copy$default(Conversion conversion2, String string2, Function1 function1, Function1 function12, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = conversion2.callFqName;
            }
            if ((n & 2) != 0) {
                function1 = conversion2.analyzer;
            }
            if ((n & 4) != 0) {
                function12 = conversion2.callChecker;
            }
            return conversion2.copy(string2, function1, function12);
        }

        @NotNull
        public String toString() {
            return "Conversion(callFqName=" + this.callFqName + ", analyzer=" + this.analyzer + ", callChecker=" + this.callChecker + ")";
        }

        public int hashCode() {
            int result2 = this.callFqName.hashCode();
            result2 = result2 * 31 + this.analyzer.hashCode();
            result2 = result2 * 31 + this.callChecker.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof Conversion)) {
                return false;
            }
            Conversion conversion2 = (Conversion)other2;
            if (!Intrinsics.areEqual((Object)this.callFqName, (Object)conversion2.callFqName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.analyzer, conversion2.analyzer)) {
                return false;
            }
            return Intrinsics.areEqual(this.callChecker, conversion2.callChecker);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallInspection$Holder;", "", "()V", "conversions", "", "Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallInspection$Conversion;", "getConversions", "()Ljava/util/List;", "kotlin.idea"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final List<Conversion> conversions;

        private Holder() {
        }

        @NotNull
        public final List<Conversion> getConversions() {
            return conversions;
        }

        static {
            Object[] objectArray = new Conversion[]{new Conversion("kotlin.collections.flatMap", conversions.1.INSTANCE, null, 4, null), new Conversion("kotlin.collections.filter", (Function1<? super KtCallExpression, String>)((Function1)conversions.2.INSTANCE), conversions.3.INSTANCE)};
            conversions = CollectionsKt.listOf((Object[])objectArray);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifiableCallInspection$SimplifyCallFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "conversionName", "", "replacement", "(Ljava/lang/String;Ljava/lang/String;)V", "getConversionName", "()Ljava/lang/String;", "getReplacement", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.idea"})
    private static final class SimplifyCallFix
    implements LocalQuickFix {
        @NotNull
        private final String conversionName;
        @NotNull
        private final String replacement;

        public SimplifyCallFix(@NotNull String conversionName, @NotNull String replacement2) {
            Intrinsics.checkNotNullParameter((Object)conversionName, (String)"conversionName");
            Intrinsics.checkNotNullParameter((Object)replacement2, (String)"replacement");
            this.conversionName = conversionName;
            this.replacement = replacement2;
        }

        @NotNull
        public final String getConversionName() {
            return this.conversionName;
        }

        @NotNull
        public final String getReplacement() {
            return this.replacement;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.conversionName, this.replacement};
            return KotlinBundle.message("simplify.call.fix.text", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement().getParent();
            KtCallExpression ktCallExpression = psiElement2 instanceof KtCallExpression ? (KtCallExpression)psiElement2 : null;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            callExpression2.replace((PsiElement)new KtPsiFactory(project2, false, 2, null).createExpression(this.replacement));
        }
    }
}

