/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvmDecompiler;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.KotlinDefaultHighlightingSettingsProviderKt;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.jvmDecompiler.KotlinBytecodeDecompiler;
import org.jetbrains.kotlin.idea.jvmDecompiler.KotlinJvmDecompilerBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\b\u0010\t\u001a\u00020\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompilerTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "decompiledText", "", "generateDecompiledVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateDummyRoot", "onSuccess", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "kotlin.jvm-decompiler"})
public final class KotlinBytecodeDecompilerTask
extends Task.Backgroundable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile file;
    @Nullable
    private String decompiledText;
    @NotNull
    public static final String KOTLIN_DECOMPILED_FOLDER = "kotlinDecompiled";
    @NotNull
    public static final String KOTLIN_DECOMPILED_ROOT = "dummy://kotlinDecompiled";

    public KotlinBytecodeDecompilerTask(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        super(file2.getProject(), KotlinJvmDecompilerBundle.message("internal.action.text.decompile.kotlin.bytecode", new Object[0]));
        this.file = file2;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        KotlinBytecodeDecompilerTask kotlinBytecodeDecompilerTask;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object object = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.file.getName(), (String)"file.name");
        indicator.setText(KotlinJvmDecompilerBundle.message("internal.indicator.text.decompiling", object));
        KotlinBytecodeDecompilerTask kotlinBytecodeDecompilerTask2 = this;
        try {
            kotlinBytecodeDecompilerTask = kotlinBytecodeDecompilerTask2;
            object = KotlinBytecodeDecompiler.INSTANCE.decompile(this.file);
        }
        catch (DecompileFailedException decompileFailedException) {
            kotlinBytecodeDecompilerTask = kotlinBytecodeDecompilerTask2;
            object = null;
        }
        kotlinBytecodeDecompilerTask.decompiledText = object;
    }

    public void onSuccess() {
        if (!this.file.isValid()) {
            return;
        }
        String text2 = this.decompiledText;
        if (text2 != null) {
            VirtualFile virtualFile2 = this.generateDecompiledVirtualFile(text2);
            if (virtualFile2 != null) {
                VirtualFile it = virtualFile2;
                boolean bl = false;
                new OpenFileDescriptor(this.file.getProject(), it).navigate(true);
            }
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.file.getName(), (String)"file.name");
            Messages.showErrorDialog((String)KotlinJvmDecompilerBundle.message("internal.error.text.cannot.decompile", objectArray), (String)KotlinJvmDecompilerBundle.message("internal.title.decompiler.error", new Object[0]));
        }
    }

    @Nullable
    public final VirtualFile generateDecompiledVirtualFile(@Nullable String decompiledText) {
        String string2 = decompiledText;
        if (string2 == null) {
            String string3;
            try {
                string3 = KotlinBytecodeDecompiler.INSTANCE.decompile(this.file);
            }
            catch (DecompileFailedException e) {
                string3 = null;
            }
            if ((string2 = string3) == null) {
                return null;
            }
        }
        String text2 = string2;
        VirtualFile virtualFile2 = (VirtualFile)ActionsKt.runWriteAction((Function0)((Function0)new Function0<VirtualFile>(this, text2){
            final /* synthetic */ KotlinBytecodeDecompilerTask this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                super(0);
            }

            @NotNull
            public final VirtualFile invoke() {
                VirtualFile root = KotlinBytecodeDecompilerTask.access$getOrCreateDummyRoot(this.this$0);
                String decompiledFileName = FileUtil.getNameWithoutExtension((String)KotlinBytecodeDecompilerTask.access$getFile$p(this.this$0).getName()) + ".decompiled.java";
                VirtualFile virtualFile2 = DummyFileSystem.getInstance().createChildFile(null, root, decompiledFileName);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getInstance().createChil\u2026root, decompiledFileName)");
                VirtualFile result2 = virtualFile2;
                VfsUtil.saveText((VirtualFile)result2, (String)this.$text);
                return result2;
            }
        }));
        KotlinDefaultHighlightingSettingsProviderKt.setKotlinDecompiledFile(virtualFile2, true);
        return virtualFile2;
    }

    public static /* synthetic */ VirtualFile generateDecompiledVirtualFile$default(KotlinBytecodeDecompilerTask kotlinBytecodeDecompilerTask, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return kotlinBytecodeDecompilerTask.generateDecompiledVirtualFile(string2);
    }

    private final VirtualFile getOrCreateDummyRoot() {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3 = VirtualFileManager.getInstance().refreshAndFindFileByUrl(KOTLIN_DECOMPILED_ROOT);
        if (virtualFile3 == null) {
            VirtualFile virtualFile4 = DummyFileSystem.getInstance().createRoot(KOTLIN_DECOMPILED_FOLDER);
            virtualFile2 = virtualFile4;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"getInstance().createRoot(KOTLIN_DECOMPILED_FOLDER)");
        } else {
            virtualFile2 = virtualFile3;
        }
        return virtualFile2;
    }

    public static final /* synthetic */ VirtualFile access$getOrCreateDummyRoot(KotlinBytecodeDecompilerTask $this) {
        return $this.getOrCreateDummyRoot();
    }

    public static final /* synthetic */ KtFile access$getFile$p(KotlinBytecodeDecompilerTask $this) {
        return $this.file;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompilerTask$Companion;", "", "()V", "KOTLIN_DECOMPILED_FOLDER", "", "KOTLIN_DECOMPILED_ROOT", "kotlin.jvm-decompiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

