/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.idea.presentation.KotlinDefaultNamedDeclarationPresentation;
import org.jetbrains.kotlin.idea.presentation.KotlinFunctionPresentation;
import org.jetbrains.kotlin.idea.presentation.KtJvmNameAnnotatedFilePresentation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0016\u0010\n\u001a\u0004\u0018\u00010\u0005*\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotationPresenter;", "Lcom/intellij/navigation/ItemPresentationProvider;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "()V", "getDeclarationPresentation", "Lcom/intellij/navigation/ItemPresentation;", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "annotationEntry", "getPresentation", "toItemPresentation", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAnnotationPresenters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationPresenters.kt\norg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotationPresenter\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,54:1\n57#2,2:55\n*S KotlinDebug\n*F\n+ 1 AnnotationPresenters.kt\norg/jetbrains/kotlin/idea/presentation/KtJvmNameAnnotationPresenter\n*L\n28#1:55,2\n*E\n"})
public final class KtJvmNameAnnotationPresenter
implements ItemPresentationProvider<KtAnnotationEntry> {
    @Nullable
    public ItemPresentation getPresentation(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        Name name2 = annotationEntry2.getShortName();
        if (!Intrinsics.areEqual((Object)(name2 != null ? name2.asString() : null), (Object)JvmFileClassUtil.INSTANCE.getJVM_NAME_SHORT())) {
            return null;
        }
        PsiElement psiElement2 = annotationEntry2.getParent().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"annotationEntry.parent.parent");
        return this.toItemPresentation(psiElement2, annotationEntry2);
    }

    private final ItemPresentation toItemPresentation(PsiElement $this$toItemPresentation, KtAnnotationEntry annotationEntry2) {
        ItemPresentation itemPresentation;
        PsiElement psiElement2 = $this$toItemPresentation;
        if (psiElement2 instanceof KtFile) {
            itemPresentation = new KtJvmNameAnnotatedFilePresentation(annotationEntry2);
        } else if (psiElement2 instanceof KtFunction) {
            itemPresentation = (ItemPresentation)new KotlinFunctionPresentation((KtFunction)$this$toItemPresentation, JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(annotationEntry2));
        } else if (psiElement2 instanceof KtNamedDeclaration) {
            itemPresentation = this.getDeclarationPresentation((KtNamedDeclaration)$this$toItemPresentation, annotationEntry2);
        } else if (psiElement2 instanceof KtPropertyAccessor) {
            PsiElement $this$parentOfType_u24default$iv = $this$toItemPresentation;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtProperty.class, (boolean)true);
            if (ktProperty == null) {
                return null;
            }
            KtProperty property2 = ktProperty;
            itemPresentation = this.getDeclarationPresentation((KtNamedDeclaration)property2, annotationEntry2);
        } else if (psiElement2 instanceof KtFileAnnotationList) {
            PsiElement psiElement3 = ((KtFileAnnotationList)$this$toItemPresentation).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parent");
            itemPresentation = this.toItemPresentation(psiElement3, annotationEntry2);
        } else {
            itemPresentation = null;
        }
        return itemPresentation;
    }

    private final ItemPresentation getDeclarationPresentation(KtNamedDeclaration declaration2, KtAnnotationEntry annotationEntry2) {
        return (ItemPresentation)new KotlinDefaultNamedDeclarationPresentation(declaration2, annotationEntry2){
            final /* synthetic */ KtAnnotationEntry $annotationEntry;
            {
                this.$annotationEntry = $annotationEntry;
                super($declaration);
            }

            @Nullable
            public String getPresentableText() {
                return JvmFileClassUtil.INSTANCE.getLiteralStringFromAnnotation(this.$annotationEntry);
            }
        };
    }
}

