/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.fixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.diagnostics.KtFirDiagnostic;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.fixes.AbstractKotlinApplicableQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinDiagnosticFixFactory;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes.KotlinDiagnosticFixFactoryKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.AddAccessorUtils;
import org.jetbrains.kotlin.idea.quickfix.fixes.AddAccessorsFactories;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R%\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/fixes/AddAccessorsFactories;", "", "()V", "addAccessorsToUninitializedProperty", "", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinDiagnosticFixFactory;", "Lorg/jetbrains/kotlin/analysis/api/fir/diagnostics/KtFirDiagnostic;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getAddAccessorsToUninitializedProperty", "()Ljava/util/Collection;", "AddAccessorsQuickFix", "kotlin.fir"})
public final class AddAccessorsFactories {
    @NotNull
    public static final AddAccessorsFactories INSTANCE = new AddAccessorsFactories();
    @NotNull
    private static final Collection<KotlinDiagnosticFixFactory<? extends KtFirDiagnostic<KtProperty>>> addAccessorsToUninitializedProperty;

    private AddAccessorsFactories() {
    }

    @NotNull
    public final Collection<KotlinDiagnosticFixFactory<? extends KtFirDiagnostic<KtProperty>>> getAddAccessorsToUninitializedProperty() {
        return addAccessorsToUninitializedProperty;
    }

    static {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtFirDiagnostic.MustBeInitialized.class), Reflection.getOrCreateKotlinClass(KtFirDiagnostic.MustBeInitializedOrBeAbstract.class)};
        addAccessorsToUninitializedProperty = KotlinDiagnosticFixFactoryKt.diagnosticFixFactories(kClassArray, addAccessorsToUninitializedProperty.1.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/fixes/AddAccessorsFactories$AddAccessorsQuickFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/fixes/AbstractKotlinApplicableQuickFix;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "target", "addGetter", "", "addSetter", "(Lorg/jetbrains/kotlin/psi/KtProperty;ZZ)V", "apply", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFamilyName", "", "kotlin.fir"})
    private static final class AddAccessorsQuickFix
    extends AbstractKotlinApplicableQuickFix<KtProperty> {
        private final boolean addGetter;
        private final boolean addSetter;

        public AddAccessorsQuickFix(@NotNull KtProperty target2, boolean addGetter2, boolean addSetter) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            super((PsiElement)target2);
            this.addGetter = addGetter2;
            this.addSetter = addSetter;
        }

        @NotNull
        public String getFamilyName() {
            return AddAccessorUtils.INSTANCE.familyAndActionName(this.addGetter, this.addSetter);
        }

        @Override
        public void apply(@NotNull KtProperty element3, @NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            AddAccessorUtils.INSTANCE.addAccessors(element3, this.addGetter, this.addSetter, editor2);
        }
    }
}

