/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractClass;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.SeparateFileWrapper;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ExtractSuperRefactoring;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.KotlinExtractSuperclassHandler;
import org.jetbrains.kotlin.idea.refactoring.introduce.extractClass.ui.KotlinExtractSuperDialogBase;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0011\u00a2\u0006\u0002\b\u0016J+\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J0\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\u00042\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001fH\u0016\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/refactoring/lang/ElementsHandler;", "isExtractInterface", "", "(Z)V", "checkClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "editor", "Lcom/intellij/openapi/editor/Editor;", "checkConflicts", "originalClass", "dialog", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/ui/KotlinExtractSuperDialogBase;", "createDialog", "targetParent", "Lcom/intellij/psi/PsiElement;", "doInvoke", "", "getErrorMessage", "", "getErrorMessage$kotlin_idea", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isEnabledOnElements", "([Lcom/intellij/psi/PsiElement;)Z", "selectElements", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinExtractSuperHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExtractSuperHandlerBase.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,113:1\n146#2:114\n146#2:115\n*S KotlinDebug\n*F\n+ 1 KotlinExtractSuperHandlerBase.kt\norg/jetbrains/kotlin/idea/refactoring/introduce/extractClass/KotlinExtractSuperHandlerBase\n*L\n38#1:114\n47#1:115\n*E\n"})
public abstract class KotlinExtractSuperHandlerBase
implements RefactoringActionHandler,
ElementsHandler {
    private final boolean isExtractInterface;

    public KotlinExtractSuperHandlerBase(boolean isExtractInterface) {
        this.isExtractInterface = isExtractInterface;
    }

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements2) {
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
        return ArraysKt.singleOrNull((Object[])elements2) instanceof KtClassOrObject;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @Nullable DataContext dataContext) {
        PsiElement element3;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement $this$getNonStrictParentOfType$iv = element3 = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        if (ktClassOrObject == null) {
            return;
        }
        KtClassOrObject klass2 = ktClassOrObject;
        if (!this.checkClass(klass2, editor2)) {
            return;
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.selectElements(klass2, editor2);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        PsiElement psiElement2;
        Editor editor2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
                if (dataContext == null) {
                    return;
                }
                editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                psiElement2 = PsiTreeUtil.findCommonParent((PsiElement[])Arrays.copyOf(elements2, elements2.length));
                if (psiElement2 == null) break block5;
                PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
                boolean $i$f$getNonStrictParentOfType = false;
                psiElement2 = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
                if (psiElement2 != null) break block6;
            }
            return;
        }
        PsiElement klass2 = psiElement2;
        if (!this.checkClass((KtClassOrObject)klass2, editor2)) {
            return;
        }
        this.selectElements((KtClassOrObject)klass2, editor2);
    }

    private final boolean checkClass(KtClassOrObject klass2, Editor editor2) {
        Project project2 = klass2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"klass.project");
        Project project3 = project2;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project3, (PsiElement)((PsiElement)klass2))) {
            return false;
        }
        String errorMessage = this.getErrorMessage$kotlin_idea(klass2);
        if (errorMessage != null) {
            CommonRefactoringUtil.showErrorHint((Project)project3, (Editor)editor2, (String)RefactoringBundle.getCannotRefactorMessage((String)errorMessage), (String)KotlinExtractSuperclassHandler.INSTANCE.getREFACTORING_NAME(), (String)"refactoring.extractSuperclass");
            return false;
        }
        return true;
    }

    private final void doInvoke(KtClassOrObject klass2, PsiElement targetParent) {
        KotlinRefactoringUtilKt.showWithTransaction((DialogWrapper)this.createDialog(klass2, targetParent));
    }

    private final void selectElements(KtClassOrObject klass2, Editor editor2) {
        Collection collection = KotlinRefactoringUtilKt.getExtractionContainers((PsiElement)klass2, true, true);
        PsiManagerEx psiManagerEx = klass2.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"klass.manager");
        List containers = CollectionsKt.plus((Collection)collection, (Object)((Object)new SeparateFileWrapper((PsiManager)psiManagerEx)));
        if (editor2 == null) {
            this.doInvoke(klass2, (PsiElement)CollectionsKt.first((List)containers));
            return;
        }
        KotlinRefactoringUtilKt.chooseContainerElementIfNecessary(containers, editor2, CollectionsKt.first((List)containers) instanceof KtFile ? KotlinBundle.message("text.select.target.file", new Object[0]) : KotlinBundle.message("text.select.target.code.block.file", new Object[0]), true, (Function1)new Function1<NavigatablePsiElement, Unit>(this, klass2){
            final /* synthetic */ KotlinExtractSuperHandlerBase this$0;
            final /* synthetic */ KtClassOrObject $klass;
            {
                this.this$0 = $receiver;
                this.$klass = $klass;
                super(1);
            }

            public final void invoke(@NotNull NavigatablePsiElement it) {
                NavigatablePsiElement navigatablePsiElement2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof SeparateFileWrapper) {
                    PsiDirectory psiDirectory = this.$klass.getContainingFile().getParent();
                    Intrinsics.checkNotNull((Object)psiDirectory);
                    navigatablePsiElement2 = (NavigatablePsiElement)psiDirectory;
                } else {
                    navigatablePsiElement2 = it;
                }
                KotlinExtractSuperHandlerBase.access$doInvoke(this.this$0, this.$klass, (PsiElement)navigatablePsiElement2);
            }
        });
    }

    protected final boolean checkConflicts(@NotNull KtClassOrObject originalClass, @NotNull KotlinExtractSuperDialogBase dialog2) {
        Intrinsics.checkNotNullParameter((Object)originalClass, (String)"originalClass");
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        List<KotlinMemberInfo> list2 = dialog2.getSelectedMembers();
        PsiElement psiElement2 = dialog2.getSelectedTargetParent();
        String string2 = dialog2.getExtractedSuperName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dialog.extractedSuperName");
        MultiMap<PsiElement, String> conflicts2 = ExtractSuperRefactoring.Companion.collectConflicts(originalClass, list2, psiElement2, string2, this.isExtractInterface);
        return ExtractSuperClassUtil.showConflicts((DialogWrapper)((DialogWrapper)dialog2), conflicts2, (Project)originalClass.getProject());
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String getErrorMessage$kotlin_idea(@NotNull KtClassOrObject klass2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        return ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)klass2) ? KotlinBundle.message("error.text.extraction.from.expect.class.is.not.yet.supported", new Object[0]) : (LightClassUtilsKt.toLightClass((KtClassOrObject)klass2) == null ? KotlinBundle.message("error.text.extraction.from.non.jvm.class.is.not.yet.supported", new Object[0]) : null);
    }

    @NotNull
    protected abstract KotlinExtractSuperDialogBase createDialog(@NotNull KtClassOrObject var1, @NotNull PsiElement var2);

    public static final /* synthetic */ void access$doInvoke(KotlinExtractSuperHandlerBase $this, KtClassOrObject klass2, PsiElement targetParent) {
        $this.doInvoke(klass2, targetParent);
    }
}

